/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.NodeStructure;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalBlock;
import com.jetbrains.cidr.lang.psi.impl.OCEagerBlockStatementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCLazyElementBase;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCContextSignatureBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTableProcessor;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTableProvider
extends SymbolTableProvider {
    private static final Map<Thread, List<String>> ourDebugSymbolBuildingStack = new HashMap<Thread, List<String>>();
    private static final Logger LOG = Logger.getInstance(OCSymbolTableProvider.class);

    @Override
    public boolean isSource(@NotNull PsiFile file) {
        return file instanceof OCFile;
    }

    @Override
    public boolean isSource(@NotNull VirtualFile file, @NotNull Lazy<FileType> cachedFileType) {
        return cachedFileType.getValue() == OCFileType.INSTANCE;
    }

    @Override
    public boolean shouldPreProcess() {
        return true;
    }

    @Override
    public void onOutOfCodeBlockModification(@NotNull Project project2, @Nullable PsiFile file) {
        FileSymbolTablesCache.getInstance(project2).incOCOutOfCodeBlockTracker();
    }

    @Override
    public boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event) {
        PsiElement element = event.getParent();
        while (!(element instanceof PsiFile) && !(element instanceof PsiDirectory) && element != null) {
            if (element instanceof OCLocalBlock && !(element instanceof OCEagerBlockStatementImpl)) {
                return false;
            }
            element = element.getParent();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileSymbolTable calcTable(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        PsiBuilder b;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText2(virtualFile.getName());
        }
        OCContextSignatureBuilder signatureBuilder = new OCContextSignatureBuilder(context.getLanguageKind(), context.getCurrentNamespace(), context.isSurrogate());
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)OCLanguage.getInstance());
        assert (parserDefinition != null);
        OCInclusionContext currentFileContext = context.deriveButDontCopyTypes(false);
        currentFileContext.setSignatureBuilder(signatureBuilder);
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(currentFileContext, virtualFile);
        lexer.adjustNamespace();
        String text = OCSymbolTableProvider.getFileText(virtualFile, context.getProject());
        OCSymbolTableProvider.startParsingFile(virtualFile);
        try {
            b = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)lexer, (CharSequence)text);
            new OCParsing(b, (IElementType)OCTokenTypes.OC_FILE, OCParsing.BlockParsingMode.SKIP).parseFileContents();
        }
        finally {
            OCSymbolTableProvider.finishParsingFile();
        }
        currentFileContext.setSignatureBuilder(null);
        assert (context.getLanguageKind() == currentFileContext.getLanguageKind());
        FlyweightCapableTreeStructure structure = b.getLightTree();
        FileSymbolTable answer = new FileSymbolTable(virtualFile, signatureBuilder.build());
        return OCSymbolTableProvider.buildTable(virtualFile, text, context, answer, structure, NodeStructure.LIGHTER_NODE_STRUCTURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startParsingFile(@NotNull VirtualFile virtualFile) {
        Thread currentThread = Thread.currentThread();
        Map<Thread, List<String>> map2 = ourDebugSymbolBuildingStack;
        synchronized (map2) {
            List<String> stack = ourDebugSymbolBuildingStack.get(currentThread);
            if (stack == null) {
                stack = new ArrayList<String>();
                ourDebugSymbolBuildingStack.put(currentThread, stack);
            }
            stack.add(virtualFile.getUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finishParsingFile() {
        Thread currentThread = Thread.currentThread();
        Map<Thread, List<String>> map2 = ourDebugSymbolBuildingStack;
        synchronized (map2) {
            List<String> stack = ourDebugSymbolBuildingStack.get(currentThread);
            stack.remove(stack.size() - 1);
            if (stack.isEmpty()) {
                ourDebugSymbolBuildingStack.remove(currentThread);
            }
        }
    }

    @Override
    @NotNull
    public FileSymbolTable calcTableUsingPSI(@NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        FileSymbolTable answer = new FileSymbolTable(virtualFile, new ContextSignature());
        return OCSymbolTableProvider.buildTable(virtualFile, file.getText(), context, answer, new ASTStructure((ASTNode)file.getNode()){

            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                return astNode instanceof OCLazyElementBase ? 0 : super.getChildren(astNode, into);
            }
        }, BuilderDriverBase.AST_NAMED_NODE_STRUCTURE);
    }

    private static <T> FileSymbolTable buildTable(@NotNull VirtualFile file, String text, @NotNull OCInclusionContext context, FileSymbolTable answer, FlyweightCapableTreeStructure<T> structure, NodeStructure<T> nodeStructure) {
        OCInclusionContext buildCtx = context.deriveButDontCopyTypes(false);
        OCBuilderDriver<Object> driver = new OCBuilderDriver<Object>(file, buildCtx, text, structure, nodeStructure, new OCSymbolTableProcessor(answer), context.getProject());
        driver.processDeclarationsList(structure.getRoot());
        answer.sortSymbols();
        return answer;
    }

    public static class DumpCurrentlyBuildingSymbols
    extends DumbAwareAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Map map2 = ourDebugSymbolBuildingStack;
            synchronized (map2) {
                StringBuilder res = new StringBuilder(">>>>>>>>>>>>> Currently parsed files\n");
                for (Map.Entry entry : ourDebugSymbolBuildingStack.entrySet()) {
                    List files = (List)entry.getValue();
                    Thread thread = (Thread)entry.getKey();
                    res.append(thread).append(" ").append((Object)thread.getState()).append(" (").append(files.size()).append(")").append("\n");
                    for (String file : files) {
                        res.append(file).append("\n");
                    }
                }
                res.append("<<<<<<<<<<<<<< End currently parsed files");
                LOG.warn(ThreadDumper.dumpThreadsToString());
                LOG.warn(res.toString());
            }
        }
    }
}

