/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.modulemap.ModuleMapModules;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapDiskCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapFileSymbolPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SerializationSession;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTablesBuildingActivity {
    public static final String TITLE_SAVING_SYMBOLS = "Saving symbols...";
    @NotNull
    private final FileSymbolTablesCache myCache;
    @NotNull
    private final ModuleMapResolveService myModuleMapResolveService;
    @NotNull
    private final ModuleMapManager myModuleMapManager;
    @Nullable
    private static NotNullProducer<ProgressIndicator> ourIndicatorFactory;
    @NotNull
    private static final Set<Thread> mySymbolBuildingThreads;
    public static final NotNullLazyKey<List<String>, Project> ACTIVITY_LOG;
    @NotNull
    private final Project project;
    @NotNull
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    @NotNull
    private final AtomicInteger ourRequestCount = new AtomicInteger();
    @NotNull
    private final Object ourLastBuildLock = new Object();
    @Nullable
    private volatile SymbolBuildingTask ourLastBuildTask;
    private volatile int ourLastBuild;

    public static OCSymbolTablesBuildingActivity getInstance(@NotNull Project project2) {
        return (OCSymbolTablesBuildingActivity)ServiceManager.getService((Project)project2, OCSymbolTablesBuildingActivity.class);
    }

    public OCSymbolTablesBuildingActivity(@NotNull Project project2, @NotNull FileSymbolTablesCache cache, @NotNull ModuleMapResolveService moduleMapResolveService, @NotNull ModuleMapManager moduleMapManager) {
        this.project = project2;
        this.myCache = cache;
        this.myModuleMapResolveService = moduleMapResolveService;
        this.myModuleMapManager = moduleMapManager;
    }

    @NotNull
    public SimpleModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public void assertParsingAndSymbolBuildingAllowed() {
        this.assertParsingAndSymbolBuildingAllowed(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertParsingAndSymbolBuildingAllowed(Thread thread) {
        boolean allowed;
        boolean bl = allowed = this.myCache.areSymbolsLoaded() || mySymbolBuildingThreads.contains(thread);
        if (!allowed) {
            String logEntries;
            List log;
            List list = log = (List)ACTIVITY_LOG.getValue((UserDataHolder)this.project);
            synchronized (list) {
                logEntries = StringUtil.join((Collection)log, (String)"\n");
            }
            String message = "Symbol building is not allowed: " + System.currentTimeMillis() + " . \nLoaded: " + this.myCache.areSymbolsLoaded() + "\nDumb: " + DumbService.isDumb((Project)this.project) + "\nPrevious activities: \n" + logEntries;
            OCLog.LOG.error(message);
            throw new ProcessCanceledException(new Throwable(message));
        }
    }

    public static void setIndicatorFactory(@Nullable NotNullProducer<ProgressIndicator> indicatorFactory) {
        ourIndicatorFactory = indicatorFactory;
    }

    public void rebuildSymbols() {
        this.rebuildSymbols(Mode.FAST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildSymbols(final @NotNull Mode mode) {
        final int requestNumber = this.ourRequestCount.incrementAndGet();
        String activityName = "rebuildSymbols";
        this.runSymbolActivity(new SymbolBuildingTask(activityName, activityName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                Object object = OCSymbolTablesBuildingActivity.this.ourLastBuildLock;
                synchronized (object) {
                    if (requestNumber <= OCSymbolTablesBuildingActivity.this.ourLastBuild) {
                        return;
                    }
                    OCSymbolTablesBuildingActivity.this.ourLastBuildTask = this;
                    OCSymbolTablesBuildingActivity.this.ourLastBuild = OCSymbolTablesBuildingActivity.this.ourRequestCount.get();
                }
                OCSymbolTablesBuildingActivity.this.buildSymbolsInternal(indicator, mode);
            }
        });
        Object object = this.ourLastBuildLock;
        synchronized (object) {
            SymbolBuildingTask currentTask = this.ourLastBuildTask;
            if (currentTask != null && this.ourLastBuild < requestNumber) {
                if (currentTask.shouldCancel()) {
                    DumbService.getInstance((Project)this.project).cancelTask((DumbModeTask)currentTask);
                }
                this.ourLastBuildTask = null;
            }
        }
    }

    public void rebuildSwiftModules(final FileType swiftFileType) {
        this.runSymbolActivity(new SymbolBuildingTask("rebuildSwiftModules"){

            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                OCSymbolTablesBuildingActivity.this.processSwiftModules(ContainerUtil.createMaybeSingletonList((Object)new LightVirtualFile("", swiftFileType, (CharSequence)"")), indicator);
            }
        });
    }

    public void buildSymbolsForFiles(final @NotNull Collection<VirtualFile> files) {
        this.runSymbolActivity(new SymbolBuildingTask("buildSymbolsForFiles"){

            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                OCSymbolTablesBuildingActivity.this.buildSymbolsForFilesInternal(indicator, files);
            }
        });
    }

    public void rebuildModuleMaps() {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        this.runSymbolActivity(new SymbolBuildingTask("rebuildModuleMaps"){

            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                OCSymbolTablesBuildingActivity.this.buildModuleMapsInternal(indicator, OCSymbolTablesBuildingActivity.this.getAllHeaderRoots(indicator));
            }
        });
    }

    private void buildModuleMapsInternal(@NotNull MyProgressIndicator indicator, Collection<HeadersSearchRoot> allHeaderRoots) {
        ModuleMapCache.getInstance(this.project).reset();
        indicator.setIndeterminate(false);
        this.deserializeModuleMaps(indicator, allHeaderRoots);
        this.buildRemainingModuleMaps(indicator);
        this.serializeModuleMaps(indicator, allHeaderRoots);
    }

    @NotNull
    private Set<HeadersSearchRoot> getAllHeaderRoots(@NotNull MyProgressIndicator indicator) {
        Ref result = Ref.create();
        OCSymbolTablesBuildingActivity.runCancelableReadAction((ProgressIndicator)indicator, () -> {
            THashSet roots = ContainerUtil.newTroveSet();
            List<OCResolveConfiguration> configurations = OCWorkspace.getInstance(this.project).getConfigurations();
            for (OCResolveConfiguration configuration : configurations) {
                ProgressManager.checkCanceled();
                roots.addAll(this.myModuleMapManager.getHeaderSearchRoots(configuration));
            }
            result.set((Object)roots);
        });
        return (Set)result.get();
    }

    private void deserializeModuleMaps(@NotNull MyProgressIndicator indicator, @NotNull Collection<HeadersSearchRoot> roots) {
        if (!ModuleMapCache.shouldReloadCache()) {
            return;
        }
        indicator.setText("Loading Module Maps...");
        indicator.startTiming("Loading Module Maps");
        indicator.setInterval(0.0, 0.1);
        ModuleMapDiskCache.getInstance(this.project).deserializeModuleMaps((ProgressIndicator)indicator, roots, (Consumer<ModuleMapFileSymbolPack>)((Consumer)pack -> {
            indicator.setText2(pack.getHeaderRoot().getName());
            ModuleMapCache.getInstance(this.project).cacheOrGet(pack.getHeaderRoot(), (Function0<ModuleMapFileSymbolPack>)((Function0)() -> pack));
        }));
        indicator.setText2(null);
        indicator.logTiming();
    }

    private void buildRemainingModuleMaps(final @NotNull MyProgressIndicator indicator) {
        HashSet items = ContainerUtil.newHashSet();
        final String[] projectLocationHash = new String[1];
        OCSymbolTablesBuildingActivity.runCancelableReadAction((ProgressIndicator)indicator, () -> {
            projectLocationHash[0] = this.project.getLocationHash();
            OCWorkspace workspace = OCWorkspace.getInstance(this.project);
            HashSet allRoots = ContainerUtil.newHashSet();
            for (OCResolveConfiguration configuration : workspace.getConfigurations()) {
                ProgressManager.checkCanceled();
                List<HeadersSearchRoot> roots = this.myModuleMapManager.getHeaderSearchRoots(configuration);
                allRoots.addAll(roots);
                items.addAll(ContainerUtil.map(roots, root -> Pair.create((Object)configuration, (Object)root)));
            }
            items.addAll(ContainerUtil.map((Collection)allRoots, root -> Pair.create(null, (Object)root)));
        });
        if (items.isEmpty()) {
            return;
        }
        final int allCount = items.size();
        final ArrayList pool = ContainerUtil.newArrayList((Iterable)items);
        final AtomicInteger processedCount = new AtomicInteger(0);
        indicator.setText("Building Module Maps...");
        indicator.startTiming("Building Module Maps");
        indicator.setIndeterminate(false);
        indicator.setInterval(0.1, 0.9);
        indicator.setFraction(0.0);
        OCSymbolTablesBuildingActivity.processFutures(OCSymbolTablesBuildingActivity.createTasks(new TaskProvider<Pair<OCResolveConfiguration, HeadersSearchRoot>>(){

            @Override
            @NotNull
            public Producer<Pair<OCResolveConfiguration, HeadersSearchRoot>> getItemProvider() {
                return () -> {
                    List list = pool;
                    synchronized (list) {
                        if (pool.isEmpty()) {
                            return null;
                        }
                        return (Pair)pool.remove(pool.size() - 1);
                    }
                };
            }

            @Override
            @NotNull
            public Consumer<Pair<OCResolveConfiguration, HeadersSearchRoot>> getWorker() {
                SerializationSession serializationSession = new SerializationSession(projectLocationHash[0]);
                return item -> {
                    indicator.setText2(((HeadersSearchRoot)((Object)((Object)item.second))).getName());
                    ModuleMapModules modules = OCSymbolTablesBuildingActivity.this.myModuleMapManager.getModules((OCResolveConfiguration)item.first, (HeadersSearchRoot)((Object)((Object)item.second)), serializationSession);
                    for (ModuleMapModuleSymbol module2 : modules.getModules()) {
                        OCSymbolTablesBuildingActivity.this.myModuleMapResolveService.getIncludeHeaders(module2, (OCResolveConfiguration)item.first);
                    }
                    indicator.setFraction((double)processedCount.incrementAndGet() / (double)allCount);
                };
            }
        }, (ProgressIndicator)indicator, this.project));
        indicator.setText2(null);
        indicator.logTiming();
    }

    private void serializeModuleMaps(@NotNull MyProgressIndicator indicator, @NotNull Collection<HeadersSearchRoot> roots) {
        indicator.setText("Saving Module Maps...");
        indicator.startTiming("Saving Module Maps");
        indicator.setInterval(0.9, 1.0);
        List packs = ContainerUtil.mapNotNull(roots, root -> {
            indicator.setText2(root.getName());
            return ModuleMapCache.getInstance(this.project).get((HeadersSearchRoot)((Object)root));
        });
        ModuleMapDiskCache.getInstance(this.project).serializeModuleMaps((ProgressIndicator)indicator, packs);
        indicator.setText2(null);
        indicator.logTiming();
    }

    private void runSymbolActivity(final @NotNull SymbolBuildingTask task) {
        final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (app.isUnitTestMode() && app.isWriteAccessAllowed()) {
            app.addApplicationListener(new ApplicationListener(){
                private final AtomicBoolean isHandled = new AtomicBoolean();

                public void afterWriteActionFinished(@NotNull Object action) {
                    if (!this.isHandled.getAndSet(true)) {
                        app.removeApplicationListener((ApplicationListener)this);
                        DumbService.getInstance((Project)OCSymbolTablesBuildingActivity.this.project).queueTask((DumbModeTask)task);
                    }
                }
            });
            return;
        }
        DumbService.getInstance((Project)this.project).queueTask((DumbModeTask)task);
    }

    private void buildSymbolsForFilesInternal(@NotNull MyProgressIndicator indicator, @NotNull Collection<VirtualFile> sourceFiles) {
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> {
            if (indicator.isCanceled()) {
                return;
            }
            this.myCache.notifySymbolsUnloaded();
            this.myCache.reparseCachedPsiFiles();
        }));
        indicator.checkCanceled();
        indicator.setText("Updating symbols...");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        indicator.setInterval(indicator.getFraction(), 1.0);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, sourceFiles, false).processBuildFiles();
        this.notifySymbolsAreLoadedAndReparseCachedFiles(indicator);
    }

    private void buildSymbolsInternal(@NotNull MyProgressIndicator indicator, @NotNull Mode mode) {
        List<VirtualFile> sourceFilesToIndex;
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        if (ApplicationManagerEx.getApplicationEx().isWriteAccessAllowed()) {
            OCLog.LOG.error("Symbols building must not be initiated from write action, otherwise deadlock will occur");
            return;
        }
        indicator.checkCanceled();
        indicator.setText("Building symbols...");
        indicator.setText2("");
        indicator.setIndeterminate(true);
        indicator.startTiming("Clearing symbols");
        String[] projectLocationHash = new String[1];
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> {
            if (indicator.isCanceled()) {
                return;
            }
            this.myCache.notifySymbolsUnloaded();
            this.myCache.clearAllTables();
            this.myCache.reparseCachedPsiFiles();
            this.clearAllSymbolDependentCaches();
            projectLocationHash[0] = this.project.getLocationHash();
        }));
        indicator.logTiming();
        indicator.checkCanceled();
        indicator.setText("Loading symbols...");
        indicator.startTiming("Loading symbols");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        Collection<VirtualFile> allFiles = this.getFilesToBuildCachesForSafely((ProgressIndicator)indicator);
        ArrayList sourceFiles = new ArrayList();
        OCSymbolTablesBuildingActivity.runCancelableReadAction((ProgressIndicator)indicator, () -> sourceFiles.addAll(ContainerUtil.findAll((Collection)allFiles, file -> !OCInclusionContextUtil.isNeedToFindRoot(file, this.project))));
        OCLog.LOG.info("Building symbols in " + mode.name() + " mode, " + sourceFiles.size() + " source files from total " + allFiles.size() + " project files");
        long loadedFileCount = 0L;
        if (mode != Mode.FULL) {
            loadedFileCount = this.myCache.deserializeTables(projectLocationHash[0], allFiles, (ProgressIndicator)indicator, 0.25);
        }
        double loadedFraction = indicator.getFraction();
        double savingFraction = 1.0 - 0.1 * (double)((long)allFiles.size() - loadedFileCount) / (double)Math.max(1, allFiles.size());
        indicator.logTiming();
        Set<HeadersSearchRoot> allHeaderRoots = this.getAllHeaderRoots(indicator);
        indicator.startTiming("Loading Header Maps");
        OCHeaderMapManager.getInstance(this.project).load(allHeaderRoots);
        indicator.logTiming();
        this.buildModuleMapsInternal(indicator, allHeaderRoots);
        ArrayList<VirtualFile> loadedFiles = new ArrayList<VirtualFile>(this.myCache.getCachedFiles());
        OCLog.LOG.info("Loaded " + this.getAllTablesCount() + " tables for " + loadedFiles.size() + " files (" + loadedFileCount + " project files)");
        indicator.checkCanceled();
        indicator.setText(loadedFiles.isEmpty() ? "Building symbols..." : "Updating symbols...");
        indicator.startTiming("Building symbols");
        if (mode == Mode.COMPACT) {
            sourceFilesToIndex = sourceFiles;
        } else {
            HashSet<VirtualFile> filesWithOwnTables = new HashSet<VirtualFile>(this.myCache.getFilesWithNonFallbackTables(false));
            sourceFilesToIndex = ContainerUtil.findAll(sourceFiles, file -> !filesWithOwnTables.contains(file));
        }
        OCLog.LOG.info("Building symbols for " + sourceFilesToIndex.size() + " source files");
        double sourcePart = sourceFilesToIndex.size();
        double headerWithoutTablesCount = allFiles.size() - sourceFiles.size();
        double headersPart = headerWithoutTablesCount * 0.2;
        double sourceFraction = loadedFraction + (savingFraction - loadedFraction) * (sourcePart / Math.max(sourcePart + headersPart, 1.0));
        indicator.setInterval(loadedFraction, sourceFraction);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, sourceFilesToIndex, false).processBuildFiles();
        indicator.checkCanceled();
        HashSet<VirtualFile> headersWithoutTables = new HashSet<VirtualFile>(allFiles);
        headersWithoutTables.removeAll(this.myCache.getFilesWithNonFallbackTables(mode == Mode.COMPACT));
        OCLog.LOG.info("Building symbols for " + headersWithoutTables.size() + " unused headers");
        indicator.setInterval(indicator.getFraction(), savingFraction);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, headersWithoutTables, true).processBuildFiles();
        indicator.logTiming();
        this.myCache.removeJunkTables(mode == Mode.COMPACT);
        this.processSwiftModules(allFiles, indicator);
        HashSet<VirtualFile> filesWithModifiedTables = new HashSet<VirtualFile>(this.myCache.getFilesWithChangedTables());
        this.notifySymbolsAreLoadedAndReparseCachedFiles(indicator);
        indicator.checkCanceled();
        indicator.setText(TITLE_SAVING_SYMBOLS);
        indicator.startTiming("Saving symbols");
        indicator.setInterval(savingFraction, 1.0);
        OCLog.LOG.info("Saving modified symbols for " + filesWithModifiedTables.size() + " files (" + this.getAllTablesCount(filesWithModifiedTables) + " tables of total " + this.getAllTablesCount() + ")");
        this.myCache.serializeTables(projectLocationHash[0], filesWithModifiedTables, (ProgressIndicator)indicator);
        indicator.logTiming();
        FileSymbolTable.reportStats(this.project);
    }

    private int getAllTablesCount() {
        Set<VirtualFile> files = this.myCache.getCachedFiles();
        return this.getAllTablesCount(files);
    }

    private int getAllTablesCount(@NotNull Set<VirtualFile> files) {
        int result = 0;
        for (VirtualFile file : files) {
            result += this.myCache.allTablesForFileCount(file);
        }
        return result;
    }

    private void processSwiftModules(@NotNull Collection<VirtualFile> allFiles, @NotNull MyProgressIndicator indicator) {
        ArrayList tasks2 = ContainerUtil.newArrayList();
        for (SymbolTableProvider provider2 : SymbolTableProvider.getProviders()) {
            TaskProvider<?> additionalActivity = provider2.getItemProviderAndWorkerForAdditionalSymbolLoading(this.project, (ProgressIndicator)indicator, allFiles);
            if (additionalActivity == null) continue;
            tasks2.addAll(OCSymbolTablesBuildingActivity.createTasks(additionalActivity, (ProgressIndicator)indicator, this.project));
        }
        if (!tasks2.isEmpty()) {
            indicator.setText("Processing Swift modules...");
            indicator.setIndeterminate(false);
            indicator.setInterval(0.0, 1.0);
            indicator.setFraction(0.0);
            indicator.startTiming("Processing swift modules");
            OCSymbolTablesBuildingActivity.processFutures(tasks2);
            indicator.logTiming();
        }
    }

    private void notifySymbolsAreLoadedAndReparseCachedFiles(@NotNull MyProgressIndicator indicator) {
        indicator.checkCanceled();
        OCSymbolTablesBuildingActivity.runCancelableReadAction((ProgressIndicator)indicator, () -> {
            indicator.checkCanceled();
            this.myCache.compact();
            this.myCache.notifySymbolsLoaded();
        });
        indicator.checkCanceled();
        Runnable runnable = () -> {
            if (this.project.isDisposed() || indicator.isCanceled()) {
                return;
            }
            this.myCache.reparseCachedPsiFiles();
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            TransactionGuard.getInstance().submitTransactionAndWait(runnable);
        } else {
            TransactionGuard.submitTransaction((Disposable)this.project, (Runnable)runnable);
        }
    }

    private void clearAllSymbolDependentCaches() {
        this.myModificationTracker.incModificationCount();
        for (OCResolveConfiguration configuration : OCWorkspace.getInstance(this.project).getConfigurations()) {
            OCInclusionContext.onPrecompiledContextChange(configuration);
            OCInclusionContext.clearSymbolTableConformanceCache(configuration);
            OCImportGraph.invalidateRootHeadersCache(configuration);
        }
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.project);
    }

    @NotNull
    private Collection<VirtualFile> getFilesToBuildCachesForSafely(@NotNull ProgressIndicator indicator) {
        Ref result = new Ref();
        OCSymbolTablesBuildingActivity.runCancelableReadAction(indicator, () -> result.set(this.myCache.getFilesToBuildTablesFor()));
        return (Collection)result.get();
    }

    public static void runCancelableReadAction(@NotNull ProgressIndicator indicator, @NotNull Runnable runnable) {
        ProgressIndicator innerIndicator = OCSymbolTablesBuildingActivity.createCancelableLoopIndicator(indicator);
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            ProgressManager.getInstance().runProcess(() -> application.runReadAction(runnable), innerIndicator);
            return;
        }
        OCSymbolTablesBuildingActivity.waitForCondition(indicator, (Condition<Boolean>)((Condition)o -> ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable, (ProgressIndicator)innerIndicator)));
    }

    private static void invokeAndWaitSafely(@NotNull ProgressIndicator indicator, @NotNull Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            application.runWriteAction(runnable);
            return;
        }
        Semaphore s = new Semaphore(0);
        TransactionGuard.submitTransaction((Disposable)application, () -> application.runWriteAction(() -> {
            try {
                runnable.run();
            }
            finally {
                s.release();
            }
        }));
        OCSymbolTablesBuildingActivity.waitForCondition(indicator, (Condition<Boolean>)((Condition)o -> s.tryAcquire()));
    }

    private static void waitForCondition(@NotNull ProgressIndicator indicator, @NotNull Condition<Boolean> condition) {
        long sleep = 1L;
        while (true) {
            indicator.checkCanceled();
            if (condition.value(null)) break;
            indicator.checkCanceled();
            try {
                Thread.sleep(sleep);
                sleep *= 2L;
                sleep = Math.min(sleep, 100L);
            }
            catch (InterruptedException ignore) {
                throw new ProcessCanceledException();
            }
        }
    }

    private static void processFutures(@NotNull Iterable<Future<?>> tasks2) {
        for (Future<?> future : tasks2) {
            try {
                future.get();
            }
            catch (InterruptedException ignore) {
                return;
            }
            catch (ExecutionException e) {
                OCLog.LOG.error(e.getMessage());
            }
        }
    }

    @NotNull
    private static <T> List<Future<?>> createTasks(@NotNull TaskProvider<T> taskProvider, @NotNull ProgressIndicator indicator, @NotNull Project project2) {
        int threadCount = FileSymbolTablesCache.getIndexingThreadCount();
        return Stream.generate(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Thread currentThread = Thread.currentThread();
            assert (!mySymbolBuildingThreads.contains(currentThread)) : "Dedicated thread should be used for symbols building";
            mySymbolBuildingThreads.add(currentThread);
            try {
                OCSymbolTablesBuildingActivity.processItemsInReadAction(taskProvider.getItemProvider(), taskProvider.getWorker(), indicator, project2);
            }
            finally {
                mySymbolBuildingThreads.remove(currentThread);
            }
        })).limit(threadCount).collect(Collectors.toList());
    }

    private static <T> void processItemsInReadAction(@NotNull Producer<T> itemProvider, @NotNull Consumer<T> worker, @NotNull ProgressIndicator globalIndicator, @NotNull Project project2) {
        final ProgressIndicator localProgress = OCSymbolTablesBuildingActivity.createCancelableLoopIndicator(globalIndicator);
        ProgressManager.getInstance().runProcess(() -> {
            if (project2.isDisposed()) {
                return;
            }
            ApplicationListener applicationListener = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    localProgress.cancel();
                }

                public void writeActionFinished(@NotNull Object action) {
                    if (localProgress.isRunning()) {
                        localProgress.stop();
                    }
                    localProgress.start();
                }
            };
            ApplicationManager.getApplication().addApplicationListener(applicationListener);
            try {
                Ref currentItem = new Ref();
                while (!globalIndicator.isCanceled()) {
                    if (currentItem.get() == null) {
                        Object item = itemProvider.produce();
                        if (item == null) {
                            break;
                        }
                        currentItem.set(item);
                    }
                    OCSymbolTablesBuildingActivity.runCancelableReadAction(globalIndicator, () -> {
                        if (project2.isDisposed()) {
                            return;
                        }
                        if (globalIndicator.isCanceled()) {
                            return;
                        }
                        Object item = currentItem.get();
                        currentItem.set(null);
                        try {
                            worker.consume(item);
                        }
                        catch (ProcessCanceledException ignore) {
                            currentItem.set(item);
                        }
                        catch (Throwable e) {
                            OCLog.LOG.error(e);
                        }
                    });
                }
            }
            finally {
                ApplicationManager.getApplication().removeApplicationListener(applicationListener);
            }
        }, localProgress);
    }

    @NotNull
    private static ProgressIndicator createCancelableLoopIndicator(@NotNull ProgressIndicator mainIndicator) {
        return ourIndicatorFactory != null ? (ProgressIndicator)ourIndicatorFactory.produce() : new SensitiveProgressWrapper(mainIndicator){

            protected boolean isReuseable() {
                return true;
            }
        };
    }

    public static void logStats(Logger logger) {
        StringBuilder text = new StringBuilder();
        text.append("Total symbol building time: ").append(StringUtil.formatDuration((long)MyProgressIndicator.ourTotalTime.get())).append("\n");
        for (Map.Entry entry : MyProgressIndicator.ourTotalTimePerActivity.entrySet()) {
            text.append("\tTotal ").append((String)entry.getKey()).append(" time: ").append(StringUtil.formatDuration((long)((AtomicLong)entry.getValue()).get())).append("\n");
        }
        logger.info(text.toString());
    }

    static {
        mySymbolBuildingThreads = ContainerUtil.newConcurrentSet();
        ACTIVITY_LOG = NotNullLazyKey.create((String)"SYMBOL ACTIVITY LOG", dom -> new ArrayList());
    }

    public static interface TaskProvider<T> {
        @NotNull
        public Producer<T> getItemProvider();

        @NotNull
        public Consumer<T> getWorker();
    }

    private static class MyProgressIndicator
    extends DelegatingProgressIndicator {
        private double myFromFraction;
        private double myToFraction = 1.0;
        private static final ConcurrentHashMap<String, AtomicLong> ourTotalTimePerActivity = new ConcurrentHashMap();
        private static final AtomicLong ourTotalTime = new AtomicLong();
        private String lastActivity;
        private long activityStarted;

        MyProgressIndicator(@NotNull ProgressIndicator indicator) {
            super(indicator);
        }

        public void startTiming(String activity) {
            this.activityStarted = System.currentTimeMillis();
            this.lastActivity = activity;
        }

        public void setText(String text) {
            super.setText(text);
        }

        public void logTiming() {
            long now = System.currentTimeMillis();
            long time = now - this.activityStarted;
            AtomicLong totalActivityTime = ourTotalTimePerActivity.computeIfAbsent(this.lastActivity, s -> new AtomicLong(0L));
            totalActivityTime.addAndGet(time);
            ourTotalTime.addAndGet(time);
            if (!ApplicationManagerEx.getApplicationEx().isUnitTestMode()) {
                OCLog.LOG.info(this.lastActivity + " finished in " + StringUtil.formatDuration((long)time));
            }
        }

        public void setInterval(double from, double to) {
            this.myFromFraction = from;
            this.myToFraction = to;
        }

        public void setFraction(double fraction) {
            super.setFraction(this.myFromFraction + (this.myToFraction - this.myFromFraction) * fraction);
        }
    }

    private static class OCSymbolTableBuilder {
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final Project myProject;
        private final MultiMap<OCBuildFileCategory, OCBuildFileDescriptor> myClusterization = new MultiMap();

        OCSymbolTableBuilder(@NotNull Project project2, @NotNull ProgressIndicator progressIndicator, @NotNull Collection<VirtualFile> files, boolean isSurrogate) {
            this.myIndicator = progressIndicator;
            this.myProject = project2;
            Iterator<VirtualFile> iterator2 = files.iterator();
            Producer provider2 = () -> iterator2.hasNext() ? (VirtualFile)iterator2.next() : null;
            OCSymbolTablesBuildingActivity.processItemsInReadAction(provider2, virtualFile -> {
                if (!virtualFile.isValid()) {
                    return;
                }
                PsiFile file = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                if (!(file instanceof OCConfigurationOwner)) {
                    return;
                }
                boolean needToFindRoot = OCInclusionContextUtil.isNeedToFindRoot(file);
                OCLanguageKind kind = needToFindRoot ? null : ((OCConfigurationOwner)file).getKind();
                for (OCResolveConfiguration config : OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(virtualFile, project2)) {
                    if (needToFindRoot) {
                        kind = OCLanguageKindCalculator.calculateLanguageKind(config, virtualFile, project2, false);
                    }
                    OCBuildFileCategory traits = new OCBuildFileCategory(config.getIndexingCluster(), kind);
                    OCBuildFileDescriptor fileDescriptor = new OCBuildFileDescriptor(config, (VirtualFile)virtualFile, kind, isSurrogate);
                    this.myClusterization.putValue((Object)traits, (Object)fileDescriptor);
                }
            }, progressIndicator, project2);
        }

        public void processBuildFiles() {
            final int totalFilesCount = this.myClusterization.values().size();
            Set traits = this.myClusterization.keySet();
            ArrayList tasks2 = new ArrayList(traits.size());
            final AtomicInteger processedFiles = new AtomicInteger(0);
            final ArrayList<BuildFileProvider> clusterProviders = new ArrayList<BuildFileProvider>();
            final HashMap<VirtualFile, OCBuildFileDescriptor> notProcessedFiles = new HashMap<VirtualFile, OCBuildFileDescriptor>();
            for (OCBuildFileCategory t : traits) {
                Collection<OCBuildFileDescriptor> files = Collections.unmodifiableCollection(this.myClusterization.get((Object)t));
                for (OCBuildFileDescriptor desc : files) {
                    notProcessedFiles.put(desc.myFile, desc);
                }
                Iterator<OCBuildFileDescriptor> clusterIterator = files.iterator();
                clusterProviders.add(() -> {
                    while (clusterIterator.hasNext()) {
                        OCBuildFileDescriptor next = (OCBuildFileDescriptor)clusterIterator.next();
                        Map map2 = notProcessedFiles;
                        synchronized (map2) {
                            if (notProcessedFiles.containsKey(next.myFile)) {
                                notProcessedFiles.remove(next.myFile);
                                return next;
                            }
                        }
                    }
                    return null;
                });
            }
            final BuildFileProvider remainingProvider = () -> {
                Map map2 = notProcessedFiles;
                synchronized (map2) {
                    if (!notProcessedFiles.isEmpty()) {
                        Map.Entry next = notProcessedFiles.entrySet().iterator().next();
                        notProcessedFiles.remove(next.getKey());
                        return (OCBuildFileDescriptor)next.getValue();
                    }
                }
                return null;
            };
            tasks2.addAll(OCSymbolTablesBuildingActivity.createTasks(new TaskProvider<OCBuildFileDescriptor>(){

                @Override
                @NotNull
                public Producer<OCBuildFileDescriptor> getItemProvider() {
                    return new PrioritizedBuildFileProvider(myProject, clusterProviders, remainingProvider);
                }

                @Override
                @NotNull
                public Consumer<OCBuildFileDescriptor> getWorker() {
                    return descriptor2 -> {
                        Set<VirtualFile> processed = OCImportGraph.buildSymbolAndRootHeaderCache(((OCBuildFileDescriptor)descriptor2).myConfiguration, ((OCBuildFileDescriptor)descriptor2).myFile, ((OCBuildFileDescriptor)descriptor2).myIsSurrogate, myIndicator);
                        if (processed != null) {
                            int sizeDelta = 0;
                            Map map2 = notProcessedFiles;
                            synchronized (map2) {
                                int prevSize = notProcessedFiles.size();
                                for (VirtualFile f : processed) {
                                    notProcessedFiles.remove(f);
                                }
                                sizeDelta = prevSize - notProcessedFiles.size();
                            }
                            processedFiles.addAndGet(sizeDelta);
                        } else {
                            processedFiles.incrementAndGet();
                        }
                        myIndicator.setFraction((double)processedFiles.get() / (double)totalFilesCount);
                    };
                }
            }, this.myIndicator, this.myProject));
            OCSymbolTablesBuildingActivity.processFutures(tasks2);
        }

        private static class PrioritizedBuildFileProvider
        implements BuildFileProvider {
            private boolean myUseClusters = true;
            private Producer<OCBuildFileDescriptor> myCurrentProvider;
            @NotNull
            private final Project myProject;
            @NotNull
            private final Collection<BuildFileProvider> myProviders;
            @NotNull
            private final BuildFileProvider myBottomProvider;

            private PrioritizedBuildFileProvider(@NotNull Project project2, @NotNull Collection<BuildFileProvider> providers, @NotNull BuildFileProvider bottomProvider) {
                this.myProject = project2;
                this.myProviders = providers;
                this.myBottomProvider = bottomProvider;
            }

            @Nullable
            public OCBuildFileDescriptor produce() {
                OCBuildFileDescriptor fromCluster = this.nextFromProviders();
                return fromCluster != null ? fromCluster : (OCBuildFileDescriptor)this.myBottomProvider.produce();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private OCBuildFileDescriptor nextFromProviders() {
                if (!this.myUseClusters) {
                    return null;
                }
                while (true) {
                    BuildFileProvider provider2;
                    OCBuildFileDescriptor next;
                    if (this.myCurrentProvider != null && (next = (OCBuildFileDescriptor)this.myCurrentProvider.produce()) != null) {
                        return next;
                    }
                    Collection<BuildFileProvider> collection = this.myProviders;
                    synchronized (collection) {
                        Iterator<BuildFileProvider> iterator2 = this.myProviders.iterator();
                        if (!iterator2.hasNext()) {
                            break;
                        }
                        provider2 = iterator2.next();
                        iterator2.remove();
                    }
                    this.myCurrentProvider = provider2;
                }
                this.myUseClusters = false;
                return null;
            }
        }

        @FunctionalInterface
        private static interface BuildFileProvider
        extends Producer<OCBuildFileDescriptor> {
        }

        private static final class OCBuildFileDescriptor {
            private final VirtualFile myFile;
            private final OCResolveConfiguration myConfiguration;
            @NotNull
            private final OCLanguageKind myLanguageKind;
            private final boolean myIsSurrogate;

            private OCBuildFileDescriptor(OCResolveConfiguration configuration, VirtualFile file, @NotNull OCLanguageKind kind, boolean isSurrogate) {
                this.myConfiguration = configuration;
                this.myFile = file;
                this.myLanguageKind = kind;
                this.myIsSurrogate = isSurrogate;
            }
        }

        private static final class OCBuildFileCategory {
            private final Object myConfigurationCluster;
            private final OCLanguageKind myKind;

            private OCBuildFileCategory(@Nullable Object configurationCluster, @Nullable OCLanguageKind kind) {
                this.myConfigurationCluster = configurationCluster;
                this.myKind = kind;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OCBuildFileCategory category = (OCBuildFileCategory)o;
                if (this.myKind != category.myKind) {
                    return false;
                }
                return !(this.myConfigurationCluster != null ? !this.myConfigurationCluster.equals(category.myConfigurationCluster) : category.myConfigurationCluster != null);
            }

            public int hashCode() {
                int result = this.myConfigurationCluster != null ? this.myConfigurationCluster.hashCode() : 0;
                result = 31 * result + (this.myKind != null ? this.myKind.hashCode() : 0);
                return result;
            }
        }
    }

    private abstract class SymbolBuildingTask
    extends DumbModeTask {
        @NotNull
        private final String myActivityName;
        private volatile boolean myShouldCancel;

        protected SymbolBuildingTask(@NotNull String activityName, Object equivalenceObject) {
            super(equivalenceObject);
            this.myShouldCancel = true;
            this.myActivityName = activityName;
        }

        private SymbolBuildingTask(String activityName) {
            this.myShouldCancel = true;
            this.myActivityName = activityName;
        }

        private boolean shouldCancel() {
            return this.myShouldCancel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void performInDumbMode(@NotNull ProgressIndicator original) {
            MyProgressIndicator indicator = new MyProgressIndicator(original);
            Disposable cancelOnProjectDispose = () -> {
                if (this.myShouldCancel) {
                    indicator.cancel();
                }
            };
            try {
                List log = (List)ACTIVITY_LOG.getValue((UserDataHolder)OCSymbolTablesBuildingActivity.this.project);
                long start = System.currentTimeMillis();
                List list = log;
                synchronized (list) {
                    log.add(this.myActivityName + " " + start + ": START");
                }
                Disposer.register((Disposable)OCSymbolTablesBuildingActivity.this.project, (Disposable)cancelOnProjectDispose);
                this.process(indicator);
                this.myShouldCancel = false;
                list = log;
                synchronized (list) {
                    log.add(this.myActivityName + " " + start + ": END after " + (System.currentTimeMillis() - start));
                }
            }
            catch (ProcessCanceledException pce) {
                if (indicator.isCanceled()) {
                    throw pce;
                }
                this.reportUnexpectedException(pce);
            }
            catch (Throwable t) {
                this.reportUnexpectedException(t);
            }
            finally {
                Disposer.dispose((Disposable)cancelOnProjectDispose);
            }
        }

        protected abstract void process(@NotNull MyProgressIndicator var1);

        private void reportUnexpectedException(Throwable t) {
            if (OCSymbolTablesBuildingActivity.this.project.isDisposed() || !OCSymbolTablesBuildingActivity.this.project.isOpen()) {
                return;
            }
            OCLog.LOG.error("Unexpected exception during symbol building (" + this.myActivityName + ")", t instanceof ProcessCanceledException ? new RuntimeException(t) : t);
        }
    }

    public static enum Mode {
        FAST,
        COMPACT,
        FULL;

    }
}

