/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableSerializationVersion;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.MetaData;
import com.jetbrains.cidr.lang.symbols.symtable.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.SerializationSession;
import gnu.trove.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializationServiceImpl
implements SerializationService {
    private static final Logger LOG = Logger.getInstance(SerializationServiceImpl.class);
    private static final int PARALLEL_SERIALIZER_MAX_FOR_ANDROID_STUDIO = 18;
    private static final int PARALLEL_SERIALIZERS = Math.min(18, Runtime.getRuntime().availableProcessors());
    private static final String TABLES_KEY_PREFIX = "objc_file_symbol_tables_attribute:";
    private static final Map<String, FileAttribute> ourFileCacheAttributes = new HashMap<String, FileAttribute>();
    private static final FileAttribute ourFileTablesMetaAttribute = new FileAttribute("objc_file_symbol_tables_meta_attribute", FileSymbolTableSerializationVersion.INSTANCE.getVersion(), false);
    private static final Stack<FileSymbolTableSerializer> ourSerializerPool = new Stack();

    @Override
    public void serializeTables(@NotNull Project project2, @NotNull String projectLocationHash, @NotNull Map<VirtualFile, FileSymbolTablesPack> tables, @NotNull ProgressIndicator indicator) {
        AtomicInteger counter = new AtomicInteger();
        int size = tables.size();
        ConcurrentLinkedQueue<VirtualFile> queue = new ConcurrentLinkedQueue<VirtualFile>(tables.keySet());
        String keyForSerialization = SerializationServiceImpl.getKeyForSerialization(projectLocationHash);
        FileAttribute cacheAttribute = SerializationServiceImpl.getFileCacheAttributeForProjectKey(keyForSerialization);
        String basePath = project2.getBasePath();
        LOG.assertTrue(basePath != null);
        this.serializeParallel(project2, indicator, (Consumer<FileSymbolTableSerializer>)((Consumer)serializer2 -> {
            VirtualFile file;
            boolean ok = true;
            while (ok && (file = (VirtualFile)queue.poll()) != null) {
                indicator.checkCanceled();
                VirtualFile finalFile = file;
                ok = (Boolean)ReadAction.compute(() -> {
                    indicator.checkCanceled();
                    if (SerializationServiceImpl.shouldSerializeTable(finalFile)) {
                        try {
                            MetaData metaData = SerializationServiceImpl.readMetaData(serializer2, finalFile);
                            metaData.registerProject(projectLocationHash, basePath);
                            SerializationServiceImpl.writeMetaData(serializer2, finalFile, metaData);
                            FileSymbolTablesPack pack = (FileSymbolTablesPack)tables.get(finalFile);
                            SerializationServiceImpl.writePack(pack, finalFile, serializer2, cacheAttribute);
                        }
                        catch (IOException e) {
                            LOG.error("Can't serialize file symbol table", (Throwable)e);
                            return false;
                        }
                    }
                    return true;
                });
                indicator.setFraction((double)counter.incrementAndGet() / (double)size);
            }
        }));
    }

    @Override
    @NotNull
    public Map<VirtualFile, FileSymbolTablesPack> deserializeTables(@NotNull Project project2, @NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project2);
        ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(project2);
        THashSet processedFiles = new THashSet();
        Set notLoaded = ContainerUtil.newConcurrentSet();
        notLoaded.addAll(filesToLoad);
        ArrayDeque<VirtualFile> workset = new ArrayDeque<VirtualFile>(filesToLoad);
        Set dirtySet = ContainerUtil.newConcurrentSet();
        MultiMap importsMap = new MultiMap();
        ConcurrentMap result = ContainerUtil.newConcurrentMap();
        long total = notLoaded.size();
        this.serializeParallel(project2, indicator, (Consumer<FileSymbolTableSerializer>)((Consumer)arg_0 -> this.lambda$deserializeTables$3(projectLocationHash, indicator, workset, (Set)processedFiles, dirtySet, notLoaded, indicatorScale, total, importsMap, moduleMapManager, moduleMapResolveService, result, arg_0)));
        workset.addAll(dirtySet);
        while (!workset.isEmpty()) {
            VirtualFile file = workset.pop();
            for (VirtualFile dep : importsMap.get((Object)file)) {
                if (!dirtySet.add(dep)) continue;
                workset.push(dep);
            }
        }
        for (VirtualFile file : dirtySet) {
            result.remove(file);
        }
        return result;
    }

    private void serializeParallel(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull Consumer<FileSymbolTableSerializer> task) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < PARALLEL_SERIALIZERS; ++i) {
            futures.add(ApplicationManager.getApplication().executeOnPooledThread(() -> {
                FileSymbolTableSerializer serializer2 = SerializationServiceImpl.borrowSerializer(project2);
                try {
                    task.consume((Object)serializer2);
                }
                finally {
                    this.returnSerializer(serializer2);
                }
            }));
        }
        SmartList exceptions = new SmartList();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                exceptions.add(e.getCause());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new CompoundRuntimeException((List)exceptions);
        }
        indicator.checkCanceled();
    }

    private static boolean shouldSerializeTable(@NotNull VirtualFile file) {
        return file.isValid() && file instanceof VirtualFileWithId && !file.isDirectory();
    }

    @NotNull
    private static String getKeyForSerialization(String projectLocationHash) {
        return TABLES_KEY_PREFIX + projectLocationHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static FileAttribute getFileCacheAttributeForProjectKey(@NotNull String key) {
        FileAttribute attribute;
        Map<String, FileAttribute> map2 = ourFileCacheAttributes;
        synchronized (map2) {
            attribute = ourFileCacheAttributes.get(key);
            if (attribute == null) {
                attribute = new FileAttribute(key, FileSymbolTableSerializationVersion.INSTANCE.getVersion(), false);
                ourFileCacheAttributes.put(key, attribute);
            }
        }
        return attribute;
    }

    @Nullable
    private static FileSymbolTablesPack readTablesForFile(@NotNull FileSymbolTableSerializer serializer2, @NotNull SerializationSession session, @NotNull VirtualFile file) throws IOException {
        boolean metaDataChanged;
        String lastLocationHash;
        String keyForSerialization;
        FileSymbolTablesPack pack = null;
        MetaData metaData = SerializationServiceImpl.readMetaData(serializer2, file);
        boolean upToDate = metaData.isFileUpToDate();
        if (upToDate && (pack = SerializationServiceImpl.readPack(serializer2, keyForSerialization = SerializationServiceImpl.getKeyForSerialization(session.getProjectLocationHash()), file)) == null && (lastLocationHash = metaData.getMostRecentLocationHash()) != null && (pack = SerializationServiceImpl.readPack(serializer2, keyForSerialization = SerializationServiceImpl.getKeyForSerialization(lastLocationHash), file)) != null) {
            pack.markAsFallback();
        }
        if (metaDataChanged = metaData.evictProjects((projectKey, projectPath) -> {
            if (upToDate && session.projectExists(projectPath)) {
                return false;
            }
            FileAttribute attribute = SerializationServiceImpl.getFileCacheAttributeForProjectKey(projectKey);
            attribute.writeAttribute(file).close();
            return true;
        })) {
            SerializationServiceImpl.writeMetaData(serializer2, file, metaData);
        }
        return pack;
    }

    @Nullable
    private static FileSymbolTablesPack readPack(@NotNull FileSymbolTableSerializer serializer2, @NotNull String keyForSerialization, @NotNull VirtualFile file) throws IOException {
        FileAttribute attribute = SerializationServiceImpl.getFileCacheAttributeForProjectKey(keyForSerialization);
        try (DataInputStream dis = attribute.readAttribute(file);){
            if (dis == null || dis.available() == 0) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            long metaIndicesVersion = dis.readLong();
            if (metaIndicesVersion != FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion()) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            long savedTimestamp = dis.readLong();
            if (savedTimestamp != file.getTimeStamp()) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            FileSymbolTablesPack fileSymbolTablesPack = serializer2.readSymbolTables(dis, file);
            return fileSymbolTablesPack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePack(@NotNull FileSymbolTablesPack pack, @NotNull VirtualFile finalFile, @NotNull FileSymbolTableSerializer serializer2, @NotNull FileAttribute cacheAttribute) throws IOException {
        try (DataOutputStream dos = cacheAttribute.writeAttribute(finalFile);){
            dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
            dos.writeLong(finalFile.getTimeStamp());
            Object object = pack.getTablesAccessLock();
            synchronized (object) {
                serializer2.writeSymbolTables(dos, pack);
                pack.setSerialized();
            }
        }
    }

    @NotNull
    private static MetaData readMetaData(FileSymbolTableSerializer serializer2, VirtualFile file) throws IOException {
        try (DataInputStream dis = ourFileTablesMetaAttribute.readAttribute(file);){
            if (dis == null || dis.available() == 0) {
                MetaData metaData = new MetaData();
                return metaData;
            }
            long metaIndicesVersion = dis.readLong();
            long metaFileTimestamp = dis.readLong();
            boolean isUpToDate = metaIndicesVersion == FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion();
            isUpToDate = isUpToDate && metaFileTimestamp == file.getTimeStamp();
            MetaData metaData = serializer2.readMetaData(dis);
            if (metaData == null) {
                MetaData metaData2 = new MetaData();
                return metaData2;
            }
            metaData.setFileUpToDate(isUpToDate);
            MetaData metaData3 = metaData;
            return metaData3;
        }
    }

    private static void writeMetaData(FileSymbolTableSerializer serializer2, VirtualFile file, MetaData metaData) throws IOException {
        try (DataOutputStream dos = ourFileTablesMetaAttribute.writeAttribute(file);){
            dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
            dos.writeLong(file.getTimeStamp());
            serializer2.writeMetaData(dos, metaData);
        }
    }

    @Override
    @Nullable
    public FileSymbolTablesPack deserializeTables(@NotNull Project project2, @NotNull SerializationSession session, @NotNull VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Ref ref = Ref.create();
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            FileSymbolTableSerializer serializer2 = SerializationServiceImpl.borrowSerializer(project2);
            try {
                FileSymbolTablesPack p = SerializationServiceImpl.readTablesForFile(serializer2, session, file);
                if (p != null && !p.isEmpty()) {
                    ref.set((Object)p);
                }
            }
            catch (IOException e) {
                LOG.error("Can't deserialize file symbol table", (Throwable)e);
            }
            finally {
                this.returnSerializer(serializer2);
            }
        });
        return (FileSymbolTablesPack)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static FileSymbolTableSerializer borrowSerializer(@NotNull Project project2) {
        Stack<FileSymbolTableSerializer> stack = ourSerializerPool;
        synchronized (stack) {
            FileSymbolTableSerializer result = (FileSymbolTableSerializer)ourSerializerPool.tryPop();
            if (result == null) {
                result = new FileSymbolTableSerializer();
            }
            result.setProject(project2);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void returnSerializer(@NotNull FileSymbolTableSerializer serializer2) {
        Stack<FileSymbolTableSerializer> stack = ourSerializerPool;
        synchronized (stack) {
            serializer2.setProject(null);
            serializer2.compact();
            ourSerializerPool.push((Object)serializer2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$deserializeTables$3(String projectLocationHash, final ProgressIndicator indicator, ArrayDeque workset, Set processedFiles, final Set dirtySet, Set notLoaded, double indicatorScale, long total, MultiMap importsMap, ModuleMapManager moduleMapManager, ModuleMapResolveService moduleMapResolveService, Map result, final FileSymbolTableSerializer serializer2) {
        try {
            final SerializationSession session = new SerializationSession(projectLocationHash);
            while (true) {
                VirtualFile file;
                indicator.checkCanceled();
                ArrayDeque arrayDeque = workset;
                synchronized (arrayDeque) {
                    if (workset.isEmpty()) {
                        return;
                    }
                    file = (VirtualFile)workset.pop();
                    if (!processedFiles.add(file)) {
                        continue;
                    }
                }
                FileSymbolTablesPack pack = (FileSymbolTablesPack)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<FileSymbolTablesPack, IOException>(){

                    public FileSymbolTablesPack compute() throws IOException {
                        indicator.checkCanceled();
                        if (!SerializationServiceImpl.shouldSerializeTable(file)) {
                            return null;
                        }
                        FileSymbolTablesPack p = SerializationServiceImpl.readTablesForFile(serializer2, session, file);
                        if (p == null) {
                            dirtySet.add(file);
                        }
                        return p;
                    }
                });
                if (pack == null) continue;
                notLoaded.remove(file);
                indicator.setFraction(indicatorScale * ((double)total - (double)notLoaded.size()) / (double)total);
                if (pack.isEmpty()) continue;
                for (FileSymbolTable table : pack.tablesView()) {
                    table.processIncludes((Processor<? super OCSymbol>)((Processor)include -> {
                        ModuleMapModuleSymbol module2;
                        indicator.checkCanceled();
                        if (include instanceof OCIncludeSymbol) {
                            VirtualFile targetFile;
                            OCIncludeSymbol inc = (OCIncludeSymbol)include;
                            if (inc.isSymbolTableUsed() && (targetFile = inc.getTargetFile()) != null) {
                                ArrayDeque arrayDeque = workset;
                                synchronized (arrayDeque) {
                                    workset.push(targetFile);
                                    importsMap.putValue((Object)targetFile, (Object)file);
                                }
                            }
                        } else if (include instanceof OCModuleImportSymbol && (module2 = moduleMapManager.findModule(include.getName(), null)) != null) {
                            ArrayDeque arrayDeque = workset;
                            synchronized (arrayDeque) {
                                for (VirtualFile header : moduleMapResolveService.getIncludeHeaders(module2, null)) {
                                    workset.push(header);
                                    importsMap.putValue((Object)header, (Object)file);
                                }
                            }
                        }
                        return true;
                    }));
                }
                result.put(file, pack);
            }
        }
        catch (IOException e) {
            LOG.error("Can't deserialize file symbol table", (Throwable)e);
            return;
        }
    }
}

