/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMagicType
extends OCType {
    public static final String UNKNOWN = "<unknown>";
    public static final OCMagicType SEVERAL_UNRELATED_STRUCTS = new OCMagicType(){

        @Override
        public void attachAliasName(@Nullable String aliasName) {
        }

        @Override
        public void attachGuessedType(@Nullable OCType guessedType) {
        }

        @Override
        public void attachNullability(@Nullable OCNullability nullability) {
        }

        @Override
        public OCType getShallowCopy() {
            return this;
        }
    };
    @NotNull
    private String myName;
    @Nullable
    private OCType myGuessedType;

    public OCMagicType(@NotNull String name2, @Nullable OCType guessedType, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myName = name2;
        this.myGuessedType = guessedType;
    }

    public OCMagicType(String name2) {
        this(name2, false, false);
    }

    public OCMagicType(String name2, boolean isConst, boolean isVolatile) {
        this(name2 != null ? name2 : UNKNOWN, null, isConst, isVolatile);
    }

    public OCMagicType() {
        this(UNKNOWN, null, false, false);
    }

    public OCMagicType(OCType inner) {
        this(inner.getName(), inner, false, false);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitMagicType(this);
    }

    @NotNull
    public String getMagicName() {
        return this.myName;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isCppStructType(@NotNull OCCompilationContext context) {
        return true;
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return true;
    }

    public OCType getRefType() {
        OCType guessedUnmagicType = this.getGuessedUnmagicType();
        if (guessedUnmagicType instanceof OCPointerType) {
            return new OCMagicType(((OCPointerType)guessedUnmagicType).getRefType());
        }
        return this;
    }

    @Override
    @NotNull
    public OCType getTerminalType() {
        OCType guessedUnmagicType = this.getGuessedUnmagicType();
        if (guessedUnmagicType instanceof OCPointerType) {
            return new OCMagicType(guessedUnmagicType.getTerminalType());
        }
        return this;
    }

    @Override
    @NotNull
    public OCType getGuessedUnmagicType() {
        return this.myGuessedType != null ? this.myGuessedType.getGuessedUnmagicType() : this;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMagicType f = (OCMagicType)first;
        OCMagicType s = (OCMagicType)second;
        if (!f.myName.equals(s.myName)) {
            return false;
        }
        return c.equalObjects(f.myGuessedType, s.myGuessedType);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myName.hashCode();
    }
}

