/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.ArcAnnotatedType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceType
extends OCType
implements Serializable,
ArcAnnotatedType {
    @NotNull
    private OCSymbolReference myReference;
    @NotNull
    private String[] myProtocolNames;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private ARCAttribute myARCAttribute;
    private boolean myIsKindof;
    private boolean myFunctionParameterType = false;

    public OCReferenceType() {
    }

    public OCReferenceType(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, @NotNull String[] protocolNames, @NotNull OCTypeSubstitution substitution, @Nullable ARCAttribute arcAttribute, @Nullable OCNullability nullability, boolean functionParameterType, boolean isKindof) {
        super(isConst, isVolatile, nullability);
        this.myReference = reference;
        this.myProtocolNames = protocolNames;
        this.mySubstitution = substitution;
        this.myARCAttribute = arcAttribute;
        this.myFunctionParameterType = functionParameterType;
        this.myIsKindof = isKindof;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceType f = (OCReferenceType)first;
        OCReferenceType s = (OCReferenceType)second;
        if (f.myARCAttribute != s.myARCAttribute) {
            return false;
        }
        if (f.myIsKindof != s.myIsKindof) {
            return false;
        }
        if (!Arrays.equals(f.myProtocolNames, s.myProtocolNames)) {
            return false;
        }
        if (!c.equalObjects(f.myReference, s.myReference)) {
            return false;
        }
        return c.equalObjects(f.mySubstitution, s.mySubstitution);
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + this.myReference.hashCode();
        result = 31 * result + (this.myARCAttribute == null ? 0 : this.myARCAttribute.hashCode());
        result = 31 * result + Arrays.hashCode(this.myProtocolNames);
        result = 31 * result + this.mySubstitution.hashCode();
        result = 31 * result + Boolean.valueOf(this.myIsKindof).hashCode();
        return result;
    }

    @NotNull
    public String[] getProtocolNames() {
        return this.myProtocolNames;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        return true;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @NotNull
    public static OCType resolvedFromText(String name2, @NotNull PsiElement context) {
        return OCReferenceType.fromText(name2).resolve(context);
    }

    @NotNull
    public static OCType resolvedFromText(String name2, @NotNull OCResolveContext context) {
        return OCReferenceType.fromText(name2).resolve(context);
    }

    @NotNull
    public static OCType resolvedFromText(String name2, @NotNull String protocolName, @NotNull PsiElement context) {
        return OCReferenceType.fromText(name2, protocolName).resolve(context);
    }

    @NotNull
    public static OCType resolvedFromText(String name2, @NotNull String protocolName, @NotNull OCResolveContext context) {
        return OCReferenceType.fromText(name2, protocolName).resolve(context);
    }

    @NotNull
    public static OCType resolvedFromText(String name2, @NotNull OCResolveContext context, boolean ignoreImports) {
        return OCReferenceType.fromText(name2).resolve(context, ignoreImports);
    }

    @NotNull
    public static OCReferenceType fromText(String name2) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name2))).build();
    }

    @NotNull
    public static OCReferenceType fromText(String name2, @NotNull String protocolName) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name2))).setSingleProtocolName(protocolName).build();
    }

    @NotNull
    public static OCReferenceType fromText(String name2, @NotNull String[] protocolNames) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name2))).setProtocolNames(protocolNames).build();
    }

    public static OCReferenceType fromQualifiedName(OCQualifiedName name2) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(name2)).build();
    }

    @NotNull
    public OCReferenceType cloneWithReference(@NotNull OCSymbolReference reference) {
        return new OCReferenceType(this.isConst(), this.isVolatile(), reference, this.myProtocolNames, this.mySubstitution, this.myARCAttribute, this.getNullability(), this.myFunctionParameterType, this.myIsKindof);
    }

    @NotNull
    public OCSymbolReference getReference() {
        return this.myReference;
    }

    @NotNull
    public OCSymbolReference getReference(@NotNull OCResolveContext context) {
        return this.getReference(context.getFile());
    }

    @NotNull
    public OCSymbolReference getReference(@Nullable PsiFile file) {
        return this.getReference(!(file instanceof OCFile) || ((OCFile)file).getKind().isObjC());
    }

    @NotNull
    public OCSymbolReference getReference(boolean maybeObjC) {
        if (!maybeObjC) {
            OCQualifiedName qualifiedName = this.myReference.getQualifiedName();
            if (this.myProtocolNames.length > 0 && !(qualifiedName instanceof OCQualifiedNameWithArguments)) {
                return this.myReference.applyTypeArguments(ContainerUtil.map((Object[])this.myProtocolNames, argumentName -> new OCReferenceTypeBuilder(this.myReference.createReferenceInSameContext(OCQualifiedName.interned(argumentName))).build()));
            }
        }
        return this.myReference;
    }

    @Override
    @Nullable
    public ARCAttribute getARCAttribute() {
        return this.myARCAttribute;
    }

    @Override
    @NotNull
    public OCReferenceType cloneWithArcAttribute(@Nullable ARCAttribute arcAttribute) {
        OCReferenceType clone = (OCReferenceType)this.getShallowCopy();
        clone.myARCAttribute = arcAttribute;
        return clone;
    }

    public boolean isFunctionParameterType() {
        return this.myFunctionParameterType;
    }

    public void setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }

    public boolean hasElaboratedTypeSpecifier() {
        return OCSymbolReference.removeTypeToken((String)this.myReference.getQualifiedName().getName()).typeToken != null;
    }
}

