/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCLocalTypes;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceTypeBuilder {
    private boolean myConst = false;
    private boolean myVolatile = false;
    @Nullable
    private OCNullability myNullability;
    @NotNull
    private final OCSymbolReference myReference;
    @NotNull
    private String[] myProtocolNames = ArrayUtilRt.EMPTY_STRING_ARRAY;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private ARCAttribute myARCAttribute = null;
    private boolean myFunctionParameterType = false;
    private boolean myIsKindof = false;

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name2, @Nullable OCSymbolWithQualifiedName globalContext, @Nullable VirtualFile file, long complexOffset, boolean isBaseClause, boolean isInsideTemplateArguments, boolean isSpecialization) {
        this(OCReferenceTypeBuilder.makeGlobalReference(name2, globalContext, file, complexOffset, isBaseClause, isInsideTemplateArguments, isSpecialization));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name2, @Nullable PsiElement localContext, @Nullable OCSymbolWithQualifiedName globalContext, boolean isBaseClause, @Nullable VirtualFile file, long complexOffset) {
        this(OCReferenceTypeBuilder.tryMakeLocalReference(name2, localContext, globalContext, isBaseClause, file, complexOffset));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name2, @Nullable PsiElement localContext, @Nullable VirtualFile file) {
        this(OCReferenceTypeBuilder.tryMakeLocalReference(name2, localContext, null, false, file, -1L));
    }

    public OCReferenceTypeBuilder(@NotNull OCSymbolReference reference) {
        this.myReference = reference;
    }

    @NotNull
    private static OCSymbolReference makeGlobalReference(@NotNull OCQualifiedName name2, @Nullable OCSymbolWithQualifiedName globalContext, @Nullable VirtualFile file, long complexOffset, boolean isBaseClause, boolean isInsideTemplateArguments, boolean isSpecialization) {
        if (isBaseClause) {
            return OCSymbolReference.getBaseClauseReference(name2, globalContext, file, complexOffset);
        }
        if (isInsideTemplateArguments) {
            return OCSymbolReference.getTemplateArgsReference(name2, globalContext, file, complexOffset, isSpecialization);
        }
        return OCSymbolReference.getGlobalReference(name2, globalContext, file, complexOffset);
    }

    @NotNull
    private static OCSymbolReference tryMakeLocalReference(@NotNull OCQualifiedName name2, @Nullable PsiElement localContext, @Nullable OCSymbolWithQualifiedName globalContext, boolean isBaseClause, @Nullable VirtualFile virtualFile, long complexOffset) {
        PsiElement adjustedStruct;
        long adjustedOffset;
        Boolean local = false;
        if (localContext != null) {
            OCFile file = (OCFile)localContext.getContainingFile();
            virtualFile = OCElementUtil.getVirtualFile(localContext);
            local = OCLocalTypes.canBeLocalType(file, name2);
            if (local == null) {
                local = PsiTreeUtil.getTopmostParentOfType((PsiElement)localContext, OCCallable.class) != null;
            } else if (OCLocalTypes.hasLocalUsingStatement(file, (OCCallable)PsiTreeUtil.getTopmostParentOfType((PsiElement)localContext, OCCallable.class))) {
                local = true;
            }
        }
        if (local.booleanValue()) {
            return OCSymbolReference.getLocalReference(name2, localContext);
        }
        if (globalContext == null) {
            globalContext = OCSymbolReferenceResolver.getGlobalContextFromLocal(localContext);
        }
        long l = adjustedOffset = (adjustedStruct = OCSymbolReferenceResolver.getAdjustedScope(localContext)) == null ? complexOffset : OCSymbolOffsetUtil.getComplexRange(adjustedStruct).getEndOffset();
        if (isBaseClause) {
            return OCSymbolReference.getBaseClauseReference(name2, globalContext, virtualFile, complexOffset);
        }
        if (localContext != null && localContext.getParent() instanceof OCTemplateArgumentList) {
            return OCSymbolReference.getTemplateArgsReference(name2, globalContext, virtualFile, adjustedOffset, localContext.getParent().getParent() instanceof OCStruct);
        }
        return OCSymbolReference.getGlobalReference(name2, globalContext, virtualFile, adjustedOffset);
    }

    @NotNull
    public OCReferenceTypeBuilder setSingleProtocolName(@NotNull String protocolName) {
        return this.setProtocolNames(new String[]{protocolName});
    }

    @NotNull
    public OCReferenceTypeBuilder setProtocolNames(@NotNull String[] protocolNames) {
        this.myProtocolNames = protocolNames;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setSubstitution(@NotNull OCTypeSubstitution substitution) {
        this.mySubstitution = substitution;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setARCAttribute(@Nullable ARCAttribute arcAttribute) {
        this.myARCAttribute = arcAttribute;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setProtocolSubstitutionARCFromType(@NotNull OCReferenceType fromType) {
        this.setProtocolNames(fromType.getProtocolNames());
        this.setSubstitution(fromType.getSubstitution());
        this.setARCAttribute(fromType.getARCAttribute());
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setConstVolatile(boolean isConst, boolean isVolatile) {
        this.myConst = isConst;
        this.myVolatile = isVolatile;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setConstVolatile(@NotNull OCType fromType) {
        return this.setConstVolatile(fromType.isConst(), fromType.isVolatile());
    }

    @NotNull
    public OCReferenceTypeBuilder setNullability(@Nullable OCNullability nullability) {
        this.myNullability = nullability;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
        return this;
    }

    public void setIsKindof(boolean isKindof) {
        this.myIsKindof = isKindof;
    }

    @NotNull
    public OCReferenceType build() {
        return new OCReferenceType(this.myConst, this.myVolatile, this.myReference, this.myProtocolNames, this.mySubstitution, this.myARCAttribute, this.myNullability, this.myFunctionParameterType, this.myIsKindof);
    }
}

