/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTollFreeBridges {
    private static String[][] ourArray = new String[][]{{"CFArrayRef", "NSArray *"}, {"CFAttributedStringRef", "NSAttributedString *"}, {"CFCalendarRef", "NSCalendar *"}, {"CFCharacterSetRef", "NSCharacterSet *"}, {"CFDataRef", "NSData *"}, {"CFDateRef", "NSDate *"}, {"CFDictionaryRef", "NSDictionary *"}, {"CFErrorRef", "NSError *"}, {"CFLocaleRef", "NSLocale *"}, {"CFMutableArrayRef", "NSMutableArray *"}, {"CFMutableAttributedStringRef", "NSMutableAttributedString *"}, {"CFMutableCharacterSetRef", "NSMutableCharacterSet *"}, {"CFMutableDataRef", "NSMutableData *"}, {"CFMutableDictionaryRef", "NSMutableDictionary *"}, {"CFMutableSetRef", "NSMutableSet *"}, {"CFMutableStringRef", "NSMutableString *"}, {"CFNumberRef", "NSNumber *"}, {"CFReadStreamRef", "NSInputStream *"}, {"CFRunLoopTimerRef", "NSTimer *"}, {"CFSetRef", "NSSet *"}, {"CFStringRef", "NSString *"}, {"CFTimeZoneRef", "NSTimeZone *"}, {"CFURLRef", "NSURL *"}, {"CFWriteStreamRef", "NSOutputStream *"}, {"CGPoint", "NSPoint"}, {"CGSize", "NSSize"}, {"CGRect", "NSRect"}, {"CFRange", "NSRange"}};
    private static Map<String, String> cfToNSMap = new HashMap<String, String>();
    private static Map<String, String> nsToCFMap = new HashMap<String, String>();

    private OCTollFreeBridges() {
    }

    @Nullable
    public static String getNSCounterpart(String cfTypeName) {
        return cfToNSMap.get(cfTypeName);
    }

    @Nullable
    public static OCType getResolvedNSCounterpart(String cfTypeName, @NotNull PsiElement context) {
        return OCTollFreeBridges.resolve(cfToNSMap.get(cfTypeName), context);
    }

    @Nullable
    private static OCType resolve(@Nullable String nsType, @NotNull PsiElement context) {
        if (nsType != null) {
            if (nsType.endsWith(" *")) {
                nsType = nsType.substring(0, nsType.length() - 2);
                return OCPointerType.to(OCReferenceType.resolvedFromText(nsType, context));
            }
            return OCReferenceType.resolvedFromText(nsType, context);
        }
        return null;
    }

    public static boolean hasCFCounterpart(String nsTypeName) {
        return nsToCFMap.containsKey(nsTypeName);
    }

    @Nullable
    public static OCType getCounterpart(OCType type, @NotNull PsiElement context) {
        String typeName = type.getBestNameInContext(context);
        if (nsToCFMap.containsKey(typeName)) {
            return OCTollFreeBridges.resolve(nsToCFMap.get(typeName), context);
        }
        return OCTollFreeBridges.resolve(cfToNSMap.get(typeName), context);
    }

    private static boolean isPtrCompatible(OCType nsType, OCType cfType) {
        String nsCounterpart = OCTollFreeBridges.getNSCounterpart(cfType.cloneWithoutConstModifier(null).getName());
        String nsTypeName = nsType.getName();
        return nsCounterpart != null && (nsCounterpart.equals(nsTypeName) || nsType.isObjCRootType());
    }

    public static boolean isCompatible(OCType type1, OCType type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.isPointerToObject() && type2 instanceof OCPointerType && OCTollFreeBridges.isPtrCompatible(type1, type2) || type2.isPointerToObject() && type1 instanceof OCPointerType && OCTollFreeBridges.isPtrCompatible(type2, type1) || type1 instanceof OCStructType && type2 instanceof OCStructType && (Comparing.equal((String)((OCStructType)type1).getSymbol().getName(), (String)OCTollFreeBridges.getNSCounterpart(((OCStructType)type2).getSymbol().getName())) || Comparing.equal((String)((OCStructType)type2).getSymbol().getName(), (String)OCTollFreeBridges.getNSCounterpart(((OCStructType)type1).getSymbol().getName())));
    }

    static {
        for (String[] pair2 : ourArray) {
            cfToNSMap.put(pair2[0], pair2[1]);
            nsToCFMap.put(pair2[1], pair2[0]);
        }
    }
}

