/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSizeofCalculatorVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCDumbTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitorBase;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCType
implements OCTypeArgument {
    private static final byte IS_CONST = 1;
    private static final byte IS_VOLATILE = 2;
    private static final byte IS_NULLABLE = 4;
    private static final byte IS_NONNULL = 8;
    private static final byte IS_NULL_UNSPECIFIED = 16;
    protected static final byte IS_FUNCTION_LVALUE_REF = 32;
    protected static final byte IS_FUNCTION_RVALUE_REF = 64;
    @Nullable
    protected String myAliasName;
    @Nullable
    private OCType myGuessedType;
    protected byte myTypeAttributes;
    private static Pattern requiresNilAttributePattern = Pattern.compile("sentinel.*");

    public OCType() {
    }

    public OCType(boolean isConst, boolean isVolatile) {
        this.myTypeAttributes = (byte)((isConst ? 1 : 0) | (isVolatile ? 2 : 0));
    }

    public OCType(boolean isConst, boolean isVolatile, @Nullable OCNullability nullability) {
        this(isConst, isVolatile);
        this.attachNullability(nullability);
    }

    public void compact() {
    }

    public void attachAliasName(@Nullable String aliasName) {
        this.myAliasName = aliasName;
    }

    public void attachGuessedType(@Nullable OCType guessedType) {
        this.myGuessedType = guessedType;
    }

    @Contract(pure=true)
    protected static byte clearAttribute(byte mask, byte attribute) {
        return (byte)(mask & ~attribute);
    }

    @Contract(pure=true)
    protected static byte attachAttribute(byte mask, byte attribute) {
        return (byte)(mask | attribute);
    }

    @Contract(pure=true)
    protected final boolean checkAttribute(byte attribute) {
        return (this.myTypeAttributes & attribute) != 0;
    }

    public void attachNullability(@Nullable OCNullability nullability) {
        byte newAttribute = this.myTypeAttributes;
        newAttribute = OCType.clearAttribute(newAttribute, (byte)8);
        newAttribute = OCType.clearAttribute(newAttribute, (byte)4);
        newAttribute = OCType.clearAttribute(newAttribute, (byte)16);
        if (nullability == OCNullability.NONNULL) {
            newAttribute = OCType.attachAttribute(newAttribute, (byte)8);
        } else if (nullability == OCNullability.NULLABLE) {
            newAttribute = OCType.attachAttribute(newAttribute, (byte)4);
        } else if (nullability == OCNullability.UNSPECIFIED) {
            newAttribute = OCType.attachAttribute(newAttribute, (byte)16);
        }
        this.myTypeAttributes = newAttribute;
    }

    @NotNull
    public String getName() {
        return this.getShortName(0);
    }

    @Override
    public String getShortName(int templateDepth) {
        return new OCDumbTypeNameVisitor(templateDepth, null).getName(this);
    }

    @NotNull
    public String getName(@NotNull PsiElement context) {
        return this.getBestNameInContext(OCResolveContext.forPsi(context), null, 0);
    }

    @NotNull
    public String getName(@NotNull OCResolveContext context) {
        return this.getBestNameInContext(context, null, 0);
    }

    public String getBestNameInContext(@NotNull PsiElement context) {
        return this.getName(context);
    }

    public String getBestNameInContext(@NotNull OCResolveContext context) {
        return this.getName(context);
    }

    public String getBestNameInContext(@NotNull PsiElement context, @Nullable String nameHint) {
        return this.getBestNameInContext(OCResolveContext.forPsi(context), nameHint, 0);
    }

    public String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint) {
        return this.getBestNameInContext(context, nameHint, 0);
    }

    private String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint, int templateDepth) {
        if (nameHint != null && this.equalsAfterResolving(nameHint, context)) {
            return nameHint;
        }
        return new OCTypeNameVisitor(Presentation.BEST, true, true, context, templateDepth).getName(this.resolve(context));
    }

    @NotNull
    public String getCanonicalName(@NotNull OCResolveContext context) {
        return new OCTypeNameVisitor(Presentation.FULL, false, true, context, 0).getName(this);
    }

    @Override
    public String getNameForPresentation(Presentation presentation, @NotNull OCResolveContext context, boolean includeGlobalQualifier, int templateDepth) {
        if (presentation == Presentation.BEST) {
            return this.getBestNameInContext(context, null, templateDepth);
        }
        return new OCTypeNameVisitor(Presentation.FULL, false, includeGlobalQualifier, context, templateDepth).getName(this);
    }

    @Nullable
    public String getAliasName() {
        return this.myAliasName;
    }

    public boolean isBetterAliasName(OCType candidateType, String candidateName, String bestAliasName, PsiElement context) {
        if (context != null && candidateName != null && (bestAliasName == null || OCType.getNameComplexity(bestAliasName) > OCType.getNameComplexity(candidateName))) {
            OCType thisType = this;
            if (thisType instanceof OCCppReferenceType) {
                thisType = ((OCCppReferenceType)thisType).getRefType();
            }
            if (candidateType instanceof OCCppReferenceType) {
                candidateType = ((OCCppReferenceType)candidateType).getRefType();
            }
            return thisType.equals(candidateType, OCResolveContext.forPsi(context));
        }
        return false;
    }

    protected static int getNameComplexity(String name2) {
        int complexity = 0;
        for (int i = 0; i < name2.length(); ++i) {
            char symbol = name2.charAt(i);
            if (symbol != ':' && symbol != '<' && symbol != '>') continue;
            ++complexity;
        }
        return complexity;
    }

    @NotNull
    public OCType getGuessedType() {
        return this.myGuessedType != null ? this.myGuessedType : this;
    }

    public boolean hasGuessedType() {
        return this.myGuessedType != null;
    }

    public boolean isConst() {
        return (this.myTypeAttributes & 1) != 0;
    }

    public boolean isVolatile() {
        return (this.myTypeAttributes & 2) != 0;
    }

    @Nullable
    public OCNullability getNullability() {
        if (this.checkAttribute((byte)4)) {
            return OCNullability.NULLABLE;
        }
        if (this.checkAttribute((byte)8)) {
            return OCNullability.NONNULL;
        }
        if (this.checkAttribute((byte)16)) {
            return OCNullability.UNSPECIFIED;
        }
        return null;
    }

    @NotNull
    public CVQualifiers getCVQualifiers() {
        return CVQualifiers.get(this.isConst(), this.isVolatile());
    }

    @NotNull
    public OCType getGuessedUnmagicType() {
        return this;
    }

    @NotNull
    public OCType cloneWithCVQualifiers(@NotNull CVQualifiers modifiers, @Nullable Project project2) {
        if (this.getCVQualifiers() != modifiers) {
            OCType clone = this.getShallowCopy(true, modifiers.isConst(), modifiers.isVolatile());
            if (clone.myAliasName != null) {
                String aliasName = clone.myAliasName;
                aliasName = modifiers.isConst() ? OCTypeNameVisitorBase.addTypeQualifier(aliasName, clone, project2, "const") : OCTypeNameVisitorBase.removeTypeQualifier(aliasName, clone, project2, "const");
                aliasName = modifiers.isVolatile() ? OCTypeNameVisitorBase.addTypeQualifier(aliasName, clone, project2, "volatile") : OCTypeNameVisitorBase.removeTypeQualifier(aliasName, clone, project2, "volatile");
                clone.attachAliasName(aliasName);
            }
            return clone;
        }
        return this;
    }

    @NotNull
    public OCType cloneWithoutCVQualifiers(@Nullable Project project2) {
        return this.cloneWithCVQualifiers(CVQualifiers.EMPTY, project2);
    }

    @NotNull
    public OCType cloneWithAddedCVQualifiers(@NotNull CVQualifiers modifiers, @Nullable Project project2) {
        return this.cloneWithCVQualifiers(this.getCVQualifiers().or(modifiers), project2);
    }

    @NotNull
    public OCType cloneWithoutConstModifier(@Nullable Project project2) {
        return this.cloneWithCVQualifiers(CVQualifiers.get(false, this.isVolatile()), project2);
    }

    @NotNull
    public OCType cloneWithConstModifier(@Nullable Project project2) {
        return this.cloneWithCVQualifiers(CVQualifiers.get(true, this.isVolatile()), project2);
    }

    @NotNull
    public OCType cloneWithAliasName(String aliasName) {
        if (!Comparing.equal((String)this.myAliasName, (String)aliasName)) {
            OCType clone = this.getShallowCopy();
            clone.attachAliasName(aliasName);
            return clone;
        }
        return this;
    }

    @NotNull
    public OCType cloneWithGuessedType(OCType guessedType) {
        if (this.myGuessedType != null || guessedType != null) {
            OCType clone = this.getShallowCopy(true, null, null);
            clone.attachGuessedType(guessedType);
            return clone;
        }
        return this;
    }

    @NotNull
    public OCType cloneWithNullability(@Nullable OCNullability nullability) {
        if (this.getNullability() != nullability) {
            OCType clone = this.getShallowCopy(true, null, null);
            clone.attachNullability(nullability);
            return clone;
        }
        return this;
    }

    public OCType getShallowCopy() {
        return this.getShallowCopy(false, null, null);
    }

    private OCType getShallowCopy(boolean keepAliasName, Boolean forcedConst, Boolean forcedVolatile) {
        OCTypeCloneVisitor visitor = new OCTypeCloneVisitor(true, this, forcedConst, forcedVolatile);
        OCType clone = this.transformType(visitor);
        if (!keepAliasName) {
            clone.attachAliasName(null);
        }
        return clone;
    }

    @NotNull
    public OCType resolve(@NotNull PsiElement element) {
        return this.resolve(OCResolveContext.forPsi(element));
    }

    @NotNull
    public OCType resolve(@NotNull OCResolveContext context) {
        return this.transformType(new OCTypeResolveVisitor(context));
    }

    @NotNull
    public OCType resolve(@NotNull PsiElement context, boolean ignoringImports) {
        return this.transformType(new OCTypeResolveVisitor(OCResolveContext.forPsi(context), ignoringImports));
    }

    @NotNull
    public OCType resolve(@NotNull OCResolveContext context, boolean ignoringImports) {
        return this.transformType(new OCTypeResolveVisitor(context, ignoringImports));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @NotNull
    public OCType getTerminalType() {
        return this;
    }

    @NotNull
    public OCType getArrayElementType() {
        return this;
    }

    public int pointersDepth() {
        return 0;
    }

    public boolean isVoid() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public final boolean isUnresolved(@NotNull PsiElement context) {
        return this.isUnresolved(OCResolveContext.forPsi(context));
    }

    public boolean isUnresolved(@NotNull OCResolveContext context) {
        return false;
    }

    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return false;
    }

    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        return false;
    }

    public boolean isScalar() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isScalarOrConvertibleToScalar(@NotNull OCResolveContext context) {
        if (this.isScalar()) {
            return true;
        }
        if (!this.isCppStructType(context)) {
            return false;
        }
        if (this.isIntConvertible(context) || OCIntType.BOOL_NATIVE.isConvertibleByOperator(this, context, true)) {
            return true;
        }
        if (this.isPointerConvertible(context)) {
            return true;
        }
        return this.isEnumOrEnumConvertible(context);
    }

    public boolean isInstanceable() {
        return false;
    }

    public boolean isPointerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        return !context.isCpp() && this.isIntegerCompatible(context) || checkCppConvertible && this.isCppStructType(context) && this.isPointerConvertible(context);
    }

    public boolean isPointerCompatible(@NotNull OCResolveContext context) {
        return this.isPointerCompatible(context, true);
    }

    public boolean isPointerToString() {
        return "NSString *".equals(this.getName());
    }

    public boolean isPointerToStringCompatible() {
        return this.isPointerToStringCompatible(false);
    }

    public boolean isPointerToStringCompatible(boolean includeMutable) {
        return "NSString *".equals(this.getName()) || "NSString *".equals(OCTollFreeBridges.getNSCounterpart(this.getName())) || includeMutable && ("NSMutableString *".equals(this.getName()) || "NSMutableString *".equals(OCTollFreeBridges.getNSCounterpart(this.getName())));
    }

    public boolean isObjCRootType() {
        String name2 = this.getName();
        return "id".equals(name2) || "NSObject *".equals(name2);
    }

    public boolean isEnumOrEnumConvertible(@NotNull OCResolveContext context) {
        if (!(this instanceof OCStructType)) {
            return false;
        }
        OCStructType that = (OCStructType)this;
        if (that.isEnum()) {
            return true;
        }
        Pair<OCType, OCFunctionSymbol> convertedRes = OCTypeCompatibilityVisitor.convertByOperator(that, false, true, context, (Predicate<OCType>)((Predicate)type -> OCTypeUtils.isEnumType(type)));
        return convertedRes != null;
    }

    private boolean isPointerConvertible(@NotNull OCResolveContext context) {
        return OCPointerType.to(OCVoidType.instance()).isConvertibleByOperator(this, context, false);
    }

    private boolean isIntConvertible(@NotNull OCResolveContext context) {
        return OCIntType.INT.isConvertibleByOperator(this, context, false);
    }

    public boolean isNumberCompatible(@NotNull OCResolveContext context) {
        return this.isCppStructType(context) && OCRealType.DOUBLE.isConvertibleByOperator(this, context, false);
    }

    public boolean isIntegerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        return checkCppConvertible && this.isCppStructType(context) && this.isIntConvertible(context);
    }

    public boolean isIntegerCompatible(@NotNull OCResolveContext context) {
        return this.isIntegerCompatible(context, true);
    }

    public boolean isPointerToObject() {
        return false;
    }

    public boolean isPointerToObjectCompatible() {
        return this.isPointerToObject() || this.isClassType() || this instanceof OCBlockPointerType;
    }

    public boolean isPointerToPointerToObjectCompatible() {
        return this.isPointerToObjectCompatible() || this instanceof OCPointerType && ((OCPointerType)this).getRefType().isPointerToPointerToObjectCompatible();
    }

    public boolean isPointerToID(boolean withProtocols) {
        return false;
    }

    public boolean isPointerToID() {
        return this.isPointerToID(false);
    }

    public boolean isPointerToChar() {
        return false;
    }

    public boolean isCString() {
        return false;
    }

    public boolean isPointer() {
        return false;
    }

    public boolean isPointerToVoid() {
        return false;
    }

    public boolean isClassType(boolean withProtocols) {
        if (this instanceof OCPointerType) {
            OCType refType = ((OCPointerType)this).getRefType();
            String name2 = refType.getName();
            return (name2.equals("struct objc_class") || name2.equals("objc_class")) && (!withProtocols || refType instanceof OCObjectType && !((OCObjectType)refType).getAugmentedProtocols().isEmpty());
        }
        return false;
    }

    public boolean isClassType() {
        return this.isClassType(false);
    }

    public boolean isCppStructType(@NotNull OCCompilationContext context) {
        return false;
    }

    public boolean isPointerToCppStructType(@NotNull OCCompilationContext context) {
        return false;
    }

    @Override
    public boolean isVariadic() {
        return false;
    }

    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context) {
        if (this.isPointerToObject()) {
            return "nil";
        }
        if (OCCompilerFeatures.supportsNullptr(context.getFile())) {
            return "nullptr";
        }
        return "NULL";
    }

    public final int getSizeInBytes(@Nullable PsiFile file, @Nullable OCInclusionContext context, @NotNull Project project2) {
        return new OCSizeofCalculatorVisitor(file, context, project2).calculate(this);
    }

    public OCType transformType(OCTypeVisitor<OCType> visitor) {
        OCType result = this.accept(visitor);
        if (result == null) {
            return null;
        }
        if (this.myAliasName != null) {
            result = result.cloneWithAliasName(this.myAliasName);
        }
        if (this.myGuessedType != null) {
            result = result.cloneWithGuessedType(this.myGuessedType);
        }
        if (this.getNullability() != null) {
            result = result.cloneWithNullability(this.getNullability());
        }
        return result;
    }

    public abstract <T> T accept(OCTypeVisitor<T> var1);

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCType f = (OCType)first;
        OCType s = (OCType)second;
        if (f.myTypeAttributes != s.myTypeAttributes) {
            return false;
        }
        if (!Comparing.equal((String)f.myAliasName, (String)s.myAliasName)) {
            return false;
        }
        return c.equalObjects(f.myGuessedType, s.myGuessedType);
    }

    public final boolean equals(Object o) {
        throw new UnsupportedOperationException("Use equals(Object o, @NotNull OCResolveContext context) instead");
    }

    @Override
    public boolean equals(Object o, @NotNull OCResolveContext context) {
        return this.equals(o, true, context);
    }

    public boolean equals(Object o, boolean checkCV, @NotNull OCResolveContext context) {
        return o instanceof OCType && new OCTypeEqualityVisitor((OCType)o, false, !checkCV, context).equal(this);
    }

    protected int baseHashCode() {
        int result = this.myAliasName != null ? this.myAliasName.hashCode() : 0;
        result = 31 * result + (this.myGuessedType != null ? this.myGuessedType.hashCode() : 0);
        result = 31 * result + this.myTypeAttributes;
        return result;
    }

    public int hashCode() {
        OCLog.LOG.warn("An attempt to get hashCode for OCType base class!");
        return 0;
    }

    public boolean equalsAfterResolving(String typeName, @NotNull OCResolveContext context) {
        PsiElement element = context.getElement();
        return element != null && this.equalsAfterResolving(OCElementUtil.getType(OCElementFactory.typeCodeFragment(typeName, element)), context, true);
    }

    public boolean equalsAfterResolving(OCType type, @NotNull OCResolveContext context, boolean magicTypeEquals) {
        OCType thisType = this;
        if (type == null) {
            return false;
        }
        if (thisType instanceof OCCppReferenceType) {
            thisType = ((OCCppReferenceType)thisType).getRefType();
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        return new OCTypeEqualityAfterResolvingVisitor(type, false, magicTypeEquals, true, true, context).equal(thisType);
    }

    public boolean equalsAfterResolving(OCType type, @NotNull OCResolveContext context) {
        return new OCTypeEqualityAfterResolvingVisitor(type, false, context).equal(this);
    }

    public boolean equalsWithAliasName(OCType type, @NotNull OCResolveContext context) {
        String thisAliasName = this.getAliasName();
        String typeAliasName = type.getAliasName();
        if (thisAliasName == null) {
            thisAliasName = this.getCanonicalName(context);
        }
        if (typeAliasName == null) {
            typeAliasName = type.getCanonicalName(context);
        }
        return Comparing.equal((String)thisAliasName, (String)typeAliasName) && this.equalsAfterResolving(type, context);
    }

    @Deprecated
    @NotNull
    public OCType getLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (type == null) {
            return OCUnknownType.INSTANCE;
        }
        OCType result = this.doGetLeastCommonType(type, context);
        result = result.cloneWithAddedCVQualifiers(this.getCVQualifiers().or(type.getCVQualifiers()), context.getProject());
        result = OCType.updateWithCommonGuessedType(this, type, result, context);
        return result;
    }

    @NotNull
    public static OCType updateWithCommonGuessedType(OCType type1, OCType type2, OCType result, @NotNull OCResolveContext context) {
        OCType commonGuessedType;
        if (!(type1.myGuessedType == null || type2.myGuessedType == null || (commonGuessedType = type1.myGuessedType.doGetLeastCommonType(type2.myGuessedType, context)).isUnknown() || !result.isPointerToID() && commonGuessedType.isCompatible(result, context))) {
            return result.cloneWithGuessedType(commonGuessedType);
        }
        return result;
    }

    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        return OCUnknownType.INSTANCE;
    }

    @NotNull
    public OCTypeCheckResult checkCompatible(OCType type, @Nullable OCTypeOwner expression, @Nullable PsiElement context, @NotNull OCResolveContext resolveContext) {
        return this.checkCompatible(type, expression, context, true, resolveContext);
    }

    @NotNull
    public OCTypeCheckResult checkCompatible(OCType type, @Nullable OCTypeOwner expression, @Nullable PsiElement context, boolean allowImplicitConversions, @NotNull OCResolveContext resolveContext) {
        return OCTypeCompatibilityVisitor.checkConvertible(this, type, expression, context, allowImplicitConversions, allowImplicitConversions, resolveContext);
    }

    public boolean isConvertibleByOperator(OCType type, @NotNull OCResolveContext context, boolean isExplicitCast) {
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCStructType) {
            OCTypeCheckResult error = new OCTypeCheckResult(OCTypeCheckState.ERROR);
            PsiElement element = context.getElement();
            return !OCTypeCompatibilityVisitor.checkConversionOperators(this, (OCStructType)type, null, element, error, isExplicitCast, context).getState().isError(element);
        }
        return false;
    }

    public boolean isCompatible(OCType type, @NotNull OCResolveContext context) {
        return this.checkCompatible(type, null, context.getElement(), true, context).getState() == OCTypeCheckState.OK;
    }

    public boolean isSuperType(OCType type, @NotNull PsiElement context) {
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        OCType self = this.resolve(resolveContext);
        type = type.resolve(resolveContext);
        if (self.isPointerToObject() && type.isPointerToObject()) {
            return self.isCompatible(type, resolveContext);
        }
        if (self.isCppStructType(resolveContext) && type.isCppStructType(resolveContext)) {
            return OCTypeUtils.isSameOrDerivedFrom(type, self, resolveContext) && this.getCVQualifiers() == type.getCVQualifiers();
        }
        if (type instanceof OCArrayType && this instanceof OCPointerType) {
            OCType refType = ((OCPointerType)this).getRefType().resolve(resolveContext);
            OCType typeRefType = ((OCArrayType)type).getRefType().resolve(resolveContext);
            if (refType.isPointerToID() && typeRefType.isPointerToID()) {
                return true;
            }
        }
        return self.equalsAfterResolving(type, resolveContext);
    }

    @Nullable
    public String getFormatString() {
        return null;
    }

    public static boolean isFunctionRequiringNil(OCSymbol callable) {
        for (String attribute : callable.getAttributes()) {
            Matcher matcher = requiresNilAttributePattern.matcher(attribute);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public static enum Presentation {
        FULL,
        BEST;

    }
}

