/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.ArcAnnotatedType;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.MachineModeAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeBuilder {
    @NotNull
    private final OCLanguageKind myFileKind;
    @NotNull
    private final OCInclusionContext myInclusionContext;
    @NotNull
    private final Project myProject;
    private OCType myCurrentType;
    private int longKeywords = 0;
    private List<IElementType> myRefTokens = new ArrayList<IElementType>();
    private List<IElementType> myFunctionRefTokens = new ArrayList<IElementType>();
    @Nullable
    private String[] myProtocols = null;
    private boolean myIsTypedef = false;
    private boolean myWasLT = false;
    private boolean myWasConst = false;
    private boolean myIsInsideBrackets = false;
    private boolean myPassByReference = false;
    private boolean myConst;
    private boolean myVolatile;
    private boolean mySign = false;
    private boolean myUnsign = false;
    private boolean myWasComplex;
    private boolean myVariadic;
    private OCQualifiedName myPointerQualifier;
    private int myParLevel = 0;
    private BuilderDriverBase.DeclarationContext myLocalContext;
    private OCQualifiedName myNamespaceQualifier;
    private String myName;
    private long myComplexOffset = -1L;
    private VirtualFile myVirtualFile = null;
    private List<OCTypeArgument> myTypeArguments;
    private MachineModeAttribute myModeAttribute;
    private static final OCExpressionSymbol[] EMPTY_ARRAY_LENGTHS = new OCExpressionSymbol[0];
    private OCExpressionSymbol[] myArrayLengths = EMPTY_ARRAY_LENGTHS;
    @Nullable
    private OCExpressionSymbol myArrayLengthSymbol = null;
    private boolean myWasAuto = false;
    private boolean myIsKindof = false;
    private OCNullability myNullability = null;
    private boolean myAssumeNonNullOn;

    public OCTypeBuilder(@NotNull OCLanguageKind fileKind, @NotNull OCInclusionContext inclusionContext, @NotNull BuilderDriverBase.DeclarationContext context, @NotNull Project project2) {
        this.myFileKind = fileKind;
        this.myInclusionContext = inclusionContext;
        this.myLocalContext = context;
        this.myAssumeNonNullOn = context.isAssumeNonNull();
        if (context.isLambdaInitCapture()) {
            this.myWasAuto = true;
            this.myCurrentType = new OCAutoType();
        }
        this.myProject = project2;
    }

    public void setLocalContext(@NotNull BuilderDriverBase.DeclarationContext localContext) {
        this.myLocalContext = localContext;
    }

    public void setOffset(VirtualFile virtualFile, long offset) {
        this.myVirtualFile = virtualFile;
        this.myComplexOffset = offset;
    }

    public void setPointerQualifier(OCQualifiedName pointerQualifier, VirtualFile virtualFile, long complexOffset) {
        this.myPointerQualifier = pointerQualifier;
        if (this.myComplexOffset == -1L) {
            this.myVirtualFile = virtualFile;
            this.myComplexOffset = complexOffset;
        }
    }

    public void learn(IElementType token) {
        this.learn(token, null, null, -1L);
    }

    public void learnNamespaceQualifier(OCQualifiedName qualifier) {
        this.myNamespaceQualifier = qualifier;
    }

    public void learn(IElementType token, @Nullable String tokenText, @Nullable VirtualFile file, long complexOffset) {
        List<IElementType> refTokens;
        List<IElementType> list = refTokens = this.isInsideParentheses() ? this.myFunctionRefTokens : this.myRefTokens;
        if (token == OCTokenTypes.MUL) {
            refTokens.add(OCTokenTypes.MUL);
            this.myConst = false;
        } else if (token == OCTokenTypes.XOR) {
            refTokens.add(OCTokenTypes.XOR);
            this.myConst = false;
        } else if (token == OCTokenTypes.AND) {
            refTokens.add(OCTokenTypes.AND);
            this.myConst = false;
        } else if (token == OCTokenTypes.ANDAND) {
            refTokens.add(OCTokenTypes.ANDAND);
            this.myConst = false;
        } else if (token == OCTokenTypes.CONST_KEYWORD) {
            refTokens.add(OCTokenTypes.CONST_KEYWORD);
            this.myConst = true;
            this.myWasConst = true;
        } else if (token == OCTokenTypes.VOLATILE_KEYWORD) {
            refTokens.add(OCTokenTypes.VOLATILE_KEYWORD);
            this.myVolatile = true;
        } else if (token == OCTokenTypes.LBRACKET) {
            this.myIsInsideBrackets = true;
        } else if (token == OCTokenTypes.RBRACKET) {
            this.myArrayLengths = (OCExpressionSymbol[])ArrayUtil.append((Object[])this.myArrayLengths, (Object)this.myArrayLengthSymbol);
            this.myArrayLengthSymbol = null;
            refTokens.add(OCTokenTypes.LBRACKET);
            this.myIsInsideBrackets = false;
        } else if (token == OCTokenTypes.LPAR) {
            ++this.myParLevel;
        } else if (token == OCTokenTypes.RPAR) {
            --this.myParLevel;
        } else if (token == OCTokenTypes.ELLIPSIS) {
            if (this.myCurrentType == null && this.myName == null || !this.myFileKind.isCpp()) {
                this.myCurrentType = OCEllipsisType.instance();
            } else {
                this.myVariadic = true;
            }
        } else if (OCTokenTypes.NULLABILITY_KEYWORDS.contains(token)) {
            refTokens.add(token);
        } else if (OCTokenTypes.IN_SELECTOR_NULLABILITY_KEYWORDS.contains(token)) {
            this.myNullability = OCNullability.parseFrom(token);
        }
        if (this.isInsideParentheses()) {
            return;
        }
        if (token == OCTokenTypes.SIGNED_KEYWORD) {
            if (this.mySign) {
                this.error("duplicate 'signed'");
            }
            this.mySign = true;
            if (this.myUnsign) {
                this.error("'signed' and 'unsigned' specified together");
            }
            if (this.myCurrentType == OCIntType.CHAR || this.myCurrentType == OCIntType.UCHAR) {
                this.myCurrentType = OCIntType.SCHAR;
            } else if (this.myCurrentType == null || this.myWasAuto) {
                this.myCurrentType = OCIntType.INT;
            } else if (!(this.myCurrentType instanceof OCIntType)) {
                this.error("signed is only applicable to integer types!");
            }
        }
        if (token == OCTokenTypes.UNSIGNED_KEYWORD) {
            if (this.myUnsign) {
                this.error("duplicate 'unsigned'");
            }
            this.myUnsign = true;
            if (this.mySign) {
                this.error("'signed' and 'unsigned' specified together");
            }
            if (this.myCurrentType == OCIntType.CHAR || this.myCurrentType == OCIntType.SCHAR) {
                this.myCurrentType = OCIntType.UCHAR;
            } else if (this.myCurrentType == OCIntType.SHORT) {
                this.myCurrentType = OCIntType.USHORT;
            } else if (this.myCurrentType == null || this.myCurrentType == OCIntType.INT || this.myWasAuto) {
                this.myCurrentType = OCIntType.UINT;
            } else if (this.myCurrentType == OCIntType.LONG) {
                this.myCurrentType = OCIntType.ULONG;
            } else if (this.myCurrentType == OCIntType.LONGLONG) {
                this.myCurrentType = OCIntType.ULONGLONG;
            } else if (this.myCurrentType == OCIntType.__INT8) {
                this.myCurrentType = OCIntType.__UINT8;
            } else if (this.myCurrentType == OCIntType.__INT16) {
                this.myCurrentType = OCIntType.__UINT16;
            } else if (this.myCurrentType == OCIntType.__INT32) {
                this.myCurrentType = OCIntType.__UINT32;
            } else if (this.myCurrentType == OCIntType.__INT64) {
                this.myCurrentType = OCIntType.__UINT64;
            } else if (this.myCurrentType == OCIntType.INT128) {
                this.myCurrentType = OCIntType.UINT128;
            } else if (!(this.myCurrentType instanceof OCIntType)) {
                this.error("unsigned is only applicable to integer types!");
            }
        } else if (OCTokenTypes.AUTO_KEYWORDS.contains(token)) {
            this.myWasAuto = true;
            this.myCurrentType = new OCAutoType();
            if (this.myLocalContext.getParent() instanceof OCStatement && ((OCStatement)this.myLocalContext.getParent()).getParent() instanceof OCLambdaExpression) {
                this.myCurrentType = new OCAutoType((OCLambdaExpression)((OCStatement)this.myLocalContext.getParent()).getParent(), this.myLocalContext.getLambdaParameterIndex());
            } else if (this.myLocalContext.getLambdaParameterIndex() != -1) {
                this.myCurrentType = new OCAutoType(null, this.myLocalContext.getLambdaParameterIndex());
            }
        } else if (token == OCTokenTypes.INT_KEYWORD && (this.myCurrentType == null || this.myCurrentType == OCIntType.INT || this.myWasAuto)) {
            this.updateIntegerWidth(OCIntType.INT, OCIntType.UINT);
        } else if (token == OCTokenTypes.CHAR_KEYWORD) {
            this.updateIntegerWidth(this.mySign ? OCIntType.SCHAR : OCIntType.CHAR, OCIntType.UCHAR);
        } else if (token == OCTokenTypes.SHORT_KEYWORD) {
            this.updateIntegerWidth(OCIntType.SHORT, OCIntType.USHORT);
        } else if (token == OCTokenTypes.LONG_KEYWORD) {
            ++this.longKeywords;
            if (this.myCurrentType == OCRealType.DOUBLE) {
                this.myCurrentType = OCRealType.LONG_DOUBLE;
            } else if (this.myCurrentType == null || this.myCurrentType == OCIntType.INT || this.myCurrentType == OCIntType.UINT || this.myWasAuto) {
                this.updateIntegerWidth(OCIntType.LONG, OCIntType.ULONG);
            } else if (this.longKeywords == 2) {
                this.updateIntegerWidth(OCIntType.LONGLONG, OCIntType.ULONGLONG);
            }
        } else if (token == OCTokenTypes.VOID_KEYWORD) {
            this.myCurrentType = OCVoidType.instance();
        } else if (token == OCTokenTypes._BOOL_KEYWORD) {
            this.myCurrentType = OCIntType.BOOL_NATIVE;
        } else if (token == OCTokenTypes.FLOAT_KEYWORD) {
            this.myCurrentType = this.myWasComplex ? OCRealType.COMPLEX_FLOAT : OCRealType.FLOAT;
        } else if (token == OCTokenTypes.DOUBLE_KEYWORD) {
            this.myCurrentType = this.myWasComplex ? (this.longKeywords > 0 ? OCRealType.COMPLEX_LONG_DOUBLE : OCRealType.COMPLEX_DOUBLE) : (this.longKeywords > 0 ? OCRealType.LONG_DOUBLE : OCRealType.DOUBLE);
        } else if (token == OCTokenTypes._COMPLEX_KEYWORD) {
            if (this.myCurrentType instanceof OCRealType) {
                this.myCurrentType = ((OCRealType)this.myCurrentType).cloneWithComplexModifier();
            }
            this.myWasComplex = true;
        } else if (token == OCTokenTypes.LT) {
            this.myWasLT = true;
        } else if (token != OCTokenTypes.GT) {
            if (token == OCTokenTypes.BOOL_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.BOOL_NATIVE;
            } else if (token == OCTokenTypes.WCHAR_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.WCHAR;
            } else if (token == OCTokenTypes.__WCHAR_T_KEYWORD) {
                this.myCurrentType = OCIntType.__WCHAR_T;
            } else if (token == OCTokenTypes.CHAR16_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.CHAR16;
            } else if (token == OCTokenTypes.CHAR32_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.CHAR32;
            } else if (token == OCTokenTypes.__INT8_KEYWORD) {
                this.updateIntegerWidth(OCIntType.__INT8, OCIntType.__UINT8);
            } else if (token == OCTokenTypes.__INT16_KEYWORD) {
                this.updateIntegerWidth(OCIntType.__INT16, OCIntType.__UINT16);
            } else if (token == OCTokenTypes.__INT32_KEYWORD) {
                this.updateIntegerWidth(OCIntType.__INT32, OCIntType.__UINT32);
            } else if (token == OCTokenTypes.__INT64_KEYWORD) {
                this.updateIntegerWidth(OCIntType.__INT64, OCIntType.__UINT64);
            } else if (token == OCTokenTypes.INT128_T_KEYWORD) {
                this.updateIntegerWidth(OCIntType.INT128, OCIntType.UINT128);
            } else if (token == OCTokenTypes.UINT128_T_KEYWORD) {
                this.myCurrentType = OCIntType.UINT128;
            } else if (token == OCTokenTypes.IDENTIFIER || token == OCElementTypes.EMPTY_NAME) {
                if (token == OCElementTypes.EMPTY_NAME && this.myWasAuto) {
                    this.myCurrentType = new OCAutoType();
                    return;
                }
                if (!OCElementTypes.PARAMETER_TYPE_QUALIFIERS.contains((Object)tokenText)) {
                    if (this.myProtocols != null && this.myWasLT) {
                        this.myProtocols = (String[])ArrayUtil.append((Object[])this.myProtocols, (Object)OCNamesInternary.intern(tokenText), String.class);
                    } else {
                        if (token == OCElementTypes.EMPTY_NAME && !this.myFileKind.isObjC()) {
                            this.myCurrentType = OCIntType.INT;
                            return;
                        }
                        this.myProtocols = ArrayUtil.EMPTY_STRING_ARRAY;
                        String string = this.myName = token == OCElementTypes.EMPTY_NAME ? "id" : OCNamesInternary.intern(tokenText);
                        if (this.myComplexOffset == -1L) {
                            this.myComplexOffset = complexOffset;
                            this.myVirtualFile = file;
                        }
                    }
                } else {
                    this.myPassByReference = true;
                }
            } else if (token == OCTokenTypes.TYPEDEF_KEYWORD) {
                this.myIsTypedef = true;
                this.myAssumeNonNullOn = false;
            } else if (ARCAttribute.isArcToken(token)) {
                this.learnArcKeyword(token);
            } else if (token == OCTokenTypes.KINDOF_KEYWORD) {
                this.myIsKindof = true;
            }
        }
    }

    public void learnAttributes(@NotNull List<String> attributeList) {
        this.tryLearnArcAttributes(attributeList);
        this.tryLearnMachineMode(attributeList);
    }

    private void tryLearnArcAttributes(@NotNull List<String> attributeList) {
        ARCAttribute parsedAttribute = ARCAttribute.parseArcAttribute(attributeList);
        if (parsedAttribute != null) {
            this.learnArcKeyword(parsedAttribute.getTokenType());
        }
    }

    private void learnArcKeyword(@NotNull IElementType arcToken) {
        this.myRefTokens.add(arcToken);
    }

    private void tryLearnMachineMode(@NotNull List<String> attributeList) {
        MachineModeAttribute modeAttribute = MachineModeAttribute.getModeAttribute(attributeList);
        if (modeAttribute != null && this.myModeAttribute == null) {
            this.myModeAttribute = modeAttribute;
        }
    }

    public void learnArrayLengthSymbol(@Nullable OCExpressionSymbol symbol) {
        OCLog.LOG.assertTrue(this.myIsInsideBrackets);
        OCLog.LOG.assertTrue(this.myArrayLengthSymbol == null);
        this.myArrayLengthSymbol = symbol;
    }

    private void updateIntegerWidth(OCIntType signed, OCIntType unsigned) {
        if (this.myCurrentType == null || this.myWasAuto) {
            this.myCurrentType = signed;
            return;
        }
        if (this.myCurrentType instanceof OCIntType) {
            this.myCurrentType = ((OCIntType)this.myCurrentType).isSigned() ? signed : unsigned;
        } else {
            this.error("Illegal combination of type specifiers");
        }
    }

    public void updateArrayLength(int length) {
        if (this.myArrayLengths.length >= 1 && this.myArrayLengths[0] == null) {
            this.myArrayLengths[0] = OCArrayType.lengthFromInt(length);
        }
    }

    private void error(@NotNull String message) {
    }

    public OCType getResult() {
        return this.getResult(false);
    }

    public OCType getResult(boolean isFunctionReturnType) {
        OCType typeForMachineMode;
        OCType result;
        if (this.myName != null) {
            OCQualifiedName qualifiedName = this.myTypeArguments == null ? OCQualifiedName.interned(this.myNamespaceQualifier, this.myName) : new OCQualifiedNameWithArguments(this.myNamespaceQualifier, this.myName, this.myTypeArguments);
            this.myCurrentType = this.createReferenceType(qualifiedName);
        }
        List refTokens = this.myRefTokens;
        if (!isFunctionReturnType) {
            refTokens = ContainerUtil.concat(this.myRefTokens, this.myFunctionRefTokens);
            if (!(this.myFunctionRefTokens.isEmpty() || this.myFunctionRefTokens.contains((Object)OCTokenTypes.CONST_KEYWORD) || this.myFunctionRefTokens.contains((Object)OCTokenTypes.RBRACKET))) {
                this.myConst = false;
            }
        }
        if ((result = this.myCurrentType) == null) {
            OCType oCType = result = this.myFileKind.isObjC() ? OCIdType.pointerToID().cloneWithNullability(this.getNullability()) : OCIntType.INT;
        }
        if (this.myModeAttribute != null && (typeForMachineMode = this.getNumericTypeForMachineMode(result, this.myModeAttribute)) != null) {
            result = typeForMachineMode;
        }
        result = this.getPointerType(result, refTokens);
        if (this.myVariadic) {
            result = new OCVariadicType(result);
        }
        return result;
    }

    protected OCReferenceType createReferenceType(OCQualifiedName qualifiedName) {
        OCReferenceTypeBuilder typeBuilder;
        PsiElement localContext = this.myLocalContext.getLocalContext();
        String[] protocols = this.myProtocols;
        if (localContext != null) {
            typeBuilder = new OCReferenceTypeBuilder(qualifiedName, localContext, this.myLocalContext.getParentSymbol(), this.myLocalContext.isBaseClause(), this.myVirtualFile, this.myComplexOffset);
        } else {
            OCSymbolWithQualifiedName symbol = this.myLocalContext != null ? this.myLocalContext.getParentSymbol() : null;
            boolean isBaseClause = this.myLocalContext != null && this.myLocalContext.isBaseClause();
            boolean isInsideTemplateArguments = this.myLocalContext != null && this.myLocalContext.isInsideTemplateArguments();
            boolean isSpecialization = this.myLocalContext != null && this.myLocalContext.isSpecialization();
            typeBuilder = new OCReferenceTypeBuilder(qualifiedName, symbol, this.myVirtualFile, this.myComplexOffset, isBaseClause, isInsideTemplateArguments, isSpecialization);
        }
        if (protocols != null) {
            typeBuilder.setProtocolNames(protocols);
        }
        typeBuilder.setARCAttribute(null);
        typeBuilder.setIsKindof(this.myIsKindof);
        if (this.myNullability != null) {
            typeBuilder.setNullability(this.myNullability);
        } else if (this.myAssumeNonNullOn) {
            typeBuilder.setNullability(OCNullability.NONNULL);
        }
        OCReferenceType type = typeBuilder.build();
        if (localContext == null) {
            this.myLocalContext.addSymbolReference((Pair<OCSymbolReference, Long>)Pair.create((Object)type.getReference(), (Object)this.myComplexOffset));
        }
        return type;
    }

    @Nullable
    private OCType getNumericTypeForMachineMode(@NotNull OCType result, @NotNull MachineModeAttribute modeAttribute) {
        boolean isProperIntOrRealType;
        boolean bl = isProperIntOrRealType = modeAttribute.isIntegralType() ? result instanceof OCIntType : result instanceof OCRealType;
        if (!isProperIntOrRealType) {
            this.error("Machine mode '" + (Object)((Object)modeAttribute) + "' applied to inappropriate type");
            return null;
        }
        return this.lookupTypeForSize(modeAttribute.getSizeInBytes(), ((OCNumericType)result).getBasicTypes());
    }

    @Nullable
    private <T extends OCNumericType> T lookupTypeForSize(short bytes, @NotNull List<T> types) {
        for (OCNumericType basicType : types) {
            if (basicType.getCTypeId().getBytes(null, this.myInclusionContext) != bytes) continue;
            return (T)basicType;
        }
        return null;
    }

    public OCType createFunction(OCType result, List<OCType> parameterTypes, List<String> parameterNames, boolean createPointers, boolean isConst, boolean isVolatile, boolean isLvalueFun, boolean isRvalueFun, OCExceptionSpecificationInfo exceptionSpecification) {
        if (parameterTypes != null) {
            result = new OCFunctionType(result, parameterTypes, parameterNames, isConst, isVolatile, isLvalueFun, isRvalueFun, exceptionSpecification);
            return createPointers ? this.getPointerType(result, this.myFunctionRefTokens) : result;
        }
        return result;
    }

    public void learnTypeArguments(List<OCTypeArgument> arguments) {
        this.myTypeArguments = arguments;
    }

    private OCType getPointerType(OCType type, List<IElementType> refTokens) {
        int i = 0;
        int arrayLengthCounter = this.myArrayLengths.length - 1;
        ArcContext arcContext = new ArcContext();
        while (i < refTokens.size()) {
            IElementType token;
            if ((token = refTokens.get(i++)) == OCTokenTypes.CONST_KEYWORD) {
                type = type.cloneWithCVQualifiers(CVQualifiers.get(true, type.isVolatile()), this.myProject);
            } else if (token == OCTokenTypes.VOLATILE_KEYWORD) {
                type = type.cloneWithCVQualifiers(CVQualifiers.get(type.isConst(), true), this.myProject);
            } else if (token == OCTokenTypes.LBRACKET) {
                type = arrayLengthCounter >= 0 ? OCArrayType.to(type, this.myArrayLengths[arrayLengthCounter--], null) : OCArrayType.to(type, -1, null);
            } else if (token == OCTokenTypes.XOR) {
                type = OCBlockPointerType.blockPtr(type, null, this.getNullability(), false, false);
            } else if (token == OCTokenTypes.AND) {
                type = OCCppReferenceType.to(type);
            } else if (token == OCTokenTypes.ANDAND) {
                type = OCCppReferenceType.rvalue(type);
            } else if (token == OCTokenTypes.MUL) {
                type = OCPointerType.to(type, null, this.myPointerQualifier != null ? this.createReferenceType(this.myPointerQualifier) : null, this.getNullability(), false, false);
            } else if (OCTokenTypes.NULLABILITY_KEYWORDS.contains(token)) {
                type = type.cloneWithNullability(OCNullability.parseFrom(token));
            } else {
                arcContext.pushArcAttribute(token);
            }
            type = OCTypeBuilder.tryApplyArcAttributeToType(type, arcContext);
        }
        return type;
    }

    @NotNull
    private static OCType tryApplyArcAttributeToType(@NotNull OCType type, @NotNull ArcContext arcContext) {
        if (type instanceof ArcAnnotatedType && ((ArcAnnotatedType)((Object)type)).getARCAttribute() == null) {
            return ((ArcAnnotatedType)((Object)type)).cloneWithArcAttribute(arcContext.popArcAttribute());
        }
        return type;
    }

    public OCTypeBuilder copy() {
        OCTypeBuilder answer = new OCTypeBuilder(this.myFileKind, this.myInclusionContext, this.myLocalContext, this.myProject);
        answer.myCurrentType = this.myCurrentType;
        answer.myName = this.myName;
        answer.myComplexOffset = this.myComplexOffset;
        answer.myVirtualFile = this.myVirtualFile;
        answer.myProtocols = this.myProtocols;
        answer.myRefTokens = new ArrayList<IElementType>(this.myRefTokens);
        answer.myIsTypedef = this.myIsTypedef;
        answer.myLocalContext = this.myLocalContext;
        answer.myPointerQualifier = this.myPointerQualifier;
        answer.myConst = this.myConst;
        answer.myVolatile = this.myVolatile;
        answer.mySign = this.mySign;
        answer.myUnsign = this.myUnsign;
        answer.myWasConst = this.myWasConst;
        answer.myWasAuto = this.myWasAuto;
        answer.myWasComplex = this.myWasComplex;
        answer.myArrayLengths = this.myArrayLengths;
        answer.myNamespaceQualifier = this.myNamespaceQualifier;
        answer.myTypeArguments = this.myTypeArguments;
        answer.myModeAttribute = this.myModeAttribute;
        answer.myIsKindof = this.myIsKindof;
        answer.myNullability = this.myNullability;
        answer.myAssumeNonNullOn = this.myAssumeNonNullOn;
        return answer;
    }

    public boolean isTypedef() {
        return this.myIsTypedef;
    }

    public boolean isPassByReference() {
        return this.myPassByReference;
    }

    public void learnBaseType(OCType type) {
        this.myCurrentType = type;
    }

    public boolean isConst() {
        return this.myConst;
    }

    public boolean isVolatile() {
        return this.myVolatile;
    }

    public boolean wasAuto() {
        return this.myWasAuto;
    }

    public boolean eraseWasConst() {
        boolean result = this.myWasConst;
        this.myWasConst = false;
        return result;
    }

    public boolean isInsideParentheses() {
        return this.myParLevel > 0;
    }

    @Nullable
    private OCNullability getNullability() {
        if (this.myNullability != null) {
            return this.myNullability;
        }
        return this.myAssumeNonNullOn ? OCNullability.NONNULL : null;
    }

    public boolean isInsideBrackets() {
        return this.myIsInsideBrackets;
    }

    private static final class ArcContext {
        private ARCAttribute myCurrentArcAttribute = null;
        private boolean myIsArcAttributeProcessed = false;

        private ArcContext() {
        }

        public void pushArcAttribute(@NotNull IElementType token) {
            if (!this.myIsArcAttributeProcessed) {
                ARCAttribute parsedArcAttribute = ARCAttribute.getAttributeByToken(token);
                this.myCurrentArcAttribute = parsedArcAttribute != null ? parsedArcAttribute : this.myCurrentArcAttribute;
            }
        }

        @Nullable
        ARCAttribute popArcAttribute() {
            if (this.myCurrentArcAttribute != null) {
                this.myIsArcAttributeProcessed = true;
            }
            ARCAttribute arcAttribute = this.myCurrentArcAttribute;
            this.myCurrentArcAttribute = null;
            return arcAttribute;
        }
    }
}

