/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeCheckResult {
    private OCTypeCheckState state;
    private boolean myIsWithConversion;
    private OCType myTypeAfterConversion;
    private OCType myTypeBeforeConversion;
    private OCFunctionSymbol myImplicitConstructor;

    public String toString() {
        return this.state.toString();
    }

    public OCTypeCheckResult(OCTypeCheckState state, OCType typeBeforeConversion, OCType typeAfterConversion) {
        this.state = state;
        this.setConversion(typeBeforeConversion, typeAfterConversion);
    }

    public OCTypeCheckResult(OCTypeCheckState state) {
        this.state = state;
    }

    public OCTypeCheckState getState() {
        return this.state;
    }

    public OCTypeCheckResult setState(OCTypeCheckState state) {
        this.state = state;
        return this;
    }

    public boolean isWithConversion() {
        return this.myIsWithConversion;
    }

    public OCType getTypeBeforeConversion() {
        return this.myTypeBeforeConversion;
    }

    @Nullable
    public OCType getTypeAfterConversion() {
        return this.myTypeAfterConversion;
    }

    public OCTypeCheckResult setConversion(OCType typeBeforeConversion, OCType typeAfterConversion) {
        this.myIsWithConversion = true;
        this.myTypeAfterConversion = typeAfterConversion;
        this.myTypeBeforeConversion = typeBeforeConversion;
        return this;
    }

    @Nullable
    public OCFunctionSymbol getImplicitConstructor() {
        return this.myImplicitConstructor;
    }

    public OCTypeCheckResult setImplicitConstructor(OCFunctionSymbol implicitConstructor) {
        this.myImplicitConstructor = implicitConstructor;
        return this;
    }

    public boolean canBeCasted(OCType lType, OCType rType, @NotNull OCResolveContext context) {
        if (this.state != OCTypeCheckState.ERROR) {
            return true;
        }
        if (lType.isPointerCompatible(context) && rType.isPointerCompatible(context) && lType.isPointerToObjectCompatible() == rType.isPointerToObjectCompatible()) {
            return true;
        }
        return lType instanceof OCCppReferenceType && ((OCCppReferenceType)lType).isRvalueRef() && ((OCCppReferenceType)lType).getRefType().checkCompatible(rType, null, context.getElement(), true, context).getState() == OCTypeCheckState.OK;
    }

    @NotNull
    public static OCTypeCheckResult createError() {
        return new OCTypeCheckResult(OCTypeCheckState.ERROR);
    }

    public static OCTypeCheckResult createOK() {
        return new OCTypeCheckResult(OCTypeCheckState.OK);
    }
}

