/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCDeductionCandidateSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeUtils {
    @NotNull
    private static final TObjectHashingStrategy DEEP_EQUAL_HASHING_STRATEGY = new TObjectHashingStrategy(){

        public int computeHashCode(@NotNull Object object) {
            return object.hashCode();
        }

        public boolean equals(@NotNull Object o1, @NotNull Object o2) {
            return DeepEqual.equalObjects(o1, o2);
        }
    };

    @NotNull
    public static <T> TObjectHashingStrategy<T> deepEqualHashingStrategy() {
        return DEEP_EQUAL_HASHING_STRATEGY;
    }

    @NotNull
    public static <T> Set<T> newSymbolWithSubstitutionSet() {
        return ContainerUtil.newTroveSet((TObjectHashingStrategy)new TObjectHashingStrategy<T>(){

            public int computeHashCode(T symbol) {
                return symbol.hashCode() * 31 + (symbol instanceof OCSymbolWithSubstitution ? ((OCSymbolWithSubstitution)symbol).getSubstitution().hashCode() : 0);
            }

            public boolean equals(T o1, T o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    @NotNull
    public static Set<Pair<OCSymbolReference, OCTypeSubstitution>> newReferenceWithSubstitutionSet() {
        return ContainerUtil.newTroveSet(OCTypeUtils.deepEqualHashingStrategy());
    }

    @NotNull
    public static Map<OCTypeParameterSymbol, OCTypeArgument> newTypeParameterMap() {
        return ContainerUtil.newTroveMap(OCTypeUtils.deepEqualHashingStrategy());
    }

    @NotNull
    public static <T extends OCTypeArgument> Set<T> newTypeSet() {
        return ContainerUtil.newTroveSet(OCTypeUtils.deepEqualHashingStrategy());
    }

    @NotNull
    public static Map<OCType, OCType> newTypesMap() {
        return ContainerUtil.newTroveMap(OCTypeUtils.deepEqualHashingStrategy());
    }

    @NotNull
    public static <TKey, TValue> ConcurrentMap<TKey, TValue> newDeepEqualityMap() {
        return ConcurrentCollectionFactory.createMap(OCTypeUtils.deepEqualHashingStrategy());
    }

    public static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        return OCTypeUtils.areSignaturesEqual(s1, s2, context, checkFunctionReturnTypes, false);
    }

    public static boolean isSignaturesConformsTo(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        return OCTypeUtils.areSignaturesEqual(s1, s2, context, checkFunctionReturnTypes, true);
    }

    private static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes, boolean conformsTo) {
        List templateParams2;
        if ((s1 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s1)).isTemplateSymbol()) != (s2 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s2)).isTemplateSymbol())) {
            return false;
        }
        OCQualifiedName fqn1 = s1.getResolvedQualifiedName(false, false, context);
        OCQualifiedName fqn2 = s2.getResolvedQualifiedName(false, false, context);
        if (fqn1 == null || fqn2 == null || !fqn1.equals(fqn2)) {
            return false;
        }
        List parentTemplateParams1 = s1.getParent() == s2.getParent() && s1.getParent() instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1.getParent())).getTemplateParameters() : Collections.emptyList();
        List parentTemplateParams2 = s1.getParent() == s2.getParent() && s2.getParent() instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2.getParent())).getTemplateParameters() : Collections.emptyList();
        List templateParams1 = s1 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1)).getTemplateParameters() : Collections.emptyList();
        List<Object> list = templateParams2 = s2 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2)).getTemplateParameters() : Collections.emptyList();
        if (templateParams1.size() != templateParams2.size()) {
            return false;
        }
        Map<OCTypeParameterSymbol, OCTypeArgument> map2 = OCTypeUtils.newTypeParameterMap();
        OCType t1 = (s1 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s1).getTypeWithoutSubstitution() : s1.getType()).resolve(context);
        OCType t2 = (s2 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s2).getTypeWithoutSubstitution() : s2.getType()).resolve(context);
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, false, t2, null, map2, null, context).unify(t1, t2).isUnified()) {
            return false;
        }
        if (conformsTo) {
            return true;
        }
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, false, t1, null, new HashMap<OCTypeParameterSymbol, OCTypeArgument>(), null, context).unify(t2, t1).isUnified()) {
            return false;
        }
        block0: for (Map.Entry<OCTypeParameterSymbol, OCTypeArgument> each : map2.entrySet()) {
            if (!(each.getValue() instanceof OCTypeParameterType)) {
                return false;
            }
            OCTypeParameterSymbol key = each.getKey();
            OCTypeParameterSymbol value = ((OCTypeParameterType)each.getValue()).getSymbol();
            if (!(s1.getParent() != s2.getParent() || Objects.equals(key.getName(), value.getName()) || templateParams1.contains(key) || templateParams2.contains(value))) {
                return false;
            }
            while (key != null && value != null) {
                if (templateParams1.indexOf(key) != templateParams2.indexOf(value)) {
                    return false;
                }
                if (parentTemplateParams1.indexOf(key) != parentTemplateParams2.indexOf(value)) {
                    return false;
                }
                if (!(key instanceof OCTypeParameterTypeSymbol) || !(value instanceof OCTypeParameterTypeSymbol)) continue block0;
                key = ((OCTypeParameterTypeSymbol)key).getQualifierTypeParameter();
                value = ((OCTypeParameterTypeSymbol)value).getQualifierTypeParameter();
            }
        }
        for (int i = 0; i < templateParams1.size(); ++i) {
            OCType pt1 = ((OCSymbol)templateParams1.get(i)).getType().resolve(context);
            OCType pt2 = ((OCSymbol)templateParams2.get(i)).getType().resolve(context);
            if (pt1 instanceof OCTypeParameterType && pt2 instanceof OCTypeParameterType || pt1.equals(pt2, true, context)) continue;
            return false;
        }
        return true;
    }

    public static OCType getExtractExpressionType(OCType type, @NotNull PsiElement context, boolean disallowConst) {
        return OCTypeUtils.getExtractExpressionType(type, context, disallowConst, false);
    }

    public static OCType getExtractExpressionType(OCType type, @NotNull PsiElement context, boolean disallowConst, boolean forceReferenceMode) {
        if ((type = type.resolve(context)) instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type;
            type = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, false);
        }
        if (OCTypeUtils.isPassableByReference(type, forceReferenceMode, context)) {
            return OCCppReferenceType.to(disallowConst ? type : type.cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type instanceof OCCppReferenceType) {
            return OCCppReferenceType.to(((OCCppReferenceType)type).getRefType().cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type instanceof OCPointerType && !(type instanceof OCBlockPointerType) && !type.isPointerToObject()) {
            return OCPointerType.to(((OCPointerType)type).getRefType().cloneWithConstModifier(context.getProject()));
        }
        return type;
    }

    public static boolean isPassableByReference(OCType type, boolean forceReferenceMode, PsiElement context) {
        return (forceReferenceMode || type instanceof OCStructType && ((OCStructType)type).getKind() != OCSymbolKind.ENUM || type instanceof OCReferenceType) && !OCCodeInsightUtil.isInPlainOldC(context);
    }

    @Nullable
    public static OCType getCollectionItemType(@NotNull OCType collectionType, final @NotNull OCResolveContext context) {
        OCProtocolSymbol protocol;
        OCObjectType objectType;
        OCClassSymbol symbol;
        if (collectionType instanceof OCObjectType && (symbol = (objectType = (OCObjectType)collectionType).getClassSymbol()) != null && (protocol = (OCProtocolSymbol)OCSymbolBase.findSymbolDefinition("NSFastEnumeration", OCSymbolKind.PROTOCOL, context.getProject(), symbol.getContainingFile())) != null && objectType.implementsProtocol(protocol)) {
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol o) {
                    OCType returnType = o.getReturnType(context.getProject()).resolve(context);
                    if (returnType instanceof OCPointerType) {
                        returnType = ((OCPointerType)returnType).getRefType();
                    }
                    if (!(returnType instanceof OCObjectType)) {
                        return false;
                    }
                    return "NSEnumerator".equals(((OCObjectType)returnType).getClassName());
                }
            };
            Iterator methodNamesIterator = ContainerUtil.newArrayList((Object[])new String[]{"keyEnumerator", "objectEnumerator", null}).iterator();
            while (!processor2.isFound() && methodNamesIterator.hasNext()) {
                objectType.processMembers((String)methodNamesIterator.next(), OCMethodSymbol.class, processor2, true, false);
            }
            if (processor2.isFound()) {
                OCTypeArgument argument;
                List<OCGenericParameterSymbol> parameters;
                OCInterfaceSymbol interfaceSymbol;
                OCMethodSymbol value = (OCMethodSymbol)processor2.getFoundValue();
                assert (value != null);
                OCType returnType = value.getReturnType(context.getProject()).resolve(context);
                if (returnType instanceof OCPointerType) {
                    returnType = ((OCPointerType)returnType).getRefType();
                }
                if ((interfaceSymbol = ((OCObjectType)returnType).getInterface()) != null && !(parameters = interfaceSymbol.getGenericParameters()).isEmpty() && (argument = interfaceSymbol.getSubstitution().getSubstitutionFor(parameters.get(0))) instanceof OCType) {
                    return (OCType)argument;
                }
            }
        }
        return null;
    }

    public static OCType decayType(@NotNull OCType type, @NotNull Project project2) {
        return OCTypeUtils.decayType(type, project2, true);
    }

    public static OCType decayType(@NotNull OCType type, @NotNull Project project2, boolean removeCV) {
        if (type instanceof OCArrayType) {
            type = OCArrayToPointerChanger.INSTANCE.visitArrayType((OCArrayType)type);
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCFunctionType) {
            type = OCPointerType.to(type);
        }
        return removeCV ? type.cloneWithoutCVQualifiers(project2) : type;
    }

    public static boolean isInstanceOfTypeResolved(@Nullable OCExpression expression, Class<? extends OCType> ... typeClasses) {
        if (expression == null) {
            return false;
        }
        return OCTypeUtils.isInstanceOfTypeResolved(expression, OCResolveContext.forPsi(expression), typeClasses);
    }

    public static boolean isInstanceOfTypeResolved(@Nullable OCExpression expression, @NotNull OCResolveContext resolveContext, Class<? extends OCType> ... typeClasses) {
        return OCTypeUtils.isInstanceOfType(OCTypeUtils.getResolvedCppReferencedType(expression, resolveContext), typeClasses);
    }

    @Nullable
    public static OCType getResolvedCppReferencedType(@Nullable OCExpression expression, @NotNull OCResolveContext resolveContext) {
        return expression != null ? OCTypeUtils.getResolvedCppReferencedType(expression.getResolvedType(resolveContext), resolveContext) : null;
    }

    @NotNull
    public static OCType getResolvedCppReferencedType(@NotNull OCType type, @NotNull OCResolveContext resolveContext) {
        OCType resolvedType = type.resolve(resolveContext);
        return OCTypeUtils.getCppReferencedType(resolvedType);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static OCType getCppReferencedType(@Nullable OCType type) {
        if (type instanceof OCCppReferenceType) {
            return ((OCCppReferenceType)type).getRefType();
        }
        return type;
    }

    public static boolean isCppReferenceType(@Nullable OCType type) {
        return type instanceof OCCppReferenceType;
    }

    public static boolean isInstanceOfType(@Nullable OCType type, Class<? extends OCType> ... typeClasses) {
        if (type == null) {
            return false;
        }
        for (Class<? extends OCType> typeClass : typeClasses) {
            if (!typeClass.isInstance(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntegralType(@Nullable OCType type) {
        return type instanceof OCIntType;
    }

    public static boolean isEnumType(@Nullable OCType type) {
        return type instanceof OCStructType && ((OCStructType)type).isEnum();
    }

    @Nullable
    public static <T extends OCType> T getAs(@NotNull Class<T> cls, @Nullable OCType type) {
        if (type != null && cls.isAssignableFrom(type.getClass())) {
            return (T)type;
        }
        return null;
    }

    @NotNull
    public static OCType doSwitchImplicitConversion(@NotNull OCSwitchStatement swtch, @NotNull OCType switchType) {
        OCResolveContext context = OCResolveContext.forPsi(swtch);
        if (switchType instanceof OCCppReferenceType) {
            switchType = ((OCCppReferenceType)switchType).getRefType();
        }
        if (!(switchType instanceof OCStructType)) {
            if (switchType.isIntegerCompatible(context)) {
                return OCIntType.INT;
            }
            return switchType;
        }
        OCStructType clsTy = (OCStructType)switchType;
        if (clsTy.isEnum()) {
            return clsTy;
        }
        Pair<OCType, OCFunctionSymbol> conversionRes = OCTypeCompatibilityVisitor.convertByOperator(clsTy, false, true, context, (Predicate<OCType>)((Predicate)type -> OCTypeUtils.isIntegralType(type) || OCTypeUtils.isEnumType(type)));
        if (conversionRes == null) {
            return switchType;
        }
        if (!OCVisibility.isVisible((OCSymbol)conversionRes.second, swtch, null, context.getProject())) {
            return switchType;
        }
        return (OCType)conversionRes.first;
    }

    public static int getNonVariadicParametersCount(List<? extends OCType> parameterTypes) {
        int count = 0;
        for (OCType oCType : parameterTypes) {
            if (oCType instanceof OCVariadicType || oCType instanceof OCEllipsisType) continue;
            ++count;
        }
        return count;
    }

    public static int getNonInitializedParametersCount(@NotNull List<OCDeclaratorSymbol> parameterSymbols, @Nullable OCResolveContext context) {
        int result = 0;
        for (OCDeclaratorSymbol param : parameterSymbols) {
            OCType paramType = param.getType();
            if (context != null) {
                paramType = paramType.resolve(context.clone());
            }
            if (param.hasInitializer() || paramType instanceof OCEllipsisType || paramType instanceof OCVoidType) break;
            if (paramType instanceof OCVariadicType) {
                List<OCType> expanded;
                if (context == null || (expanded = OCArgumentsList.expandVariadicTypes(Collections.singletonList(paramType), context)).size() == 1 && ContainerUtil.getFirstItem(expanded) == paramType) continue;
                result += expanded.size();
                continue;
            }
            ++result;
        }
        return result;
    }

    public static boolean hasAutoInside(@NotNull OCType type) {
        return type.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitAutoType(OCAutoType type) {
                return type.getExpressionSymbol() == null && type.getExpressionElement() == null;
            }
        });
    }

    @NotNull
    public static OCType replaceAutoTypesWithTypeParameters(@NotNull OCType type, final @NotNull Map<OCType, OCType> map2, @NotNull Project project2) {
        return type.accept(new OCNonPrimitiveTypeCloneVisitor(){

            @Override
            public OCType visitAutoType(OCAutoType type) {
                OCTypeParameterTypeSymbol autoSymbol = new OCTypeParameterTypeSymbol(null, map2.size(), "auto", null, Collections.emptyList(), null, false, true, true);
                OCTypeParameterType.ReplacedAutoType newType = new OCTypeParameterType.ReplacedAutoType(autoSymbol, type.isConst(), type.isVolatile());
                map2.put(type, newType);
                return newType;
            }
        });
    }

    public static boolean isUnresolvedLambdaAutoType(@Nullable OCType type) {
        return type instanceof OCAutoType && ((OCAutoType)type).needsAutoParamsResolving();
    }

    @Nullable
    public static OCType resolveLambdaAutoType(@NotNull OCType type, @NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> argumentsList, boolean failIfNotUnified) {
        OCExpressionSymbol symbol = ((OCAutoType)type).getExpressionSymbol();
        if (symbol instanceof OCLambdaExpressionSymbol) {
            return ((OCLambdaExpressionSymbol)symbol).getResolvedType(context, argumentsList, failIfNotUnified);
        }
        return type;
    }

    @Nullable
    public static OCType resolveLambdaAutoType(@NotNull OCType lType, @NotNull OCType rType, @NotNull OCResolveContext context) {
        if (lType.getTerminalType() instanceof OCFunctionType) {
            OCArgumentsList arguments = new OCArgumentsList(((OCFunctionType)lType.getTerminalType()).getParameterTypes(), null);
            OCType resolvedType = OCTypeUtils.resolveLambdaAutoType(rType, context, arguments, false);
            if (resolvedType != null && resolvedType.getTerminalType() instanceof OCFunctionType) {
                return resolvedType;
            }
            ((OCAutoType)rType).setNeedsAutoParamsResolving(false);
            return rType.resolve(context);
        }
        OCExpressionSymbol expressionSymbol = ((OCAutoType)rType).getExpressionSymbol();
        if (expressionSymbol != null) {
            return expressionSymbol.getResolvedType(context);
        }
        return rType;
    }

    public static boolean isSameOrDerivedFrom(OCType derived, OCType base, @NotNull OCResolveContext context) {
        return TypeProperties.hasSameUnqualifiedType(derived, base, context) || TypeProperties.IsDerivedFrom(derived, base, context);
    }

    public static boolean isOrIsDerivedFromSpecializationOf(OCType derived, OCType base, @NotNull OCResolveContext context) {
        if (!(base instanceof OCStructType) || !(derived instanceof OCStructType)) {
            return false;
        }
        if (!OCTypeUtils.isPrimaryTemplate((OCStructType)base) || OCTypeUtils.isPrimaryTemplate((OCStructType)derived)) {
            return false;
        }
        if (TypeProperties.hasSameUnqualifiedType(derived, base, context)) {
            return true;
        }
        for (OCStructSymbol derivedSymbol : ((OCStructType)derived).getStructs()) {
            Ref result = new Ref((Object)false);
            derivedSymbol.processAllBaseClasses((symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol && !OCTypeUtils.isPrimaryTemplate((OCStructSymbol)symbol) && TypeProperties.hasSameUnqualifiedType(symbol.getResolvedType(context), base, context)) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            }, context);
            if (!((Boolean)result.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimaryTemplate(OCStructType type) {
        return OCTypeUtils.isPrimaryTemplate(type.getSymbol());
    }

    public static boolean isPrimaryTemplate(OCStructSymbol symbol) {
        return symbol.isTemplateSymbol() && symbol.getSubstitution().isEmpty();
    }

    public static boolean isPolymorphic(@NotNull OCType type, @NotNull OCResolveContext context) {
        return type.isCppStructType(context) && !((OCStructType)type).processMembers(null, (Processor<OCSymbol>)((Processor)symbol -> !(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isVirtual()), context);
    }

    public static OCType getSymbolType(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        return OCTypeUtils.getSymbolType(symbol, null, context);
    }

    public static OCType getSymbolType(@Nullable OCSymbol symbol, @Nullable OCSymbolReference reference, @NotNull OCResolveContext context) {
        if (symbol instanceof OCStructSymbol) {
            return new OCFunctionType(OCVoidType.instance(), Collections.emptyList());
        }
        OCType type = symbol != null ? symbol.getType() : OCUnknownType.INSTANCE;
        type = OCTypeUtils.changeTypeReferences(type, reference, context);
        return type instanceof OCVariadicType ? ((OCVariadicType)type).getUnderlyingType() : type;
    }

    @NotNull
    public static OCType deduceDeclaratorTemplateArguments(@NotNull OCStructType type, OCType unresolvedType, @NotNull OCDeclaratorSymbol symbol, @NotNull OCResolveContext context) {
        OCStructSymbol structSymbol = type.getSymbol();
        if (structSymbol.isTemplateSymbol() && !structSymbol.isSpecialization() && structSymbol.getSubstitution().isEmpty()) {
            boolean isListInitialization;
            List<OCExpressionSymbol> initializers;
            OCInitializerSymbol initializerSymbol = symbol.getInitializer();
            if (initializerSymbol != null) {
                initializers = initializerSymbol.getArguments();
                isListInitialization = initializerSymbol.isListInitializer();
            } else {
                initializers = Collections.emptyList();
                isListInitialization = false;
            }
            OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(initializers, context);
            return OCTypeUtils.deduceClassTemplateArguments(type, unresolvedType, arguments, isListInitialization, context, symbol.getContainingFile(), symbol.getComplexOffset());
        }
        return type;
    }

    @NotNull
    public static OCType deduceClassTemplateArguments(@NotNull OCStructType type, OCType unresolvedType, OCArgumentsList<?> arguments, boolean isListInitialization, @NotNull OCResolveContext context, @Nullable VirtualFile file, long complexOffset) {
        OCStructSymbol structSymbol = type.getSymbol();
        if (type.getArguments() == null && OCTypeUtils.hasNonDeducedClassTemplateArguments(structSymbol)) {
            OCStructSymbol deducedTypeSymbol;
            OCType deducedType;
            OCFunctionSymbol deductionFunction = OCTypeUtils.findDeductionCandidate(structSymbol, arguments, context, isListInitialization, file, complexOffset);
            OCType oCType = deducedType = deductionFunction != null ? deductionFunction.getEffectiveResolvedType(context) : null;
            if (deducedType instanceof OCStructType && !OCTypeUtils.hasNonDeducedClassTemplateArguments(deducedTypeSymbol = ((OCStructType)deducedType).getSymbol())) {
                if (unresolvedType instanceof OCReferenceType) {
                    List<OCTypeArgument> templateArguments = deducedTypeSymbol.getTemplateArguments(context);
                    OCSymbolReference reference = ((OCReferenceType)unresolvedType).getReference().cloneWithArguments(templateArguments);
                    deducedType = ((OCReferenceType)unresolvedType).cloneWithReference(reference).resolve(context);
                }
                return deducedType.cloneWithCVQualifiers(type.getCVQualifiers(), context.getProject());
            }
        }
        return type;
    }

    private static boolean hasNonDeducedClassTemplateArguments(OCStructSymbol structSymbol) {
        return structSymbol.isTemplateSymbol() && !structSymbol.isSpecialization() && structSymbol.getSubstitution().isEmpty();
    }

    @Nullable
    private static OCFunctionSymbol findDeductionCandidate(final @NotNull OCStructSymbol structSymbol, @NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context, boolean isListInitialization, @Nullable VirtualFile file, long complexOffset) {
        final HashSet<OCSymbol> deductionCandidates = new HashSet<OCSymbol>();
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol constructorSymbol) {
                if (constructorSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)constructorSymbol).isCppConstructor()) {
                    OCDeductionCandidateSymbol candidate = OCDeductionCandidateSymbol.createFromConstructor(structSymbol, (OCFunctionSymbol)constructorSymbol);
                    return deductionCandidates.add(candidate);
                }
                return false;
            }
        };
        structSymbol.processConstructors((Processor<? super OCFunctionSymbol>)collector);
        OCSymbolReference.SymbolFilter guildeFilter = symbol -> {
            if (!(symbol instanceof OCDeductionGuideSymbol)) {
                return false;
            }
            return OCResolveUtil.isEarlierInCodeWithComplexOffset(symbol, file, complexOffset);
        };
        List<OCSymbol> guides = OCSymbolReference.getGlobalReference(OCQualifiedName.with(structSymbol.getType().getName()), null, null, -1L, guildeFilter).resolveToSymbols(context);
        for (OCSymbol guide : guides) {
            if (!(guide instanceof OCDeductionGuideSymbol)) continue;
            OCDeductionCandidateSymbol candidate = OCDeductionCandidateSymbol.createFromDeductionGuide(structSymbol, (OCDeductionGuideSymbol)guide);
            deductionCandidates.add(candidate);
        }
        deductionCandidates.add(structSymbol);
        FindConstructorResult overloadResult = OCResolveOverloadsUtil.resolveConstructorOverloads(structSymbol.getType(), deductionCandidates, arguments, false, isListInitialization, true, context, null);
        return overloadResult.getSymbol();
    }

    public static OCType changeTypeReferences(@NotNull OCType type, @Nullable OCSymbolReference reference) {
        return OCTypeUtils.changeTypeReferences(type, reference, null);
    }

    public static OCType changeTypeReferences(@NotNull OCType type, final @Nullable OCSymbolReference reference, final @Nullable OCResolveContext context) {
        if (reference != null) {
            type = OCTypeCloneVisitor.cloneType(type, new OCTypeCloneVisitor(false){

                @Override
                public OCType visitReferenceType(OCReferenceType type) {
                    if (context != null && context.getResolvingTypeNames().contains(type.getReference().getQualifiedName().dropArguments())) {
                        return type;
                    }
                    return this.cloneReferenceType(type, type.getReference().cloneWithOffset(reference));
                }

                @Override
                public OCType visitDeferredType(OCDeferredType type) {
                    if (context == null) {
                        return super.visitDeferredType(type);
                    }
                    return type.getActualType(context).accept(this);
                }
            });
        }
        return type;
    }
}

