/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCPointerType
extends OCTypeCompatibilityVisitor<OCPointerType> {
    protected OCTypeCompatibilityVisitor_OCPointerType(@NotNull OCPointerType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(OCFunctionType type) {
        if (((OCPointerType)this.mySourceType).getRefType() instanceof OCVoidType) {
            return OCTypeCheckResult.createOK();
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitPointerType(OCPointerType type) {
        OCType lTerminalType = type.getTerminalType();
        OCType rTerminalType = ((OCPointerType)this.mySourceType).getTerminalType();
        int lPointersDepth = type.pointersDepth();
        int rPointersDepth = ((OCPointerType)this.mySourceType).pointersDepth();
        OCTypeCheckResult error = new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        if (type.getClassQualifier() != null && ((OCPointerType)this.mySourceType).getClassQualifier() != null ? !((OCPointerType)this.mySourceType).getClassQualifier().isCompatible(type.getClassQualifier(), this.myResolveContext) : type.getClassQualifier() != null && !(type.getClassQualifier() instanceof OCMagicType) || ((OCPointerType)this.mySourceType).getClassQualifier() != null && !(((OCPointerType)this.mySourceType).getClassQualifier() instanceof OCMagicType)) {
            return error;
        }
        if (!(lTerminalType.isUnknown() || rTerminalType.isUnknown() || lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType || !(type.isPointerToPointerToObjectCompatible() ^ ((OCPointerType)this.mySourceType).isPointerToPointerToObjectCompatible()))) {
            boolean isTollFreeBridge = OCTollFreeBridges.isCompatible(type, this.mySourceType);
            if (OCCompilerFeatures.isArcEnabled(this.myContext.getContainingFile())) {
                OCTypeCheckResult result = this.checkArcBridgeCast(type, isTollFreeBridge);
                if (result != null) {
                    return result;
                }
            } else if (isTollFreeBridge) {
                return OCTypeCheckResult.createOK();
            }
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        boolean warningEvenInCpp = false;
        OCTypeCheckResult checkResult = type.validateConstPointers(this.mySourceType, this.myResolveContext);
        if (checkResult.getState() != OCTypeCheckState.ERROR) {
            return checkResult;
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && type.getRefType().isCompatible(((OCPointerType)this.mySourceType).getRefType(), this.myResolveContext)) {
            return OCTypeCheckResult.createOK();
        }
        if (type.isPointerToVoid() && !isCpp) {
            return OCTypeCheckResult.createOK();
        }
        if (((OCPointerType)this.mySourceType).isPointerToVoid() && !isCpp) {
            return OCTypeCheckResult.createOK();
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && lPointersDepth == rPointersDepth) {
            return type.getRefType().checkCompatible(((OCPointerType)this.mySourceType).getRefType(), this.mySource, this.myContext, this.myResolveContext);
        }
        if (lTerminalType instanceof OCMagicType) {
            return OCTypeCheckResult.createOK();
        }
        if (this.isCppClassType(lTerminalType) && this.isCppClassType(rTerminalType) && lPointersDepth == rPointersDepth) {
            if (OCTypeUtils.isSameOrDerivedFrom(((OCPointerType)this.mySourceType).getRefType(), type.getRefType(), this.myResolveContext) || ((OCPointerType)this.mySourceType).isMagicInside(this.myResolveContext)) {
                return OCTypeCheckResult.createOK();
            }
            if (this.myContext instanceof OCCastExpression) {
                warningEvenInCpp = true;
            }
        }
        if (lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType && lPointersDepth == rPointersDepth && (type instanceof OCBlockPointerType || !(this.mySourceType instanceof OCBlockPointerType))) {
            return type.getRefType().checkCompatible(((OCPointerType)this.mySourceType).getRefType(), this.mySource, this.myContext, this.myResolveContext);
        }
        if (type.getRefType() instanceof OCIdType && ((OCIdType)type.getRefType()).getAllProtocols().isEmpty() && ((OCPointerType)this.mySourceType).isPointerToObjectCompatible() || type.isPointerToObjectCompatible() && ((OCPointerType)this.mySourceType).isPointerToID() && ((OCPointerType)this.mySourceType).getTerminalType() instanceof OCObjectType && ((OCObjectType)((OCPointerType)this.mySourceType).getTerminalType()).getAllProtocols().isEmpty()) {
            return OCTypeCheckResult.createOK();
        }
        if ((lTerminalType instanceof OCReferenceType || rTerminalType instanceof OCReferenceType) && type.getCanonicalName(this.myResolveContext).equals(((OCPointerType)this.mySourceType).getCanonicalName(this.myResolveContext))) {
            return OCTypeCheckResult.createOK();
        }
        if (checkResult.getState() == OCTypeCheckState.ERROR_IF_CPP) {
            return checkResult;
        }
        if (warningEvenInCpp) {
            error.setState(OCTypeCheckState.WARNING);
        }
        return error;
    }

    @Override
    public OCTypeCheckResult visitStructType(OCStructType type) {
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type)) {
            return OCTypeCheckResult.createOK();
        }
        if (type.getKind() == OCSymbolKind.ENUM && !type.isEnumClass()) {
            Computable message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from pointer";
            return this.checkAssignToEnum(type, (Computable<String>)message);
        }
        return this.checkStructCompatibleCtor(type);
    }
}

