/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCTypeArgumentsProcessor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeUnificationVisitor
implements OCTypeVisitor<UnificationResult> {
    public static final int MAX_EXPANSION_PACK_SIZE = 25;
    private static final int HANDLE_ALL_ARGUMENTS = -1;
    public static final UnificationResult NOT_UNIFIED = new UnificationResult(-1);
    public static final UnificationResult UNIFIED = new UnificationResult(1);
    public static final UnificationResult UNIFIED_CONST_VALUE = new UnificationResult(1, 0, 1);
    public static final UnificationResult UNKNOWN = new UnificationResult(0);
    private boolean myFunctionParametersMode;
    private boolean myCheckFunctionReturnTypes;
    private final boolean myVariadicMode;
    private final boolean myMagicTypesEqual;
    private final boolean myPartialOrderingMode;
    private int myRelevantFunctionArgumentsCount = -1;
    private OCTypeArgument myArgument;
    @Nullable
    private final OCTypeOwner myArgumentExpr;
    private final Map<OCTypeParameterSymbol, OCTypeArgument> mySubstitutionMap;
    @Nullable
    private final Set<OCTypeParameterSymbol> myDependentTypes;
    @Nullable
    private Set<OCTypeParameterSymbol> myUnifiableTypeParameters = null;
    @Nullable
    private Set<OCTypeParameterSymbol> myCTADParameters = null;
    @NotNull
    private final OCResolveContext myContext;

    public OCTypeUnificationVisitor(boolean functionParametersMode, boolean checkFunctionReturnTypes, boolean variadicMode, boolean magicTypesEqual, boolean partialOrderingMode, @NotNull OCTypeArgument argument, @Nullable OCTypeOwner expression, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @Nullable Set<OCTypeParameterSymbol> dependentTypes, @NotNull OCResolveContext context) {
        this.myFunctionParametersMode = functionParametersMode;
        this.myCheckFunctionReturnTypes = checkFunctionReturnTypes;
        this.myVariadicMode = variadicMode;
        this.myMagicTypesEqual = magicTypesEqual;
        this.myPartialOrderingMode = partialOrderingMode;
        this.myArgument = argument;
        this.myArgumentExpr = expression;
        this.mySubstitutionMap = substitutionMap;
        this.myDependentTypes = dependentTypes;
        this.myContext = context;
    }

    public UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument) {
        if (parameter instanceof OCExpressionTypeArgument) {
            OCResolveContext context = this.myContext.substitute(OCSimpleTypeSubstitution.create(this.mySubstitutionMap));
            OCExpressionSymbol parameterSymbol = ((OCExpressionTypeArgument)parameter).getSymbol();
            Number paramValue = OCExpressionEvaluator.evaluate(parameterSymbol, context);
            Number argValue = null;
            if (paramValue == null) {
                OCSymbol symbol;
                if (parameterSymbol instanceof OCReferenceExpressionSymbol && (symbol = ((OCReferenceExpressionSymbol)parameterSymbol).resolveToSymbol(this.myContext)) instanceof OCTypeParameterValueSymbol) {
                    if (((OCTypeParameterSymbol)((Object)symbol)).isVariadic() && !(argument instanceof OCExpansionPackType)) {
                        OCTypeArgument old = this.mySubstitutionMap.get((OCTypeParameterSymbol)((Object)symbol));
                        argument = old != null ? ((OCExpansionPackType)old).appendTypeArgument(argument) : new OCExpansionPackType(Collections.singletonList(argument));
                    }
                    this.mySubstitutionMap.put((OCTypeParameterSymbol)((Object)symbol), argument);
                    return UNIFIED;
                }
                return UNKNOWN;
            }
            if (argument instanceof OCExpressionTypeArgument) {
                argValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)argument).getSymbol(), context);
            } else if (!(argument instanceof OCMagicType) && !(argument instanceof OCReferenceType) || this.myPartialOrderingMode) {
                return NOT_UNIFIED;
            }
            if (argValue != null) {
                return OCTypeUnificationVisitor.isSameValue(paramValue, argValue) ? UNIFIED_CONST_VALUE : this.defaultResult();
            }
        } else if (parameter instanceof OCType) {
            if (argument instanceof OCReferenceType) {
                argument = OCUnknownType.INSTANCE;
            }
            if (parameter instanceof OCPointerType && !(argument instanceof OCPointerType) && ((OCPointerType)parameter).getRefType() instanceof OCFunctionType) {
                parameter = ((OCPointerType)parameter).getRefType();
            }
            if (this.myFunctionParametersMode || this.myPartialOrderingMode) {
                boolean shouldDropRefFromArgument;
                boolean bl = shouldDropRefFromArgument = !(parameter instanceof OCTypeParameterType) || parameter instanceof OCTypeParameterType.ReplacedAutoType;
                if (argument instanceof OCCppReferenceType && shouldDropRefFromArgument) {
                    argument = ((OCCppReferenceType)argument).getRefType();
                }
                if (parameter instanceof OCCppReferenceType) {
                    if (argument instanceof OCType && !(argument instanceof OCCppReferenceType) && this.isForwardingReference((OCCppReferenceType)parameter) && OCExprValueCategory.classify(this.myArgumentExpr, this.myContext).isLValue()) {
                        argument = OCCppReferenceType.to((OCType)argument);
                    }
                    parameter = ((OCCppReferenceType)parameter).getRefType();
                    if (this.myPartialOrderingMode) {
                        CVQualifiers argumentQualifiers = argument instanceof OCType ? ((OCType)argument).getCVQualifiers() : CVQualifiers.EMPTY;
                        parameter = ((OCType)parameter).cloneWithCVQualifiers(argumentQualifiers, this.myContext.getProject());
                    }
                }
            }
            if (argument instanceof OCTypeParameterType && this.myMagicTypesEqual && this.myDependentTypes != null) {
                if (parameter instanceof OCTypeParameterType) {
                    this.myDependentTypes.add(((OCTypeParameterType)argument).getSymbol());
                } else {
                    ((OCType)parameter).accept(new OCBooleanTypeVisitor(){

                        @Override
                        public Boolean visitTypeParameterType(OCTypeParameterType type) {
                            OCTypeUnificationVisitor.this.myDependentTypes.add(type.getSymbol());
                            return true;
                        }
                    });
                }
            }
            OCTypeArgument save = this.myArgument;
            this.myArgument = argument;
            UnificationResult result = !this.myFunctionParametersMode && argument instanceof OCType && !(argument instanceof OCExpansionPackType) && (((OCType)parameter).isConst() != ((OCType)argument).isConst() && (!(parameter instanceof OCTypeParameterType) || argument instanceof OCTypeParameterType && ((OCTypeParameterType)parameter).isConst()) || ((OCType)parameter).isVolatile() != ((OCType)argument).isVolatile() && (!(parameter instanceof OCTypeParameterType) || argument instanceof OCTypeParameterType && ((OCTypeParameterType)parameter).isVolatile())) ? this.defaultResult() : ((OCType)parameter).accept(this);
            this.myArgument = save;
            return result;
        }
        return UNKNOWN;
    }

    private boolean isForwardingReference(@NotNull OCType parameter) {
        if (!(parameter instanceof OCCppReferenceType)) {
            return false;
        }
        OCCppReferenceType ref = (OCCppReferenceType)parameter;
        OCType refType = ref.getRefType();
        if (!ref.isRvalueRef() || refType.getCVQualifiers() != CVQualifiers.EMPTY || !(refType instanceof OCTypeParameterType)) {
            return false;
        }
        OCTypeParameterSymbol parameterSymbol = ((OCTypeParameterType)refType).getSymbol();
        return !this.isCTADParameter(parameterSymbol);
    }

    public static boolean isSameValue(@Nullable Object value1, @Nullable Object value2) {
        if (value1 instanceof Boolean && value2 instanceof Number) {
            return (Boolean)value1 == (OCExpressionEvaluator.singAsInC(value2) != 0);
        }
        if (value1 instanceof Number && value2 instanceof Boolean) {
            return OCExpressionEvaluator.singAsInC(value1) != 0 == (Boolean)value2;
        }
        if (value1 instanceof Number && value2 instanceof Number) {
            return OCNumber.valueOf(value1).compareTo(OCNumber.valueOf(value2)) == 0;
        }
        return Comparing.equal((Object)value1, (Object)value2);
    }

    private UnificationResult defaultResult() {
        if (this.myArgument instanceof OCType && ((OCType)this.myArgument).isUnresolved(this.myContext)) {
            return NOT_UNIFIED;
        }
        if (this.myArgument instanceof OCMagicType) {
            return this.myMagicTypesEqual ? UNKNOWN : NOT_UNIFIED;
        }
        return this.myFunctionParametersMode && !this.myVariadicMode ? UNKNOWN : NOT_UNIFIED;
    }

    public void setRelevantFunctionArgumentsCount(int relevantFunctionArgumentsCount) {
        this.myRelevantFunctionArgumentsCount = relevantFunctionArgumentsCount;
    }

    public void setUnifiableTypeParameters(@Nullable Set<OCTypeParameterSymbol> unifiableTypeParameters) {
        this.myUnifiableTypeParameters = unifiableTypeParameters;
    }

    public void setCTADParameters(@Nullable Set<OCTypeParameterSymbol> CTADParameters) {
        this.myCTADParameters = CTADParameters;
    }

    @Override
    public UnificationResult visitFunctionType(OCFunctionType type) {
        List<OCType> parameterTypes;
        OCType functionType;
        if (this.myArgument instanceof OCFunctionType) {
            int argumentsCnt;
            int paramsCnt;
            OCFunctionType argumentFunction = (OCFunctionType)this.myArgument;
            List<OCType> parameterTypes2 = type.getParameterTypes();
            List<OCType> argumentTypes = argumentFunction.getParameterTypes();
            if (type.isLValueRef() != argumentFunction.isLValueRef() || type.isRValueRef() != argumentFunction.isRValueRef()) {
                return this.defaultResult();
            }
            if (this.myRelevantFunctionArgumentsCount != -1) {
                assert (this.myPartialOrderingMode);
                if (argumentTypes.size() >= this.myRelevantFunctionArgumentsCount && parameterTypes2.size() >= this.myRelevantFunctionArgumentsCount) {
                    parameterTypes2 = parameterTypes2.subList(0, this.myRelevantFunctionArgumentsCount);
                    argumentTypes = argumentTypes.subList(0, this.myRelevantFunctionArgumentsCount);
                }
                this.myRelevantFunctionArgumentsCount = -1;
            }
            if ((paramsCnt = parameterTypes2.size()) == (argumentsCnt = argumentTypes.size()) || type.isVararg() && argumentsCnt + 1 >= paramsCnt) {
                Ref result = Ref.create((Object)UNIFIED);
                if (this.myCheckFunctionReturnTypes) {
                    UnificationResult cur = this.unify(type.getReturnType(), argumentFunction.getReturnType());
                    if (cur == NOT_UNIFIED) {
                        return cur;
                    }
                    result.set((Object)((UnificationResult)result.get()).add(cur));
                }
                if (!OCTypeArgumentsProcessor.processArguments(parameterTypes2, argumentTypes, (parameterType, argumentType) -> {
                    if (argumentType == null) {
                        if (parameterType instanceof OCType && ((OCType)parameterType).isUnresolved(this.myContext)) {
                            result.set((Object)NOT_UNIFIED);
                        }
                        return false;
                    }
                    boolean save = this.myCheckFunctionReturnTypes;
                    boolean save2 = this.myFunctionParametersMode;
                    this.myCheckFunctionReturnTypes = true;
                    this.myFunctionParametersMode = false;
                    UnificationResult cur = this.unify(parameterType, argumentType);
                    this.myCheckFunctionReturnTypes = save;
                    this.myFunctionParametersMode = save2;
                    result.set((Object)((UnificationResult)result.get()).add(cur));
                    return cur != NOT_UNIFIED;
                })) {
                    return NOT_UNIFIED;
                }
                return (UnificationResult)result.get();
            }
        }
        if (this.myArgument instanceof OCType && OCTypeUtils.isUnresolvedLambdaAutoType((OCType)this.myArgument) && (functionType = OCTypeUtils.resolveLambdaAutoType((OCType)this.myArgument, this.myContext, new OCArgumentsList(parameterTypes = type.getParameterTypes(), null), true)) != null && functionType.getTerminalType() instanceof OCFunctionType) {
            return this.unify(type, functionType.getTerminalType());
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitMagicType(OCMagicType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitObjectType(OCObjectType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitArrayType(OCArrayType type) {
        if (this.myArgument instanceof OCArrayType) {
            OCTypeArgument typeArg2;
            UnificationResult result = this.unify(type.getRefType(), ((OCArrayType)this.myArgument).getRefType());
            if (result == NOT_UNIFIED) {
                return result;
            }
            OCExpressionSymbol symbol1 = type.getLengthSymbol();
            OCExpressionSymbol symbol2 = ((OCArrayType)this.myArgument).getLengthSymbol();
            OCTypeArgument typeArg1 = symbol1 == null ? null : symbol1.evaluateToTypeArgument(this.myContext);
            OCTypeArgument oCTypeArgument = typeArg2 = symbol2 == null ? null : symbol2.evaluateToTypeArgument(this.myContext);
            if (typeArg1 != null && typeArg2 != null) {
                return result.add(this.unify(typeArg1, typeArg2));
            }
            return result.add(UNKNOWN);
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitPointerType(OCPointerType type) {
        if (this.myArgument instanceof OCPointerType) {
            UnificationResult result = this.unify(type.getRefType(), ((OCPointerType)this.myArgument).getRefType());
            OCType classQualifier = type.getClassQualifier();
            OCType myClassQualifier = ((OCPointerType)this.myArgument).getClassQualifier();
            if (result == NOT_UNIFIED) {
                return result;
            }
            result = result.add(UNIFIED);
            if (!(this.myArgumentExpr != null && this.myArgumentExpr.isLiteral() || classQualifier == null == (myClassQualifier == null))) {
                return NOT_UNIFIED;
            }
            if (classQualifier != null && myClassQualifier != null) {
                result = result.add(this.unify(classQualifier, myClassQualifier));
            }
            return result;
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitBlockPointerType(OCBlockPointerType type) {
        if (this.myArgument instanceof OCBlockPointerType) {
            return this.unify(type.getRefType(), ((OCBlockPointerType)this.myArgument).getRefType()).add(UNIFIED);
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitCppReferenceType(OCCppReferenceType type) {
        if (this.myArgument instanceof OCCppReferenceType) {
            OCCppReferenceType argument = (OCCppReferenceType)this.myArgument;
            if (type.isRvalueRef() == argument.isRvalueRef()) {
                return this.unify(type.getRefType(), argument.getRefType()).add(UNIFIED);
            }
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitIdType(OCIdType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitReferenceType(OCReferenceType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitUnknownType(OCUnknownType type) {
        return this.myArgument == OCUnknownType.INSTANCE ? UNKNOWN : NOT_UNIFIED;
    }

    @Override
    public UnificationResult visitAutoType(OCAutoType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitEllipsisReferenceType(OCEllipsisType type) {
        return this.myArgument instanceof OCEllipsisType ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitIntType(OCIntType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitRealType(OCRealType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitVoidType(OCVoidType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Nullable
    private OCType findMatchingAncestor(OCType argumentType, OCStructType paramType) {
        if (argumentType instanceof OCMagicType || argumentType instanceof OCStructType && ((OCStructType)argumentType).getSymbol().resolvedNamesEqual(this.myContext.getProject(), paramType.getSymbol())) {
            return argumentType;
        }
        if (this.myFunctionParametersMode && argumentType instanceof OCStructType) {
            for (OCStructSymbol paramSymbol : paramType.getStructs()) {
                for (OCStructSymbol argumentSymbol : ((OCStructType)argumentType).getStructs()) {
                    Ref result = new Ref();
                    argumentSymbol.processAllBaseClasses(this.myContext, (baseSymbol, visibility) -> {
                        if (baseSymbol instanceof OCStructSymbol && ((OCStructSymbol)baseSymbol).resolvedNamesEqual(this.myContext.getProject(), paramSymbol)) {
                            result.set((Object)baseSymbol.getType());
                            return false;
                        }
                        if (baseSymbol instanceof OCTypeParameterSymbol) {
                            result.set((Object)new OCMagicType());
                            return false;
                        }
                        return true;
                    }, false);
                    if (result.isNull()) continue;
                    return (OCType)result.get();
                }
            }
        }
        return null;
    }

    @Override
    public UnificationResult visitStructType(OCStructType type) {
        OCType argumentType;
        if (this.myArgument instanceof OCBracedInitListType) {
            OCType firstExprType;
            OCType initListTemplateParam = OCCodeInsightUtil.getStdInitializerListTemplateParameter(type, this.myContext);
            if (initListTemplateParam == null) {
                return this.defaultResult();
            }
            if (this.myArgumentExpr instanceof OCInitializerListExpressionSymbol) {
                OCExpressionSymbol firstSymbol = (OCExpressionSymbol)ContainerUtil.getFirstItem(((OCInitializerListExpressionSymbol)this.myArgumentExpr).getInitializerExpressions());
                firstExprType = firstSymbol != null ? firstSymbol.getResolvedType(this.myContext) : null;
            } else if (this.myArgumentExpr instanceof OCCompoundInitializer) {
                OCExpression firstExpr = (OCExpression)ContainerUtil.getFirstItem(((OCCompoundInitializer)this.myArgumentExpr).getInitializerExpressions());
                firstExprType = firstExpr != null ? firstExpr.getResolvedType(this.myContext) : null;
            } else {
                return this.defaultResult();
            }
            if (firstExprType == null) {
                return this.defaultResult();
            }
            return this.unify(initListTemplateParam, firstExprType);
        }
        OCType oCType = argumentType = this.myArgument instanceof OCStructType ? this.findMatchingAncestor((OCStructType)this.myArgument, type) : null;
        if (argumentType == null) {
            return this.defaultResult();
        }
        Ref result = Ref.create((Object)UNIFIED);
        if (argumentType instanceof OCStructType) {
            OCStructSymbol paramSymbol = type.getSymbol();
            List<OCTypeArgument> parameterArgs = paramSymbol.getTemplateArguments(this.myContext);
            boolean hasNullArgs = false;
            if (!paramSymbol.isSpecialization()) {
                for (OCTypeParameterSymbol paramParamSymbol : paramSymbol.getTemplateParameters()) {
                    if (paramSymbol.getSubstitution().getSubstitutionFor(paramParamSymbol) != null || paramParamSymbol.isVariadic()) continue;
                    if (this.myDependentTypes != null) {
                        this.myDependentTypes.add(paramParamSymbol);
                    }
                    hasNullArgs = true;
                }
            }
            if (hasNullArgs) {
                List<OCTypeArgument> typeArgs = type.getResolvedArguments(this.myContext.clearSubstitution());
                parameterArgs = typeArgs != null ? typeArgs : parameterArgs;
            }
            OCStructSymbol argSymbol = ((OCStructType)argumentType).getSymbol();
            List<OCTypeArgument> argumentArgs = argSymbol.getTemplateArguments(this.myContext);
            for (int i = 0; i < argumentArgs.size(); ++i) {
                if (argumentArgs.get(i) != null) continue;
                OCTypeParameterSymbol argParamSymbol = argSymbol.getTemplateParameters().get(i);
                if (!this.myContext.getTypeDependencies().contains(argParamSymbol)) continue;
                argumentArgs.set(i, new OCTypeParameterType(argParamSymbol));
            }
            if (!OCTypeArgumentsProcessor.processArguments(parameterArgs, argumentArgs, (parameterType, argumentType1) -> {
                if (parameterType == null || argumentType1 == null) {
                    return true;
                }
                UnificationResult cur = this.unify(parameterType, argumentType1);
                result.set((Object)((UnificationResult)result.get()).add(cur));
                return cur != NOT_UNIFIED;
            })) {
                return NOT_UNIFIED;
            }
        }
        return (UnificationResult)result.get();
    }

    private boolean isCTADParameter(OCTypeParameterSymbol parameterSymbol) {
        if (this.myCTADParameters != null) {
            return this.myCTADParameters.contains(parameterSymbol);
        }
        return false;
    }

    @Override
    public UnificationResult visitTypeParameterType(OCTypeParameterType type) {
        OCTypeParameterSymbol parameterSymbol = type.getSymbol();
        if (this.myUnifiableTypeParameters != null && !this.myUnifiableTypeParameters.contains(parameterSymbol) && !this.isCTADParameter(parameterSymbol)) {
            return UNIFIED;
        }
        UnificationResult result = UNKNOWN;
        if (this.myArgument instanceof OCTypeParameterType && ((OCTypeParameterType)this.myArgument).getSymbol().equals(parameterSymbol) && !((OCSymbol)((Object)parameterSymbol)).isSynthetic()) {
            return UNIFIED;
        }
        if (parameterSymbol instanceof OCTypeParameterValueSymbol) {
            if (!(this.myArgument instanceof OCExpressionTypeArgument || this.myArgument instanceof OCTypeParameterType && ((OCTypeParameterType)this.myArgument).getSymbol() instanceof OCTypeParameterValueSymbol || this.myArgument instanceof OCExpansionPackType)) {
                return UNKNOWN;
            }
        } else {
            if (!(!(this.myArgument instanceof OCMagicType) && this.myArgument instanceof OCType || this.myArgument instanceof OCTypeParameterType)) {
                if (this.myArgument instanceof OCType) {
                    this.mySubstitutionMap.put(parameterSymbol, this.myArgument);
                }
                return UNKNOWN;
            }
            if (this.myArgument instanceof OCBracedInitListType) {
                return NOT_UNIFIED;
            }
        }
        OCTypeArgument old = this.mySubstitutionMap.get(parameterSymbol);
        if (this.myArgument instanceof OCType && !(this.myArgument instanceof OCExpansionPackType)) {
            OCType argumentType = (OCType)this.myArgument;
            if (type.isConst()) {
                if (argumentType.isConst()) {
                    argumentType = argumentType.cloneWithoutConstModifier(this.myContext.getProject());
                    this.myArgument = argumentType;
                    result = result.add(UNIFIED);
                } else if (!this.myFunctionParametersMode && !this.myPartialOrderingMode) {
                    return NOT_UNIFIED;
                }
            }
            if (type.isVolatile()) {
                if (argumentType.isVolatile()) {
                    this.myArgument = argumentType.cloneWithCVQualifiers(CVQualifiers.get(argumentType.isConst(), false), this.myContext.getProject());
                    result = result.add(UNIFIED);
                } else if (!this.myFunctionParametersMode && !this.myPartialOrderingMode) {
                    return NOT_UNIFIED;
                }
            }
        }
        if (parameterSymbol.isVariadic()) {
            if (this.myArgument instanceof OCVariadicType && ((OCVariadicType)this.myArgument).getUnderlyingType() instanceof OCExpansionPackType) {
                return NOT_UNIFIED;
            }
            if (!(this.myArgument instanceof OCExpansionPackType)) {
                if (old instanceof OCExpansionPackType) {
                    OCExpansionPackType expansionPack = (OCExpansionPackType)old;
                    if (expansionPack.getExpansionsCnt() > 25) {
                        return NOT_UNIFIED;
                    }
                    this.myArgument = expansionPack.appendTypeArgument(this.myArgument);
                } else {
                    this.myArgument = new OCExpansionPackType(Collections.singletonList(this.myArgument));
                }
            }
        } else if (this.myArgument instanceof OCExpansionPackType || this.myArgument instanceof OCVariadicType) {
            if (!((OCType)this.myArgument).isMagicInside(this.myContext)) {
                return NOT_UNIFIED;
            }
        } else if (old != null) {
            boolean equal;
            boolean bl = equal = old instanceof OCType && this.myArgument instanceof OCType ? new OCTypeEqualityVisitor((OCType)old, this.myMagicTypesEqual, true, this.myContext).equal((OCType)this.myArgument) : old.equals(this.myArgument, this.myContext);
            if (!equal) {
                return NOT_UNIFIED;
            }
        }
        this.mySubstitutionMap.put(parameterSymbol, this.myArgument);
        return result;
    }

    @Override
    public UnificationResult visitVariadicType(OCVariadicType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitExpansionPackType(OCExpansionPackType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitBracedInitListType(OCBracedInitListType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitStructuredBindingType(OCStructuredBindingType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitDeferredType(OCDeferredType type) {
        return type.getActualType(this.myContext).accept(this);
    }

    public static class UnificationResult {
        private final int numOfUnified;
        private int numOfNonSpecializedArgs;
        private int numOfConstantValueArgs;

        UnificationResult(int numOfUnified) {
            this.numOfUnified = numOfUnified;
        }

        public UnificationResult(int numOfUnified, int numOfNonSpecializedArgs, int numOfConstantValueArgs) {
            this.numOfUnified = numOfUnified;
            this.numOfNonSpecializedArgs = numOfNonSpecializedArgs;
            this.numOfConstantValueArgs = numOfConstantValueArgs;
        }

        @Contract(pure=true)
        UnificationResult add(UnificationResult result) {
            if (this == NOT_UNIFIED || result == NOT_UNIFIED) {
                return NOT_UNIFIED;
            }
            return new UnificationResult(this.numOfUnified + result.numOfUnified, this.numOfNonSpecializedArgs + result.numOfNonSpecializedArgs, this.numOfConstantValueArgs + result.numOfConstantValueArgs);
        }

        void incNumOfNonSpecializedArgs() {
            ++this.numOfNonSpecializedArgs;
        }

        public boolean isUnified() {
            return this.numOfUnified > 0;
        }

        boolean isBetter(UnificationResult other) {
            if (this.numOfUnified > other.numOfUnified) {
                return true;
            }
            if (this.numOfUnified < other.numOfUnified) {
                return false;
            }
            if (this.numOfNonSpecializedArgs < other.numOfNonSpecializedArgs) {
                return true;
            }
            if (this.numOfNonSpecializedArgs > other.numOfNonSpecializedArgs) {
                return false;
            }
            return this.numOfConstantValueArgs > other.numOfConstantValueArgs;
        }

        public String toString() {
            if (this == UNIFIED) {
                return "UNIFIED";
            }
            if (this == UNIFIED_CONST_VALUE) {
                return "UNIFIED_CONST_VALUE";
            }
            if (this == NOT_UNIFIED) {
                return "NOT_UNIFIED";
            }
            if (this == UNKNOWN) {
                return "UNKNOWN";
            }
            return "UnificationResult(unified=" + this.numOfUnified + ", non-spec=" + this.numOfNonSpecializedArgs + ", const-value=" + this.numOfConstantValueArgs + ")";
        }
    }
}

