/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors.names;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitorBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDumbTypeNameVisitor
extends OCTypeNameVisitorBase {
    @Nullable
    private final Project myProject;

    public OCDumbTypeNameVisitor() {
        this(0, null);
    }

    public OCDumbTypeNameVisitor(int templateDepth, @Nullable Project project2) {
        super(templateDepth);
        this.myProject = project2;
    }

    @Override
    @NotNull
    public String getName(OCType type) {
        String aliasName = type.getAliasName();
        if (aliasName != null) {
            return aliasName;
        }
        return type.accept(this);
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    @Override
    public String visitFunctionType(OCFunctionType type) {
        String name2 = this.getName(type.getReturnType());
        return this.getFunctionSignature(type, name2);
    }

    @Override
    public String visitMagicType(OCMagicType type) {
        return type.getMagicName();
    }

    @Override
    public String visitArrayType(OCArrayType type) {
        return this.getArrayTypeName(type, null);
    }

    @NotNull
    private String getArrayTypeName(OCArrayType type, @Nullable String modifier) {
        StringBuilder builder = new StringBuilder();
        OCType current = type;
        while (current instanceof OCArrayType) {
            OCArrayType arrayType = current;
            builder.append("[");
            if (arrayType.getLengthSymbol() != null) {
                builder.append(arrayType.getLengthSymbol().getPresentableName());
            }
            builder.append("]");
            current = arrayType.getRefType();
        }
        if (modifier != null) {
            builder.insert(0, modifier);
        }
        builder.insert(0, this.getName(current));
        return builder.toString();
    }

    @Override
    public String visitPointerType(OCPointerType type) {
        if (type.getTerminalType() instanceof OCFunctionType) {
            OCFunctionType ft = (OCFunctionType)type.getTerminalType();
            StringBuilder builder = new StringBuilder();
            builder.append(ft.getReturnType().getName()).append(" (");
            StringBuilder asteriskBuilder = new StringBuilder();
            if (type.getClassQualifier() != null) {
                builder.append(this.getName(type.getClassQualifier())).append("::");
            }
            OCType cur = type;
            while (cur instanceof OCPointerType) {
                asteriskBuilder.append(cur instanceof OCBlockPointerType ? (char)'^' : '*');
                cur = cur.getRefType();
            }
            for (int i = asteriskBuilder.length() - 1; i >= 0; --i) {
                builder.append(asteriskBuilder.charAt(i));
            }
            builder.append(')');
            String signature = this.getFunctionSignature(ft, builder.toString());
            return this.appendCVQualifiers(type, signature);
        }
        String refCanonical = (type.getARCAttribute() != null ? type.getARCAttribute().getTokenName() + " " : "") + this.getName(type.getRefType());
        if (type instanceof OCBlockPointerType) {
            return "invalid_block_pointer: ^(" + refCanonical + ")";
        }
        if (type.getRefType() instanceof OCIdType) {
            return refCanonical;
        }
        String suffix = "*";
        if (type.getClassQualifier() != null) {
            suffix = type.getClassQualifier().getName() + "::" + suffix;
        }
        return this.appendCVQualifiers(type, refCanonical + " " + suffix);
    }

    @Override
    public String visitBlockPointerType(OCBlockPointerType type) {
        return this.visitPointerType(type);
    }

    @Override
    public String visitCppReferenceType(OCCppReferenceType type) {
        String modifier;
        String string = modifier = type.isRvalueRef() ? "&&" : "&";
        if (type.getTerminalType() instanceof OCFunctionType) {
            OCFunctionType ft = (OCFunctionType)type.getTerminalType();
            return this.getFunctionSignature(ft, this.getName(ft.getReturnType()) + " (" + modifier + ")");
        }
        if (type.getRefType() instanceof OCArrayType) {
            return this.getArrayTypeName((OCArrayType)type.getRefType(), " (" + modifier + ")");
        }
        String refCanonical = this.getName(type.getRefType());
        if (type.getRefType() instanceof OCIdType) {
            return refCanonical;
        }
        return this.appendCVQualifiers(type, refCanonical + " " + modifier);
    }

    @Override
    public String visitIdType(OCIdType type) {
        return this.visitObjectType(type);
    }

    @Override
    public String visitIntType(OCIntType type) {
        return this.appendCVQualifiers(type, type.getText());
    }

    @Override
    public String visitRealType(OCRealType type) {
        return this.appendCVQualifiers(type, type.getText());
    }

    @Override
    protected String getCanonicalName(OCReferenceType type) {
        return type.getReference().getQualifiedName().getShortName(this.myTemplateDepth);
    }

    @Override
    public String visitStructType(OCStructType type) {
        OCStructSymbol symbol = type.getStructs().get(0);
        String baseName = type.getTypedefName() != null ? type.getTypedefName() : (symbol.isUnnamed() ? "anonymous " + symbol.getKind().getNameLowercase() : symbol.getName());
        OCTypeSubstitution substitution = symbol.getSubstitution();
        if (substitution != OCTypeSubstitution.ID || symbol.isSpecialization()) {
            return this.appendCVQualifiers(type, this.getSubstitutedTypeName(baseName, symbol));
        }
        return this.appendCVQualifiers(type, baseName);
    }

    @Override
    protected String getNameForTypeArgument(OCTypeArgument argument) {
        return argument.getShortName(this.myTemplateDepth + 1);
    }

    @Override
    @NotNull
    protected List<OCTypeArgument> getTypeArguments(OCTemplateSymbol symbol) {
        OCTypeSubstitution substitution = symbol.getSubstitution();
        ArrayList<OCTypeArgument> arguments = new ArrayList<OCTypeArgument>();
        List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
        if (specialization != null) {
            arguments.addAll(specialization);
        } else {
            for (OCTypeParameterSymbol argument : symbol.getTemplateParameters()) {
                arguments.add(substitution.getSubstitutionFor(argument));
            }
        }
        if (symbol instanceof OCInterfaceSymbol) {
            for (int i = arguments.size() - 1; i >= 0; --i) {
                OCTypeParameterSymbol argument;
                argument = symbol.getTemplateParameters().get(i);
                OCTypeArgument typeArgument = (OCTypeArgument)arguments.get(i);
                if (!(typeArgument instanceof OCType) || !(argument.getDefaultValue() instanceof OCType)) continue;
                if (!((OCType)argument.getDefaultValue()).isPointerToID() || !((OCType)typeArgument).isPointerToID()) break;
                arguments.remove(i);
            }
        }
        return arguments;
    }

    @Override
    public String visitExpansionPackType(OCExpansionPackType type) {
        return StringUtil.join((Collection)ContainerUtil.map(type.getExpansions(), typeArgument -> typeArgument.getShortName(this.myTemplateDepth)), (String)", ");
    }
}

