/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors.names;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeNameVisitorBase
implements OCTypeVisitor<String> {
    public static final int MAX_STRUCT_PARAMETERS_IN_PRESENTATION = 5;
    public static final int MAX_TEMPLATE_DEPTH_IN_PRESENTATION = 10;
    protected final int myTemplateDepth;

    protected OCTypeNameVisitorBase(int templateDepth) {
        this.myTemplateDepth = templateDepth;
    }

    @NotNull
    public abstract String getName(OCType var1);

    protected abstract String getNameForTypeArgument(OCTypeArgument var1);

    @NotNull
    protected abstract List<OCTypeArgument> getTypeArguments(OCTemplateSymbol var1);

    @Nullable
    protected abstract String getCanonicalName(OCReferenceType var1);

    @Nullable
    protected abstract Project getProject();

    protected String getSubstitutedTypeName(String baseName, OCTemplateSymbol symbol) {
        List<OCTypeArgument> arguments = this.getTypeArguments(symbol);
        StringBuilder builder = new StringBuilder(baseName);
        if (arguments.size() > 0) {
            builder.append('<');
            if (this.myTemplateDepth < 10) {
                for (int j = 0; j < arguments.size(); ++j) {
                    if (j > 5) {
                        builder.append("...");
                        break;
                    }
                    if (j != 0) {
                        builder.append(", ");
                    }
                    OCTypeArgument argument = arguments.get(j);
                    if (symbol.isSpecialization() && argument != null) {
                        builder.append(this.getNameForTypeArgument(argument));
                        continue;
                    }
                    if (argument instanceof OCType) {
                        builder.append(this.getName((OCType)argument));
                        continue;
                    }
                    if (argument != null) {
                        builder.append(this.getNameForTypeArgument(argument));
                        continue;
                    }
                    builder.append(symbol.getTemplateParameters().get(j).getName());
                }
            } else {
                builder.append("...");
            }
            builder.append(">");
        }
        return builder.toString();
    }

    private static String appendIsKindof(boolean isKindof, String typeString) {
        if (!isKindof || typeString.startsWith("__kindof ")) {
            return typeString;
        }
        return "__kindof " + typeString;
    }

    protected String appendCVQualifiers(OCType type, String typeString) {
        return CVQualifiers.appendCVQualifiers(typeString, type, this.getProject());
    }

    @NotNull
    public static String addTypeQualifier(@NotNull String typeString, @NotNull OCType type, @Nullable Project project2, @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        if (qualifier.isEmpty()) {
            return typeString;
        }
        OCCodeStyleSettings oCCodeStyleSettings = settings = project2 != null ? (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || type instanceof OCFunctionType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            return typeString.endsWith(" " + qualifier) ? typeString : typeString + " " + qualifier;
        }
        return typeString.startsWith(qualifier + " ") ? typeString : qualifier + " " + typeString;
    }

    @NotNull
    public static String removeTypeQualifier(@NotNull String typeString, @NotNull OCType type, @Nullable Project project2, @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        OCCodeStyleSettings oCCodeStyleSettings = settings = project2 != null ? (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            return typeString.endsWith(" " + qualifier) ? typeString.substring(0, typeString.length() - qualifier.length() - 1) : typeString;
        }
        return typeString.startsWith(qualifier + " ") ? typeString.substring(qualifier.length() + 1) : typeString;
    }

    protected String getFunctionSignature(OCFunctionType type, String signatureWithoutParams) {
        StringBuilder builder = new StringBuilder(signatureWithoutParams);
        builder.append('(');
        builder.append(StringUtil.join(type.getParameterTypes(true), argumentType -> this.getName((OCType)argumentType), (String)","));
        builder.append(')');
        return this.appendCVQualifiers(type, builder.toString());
    }

    @Override
    public String visitEllipsisReferenceType(OCEllipsisType type) {
        return "...";
    }

    @Override
    public String visitObjectType(OCObjectType type) {
        boolean isGeneric;
        List<OCProtocolSymbol> protocols = type.getAugmentedProtocols();
        OCInterfaceSymbol interfaceSymbol = type.getInterface();
        boolean bl = isGeneric = interfaceSymbol != null && !interfaceSymbol.getGenericParameters().isEmpty() && interfaceSymbol.getSubstitution() != OCTypeSubstitution.ID;
        if (protocols.isEmpty() && !isGeneric) {
            return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, type.getClassName()));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(isGeneric ? this.getSubstitutedTypeName(type.getClassName(), interfaceSymbol) : type.getClassName());
        if (!protocols.isEmpty()) {
            builder.append('<');
            builder.append(StringUtil.join(protocols, OCSymbol::getName, (String)", "));
            builder.append('>');
        }
        return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder.toString()));
    }

    @Override
    public String visitUnknownType(OCUnknownType type) {
        return (String)this.visitMagicType(type);
    }

    @Override
    public String visitVoidType(OCVoidType type) {
        return this.appendCVQualifiers(type, "void");
    }

    @Override
    public String visitTypeParameterType(OCTypeParameterType type) {
        return this.appendCVQualifiers(type, type.getSymbol().getName());
    }

    @Override
    public String visitAutoType(OCAutoType type) {
        return this.appendCVQualifiers(type, "auto");
    }

    @Override
    public String visitVariadicType(OCVariadicType type) {
        return this.getName(type.getUnderlyingType()) + "...";
    }

    @Override
    public String visitBracedInitListType(OCBracedInitListType type) {
        return "<braced-init-list>";
    }

    @Override
    public String visitReferenceType(OCReferenceType type) {
        String name2 = this.getCanonicalName(type);
        String[] protocolNames = type.getProtocolNames();
        if (protocolNames.length == 0) {
            return name2 != null ? OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, name2)) : "<unnamed>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(name2).append('<').append(protocolNames[0]);
        for (int i = 1; i < protocolNames.length; ++i) {
            builder.append(", ").append(protocolNames[i]);
        }
        builder.append('>');
        return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder.toString()));
    }

    @Override
    public String visitStructuredBindingType(OCStructuredBindingType type) {
        return "<structured-binding>";
    }

    @Override
    public String visitDeferredType(OCDeferredType type) {
        return "<deferred-type>";
    }
}

