/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.ui.OCFileChooserDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileReferenceEditor
extends ReferenceEditorWithBrowseButton {
    private OCFile myLastSelectedFile;

    public OCFileReferenceEditor(ActionListener browseActionListener, EditorTextField editorTextField, Function<String, Document> factory) {
        super(browseActionListener, editorTextField, factory);
    }

    public static OCFileReferenceEditor create(final Project project2) {
        final Ref result = Ref.create(null);
        ArrayList<OCFile> files = new ArrayList<OCFile>();
        ClassCompletionProvider completionProvider = new ClassCompletionProvider(files);
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(project2, (TextFieldWithAutoCompletionListProvider)completionProvider, false, null);
        Function documentFactory = arg_0 -> OCFileReferenceEditor.lambda$create$0((EditorTextField)textField, arg_0);
        result.set((Object)new OCFileReferenceEditor(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCFileChooserDialog dialog = new OCFileChooserDialog("Choose Containing Class", project2);
                dialog.showDialog();
                if (dialog.isOK()) {
                    OCFile selectedFile = (OCFile)dialog.getSelected();
                    ((OCFileReferenceEditor)((Object)result.get())).myLastSelectedFile = selectedFile;
                    ((OCFileReferenceEditor)((Object)result.get())).setText(selectedFile.getName());
                }
            }
        }, (EditorTextField)textField, (Function<String, Document>)documentFactory));
        return (OCFileReferenceEditor)((Object)result.get());
    }

    @Nullable
    public OCFile getFile(@NotNull Project project2) {
        return (OCFile)ContainerUtil.getFirstItem(OCSearchUtil.getProjectOCFilesByName(project2, this.getText()));
    }

    private static /* synthetic */ Document lambda$create$0(EditorTextField textField, String s) {
        textField.setText(s);
        return textField.getDocument();
    }

    private static class ClassCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<OCFile> {
        protected ClassCompletionProvider(@Nullable Collection<OCFile> variants) {
            super(variants);
        }

        protected Icon getIcon(@NotNull OCFile file) {
            return file.getIcon(0);
        }

        @NotNull
        protected String getLookupString(@NotNull OCFile file) {
            return file.getName();
        }

        protected String getTailText(@NotNull OCFile file) {
            VirtualFile virtualFile = file.getVirtualFile();
            VirtualFile parent = virtualFile != null ? virtualFile.getParent() : null;
            return parent != null ? parent.getPath() : null;
        }

        protected String getTypeText(@NotNull OCFile file) {
            return null;
        }

        public int compare(OCFile file1, OCFile file2) {
            return file1.getName().compareTo(file2.getName());
        }
    }
}

