/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppTypeidExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCValueCategoryHolder;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCLValueUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCodeInsightUtil {
    private static final Map<OCElementType, OCElementType> oppositeOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.EQEQ, (Object)OCTokenTypes.EXCLEQ), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.EXCLEQ, (Object)OCTokenTypes.EQEQ), new Pair((Object)OCTokenTypes.LT, (Object)OCTokenTypes.GTEQ), new Pair((Object)OCTokenTypes.LTEQ, (Object)OCTokenTypes.GT), new Pair((Object)OCTokenTypes.GT, (Object)OCTokenTypes.LTEQ), new Pair((Object)OCTokenTypes.GTEQ, (Object)OCTokenTypes.LT)});
    private static final Map<OCElementType, OCElementType> flippedOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.ANDAND, (Object)OCTokenTypes.ANDAND), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.OROR, (Object)OCTokenTypes.OROR), new Pair((Object)OCTokenTypes.EQEQ, (Object)OCTokenTypes.EQEQ), new Pair((Object)OCTokenTypes.EXCLEQ, (Object)OCTokenTypes.EXCLEQ), new Pair((Object)OCTokenTypes.GTEQ, (Object)OCTokenTypes.LTEQ), new Pair((Object)OCTokenTypes.LTEQ, (Object)OCTokenTypes.GTEQ), new Pair((Object)OCTokenTypes.GT, (Object)OCTokenTypes.LT), new Pair((Object)OCTokenTypes.LT, (Object)OCTokenTypes.GT)});
    private static final Map<OCElementType, OCElementType> inversedLogicalOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.ANDAND, (Object)OCTokenTypes.OROR), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.OROR, (Object)OCTokenTypes.ANDAND), new Pair((Object)OCTokenTypes.OR, (Object)OCTokenTypes.AND), new Pair((Object)OCTokenTypes.AND, (Object)OCTokenTypes.OR)});

    private OCCodeInsightUtil() {
    }

    public static boolean isInPlainOldC(@Nullable PsiElement element) {
        if (element != null && element.isValid() && element.getContainingFile() instanceof OCFile) {
            return !((OCFile)element.getContainingFile()).isCpp();
        }
        return false;
    }

    public static boolean isInObjC(@Nullable PsiElement element) {
        if (element != null && element.isValid() && element.getContainingFile() instanceof OCFile) {
            return ((OCFile)element.getContainingFile()).getKind().isObjC();
        }
        return false;
    }

    public static boolean isInPlainOldC(@Nullable PsiFile file, @Nullable OCInclusionContext context) {
        if (context != null) {
            return !context.getLanguageKind().isCpp();
        }
        if (file != null) {
            return OCCodeInsightUtil.isInPlainOldC((PsiElement)file);
        }
        return true;
    }

    @Contract(value="null->false")
    public static boolean isValid(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        if (!OCSearchScope.isInProjectSources(element)) {
            return false;
        }
        OCMacroRange rangeInMacroCall = OCElementUtil.getRangeInMacroCall(element);
        if (rangeInMacroCall == null) {
            return true;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element);
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)element);
        PsiElement firstChild = PsiTreeUtil.firstChild((PsiElement)element);
        if (!(firstChild instanceof OCMacroForeignLeafElement)) {
            return false;
        }
        String macroName = ((OCMacroForeignLeafElement)firstChild).getMacroName();
        if (prevLeaf instanceof PsiErrorElement || nextLeaf instanceof PsiErrorElement) {
            return false;
        }
        if (prevLeaf instanceof OCMacroForeignLeafElement && Comparing.equal((String)((OCMacroForeignLeafElement)prevLeaf).getMacroName(), (String)macroName)) {
            return false;
        }
        return !(nextLeaf instanceof OCMacroForeignLeafElement) || !Comparing.equal((String)((OCMacroForeignLeafElement)nextLeaf).getMacroName(), (String)macroName);
    }

    @Nullable
    public static OCClassSymbol getClassInFile(OCFile file) {
        final String fileName = FileUtil.getNameWithoutExtension((String)file.getName());
        final OCClassSymbol[] result = new OCClassSymbol[]{null};
        file.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (result[0] == null || Comparing.equal((String)dcl.getName(), (String)fileName) && (!Comparing.equal((String)result[0].getName(), (String)fileName) || dcl.getCategory() == null)) {
                    result[0] = dcl.getSymbol();
                }
            }
        });
        return result[0];
    }

    @Nullable
    public static OCExpression findExpressionAtRange(PsiFile file, int startOffset, int endOffset) {
        return OCCodeInsightUtil.findElementAtRange(file, startOffset, endOffset, OCExpression.class, true);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file, TextRange range, Class<E> elementClass, boolean requireExactRange) {
        return OCCodeInsightUtil.findElementAtRange(file, range.getStartOffset(), range.getEndOffset(), elementClass, requireExactRange);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file, int startOffset, int endOffset, Class<E> elementClass, boolean requireExactRange) {
        PsiElement nameIdentifier;
        TextRange nodeRange;
        PsiElement parent;
        PsiElement node = file.findElementAt(startOffset);
        while (node != null) {
            TextRange range = node.getTextRange();
            if (range == null) {
                return null;
            }
            if (range.containsRange(startOffset, endOffset)) break;
            if (node instanceof OCMacroCall) {
                if ((node = ((OCMacroCall)node).getExpansionExpression()) == null || range.getStartOffset() != startOffset) continue;
                startOffset = node.getTextRange().getStartOffset();
                continue;
            }
            node = node.getParent();
        }
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)node, (Class[])new Class[]{elementClass, OCMacroCall.class})) != null) {
            node = parent;
        }
        TextRange textRange = nodeRange = node != null ? node.getTextRange() : null;
        if (node instanceof OCMacroCall) {
            node = ((OCMacroCall)node).getExpansionExpression();
        }
        if (node instanceof OCMacroCallArgument && node.getChildren().length >= 1) {
            node = node.getChildren()[0];
        }
        if (elementClass.equals(OCExpression.class) && node instanceof OCExpressionStatement) {
            node = ((OCExpressionStatement)node).getExpression();
            nodeRange = node.getTextRange();
        }
        if (elementClass.equals(OCDeclarator.class) && node instanceof OCDeclarator && (nameIdentifier = ((OCDeclarator)node).getNameIdentifier()) != null && nameIdentifier.getTextRange().equalsToRange(startOffset, endOffset)) {
            requireExactRange = false;
        }
        if (requireExactRange && nodeRange != null && !nodeRange.equalsToRange(startOffset, endOffset)) {
            return null;
        }
        return (E)(elementClass.isInstance(node) ? node : null);
    }

    @Nullable
    public static PsiElement[] findStatementsAtRange(PsiFile file, int startOffset, int endOffset, boolean requireExactRange) {
        PsiElement nextSibling;
        PsiElement lastItem;
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (OCElementUtil.getElementType(element2) == OCTokenTypes.EOL_COMMENT && element1 != element2) {
            if ((element2 = element2.getNextSibling()) == null || element2.getTextRange() == null) {
                return null;
            }
            endOffset = element2.getTextRange().getEndOffset();
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof OCBlockStatement) && !(parent instanceof OCCodeFragment)) {
            if (parent instanceof OCStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent == null || parent instanceof OCFile) {
                return null;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (requireExactRange && startOffset != element1.getTextRange().getStartOffset()) {
            return null;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (requireExactRange && endOffset != element2.getTextRange().getEndOffset() && (endOffset + 1 != element2.getTextRange().getEndOffset() || file.getText().charAt(endOffset) != ';')) {
            return null;
        }
        if (parent instanceof OCBlockStatement && (requireExactRange ? parent.getFirstChild() == element1 && parent.getLastChild() == element2 : parent.getFirstChild() == element1 || parent.getLastChild() == element2)) {
            PsiElement[] psiElementArray;
            if (parent.getParent() instanceof OCCallable) {
                psiElementArray = null;
            } else {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = parent;
            }
            return psiElementArray;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        if (element2 instanceof OCMacroCall) {
            PsiElement nextSibling2 = element2.getNextSibling();
            element2 = nextSibling2 != null ? nextSibling2 : element2;
        }
        boolean flag = false;
        for (PsiElement child : OCElementUtil.getAllChildren(parent)) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof OCMacroCall)) {
                array.add(child);
            }
            if (!child.equals(element2)) continue;
            break;
        }
        if ((lastItem = (PsiElement)ContainerUtil.getLastItem(array)) instanceof OCDirective && (nextSibling = lastItem.getNextSibling()) != null && OCElementUtil.isWhitespace(nextSibling)) {
            array.add(nextSibling);
        }
        for (PsiElement element : array) {
            if (element instanceof OCStatement || !OCElementUtil.isElementSignificant(element)) continue;
            return null;
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    public static <E extends PsiElement> List<E> findElementOccurrences(@Nullable PsiElement scope, @NotNull E element) {
        ArrayList<E> answer = new ArrayList<E>();
        if (!PsiTreeUtil.isAncestor((PsiElement)scope, element, (boolean)false)) {
            answer.add(element);
        }
        if (element instanceof OCExpression && OCElementUtil.getRangeInMacroCall(element) == null) {
            element = OCParenthesesUtils.diveIntoParentheses((OCExpression)element);
        }
        if (scope != null) {
            OCCodeInsightUtil.addOccurrencesIn(element, OCElementUtil.getElementType(element), scope, answer);
        }
        return answer;
    }

    private static <E extends PsiElement> void addOccurrencesIn(E element, IElementType elementType, PsiElement scope, List<E> answer) {
        if (OCElementUtil.getElementType(scope) == elementType && OCElementUtil.areElementsEquivalent(element, scope, false)) {
            if (scope instanceof OCExpression) {
                scope = OCParenthesesUtils.topmostParenthesized((OCExpression)scope);
            }
            answer.add(scope);
        } else {
            for (PsiElement c : scope.getChildren()) {
                OCCodeInsightUtil.addOccurrencesIn(element, elementType, c, answer);
            }
        }
    }

    public static boolean isLValue(OCExpression expr) {
        return OCLValueUtil.isLValue(expr);
    }

    public static boolean isAssignmentLHS(OCExpression expr) {
        return OCLValueUtil.isAssignmentLHS(expr);
    }

    public static boolean hasSideEffects(@NotNull PsiElement element) {
        final Ref result = Ref.create((Object)false);
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitPrefixExpression(OCPrefixExpression expression) {
                if (expression.getOperationSign() == OCTokenTypes.PLUSPLUS || expression.getOperationSign() == OCTokenTypes.MINUSMINUS) {
                    result.set((Object)true);
                } else {
                    super.visitPrefixExpression(expression);
                }
            }

            @Override
            public void visitPostfixExpression(OCPostfixExpression expression) {
                if (expression.getOperationSign() == OCTokenTypes.PLUSPLUS || expression.getOperationSign() == OCTokenTypes.MINUSMINUS) {
                    result.set((Object)true);
                } else {
                    super.visitPostfixExpression(expression);
                }
            }

            @Override
            public void visitAssignmentExpression(OCAssignmentExpression expression) {
                result.set((Object)true);
            }

            @Override
            public void visitCallExpression(OCCallExpression expression) {
                result.set((Object)true);
            }

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                result.set((Object)true);
            }

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                result.set((Object)true);
            }

            @Override
            public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
                result.set((Object)true);
            }

            @Override
            public void visitStatementExpression(OCStatementExpression statementExpression) {
                result.set((Object)true);
            }

            @Override
            public void visitCppNewExpression(OCCppNewExpression expression) {
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public static <E extends PsiElement> void collectElements(PsiFile file, Editor editor, int offset, Class<E> elementClass, List<? super E> elements) {
        Document document2 = editor.getDocument();
        CharSequence text = document2.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document2.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text.charAt(correctedOffset))) {
            if (text.charAt(correctedOffset) == ';') {
                --correctedOffset;
            }
            if (text.charAt(correctedOffset) != ')') {
                correctedOffset = offset;
            }
        }
        PsiElement elementAtCaret = file.findElementAt(correctedOffset);
        PsiElement context = OCCodeInsightUtil.getElementOrMacroCall(elementAtCaret, elementClass);
        while (context != null) {
            PsiElement element;
            if (!elementClass.isInstance(context)) {
                if (!(context instanceof OCMacroCall)) break;
                if (elementClass.equals(OCExpression.class) && (element = ((OCMacroCall)context).getExpansionExpression()) != null) {
                    elements.add(element);
                }
                context = OCCodeInsightUtil.getElementOrMacroCall(context, elementClass);
                continue;
            }
            element = context;
            if (!(elements.contains(element) || element instanceof OCParenthesizedExpression || element instanceof OCAssignmentExpression || element instanceof OCExpression && ((OCExpression)element).getResolvedType().isVoid() || element instanceof OCReferenceExpression && ((OCReferenceExpression)element).getResolvedType() instanceof OCObjectType)) {
                elements.add(element);
            }
            context = OCCodeInsightUtil.getElementOrMacroCall(context, elementClass);
        }
    }

    @Nullable
    private static <E extends PsiElement> PsiElement getElementOrMacroCall(PsiElement context, Class<E> elementClass) {
        return PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{elementClass, OCMacroCall.class});
    }

    public static boolean isUniqueInScope(@Nullable OCSymbolKind symbolKind, String name2, @Nullable PsiElement scope, @NotNull Project project2) {
        return OCCodeInsightUtil.resolveNameInScope(symbolKind, name2, null, scope, project2) == null;
    }

    public static OCSymbol resolveNameInScope(@Nullable OCSymbolKind symbolKind, String name2, @Nullable String categoryName, @Nullable PsiElement scope, @NotNull Project project2) {
        return OCCodeInsightUtil.resolveNameInScope(symbolKind, name2, categoryName, scope, true, project2);
    }

    public static OCSymbol resolveNameInScope(final @Nullable OCSymbolKind symbolKind, final String name2, final @Nullable String categoryName, @Nullable PsiElement scope, boolean checkBelow, @NotNull Project project2) {
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                if (symbol.isSynthetic()) {
                    return false;
                }
                if (categoryName != null && symbol instanceof OCClassSymbol && !categoryName.equals(((OCClassSymbol)symbol).getCategoryName())) {
                    return false;
                }
                return symbolKind == null || OCResolveUtil.isDuplicate(symbolKind, symbol.getKind());
            }
        };
        if (scope == null) {
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<? super OCSymbol>)processor2, name2);
        } else {
            OCResolveUtil.processSymbols(name2, scope, (Processor<OCSymbol>)processor2, checkBelow);
        }
        if (processor2.isFound()) {
            return (OCSymbol)processor2.getFoundValue();
        }
        OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)scope, OCBlockStatement.class, (boolean)false, (Class[])new Class[]{OCBlockExpression.class, OCLambdaExpression.class});
        if (block == null) {
            return null;
        }
        try {
            block.accept(new OCVisitor(){

                @Override
                public void visitOCElement(OCElement elem) {
                    elem.acceptChildren(this);
                }

                @Override
                public void visitDeclarator(OCDeclarator declarator) {
                    if (name2.equals(declarator.getName())) {
                        throw new CancelException(declarator);
                    }
                }
            });
        }
        catch (CancelException e) {
            return e.getDeclarator().getSymbol();
        }
        return null;
    }

    @Nullable
    public static Editor openInEditor(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Project project2 = element.getProject();
        int offset = element instanceof PsiFile ? -1 : element.getTextOffset();
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, virtualFile, offset);
        return FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor2, true);
    }

    public static boolean showCallableInEditorAndSelectBody(@NotNull PsiFile file, @NotNull Segment segment, @NotNull Condition<OCBlockStatement> condition) {
        class MyVisitor
        extends OCRecursiveVisitor {
            public boolean found;
            private final TextRange myRange;
            final /* synthetic */ Condition val$condition;

            MyVisitor(TextRange textRange) {
                this.val$condition = textRange;
                super(range);
                this.found = false;
                this.myRange = range;
            }

            @Override
            public void visitElement(PsiElement element) {
                if (!this.found) {
                    OCBlockStatement body;
                    if (!this.myRange.intersectsStrict(element.getTextRange())) {
                        return;
                    }
                    OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCCallable.class});
                    if (callable != null && (body = callable.getBody()) != null && this.val$condition.value((Object)body)) {
                        this.found = true;
                        Editor editor = OCCodeInsightUtil.openInEditor(body);
                        if (editor != null) {
                            OCCodeInsightUtil.selectBody(editor, body);
                        }
                    }
                }
                super.visitElement(element);
            }
        }
        MyVisitor visitor = new MyVisitor(TextRange.create((Segment)segment), condition);
        file.accept((PsiElementVisitor)visitor);
        return visitor.found;
    }

    public static void selectBody(Editor editor, OCBlockStatement body) {
        if (body == null) {
            return;
        }
        ASTNode firstNode = body.getNode().getFirstChildNode().getTreeNext();
        ASTNode lastNode = body.getNode().getLastChildNode().getTreePrev();
        while (OCTokenTypes.WHITESPACES.contains(firstNode.getElementType())) {
            firstNode = firstNode.getTreeNext();
        }
        while (OCTokenTypes.WHITESPACES.contains(lastNode.getElementType())) {
            lastNode = lastNode.getTreePrev();
        }
        if (firstNode != body.getNode().getLastChildNode()) {
            OCCodeInsightUtil.selectRange(editor, firstNode.getStartOffset(), lastNode.getTextRange().getEndOffset());
        } else {
            OCCodeInsightUtil.selectRange(editor, body.getTextOffset() + 1, body.getTextOffset() + 1);
        }
    }

    public static void selectElement(PsiElement element) {
        if (element == null) {
            return;
        }
        Editor editor = EditorHelper.openInEditor((PsiElement)element);
        if (editor != null) {
            OCCodeInsightUtil.selectRange(editor, element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
        }
    }

    public static void selectRange(Editor editor, int startOffset, int endOffset) {
        editor.getCaretModel().moveToOffset(startOffset);
        editor.getSelectionModel().setSelection(startOffset, endOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public static String getClassNameWithCategory(String className, String categoryName) {
        if (categoryName == null) {
            return className;
        }
        StringBuilder builder = new StringBuilder(className.length() + categoryName.length() + 3);
        builder.append(className).append(" + ").append(categoryName.isEmpty() ? "()" : categoryName);
        return builder.toString();
    }

    @Nullable
    public static OCClassDeclaration getPrivateCategory(OCClassDeclarationBase declaration) {
        for (PsiElement child : declaration.getContainingFile().getChildren()) {
            if (!(child instanceof OCClassDeclaration)) continue;
            OCClassDeclaration category = (OCClassDeclaration)child;
            if (!declaration.getName().equals(category.getName()) || !"".equals(category.getCategory())) continue;
            return category;
        }
        return null;
    }

    @NotNull
    public static Pair<MemberBeginEndSearchResult, OCType> getReturnTypeOfBeginEndPair(OCExpression expr, @NotNull OCStructType structType, @NotNull OCFile file) {
        OCResolveContext context = OCResolveContext.forPsi(file);
        CVQualifiers cvQualifiers = OCCodeInsightUtil.getCVQualifiers(expr, structType);
        OCType leftType = structType.cloneWithAddedCVQualifiers(cvQualifiers, file.getProject());
        Collection<OCSymbol> beginSymbols = structType.collectMethods("begin", context);
        OCSymbol beginSymbol = OCResolveOverloadsUtil.resolveOverloads(beginSymbols, new OCArgumentsList(Collections.emptyList(), null), leftType, null, null, true, true, context, expr);
        Collection<OCSymbol> endSymbols = structType.collectMethods("end", context);
        OCSymbol endSymbol = OCResolveOverloadsUtil.resolveOverloads(endSymbols, new OCArgumentsList(Collections.emptyList(), null), leftType, null, null, true, true, context, expr);
        if (beginSymbol == null && endSymbol == null) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
        }
        if (beginSymbol == null || endSymbol == null) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.INVALID), null);
        }
        assert (beginSymbol instanceof OCFunctionSymbol);
        OCType beginReturnType = beginSymbol.getEffectiveType(context.getProject()).resolve(context);
        assert (endSymbol instanceof OCFunctionSymbol);
        OCType endReturnType = beginSymbol.getEffectiveType(context.getProject()).resolve(context);
        if (endReturnType.equals(beginReturnType, context)) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.OK), (Object)beginReturnType);
        }
        return Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
    }

    public static boolean isCodeInsightAvailable(@NotNull VirtualFile file, @NotNull Project project2) {
        long textLength = file.getLength();
        if (textLength < 0L) {
            return false;
        }
        if (textLength <= (long)OCCodeInsightUtil.getMaxFileLength()) {
            return true;
        }
        return OCCodeInsightUtil.isLibraryFile(project2, file);
    }

    public static boolean isCodeInsightAvailable(@NotNull PsiFile file) {
        long textLength;
        VirtualFile virtualFile = file.getVirtualFile();
        long l = textLength = virtualFile != null ? virtualFile.getLength() : (long)file.getTextLength();
        if (textLength < 0L) {
            return false;
        }
        if (textLength <= (long)OCCodeInsightUtil.getMaxFileLength()) {
            return true;
        }
        return virtualFile != null && OCCodeInsightUtil.isLibraryFile(file.getProject(), virtualFile);
    }

    protected static boolean isLibraryFile(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        return ProjectScope.getLibrariesScope((Project)project2).contains(virtualFile);
    }

    public static boolean isCodeInsightAvailable(int fileLength, boolean isLibraryFile) {
        return fileLength >= 0 && (isLibraryFile || fileLength <= OCCodeInsightUtil.getMaxFileLength());
    }

    public static boolean isPreProcessable(@NotNull VirtualFile file, @NotNull Project project2) {
        SymbolTableProvider provider2 = SymbolTableProvider.findProvider(file);
        return provider2 != null && provider2.shouldPreProcess() && OCCodeInsightUtil.isCodeInsightAvailable(file, project2);
    }

    public static int getMaxFileLength() {
        return OCCodeInsightUtil.getMaxFileLengthRegistryKey().asInteger();
    }

    public static void setMaxFileLength(int newValue) {
        if (newValue > 0) {
            OCCodeInsightUtil.getMaxFileLengthRegistryKey().setValue(newValue);
        }
    }

    public static void resetMaxFileLength() {
        OCCodeInsightUtil.getMaxFileLengthRegistryKey().resetToDefault();
    }

    @NotNull
    private static RegistryValue getMaxFileLengthRegistryKey() {
        return Registry.get((String)"cidr.max.intellisense.file.length");
    }

    public static Pair<List<PsiElement>, OCSymbolKind> getScopeAndKind(PsiElement element) {
        OCElement scopeElement;
        OCSymbolKind kind = null;
        List<Object> scope = null;
        if (element.getParent().getParent() instanceof OCTemplateParameterList) {
            kind = OCSymbolKind.TEMPLATE_VALUE_PARAMETER;
            scopeElement = null;
        } else {
            scopeElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCLocalScopeable.class, OCEnum.class, OCTemplateParameterList.class, OCLambdaIntroducer.class});
            if (scopeElement instanceof OCEnum && !((OCEnum)scopeElement).isEnumClass()) {
                kind = OCSymbolKind.ENUM_CONST;
                scopeElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCLocalScopeable.class});
            } else if (scopeElement instanceof OCStructLike) {
                kind = element instanceof OCFunctionDefinition ? (((OCFunctionDefinition)element).getBody() != null ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.FUNCTION_PREDECLARATION) : OCSymbolKind.STRUCT_FIELD;
            } else if (scopeElement instanceof OCTemplateParameterList) {
                kind = OCSymbolKind.TEMPLATE_TYPE_PARAMETER;
                scopeElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDeclaration.class});
                if (scopeElement != null) {
                    scope = new ArrayList();
                    scope.add(scopeElement);
                    scope.addAll(DoxygenFacade.getCommentScope(scopeElement));
                }
            } else if (scopeElement instanceof OCParameterList) {
                PsiElement parent = scopeElement.getContext();
                if (parent instanceof OCCatchSection) {
                    kind = OCSymbolKind.CATCH_EXCEPTION_VARIABLE;
                    scopeElement = ((OCCatchSection)parent).getBody();
                } else {
                    kind = OCSymbolKind.PARAMETER;
                    PsiElement callable = PsiTreeUtil.getContextOfType((PsiElement)scopeElement, (Class[])new Class[]{OCCallable.class, OCParameterList.class, OCMethodSelectorPart.class, OCDeclarator.class, OCTypeElement.class});
                    if (callable instanceof OCDeclarator && callable.getParent() instanceof OCCallable) {
                        callable = callable.getParent();
                    }
                    if (callable instanceof OCCallable) {
                        scope = new ArrayList();
                        if (callable instanceof OCFunctionDefinition && (PsiTreeUtil.getChildOfType((PsiElement)((OCFunctionDefinition)callable).getDeclarator(), OCConstructorInitializationList.class) != null || PsiTreeUtil.getChildOfType((PsiElement)callable, OCCatchSection.class) != null)) {
                            scope.add(callable);
                        } else {
                            OCBlockStatement body = ((OCCallable)callable).getBody();
                            OCNoexceptSpecifier noexceptSpecifier = ((OCCallable)callable).getNoexceptSpecifier();
                            OCTypeElement typeElement = callable instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)callable).getTrailingReturnTypeElement() : ((OCCallable)callable).getReturnTypeElement();
                            scope.add(body != null ? body : scopeElement);
                            if (noexceptSpecifier != null) {
                                scope.add(noexceptSpecifier);
                            }
                            if (typeElement != null) {
                                scope.add(typeElement);
                            }
                        }
                        List<PsiComment> comments = DoxygenFacade.getCommentScope(callable);
                        scope.addAll(comments);
                    }
                }
            } else if (scopeElement instanceof OCMethod) {
                scope = new ArrayList();
                kind = OCSymbolKind.PARAMETER;
                OCBlockStatement blockStatement = ((OCMethod)scopeElement).getBody();
                if (blockStatement != null) {
                    scope.add(blockStatement);
                }
                List<PsiComment> comments = DoxygenFacade.getCommentScope(scopeElement);
                scope.addAll(comments);
            } else if (scopeElement instanceof OCLambdaIntroducer) {
                scopeElement = ((OCLambdaExpression)scopeElement.getParent()).getBody();
            }
        }
        if (scope == null) {
            List<Object> list = scope = scopeElement != null ? Collections.singletonList(scopeElement) : Collections.emptyList();
        }
        if (kind == null && element instanceof OCFunctionDefinition) {
            kind = ((OCFunctionDefinition)element).getBody() != null ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.FUNCTION_PREDECLARATION;
        }
        return Pair.create(scope, (Object)((Object)kind));
    }

    public static boolean isNonStaticFieldAccess(@NotNull OCDeclaratorSymbol symbol, @NotNull OCStructSymbol parent, @NotNull OCExpression expression) {
        return !symbol.isFriendOrStatic() && !symbol.isMutable() && OCCodeInsightUtil.isMemberAccess(symbol, parent, expression);
    }

    public static boolean isMemberAccess(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCStructSymbol parent, @NotNull OCExpression expression) {
        if (!(symbol instanceof OCFunctionSymbol) && symbol.getKind() != OCSymbolKind.STRUCT_FIELD) {
            return false;
        }
        OCResolveContext context = OCResolveContext.forPsi(expression);
        OCSymbolWithQualifiedName memberParent = symbol.getResolvedOwner(context);
        if (!(memberParent instanceof OCStructSymbol) || !((OCStructSymbol)memberParent).isAncestor(parent, context)) {
            return false;
        }
        return expression instanceof OCReferenceExpression || expression instanceof OCQualifiedExpression && ((OCQualifiedExpression)expression).getQualifier() instanceof OCReferenceExpression && ((OCReferenceExpression)((OCQualifiedExpression)expression).getQualifier()).isCppThis();
    }

    @Nullable
    public static CVQualifiers getOuterFunctionCVQualifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull OCExpression expression, @Nullable Ref<OCFunctionSymbol> functionSymbolRef) {
        OCSymbolWithQualifiedName parent;
        OCFunctionSymbol functionSymbol;
        OCFunctionDefinition function = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)expression, OCFunctionDefinition.class);
        OCFunctionSymbol oCFunctionSymbol = functionSymbol = function != null ? function.getSymbol() : null;
        if (functionSymbolRef != null) {
            functionSymbolRef.set((Object)functionSymbol);
        }
        if (functionSymbol != null && (parent = functionSymbol.getResolvedOwner(OCResolveContext.forPsi(expression))) instanceof OCStructSymbol && OCCodeInsightUtil.isNonStaticFieldAccess(symbol, (OCStructSymbol)parent, expression)) {
            return functionSymbol.getType().getCVQualifiers();
        }
        return null;
    }

    @NotNull
    public static CVQualifiers getCVQualifiers(OCExpression expression, OCType type) {
        boolean considerOuterFunction = type instanceof OCStructType;
        CVQualifiers modifiers = type.getTerminalType().getCVQualifiers();
        if (considerOuterFunction && expression instanceof OCReferenceExpression) {
            CVQualifiers functionCVQualifiers;
            OCSymbol symbol = ((OCReferenceExpression)expression).resolveToSymbol();
            CVQualifiers cVQualifiers = functionCVQualifiers = symbol instanceof OCDeclaratorSymbol ? OCCodeInsightUtil.getOuterFunctionCVQualifiers((OCDeclaratorSymbol)symbol, expression, null) : null;
            if (functionCVQualifiers != null) {
                modifiers = modifiers.or(functionCVQualifiers);
            }
        }
        return modifiers;
    }

    @NotNull
    public static String getPrettyNameFromClassName(@NotNull Class clazz) {
        String className = clazz.getSimpleName();
        if (clazz.isAnonymousClass()) {
            className = clazz.getSuperclass().getSimpleName();
        }
        return OCCodeInsightUtil.getPrettyNameFromClassName(className);
    }

    @NotNull
    public static String getPrettyNameFromClassName(@NotNull String className) {
        StringBuilder result = new StringBuilder();
        className = StringUtil.trimStart((String)className, (String)"OC");
        className = StringUtil.trimEnd((String)className, (String)"Inspection");
        className = StringUtil.trimEnd((String)className, (String)"IntentionAction");
        for (String word : StringUtil.findMatches((String)className, (Pattern)Pattern.compile("([A-Z][a-z]*)"))) {
            if (result.length() > 0) {
                result.append(' ').append(StringUtil.decapitalize((String)word));
                continue;
            }
            result.append(word);
        }
        return result.toString();
    }

    public static boolean isLikeNull(@Nullable String literal) {
        return literal != null && ("nil".equals(literal) || "NULL".equals(literal) || "nullptr".equals(literal));
    }

    public static boolean isStdInitializerListType(OCType type, @NotNull OCResolveContext context) {
        if (OCCompilerFeatures.supportsInitializerLists(context.getFile()) && type instanceof OCStructType) {
            OCStructSymbol symbol = ((OCStructType)type).getSymbol();
            OCQualifiedName name2 = symbol.getResolvedQualifiedNameWithoutArguments(context);
            return name2 != null && name2.getFullName(context).equals("::std::initializer_list");
        }
        return false;
    }

    @Nullable
    public static OCType getStdInitializerListTemplateParameter(OCType type, @NotNull OCResolveContext context) {
        OCStructSymbol paramTypeSymbol;
        if (OCCodeInsightUtil.isStdInitializerListType(type, context) && (paramTypeSymbol = ((OCStructType)type).getSymbol()).getTemplateParameters().size() == 1) {
            OCTypeParameterSymbol parameterSymbol = paramTypeSymbol.getTemplateParameters().get(0);
            OCTypeArgument paramSubstitution = paramTypeSymbol.getSubstitution().getSubstitutionFor(parameterSymbol);
            if (paramSubstitution instanceof OCType) {
                return (OCType)paramSubstitution;
            }
        }
        return null;
    }

    public static boolean isSimpleDeclaration(String declarationText, String name2) {
        return "<unnamed>".equals(name2) || declarationText.endsWith(name2);
    }

    @Nullable
    public static OCType getCollectionElementType(@NotNull OCExpression expr, OCType type) {
        OCFile file = expr.getContainingOCFile();
        OCResolveContext context = OCResolveContext.forPsi(expr);
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        OCType iteratorType = null;
        if (type instanceof OCArrayType) {
            iteratorType = type;
        } else {
            if (type instanceof OCBracedInitListType && expr instanceof OCCompoundInitializer) {
                List<OCExpression> initializers = ((OCCompoundInitializer)expr).getInitializerExpressions();
                if (initializers.isEmpty()) {
                    return null;
                }
                return initializers.get(0).getResolvedType(context).cloneWithConstModifier(context.getProject());
            }
            Pair<MemberBeginEndSearchResult, OCType> result = type instanceof OCStructType ? OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type, file) : Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
            switch ((MemberBeginEndSearchResult)((Object)result.getFirst())) {
                case NONE: {
                    OCSymbol begin = OCCodeInsightUtil.getGlobalBeginOrEnd("begin", type, expr, file, context);
                    OCSymbol end = OCCodeInsightUtil.getGlobalBeginOrEnd("end", type, expr, file, context);
                    if (begin != null && end != null) {
                        OCType endReturnType;
                        assert (begin instanceof OCFunctionSymbol);
                        assert (end instanceof OCFunctionSymbol);
                        OCType beginReturnType = begin.getEffectiveType(context.getProject()).resolve(context);
                        if (beginReturnType.equals(endReturnType = end.getEffectiveType(context.getProject()).resolve(context), context)) {
                            iteratorType = beginReturnType;
                        }
                    }
                }
                case INVALID: {
                    break;
                }
                case OK: {
                    iteratorType = (OCType)result.getSecond();
                }
            }
        }
        return OCCodeInsightUtil.getDereferencedType(expr, iteratorType);
    }

    @Nullable
    private static OCSymbol getGlobalBeginOrEnd(@NotNull String methodName, @NotNull OCType type, @NotNull OCExpression expr, @NotNull OCFile file, @NotNull OCResolveContext context) {
        OCQualifiedName beginName = OCQualifiedName.interned(methodName);
        List<OCSymbol> symbols = new ArrayList<OCSymbol>(OCSymbolReference.getDummyGlobalReference(beginName).resolveToSymbols(OCResolveContext.forPsi(file)));
        symbols = ContainerUtil.filter(symbols, symbol -> symbol instanceof OCFunctionSymbol);
        List<OCType> argTypes = Collections.singletonList(type);
        Collection<OCSymbol> symbolsWithADL = OCArgumentDepLookupAccumulator.doArgDepLookup(symbols, argTypes, Collections.singletonList(expr), beginName, context);
        OCArgumentsList<OCValueCategoryHolder> arguments = new OCArgumentsList<OCValueCategoryHolder>(argTypes, Collections.singletonList(new OCValueCategoryHolder(type, OCExprValueCategory.LValue)));
        return OCResolveOverloadsUtil.resolveOverloads(symbolsWithADL, arguments, null, null, null, true, true, context, expr);
    }

    @Nullable
    public static OCType getDereferencedType(@NotNull OCExpression expr, @Nullable OCType iteratorType) {
        if (iteratorType instanceof OCPointerType) {
            return ((OCPointerType)iteratorType).getRefType();
        }
        if (iteratorType instanceof OCStructType) {
            OCFunctionSymbol operator = OCOperatorReference.resolveOperator("*", OCOperatorReference.OperatorPlacement.PREFIX, expr, (OCStructType)iteratorType);
            return operator != null ? operator.getEffectiveType(expr).resolve(expr) : null;
        }
        if (iteratorType instanceof OCMagicType) {
            return new OCMagicType();
        }
        return null;
    }

    public static boolean isUnnamed(OCDeclaratorSymbol field) {
        OCType fieldType = field.getType();
        return fieldType instanceof OCStructType && ((OCStructType)fieldType).isUnnamed();
    }

    @Nullable
    public static OCElementType getOppositeOperator(@NotNull OCElementType operator) {
        return oppositeOperators.get((Object)operator);
    }

    @Nullable
    public static OCElementType getFlippedOperator(@NotNull OCElementType operator) {
        return flippedOperators.get((Object)operator);
    }

    @Nullable
    public static OCElementType getInversedLogicalOperator(@NotNull OCElementType operator) {
        return inversedLogicalOperators.get((Object)operator);
    }

    public static boolean insideLoopHeader(@NotNull PsiElement element) {
        OCLoopStatement parent = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCLoopStatement.class);
        if (parent instanceof OCForeachStatement) {
            OCForeachStatement foreachStatement = (OCForeachStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)foreachStatement.getVariableDeclaration(), (PsiElement)element, (boolean)false);
        }
        if (parent instanceof OCForStatement) {
            OCForStatement forStatement = (OCForStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)forStatement.getInitializer(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)forStatement.getCondition(), (PsiElement)element, (boolean)false);
        }
        if (parent != null) {
            return PsiTreeUtil.isAncestor((PsiElement)parent.getCondition(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static boolean insideConditionalHeader(@NotNull PsiElement element) {
        OCStatement parent = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCSwitchStatement.class});
        if (parent instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)element, (boolean)false);
        }
        if (parent instanceof OCSwitchStatement) {
            OCSwitchStatement switchStatement = (OCSwitchStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)switchStatement.getExpression(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static Set<PsiNamedElement> collectDeclarators(@NotNull PsiElement element) {
        final HashSet<PsiNamedElement> declarators = new HashSet<PsiNamedElement>();
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitDeclarator(OCDeclarator declarator) {
                super.visitDeclarator(declarator);
                if (declarator.getSymbol() != null && !declarator.getSymbol().isUnnamed()) {
                    declarators.add(declarator);
                }
            }

            @Override
            public void visitMethodSelectorPart(OCMethodSelectorPart part) {
                if (part.getSymbol() != null && !((OCDeclaratorSymbol)part.getSymbol()).isUnnamed()) {
                    declarators.add(part);
                }
            }
        });
        return declarators;
    }

    public static List<PsiElement> getReferences(@NotNull PsiNamedElement declarator) {
        return ContainerUtil.mapNotNull((Collection)ReferencesSearch.search((PsiElement)declarator, (SearchScope)declarator.getUseScope()).findAll(), PsiReference::getElement);
    }

    public static void renameDeclaratorAndUsages(@NotNull PsiNamedElement declarator, @NotNull String newDeclaratorName, @NotNull List<PsiElement> usages) {
        if (newDeclaratorName.equals(declarator.getName())) {
            return;
        }
        for (PsiElement usage : usages) {
            if (!(usage instanceof OCReferenceElement) || OCElementUtil.isPartOfMacroSubstitution(usage)) continue;
            ((OCReferenceElement)usage).setNameOfIdentifier(newDeclaratorName);
        }
        declarator.setName(newDeclaratorName);
    }

    public static boolean isOverloadedOperatorUsage(@NotNull OCExpression expression) {
        PsiReference reference = expression.getReference();
        return reference instanceof OCOperatorReference && !((OCOperatorReference)reference).resolveToSymbolsViaClang().isEmpty();
    }

    public static boolean isStaticallyEvaluated(@NotNull PsiElement element) {
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof OCSizeofExpression || parent instanceof OCCppTypeidExpression || parent instanceof OCGenericSelectionExpression) {
                return true;
            }
            if (parent instanceof OCCppNamespaceQualifier && OCCodeInsightUtil.hasAnyChildOfType(parent, OCTokenTypes.DECLTYPE_CPP_KEYWORD)) {
                return true;
            }
            if (!(parent instanceof OCTypeElement) || !OCCodeInsightUtil.hasAnyChildOfType(parent, OCTokenTypes.TYPEOF_KEYWORD, OCTokenTypes.DECLTYPE_CPP_KEYWORD)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyChildOfType(PsiElement parent, IElementType ... types) {
        return Arrays.stream(parent.getNode().getChildren(null)).map(OCElementUtil::getElementType).anyMatch(elementType -> {
            for (IElementType type : types) {
                if (type != elementType) continue;
                return true;
            }
            return false;
        });
    }

    static class CancelException
    extends RuntimeException {
        private final OCDeclarator myDeclarator;

        CancelException(OCDeclarator declarator) {
            this.myDeclarator = declarator;
        }

        public OCDeclarator getDeclarator() {
            return this.myDeclarator;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static enum MemberBeginEndSearchResult {
        NONE,
        INVALID,
        OK;

    }
}

