/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUndefDirective;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCDeclarationKind {
    Import(PlatformUtils.isAppCode() ? "Imports" : "Includes", OCIncludeDirective.class),
    Macro(OCDefineDirective.class, OCUndefDirective.class),
    Typedef(new Class[]{OCDeclaration.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCDeclaration && ((OCDeclaration)element).isTypedef();
        }
    }
    ,
    Enum("Enumerations", new Class[]{OCEnum.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            OCTypeElement typeElement;
            if (element instanceof OCDeclaration && this.isKindOf((typeElement = ((OCDeclaration)element).getTypeElement()) != null ? typeElement.getFirstChild() : null)) {
                return true;
            }
            return super.isKindOf(element);
        }
    }
    ,
    Constant(new Class[]{OCDeclaration.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            if (!(element instanceof OCDeclaration)) {
                return false;
            }
            List<OCDeclarator> declarators = ((OCDeclaration)element).getDeclarators();
            OCSymbol symbol = declarators.isEmpty() ? null : declarators.get(0).getSymbol();
            return symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isConst();
        }
    }
    ,
    Global("Global variables", new Class[]{OCDeclaration.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCDeclaration && !Typedef.isKindOf(element) && !Constant.isKindOf(element) && !Function.isKindOf(element) && !FunctionPredecl.isKindOf(element);
        }
    }
    ,
    Struct("Structs, unions and C++ classes", new Class[]{OCStruct.class, OCUnion.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            OCTypeElement typeElement;
            if (element instanceof OCDeclaration && this.isKindOf((typeElement = ((OCDeclaration)element).getTypeElement()) != null ? typeElement.getFirstChild() : null)) {
                return true;
            }
            return super.isKindOf(element);
        }
    }
    ,
    ClassPredef("Objective-C class predeclarations", true, OCClassPredeclarationList.class),
    FunctionPredecl("Function predeclarations", new Class[]{OCFunctionDeclaration.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCFunctionDeclaration && !Function.isKindOf(element);
        }
    }
    ,
    Function(OCFunctionDefinition.class),
    Class("Objective-C classes and protocols", true, OCClassDeclaration.class),
    Property(OCProperty.class),
    Synthesize(OCSynthesizePropertiesList.class),
    InitMethod("Init methods", new Class[]{OCMethod.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCMethod && OCElementUtil.startsWithWord(((OCMethod)element).getSelector(), "init");
        }
    }
    ,
    StaticMethod("Class methods", new Class[]{OCMethod.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCMethod && !((OCMethod)element).isInstanceMethod();
        }
    }
    ,
    InstanceMethod("Instance methods", new Class[]{OCMethod.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCMethod && ((OCMethod)element).isInstanceMethod();
        }
    }
    ,
    DeallocMethod("Dealloc method", new Class[]{OCMethod.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCMethod && ((OCMethod)element).getSelector().equals("dealloc");
        }
    };

    private final String myName;
    private final boolean myObjectiveC;
    private final Class<? extends OCElement>[] myClasses;
    public static final List<OCDeclarationKind> ourFileDeclarationKinds;
    public static final List<OCDeclarationKind> ourClassDeclarationKinds;
    public static final List<OCDeclarationKind> ourMethodKinds;

    @SafeVarargs
    private OCDeclarationKind(Class<? extends OCElement> ... classes) {
        this.myName = StringUtil.pluralize((String)this.name());
        this.myObjectiveC = false;
        this.myClasses = classes;
    }

    @SafeVarargs
    private OCDeclarationKind(String name2, Class<? extends OCElement> ... classes) {
        this(name2, false, classes);
    }

    @SafeVarargs
    private OCDeclarationKind(String name2, boolean isObjectiveC, Class<? extends OCElement> ... classes) {
        this.myName = name2;
        this.myObjectiveC = isObjectiveC;
        this.myClasses = classes;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isAvailable() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        return OCLanguage.enableObjectiveCSettings() || !this.myObjectiveC;
    }

    public boolean isKindOf(PsiElement element) {
        for (Class<? extends OCElement> aClass : this.myClasses) {
            if (!aClass.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    private static List<OCDeclarationKind> getKindsOrder(@NotNull PsiElement parent) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)parent.getContainingFile(), OCCodeStyleSettings.class);
        return parent instanceof OCFile ? settings.FILE_DECLARATIONS_ORDER : settings.CLASS_DECLARATIONS_ORDER;
    }

    @Nullable
    public static OCDeclarationKind getDeclarationKind(PsiElement element) {
        for (OCDeclarationKind kind : OCDeclarationKind.values()) {
            if (!kind.isKindOf(element)) continue;
            return kind;
        }
        return null;
    }

    private static int getDefaultEndOffset(PsiElement parent) {
        if (parent instanceof OCClassDeclaration) {
            PsiElement nonEmptyElement;
            OCInstanceVariablesList child = ((OCClassDeclaration)parent).getInstanceVariablesList();
            if (child.getTextLength() == 0 && (nonEmptyElement = OCElementUtil.getPreviousNonEmptyElement(child)) != null) {
                child = nonEmptyElement;
            }
            return child.getTextOffset() + child.getTextLength();
        }
        return -1;
    }

    public int getChildrenStartOffset(@NotNull PsiElement parent) {
        return this.getChildrenStartOffset(parent, false);
    }

    public int getChildrenStartOffset(@NotNull PsiElement parent, boolean includeAdjacentWhitespaces) {
        List<OCDeclarationKind> kinds;
        int index;
        PsiElement[] children = parent.getChildren();
        if (!includeAdjacentWhitespaces) {
            for (PsiElement aChildren : children) {
                if (!this.isKindOf(aChildren)) continue;
                TextRange range = aChildren.getTextRange();
                return range.getStartOffset();
            }
        }
        if ((index = (kinds = OCDeclarationKind.getKindsOrder(parent)).indexOf((Object)this)) <= 0) {
            return OCDeclarationKind.getDefaultEndOffset(parent);
        }
        return kinds.get(index - 1).getChildrenEndOffset(parent);
    }

    public int getChildrenEndOffset(PsiElement parent) {
        int offset;
        int j;
        OCDeclarationKind kind;
        int i;
        List<OCDeclarationKind> kinds = OCDeclarationKind.getKindsOrder(parent);
        int index = kinds.indexOf((Object)this);
        PsiElement[] children = parent.getChildren();
        if (index == -1) {
            return OCDeclarationKind.getDefaultEndOffset(parent);
        }
        int result = -1;
        for (i = index; i >= 0; --i) {
            kind = kinds.get(i);
            for (j = children.length - 1; j >= 0; --j) {
                if (!kind.isKindOf(children[j])) continue;
                offset = children[j].getTextRange().getEndOffset() + (children[j] instanceof OCIncludeDirective ? 1 : 0);
                result = result == -1 || result < offset ? offset : result;
            }
            if (result == -1) continue;
            return result;
        }
        for (i = index + 1; i < kinds.size(); ++i) {
            kind = kinds.get(i);
            for (j = 0; j < children.length; ++j) {
                if (!kind.isKindOf(children[j])) continue;
                offset = j > 0 ? children[j - 1].getTextRange().getEndOffset() : children[j].getTextRange().getStartOffset();
                result = result == -1 || result > offset ? offset : result;
            }
        }
        return result != -1 ? result : OCDeclarationKind.getDefaultEndOffset(parent);
    }

    static {
        ArrayList<OCDeclarationKind> tmpFileDeclarationKinds = new ArrayList<OCDeclarationKind>();
        ArrayList<OCDeclarationKind> tmpClassDeclarationKinds = new ArrayList<OCDeclarationKind>();
        ArrayList<OCDeclarationKind> tmpMethodKinds = new ArrayList<OCDeclarationKind>();
        for (OCDeclarationKind kind : OCDeclarationKind.values()) {
            if (!kind.isAvailable()) continue;
            if (kind.ordinal() < Property.ordinal()) {
                tmpFileDeclarationKinds.add(kind);
                continue;
            }
            tmpClassDeclarationKinds.add(kind);
        }
        tmpMethodKinds.add(InitMethod);
        tmpMethodKinds.add(StaticMethod);
        tmpMethodKinds.add(InstanceMethod);
        tmpMethodKinds.add(DeallocMethod);
        ourFileDeclarationKinds = Collections.unmodifiableList(tmpFileDeclarationKinds);
        ourClassDeclarationKinds = Collections.unmodifiableList(tmpClassDeclarationKinds);
        ourMethodKinds = Collections.unmodifiableList(tmpMethodKinds);
    }
}

