/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDocUtil {
    private static EnumSet<OCSymbolAttribute> POST_FUNC_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.FINAL, OCSymbolAttribute.OVERRIDE, OCSymbolAttribute.DELETE, OCSymbolAttribute.DEFAULT);
    private static EnumSet<OCSymbolAttribute> SKIP_DECL_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.CONSTEXPR);
    private static final Function<OCSymbolWithQualifiedName, String> TO_NAME = symbol -> StringUtil.escapeXmlEntities((String)symbol.getPresentableName());

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param) {
        return OCDocUtil.parameterSignature(type, param, null);
    }

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param, @Nullable String defValue) {
        StringBuilder sb = new StringBuilder();
        boolean hasName = param != null && !"<unnamed>".equals(param);
        sb.append(type);
        if (hasName) {
            sb.append(OCDocUtil.delimiter(type));
        }
        sb.append(hasName ? param : "");
        if (defValue != null) {
            sb.append(" = ").append(defValue);
        }
        return sb.toString();
    }

    public static String delimiter(String type) {
        return OCDocUtil.delimiter(type, " ");
    }

    public static String delimiter(String type, String del) {
        if (!(type.endsWith("*") || type.endsWith("&") || type.endsWith("&amp;"))) {
            return del;
        }
        return "";
    }

    public static void extractModifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr) || SKIP_DECL_ATTRIBUTES.contains((Object)attr)) continue;
            sb.append((Object)attr).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCFunctionSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (POST_FUNC_ATTRIBUTES.contains((Object)attr) || !symbol.hasAttribute(attr)) continue;
            sb.append((Object)attr).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCStructSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr)) continue;
            sb.append((Object)attr).append(" ");
        }
        if (symbol.isTemplateSymbol()) {
            sb.append(OCTokenTypes.TEMPLATE_CPP_KEYWORD.getName()).append(" ");
        }
    }

    public static void extractFuncPostModifiers(@NotNull OCFunctionSymbol symbol, @NotNull StringBuilder sb) {
        if (symbol.isConst()) {
            sb.append(" ").append(OCTokenTypes.CONST_KEYWORD.getName());
        }
        for (OCSymbolAttribute attr : POST_FUNC_ATTRIBUTES) {
            if (!symbol.hasAttribute(attr)) continue;
            if (attr == OCSymbolAttribute.DELETE || attr == OCSymbolAttribute.DEFAULT) {
                sb.append(" =");
            }
            sb.append(" ").append((Object)attr);
        }
    }

    @NotNull
    public static String getParametersSignature(OCFunctionSymbol symbol, boolean useSubstitution, Project project2) {
        StringBuilder answer = new StringBuilder("(");
        List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCResolveContext.forSymbol(symbol, project2));
        OCFile containingFile = symbol.getContainingOCFile(project2);
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : symbol.getParameterSymbols()) {
            String typeText;
            if (!isFirst) {
                answer.append(", ");
            }
            if (useSubstitution) {
                OCType type = param.getType().accept(new OCTypeParameterResolveVisitor(param.getContainingOCFile(project2)));
                typeText = OCDocUtil.getCanonicalName(type, contextNamespace, containingFile, project2);
            } else {
                typeText = param.getType().getCanonicalName(OCResolveContext.forSymbol(symbol, project2));
            }
            answer.append(OCDocUtil.parameterSignature(typeText, param.getName()));
            if (param.hasInitializer()) {
                answer.append(" = ").append(param.getInitializer().getSignature(project2));
            }
            isFirst = false;
        }
        return answer.append(')').toString();
    }

    @NotNull
    public static String getCanonicalName(@NotNull OCType type, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile, @NotNull Project project2) {
        OCResolveContext context = OCResolveContext.forNullablePsi(containingFile, project2);
        OCType terminalType = type.getTerminalType();
        OCType resolvedType = terminalType.resolve(context);
        if (resolvedType instanceof OCStructType) {
            CVQualifiers qualifiers;
            OCStructSymbol struct = ((OCStructType)resolvedType).getSymbol();
            List<OCSymbolWithQualifiedName> symbols = OCDocUtil.getQualifiedSymbolChain(context, struct, OCSymbolKind.NAMESPACE, OCSymbolKind.STRUCT, OCSymbolKind.ENUM, OCSymbolKind.UNION);
            if (!symbols.isEmpty()) {
                for (OCSymbolWithQualifiedName ns : contextNamespace) {
                    OCSymbolWithQualifiedName element = symbols.get(0);
                    if (!element.equals(ns)) continue;
                    symbols.remove(0);
                }
            }
            StringBuilder res = new StringBuilder();
            CVQualifiers cVQualifiers = qualifiers = type instanceof OCCppReferenceType || type instanceof OCPointerType ? type.getTerminalType().getCVQualifiers() : type.getCVQualifiers();
            if (qualifiers.isConst()) {
                res.append(OCTokenTypes.CONST_KEYWORD.getName()).append(" ");
            }
            if (qualifiers.isVolatile()) {
                res.append(OCTokenTypes.VOLATILE_KEYWORD.getName()).append(" ");
            }
            res.append(StringUtil.join(symbols, symbol -> OCDocUtil.wrapSymbolName(symbol), (String)"::"));
            List<OCTypeArgument> templateArguments = Collections.emptyList();
            if (terminalType instanceof OCReferenceType) {
                OCQualifiedName name2 = ((OCReferenceType)terminalType).getReference(containingFile).getQualifiedName();
                if (name2 instanceof OCQualifiedNameWithArguments) {
                    templateArguments = ((OCQualifiedNameWithArguments)name2).getArguments();
                }
            } else {
                templateArguments = struct.getTemplateArguments(context);
            }
            OCDocUtil.wrapTemplateArgs(templateArguments, contextNamespace, containingFile, res, project2);
            if (type instanceof OCCppReferenceType) {
                res.append(" &amp;");
            }
            if (type instanceof OCPointerType) {
                res.append(" *");
            }
            return res.toString();
        }
        return StringUtil.escapeXmlEntities((String)type.getCanonicalName(context));
    }

    @NotNull
    public static String getNamespace(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        return StringUtil.join(OCDocUtil.getParents(symbol, context), TO_NAME, (String)"::");
    }

    @NotNull
    public static String getCanonicalPrefix(@NotNull OCSymbolWithQualifiedName symbol, @NotNull Project project2) {
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(symbol, OCResolveContext.forSymbol(symbol, project2));
        List structParents = ContainerUtil.filter(chain, s -> s.getKind().isStructLike());
        List namespace = ContainerUtil.filter(chain, s -> s.getKind() == OCSymbolKind.NAMESPACE);
        if (!structParents.isEmpty()) {
            OCFile containingOCFile = symbol.getContainingOCFile(project2);
            OCSymbolWithQualifiedName parent = (OCSymbolWithQualifiedName)structParents.get(structParents.size() - 1);
            String prefix = OCDocUtil.getCanonicalName(parent.getType(), namespace, containingOCFile, project2);
            return OCDocUtil.replaceAnonymous(prefix);
        }
        return "";
    }

    @NotNull
    public static String replaceAnonymous(@NotNull String canonicalName) {
        return canonicalName.replace("anonymous ", "<i>(anonymous)</i>");
    }

    @NotNull
    public static List<OCSymbolWithQualifiedName> getParents(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(context, symbol, OCSymbolKind.NAMESPACE);
        chain.remove(symbol);
        return chain;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCResolveContext context, @NotNull OCSymbolWithQualifiedName symbol, OCSymbolKind ... filter) {
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, context, true, true, true, true, false, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parent -> {
            for (OCSymbolKind kind : filter) {
                if (parent.getKind() != kind) continue;
                parents.add((OCSymbolWithQualifiedName)parent);
            }
        }));
        return parents;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, context, true, true, true, true, false, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parents::add));
        parents.remove(symbol);
        return parents;
    }

    @NotNull
    private static String wrapSymbolName(@NotNull OCSymbol symbol) {
        if (!(symbol instanceof OCStructSymbol)) {
            return StringUtil.escapeXmlEntities((String)symbol.getPresentableName());
        }
        StringBuilder sb = new StringBuilder();
        OCDocUtil.wrapStruct((OCStructSymbol)symbol, sb);
        return sb.toString();
    }

    private static void wrapStruct(@NotNull OCStructSymbol symbol, @NotNull StringBuilder sb) {
        String name2 = symbol.getName();
        boolean hasName = !"<unnamed>".equals(name2);
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            sb.append("<a href=\"").append(link).append("\">").append(StringUtil.escapeXmlEntities((String)name2)).append("</a>");
        } else {
            sb.append(StringUtil.escapeXmlEntities((String)symbol.getPresentableName()));
        }
    }

    public static String getLink(@NotNull OCSymbol symbol) {
        String name2 = symbol.getPresentableName();
        boolean hasName = !"<unnamed>".equals(name2);
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            return "<a href=\"" + link + "\">" + StringUtil.escapeXmlEntities((String)name2) + "</a>";
        }
        return StringUtil.escapeXmlEntities((String)symbol.getPresentableName());
    }

    public static void wrapTemplateArgs(@NotNull List<OCTypeArgument> templateArguments, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile, @NotNull StringBuilder answer, @NotNull Project project2) {
        String templateArgumentsStr = StringUtil.join(templateArguments, templateArgument -> {
            if (templateArgument instanceof OCType) {
                return OCDocUtil.getCanonicalName((OCType)templateArgument, contextNamespace, containingFile, project2);
            }
            if (templateArgument instanceof OCExpressionTypeArgument) {
                return ((OCExpressionTypeArgument)templateArgument).getSymbol().getPresentableName();
            }
            return "";
        }, (String)", ");
        if (!templateArgumentsStr.isEmpty()) {
            answer.append(StringUtil.escapeXmlEntities((String)"<")).append(templateArgumentsStr).append(StringUtil.escapeXmlEntities((String)">"));
        }
    }

    public static void wrapTemplateParams(@NotNull List<OCTypeParameterSymbol> templateParams, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile, @NotNull StringBuilder answer, @NotNull Project project2) {
        String templateParamsStr = StringUtil.join(templateParams, param -> {
            StringBuilder sb = new StringBuilder();
            if (param instanceof OCTypeParameterValueSymbol) {
                String type = ((OCTypeParameterValueSymbol)param).getType().getName();
                sb.append(type).append(OCDocUtil.delimiter(type));
            }
            if (param.isVariadic()) {
                sb.append("...");
            }
            sb.append(param.getName());
            Object value = param.getDefaultValue();
            if (value != null) {
                sb.append(" = ");
                if (value instanceof OCType) {
                    sb.append(OCDocUtil.getCanonicalName((OCType)value, contextNamespace, containingFile, project2));
                } else if (value instanceof OCExpressionTypeArgument) {
                    sb.append(((OCExpressionTypeArgument)value).getSymbol().getPresentableName());
                }
            }
            return sb.toString();
        }, (String)", ");
        answer.append(StringUtil.escapeXmlEntities((String)"template<")).append(templateParamsStr).append(StringUtil.escapeXmlEntities((String)">"));
    }

    @Nullable
    private static String buildLinkSymbol(@NotNull OCSymbol symbol) {
        StringBuilder sb = new StringBuilder("psi_element://");
        VirtualFile file = symbol.getContainingFile();
        if (file != null) {
            sb.append(file.getPath()).append('#').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static List<OCSymbolWithParent> getSuperSymbols(@NotNull PsiElement element) {
        Object symbol;
        ArrayList<OCSymbolWithParent> supers = new ArrayList<OCSymbolWithParent>();
        if (element instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCSymbolWithParent) {
            OCSearchUtil.processMemberAncestors((OCSymbolWithParent)symbol, (Processor<? super OCSymbolWithParent>)((Processor)s -> {
                supers.add((OCSymbolWithParent)s);
                return true;
            }), true, element.getProject());
        }
        return supers;
    }
}

