/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCCommaExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParenthesesUtils {
    public static final int SEND_MESSAGE_OUTER_PRECEDENCE = 1;
    public static final int PREFIX_INCDEC_PRECEDENCE = 2;
    public static final int UNARY_OP_PRECEDENCE = 3;
    public static final int PM_OP_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    public static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    public static final int RELATIONAL_PRECEDENCE = 8;
    public static final int EQUALITY_PRECEDENCE = 9;
    public static final int BITWISE_AND_PRECEDENCE = 10;
    public static final int BITWISE_XOR_PRECEDENCE = 11;
    public static final int BITWISE_OR_PRECEDENCE = 12;
    public static final int LOGICAL_AND_PRECEDENCE = 13;
    public static final int LOGICAL_OR_PRECEDENCE = 14;
    public static final int TERNARY_OPERATOR_PRECEDENCE = 15;
    public static final int ASSIGNMENT_PRECEDENCE = 16;
    public static final int COMMA_PRECEDENCE_PRECEDENCE = 17;
    public static final int SEND_MESSAGE_INNER_PRECEDENCE = 18;
    private static final Map<OCElementType, Integer> BINARY_OPERATOR_PRECEDENCE = new HashMap<OCElementType, Integer>();

    private OCParenthesesUtils() {
    }

    public static int getPrecedence(OCElementType operator) {
        if (operator == OCTokenTypes.EQ) {
            return 16;
        }
        if (OCTokenTypes.UNARY_OPERATIONS.contains((IElementType)operator)) {
            return 3;
        }
        if (BINARY_OPERATOR_PRECEDENCE.containsKey((Object)operator)) {
            return BINARY_OPERATOR_PRECEDENCE.get((Object)operator);
        }
        throw new IllegalArgumentException("Unknown precedence of operator " + operator.getName());
    }

    public static int getPrecedence(OCExpression expression, boolean isInnerPrecedence) {
        if (expression instanceof OCParenthesizedExpression || expression instanceof OCLiteralExpression || expression instanceof OCReferenceExpression) {
            return 0;
        }
        if (expression instanceof OCQualifiedExpression || expression instanceof OCPrefixExpression || expression instanceof OCArraySelectionExpression || expression instanceof OCCallExpression) {
            return 2;
        }
        if (expression instanceof OCUnaryExpression || expression instanceof OCCastExpression || expression instanceof OCSizeofExpression) {
            return 3;
        }
        if (expression instanceof OCBinaryExpression) {
            return BINARY_OPERATOR_PRECEDENCE.get((Object)((OCBinaryExpression)expression).getOperationSign());
        }
        if (expression instanceof OCConditionalExpression) {
            return 15;
        }
        if (expression instanceof OCAssignmentExpression) {
            return 16;
        }
        if (expression instanceof OCCommaExpression || expression instanceof OCPostfixExpression) {
            return 17;
        }
        if (expression instanceof OCSendMessageExpression) {
            return isInnerPrecedence ? 18 : 1;
        }
        return -1;
    }

    @Nullable
    public static OCStatement stripBraces(@Nullable OCStatement branch) {
        if (branch instanceof OCBlockStatement) {
            OCBlockStatement block = (OCBlockStatement)branch;
            List<OCStatement> statements = block.getStatements();
            if (statements.size() == 1) {
                return statements.get(0);
            }
            return block;
        }
        return branch;
    }

    @NotNull
    public static OCParenthesizedExpression appendParentheses(@NotNull OCExpression expression) {
        OCParenthesizedExpression parent = (OCParenthesizedExpression)OCElementFactory.expressionFromText("(1)", expression, false);
        OCChangeUtil.replaceHandlingMacros(parent.getOperand(), expression);
        return parent;
    }

    public static PsiElement replaceExpressionAndRemoveAppendParentheses(@NotNull OCExpression oldElement, @NotNull OCExpression newElement) {
        newElement = OCParenthesesUtils.diveIntoParenthesesButNotIntoMacroCall(newElement);
        while (oldElement.getParent() instanceof OCParenthesizedExpression) {
            oldElement = (OCExpression)oldElement.getParent();
        }
        return OCParenthesesUtils.replaceExpressionAndAppendParentheses(oldElement, newElement);
    }

    public static PsiElement replaceExpressionAndAppendParentheses(@NotNull OCExpression oldElement, @NotNull OCExpression newElement) {
        OCDeclaration declaration;
        if (newElement instanceof OCCompoundInitializer && newElement.getParent() instanceof OCDeclarator && !(oldElement instanceof OCCompoundInitializer) && (declaration = (OCDeclaration)newElement.getParent().getParent()).getTypeElement() != null) {
            OCCastExpression cast = (OCCastExpression)OCElementFactory.expressionFromText("(int)1", newElement);
            OCChangeUtil.replaceHandlingMacros(cast.getTypeElement(), declaration.getTypeElement());
            OCChangeUtil.replaceHandlingMacros(cast.getOperand(), newElement);
            newElement = cast;
        }
        if (OCParenthesesUtils.isParenthesesNeededInReplacing(oldElement, newElement)) {
            return OCChangeUtil.replaceHandlingMacros(oldElement, OCParenthesesUtils.appendParentheses(newElement));
        }
        return OCChangeUtil.replaceHandlingMacros(oldElement, newElement);
    }

    public static boolean isParenthesesNeededInReplacing(@NotNull OCExpression oldElement, @NotNull OCExpression newElement) {
        PsiElement parent = oldElement.getParent();
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence((OCExpression)parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(newElement, false))) {
                return false;
            }
            if (parentPrecedence < destPrecedence) {
                return true;
            }
            if (parent instanceof OCBinaryExpression && oldElement == ((OCBinaryExpression)parent).getRight()) {
                return OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, newElement);
            }
            return false;
        }
        return false;
    }

    public static boolean isParenthesesNeededInRightArgument(OCBinaryExpression parent, OCExpression right) {
        if (right instanceof OCBinaryExpression) {
            OCBinaryExpression binSource = (OCBinaryExpression)right;
            if (parent.getOperationSign() == binSource.getOperationSign() && (binSource.getOperationSign() == OCTokenTypes.ANDAND || binSource.getOperationSign() == OCTokenTypes.OROR)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static OCExpression diveIntoParenthesesAndCasts(@Nullable OCExpression expression) {
        return OCParenthesesUtils.diveIntoParenthesesAndCasts(expression, OCCastKind.values());
    }

    @Nullable
    public static OCExpression diveIntoParenthesesAndCasts(@Nullable OCExpression expression, @NotNull OCCastKind[] acceptableCasts) {
        while (true) {
            OCCastExpression castExpression;
            if (expression instanceof OCParenthesizedExpression) {
                expression = ((OCParenthesizedExpression)expression).getOperand();
                continue;
            }
            if (!(expression instanceof OCCastExpression) || ArrayUtil.indexOf((Object[])acceptableCasts, (Object)((Object)(castExpression = (OCCastExpression)expression).getCastKind())) == -1) break;
            expression = castExpression.getOperand();
        }
        return expression;
    }

    @Nullable
    public static OCExpression diveIntoParenthesesButNotIntoMacroCall(@Nullable OCExpression expr) {
        if (expr instanceof OCParenthesizedExpression && !OCElementUtil.isPartOfMacroSubstitution(expr)) {
            return OCParenthesesUtils.diveIntoParenthesesButNotIntoMacroCall(((OCParenthesizedExpression)expr).getOperand());
        }
        return expr;
    }

    @Nullable
    public static OCTypeOwner diveIntoParentheses(@Nullable OCTypeOwner expr) {
        return expr instanceof OCExpression ? OCParenthesesUtils.diveIntoParentheses((OCExpression)expr) : expr;
    }

    @Nullable
    public static OCExpression diveIntoParentheses(@Nullable OCExpression expr) {
        if (expr instanceof OCParenthesizedExpression) {
            return OCParenthesesUtils.diveIntoParentheses(((OCParenthesizedExpression)expr).getOperand());
        }
        return expr;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement diveIntoParenthesesAndCasts(@Nullable PsiElement element) {
        if (element instanceof OCExpression) {
            return OCParenthesesUtils.diveIntoParenthesesAndCasts((OCExpression)element);
        }
        return element;
    }

    public static OCExpression topmostParenthesized(OCExpression expr) {
        if (expr.getParent() instanceof OCParenthesizedExpression) {
            return OCParenthesesUtils.topmostParenthesized((OCExpression)expr.getParent());
        }
        return expr;
    }

    public static boolean areExpressionsEquivalent(@Nullable OCExpression expr1, @Nullable OCExpression expr2, boolean differentMacrosAreEquivalent, @NotNull OCResolveContext context) {
        expr1 = OCParenthesesUtils.diveIntoParentheses(expr1);
        expr2 = OCParenthesesUtils.diveIntoParentheses(expr2);
        return expr1 != null && expr2 != null && OCElementUtil.areElementsEquivalent(expr1, expr2, differentMacrosAreEquivalent, context);
    }

    public static boolean areExpressionsOpposite(OCExpression expr1, OCExpression expr2, boolean differentMacrosAreEquivalent, @NotNull OCResolveContext context) {
        expr1 = OCParenthesesUtils.diveIntoParentheses(expr1);
        expr2 = OCParenthesesUtils.diveIntoParentheses(expr2);
        if (expr1 instanceof OCUnaryExpression && ((OCUnaryExpression)expr1).getOperationSign() == OCTokenTypes.EXCL) {
            return OCParenthesesUtils.areExpressionsEquivalent(((OCUnaryExpression)expr1).getOperand(), expr2, differentMacrosAreEquivalent, context);
        }
        if (expr2 instanceof OCUnaryExpression && ((OCUnaryExpression)expr2).getOperationSign() == OCTokenTypes.EXCL) {
            return OCParenthesesUtils.areExpressionsEquivalent(((OCUnaryExpression)expr2).getOperand(), expr1, differentMacrosAreEquivalent, context);
        }
        return false;
    }

    static {
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.DOT_MUL, 4);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.DEREF_MUL, 4);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.MUL, 5);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.DIV, 5);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.PERC, 5);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.PLUS, 6);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.MINUS, 6);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.LTLT, 7);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.GTGT, 7);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.LT, 8);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.LTEQ, 8);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.GT, 8);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.GTEQ, 8);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.EQEQ, 9);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.EXCLEQ, 9);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.AND, 10);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.XOR, 11);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.OR, 12);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.ANDAND, 13);
        BINARY_OPERATOR_PRECEDENCE.put(OCTokenTypes.OROR, 14);
    }
}

