/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Variant<F, S> {
    @Nullable
    private final F first;
    @Nullable
    private final S second;

    @NotNull
    public static <F, S> Variant<F, S> forFirst(@NotNull F left) {
        return new Variant<F, Object>(left, null);
    }

    @NotNull
    public static <F, S> Variant<F, S> forSecond(@NotNull S right) {
        return new Variant<Object, S>(null, right);
    }

    @Contract(value="null, null -> fail")
    private Variant(@Nullable F first, @Nullable S second) {
        assert (first != null || second != null);
        this.first = first;
        this.second = second;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public boolean isFirst() {
        return this.first != null;
    }

    public boolean isSecond() {
        return this.second != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variant variant = (Variant)o;
        if (this.first != null ? !this.first.equals(variant.first) : variant.first != null) {
            return false;
        }
        return !(this.second != null ? !this.second.equals(variant.second) : variant.second != null);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Variant [").append(System.lineSeparator());
        builder.append("  first = ").append(this.first).append(System.lineSeparator());
        builder.append("  second = ").append(this.second).append(System.lineSeparator());
        return builder.append("]").toString();
    }
}

