/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculator {
    private static final Key<Pair<Long, Boolean>> LOOKS_LIKE_OBJC_KEY = new Key("LOOKS_LIKE_OBJC_KEY");
    private static final FileAttribute LOOKS_LIKE_OBJC_ATTRIBUTE = new FileAttribute("LOOKS_LIKE_OBJC_ATTRIBUTE", 1, true);
    private static final TokenSet OBJC_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.AT, OCTokenTypes.IMPORT_DIRECTIVE}), OCTokenTypes.OBJC_KEYWORDS_NO_AT, OCTokenTypes.ARC_TYPE_QUALIFIERS});

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull PsiFile file) {
        Project project2 = file.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        if (virtualFile != null) {
            OCLanguageKind result = OCLanguageKindCalculator.calculateLanguageKindFast(project2, virtualFile);
            if (result != null) {
                return result;
            }
        } else {
            String name2 = file.getName();
            OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project2, name2);
            if (result != null) {
                return result;
            }
        }
        return CLanguageKind.maxLanguage();
    }

    @Nullable
    private static OCLanguageKind calculateLanguageKindFast(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        OCLanguageKind result = OCLanguageKindCalculator.tryFileTypeAndExtension(project2, virtualFile);
        if (result != null) {
            return result;
        }
        return OCLanguageKindCalculator.calculateFastByAssociatedFiles(project2, virtualFile);
    }

    private static OCLanguageKind calculateFastByAssociatedFiles(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        if (!SymbolTableProvider.isSourceFile(virtualFile) || !OCFileTypeHelpers.isHeaderFile(virtualFile.getName())) {
            return null;
        }
        Ref isCpp = new Ref((Object)false);
        Ref isObjC = new Ref((Object)false);
        Ref found2 = new Ref((Object)false);
        Processor processor2 = file -> {
            String name2 = file.getName();
            OCLanguageKind lk = OCFileTypeHelpers.getLanguageKindStrict(name2);
            if (lk != null && !OCFileTypeHelpers.isHeaderFile(name2)) {
                found2.set((Object)true);
                isCpp.set((Object)((Boolean)isCpp.get() != false || lk.isCpp() ? 1 : 0));
                isObjC.set((Object)((Boolean)isObjC.get() != false || lk.isObjC() ? 1 : 0));
                if (((Boolean)isCpp.get()).booleanValue() && ((Boolean)isObjC.get()).booleanValue()) {
                    return false;
                }
            }
            return true;
        };
        OCSearchUtil.processAssociatedFilesWithSameName(project2, virtualFile, (Processor<? super VirtualFile>)processor2);
        if (((Boolean)found2.get()).booleanValue()) {
            return CLanguageKind.find((Boolean)isObjC.get(), (Boolean)isCpp.get());
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project2, @Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        OCLanguageKind result = OCLanguageKindCalculator.trySpecifiedFileType(project2, file);
        if (result != null) {
            return result;
        }
        result = OCLanguageKindCalculator.tryFileExtension(project2, file.getName());
        if (result != null) {
            return result;
        }
        return null;
    }

    @Nullable
    private static OCLanguageKind trySpecifiedFileType(@Nullable Project project2, @Nullable VirtualFile file) {
        if (project2 == null || file == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result = each.getSpecifiedLanguage(project2, file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind calculateMinimalKindByExtension(@Nullable Project project2, @NotNull String name2) {
        OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project2, name2);
        if (result != null) {
            return result;
        }
        return OCFileTypeHelpers.getLanguageKind(name2);
    }

    @Nullable
    private static OCLanguageKind tryFileExtension(@Nullable Project project2, @NotNull String name2) {
        if (project2 == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result = each.getLanguageByExtension(project2, name2);
            if (result == null) continue;
            return result;
        }
        return !OCFileTypeHelpers.isHeaderFile(name2) ? OCFileTypeHelpers.getLanguageKindStrict(name2) : null;
    }

    @NotNull
    private static List<OCLanguageKindCalculatorHelper> getHelpers() {
        return OCLanguageKindCalculatorHelper.EP_NAME.getExtensionList();
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@NotNull OCFile file) {
        PsiFile containingFile;
        PsiElement context;
        if (file instanceof OCCodeFragment && (context = file.getContext()) != null && (containingFile = context.getContainingFile()) instanceof OCFile) {
            return OCLanguageKindCalculator.calculateLanguageKind((OCFile)containingFile);
        }
        Project project2 = file.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        if (virtualFile == null) {
            String name2 = file.getName();
            OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project2, name2);
            if (result != null) {
                return result;
            }
            return CLanguageKind.maxLanguage();
        }
        return OCLanguageKindCalculator.calculateLanguageKind(OCInclusionContextUtil.getActiveConfiguration(file), virtualFile, project2, true);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration activeConfig, @NotNull VirtualFile file, @NotNull Project project2, boolean tryFromRoot) {
        boolean isCpp;
        OCLanguageKind result;
        if (activeConfig != null && (result = activeConfig.getDeclaredLanguageKind(file)) != null) {
            return result;
        }
        result = OCLanguageKindCalculator.tryFileTypeAndExtension(project2, file);
        if (result != null) {
            return result;
        }
        if (tryFromRoot && OCInclusionContextUtil.isNeedToFindRoot(file, project2)) {
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(file, project2);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCResolveConfiguration rootConfig = rootAndConfiguration.getConfiguration();
            if (rootFile != null && rootConfig != null && !rootFile.equals(file)) {
                result = OCLanguageKindCalculator.tryLanguageKindFromPchRoot(rootConfig, file, rootFile);
                if (result != null) {
                    return result;
                }
                return OCLanguageKindCalculator.calculateLanguageKind(rootConfig, rootFile, project2, false);
            }
        }
        boolean isObjC = false;
        result = OCLanguageKindCalculator.calculateFastByAssociatedFiles(project2, file);
        if (result != null) {
            isCpp = result.isCpp();
            isObjC = result.isObjC();
        } else {
            isCpp = OCLanguageKindCalculator.isCppPreferred(activeConfig, file.getName());
        }
        isObjC = isObjC || OCLanguageKindCalculator.looksLikeObjC(file);
        return CLanguageKind.find(isObjC, isCpp);
    }

    public static boolean isCppPreferred(@Nullable OCResolveConfiguration activeConfig, @NotNull String name2) {
        if (OCFileTypeHelpers.isCppFile(name2)) {
            return true;
        }
        if (activeConfig != null) {
            Set<OCLanguageKind> kinds = activeConfig.getEnabledLanguageKinds();
            return kinds.isEmpty() || kinds.stream().anyMatch(OCLanguageKind::isCpp);
        }
        return true;
    }

    @Nullable
    public static OCLanguageKind tryLanguageKindFromPchRoot(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        OCImmutableInclusionContext cachedContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, header, pchCandidate);
        return cachedContext != null ? cachedContext.getLanguageKind() : null;
    }

    private static boolean looksLikeObjC(@NotNull VirtualFile file) {
        if (file.getFileType().isBinary()) {
            return false;
        }
        long currentTimestamp = file.getModificationStamp();
        Pair info = (Pair)LOOKS_LIKE_OBJC_KEY.get((UserDataHolder)file);
        if (info != null && (Long)info.first == currentTimestamp) {
            return (Boolean)info.second;
        }
        if (info == null) {
            info = OCLanguageKindCalculator.readDetectionInfo(file);
        }
        if (info == null || (Long)info.first != currentTimestamp) {
            CharSequence text = LoadTextUtil.loadText((VirtualFile)file, (int)10240);
            boolean isObjC = OCLanguageKindCalculator.calcLooksLikeObjC(text);
            info = Pair.create((Object)currentTimestamp, (Object)isObjC);
            OCLanguageKindCalculator.writeDetectionInfo(file, (Pair<Long, Boolean>)info);
        }
        file.putUserData(LOOKS_LIKE_OBJC_KEY, info);
        return (Boolean)info.second;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Long, Boolean> readDetectionInfo(@NotNull VirtualFile file) {
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try (DataInputStream in = LOOKS_LIKE_OBJC_ATTRIBUTE.readAttribute(file);){
            if (in == null) return null;
            long timestamp = in.readLong();
            boolean isObjC = in.readBoolean();
            Pair pair2 = Pair.create((Object)timestamp, (Object)isObjC);
            return pair2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void writeDetectionInfo(@NotNull VirtualFile file, @NotNull Pair<Long, Boolean> info) {
        if (!(file instanceof VirtualFileWithId)) {
            return;
        }
        try (DataOutputStream out = LOOKS_LIKE_OBJC_ATTRIBUTE.writeAttribute(file);){
            out.writeLong((Long)info.first);
            out.writeBoolean((Boolean)info.second);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean calcLooksLikeObjC(CharSequence text) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage(CLanguageKind.OBJ_CPP).build());
        lexer.start(text);
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (OBJC_TOKENS.contains(tt)) {
                return true;
            }
            lexer.advance();
        }
        return false;
    }
}

