/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.project.ProjectKt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.PathTree;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class OCRootsSynchronizer
implements Disposable {
    private volatile boolean isStarted;
    @Nullable
    private MessageBusConnection myBusConnection;
    @NotNull
    protected final Project myProject;
    @Nullable
    private Set<LocalFileSystem.WatchRequest> myWatchRequest;

    public OCRootsSynchronizer(@NotNull Project project2) {
        this.myProject = project2;
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    public void installClasspathStorage(@NotNull String id) {
        ClasspathStorage.setStorageType((ModuleRootModel)ModuleRootManager.getInstance((Module)this.getModuleOrCreateNew()), (String)id);
    }

    public void startListening() {
        if (this.isStarted) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already started");
        }
        this.myBusConnection = this.myProject.getMessageBus().connect();
        this.synchronizeOnFileMoves(this.myBusConnection);
        this.isStarted = true;
    }

    public void shutdown() {
        if (this.isStarted) {
            this.isStarted = false;
            if (this.myBusConnection != null) {
                this.myBusConnection.disconnect();
            }
            this.myBusConnection = null;
            this.registerWatchRoots(Collections.emptyList());
        }
    }

    public void dispose() {
        this.shutdown();
    }

    public void updateRoots(@NotNull RootsInfo info) {
        this.updateRoots(info, false);
    }

    public void updateRoots(@NotNull RootsInfo info, boolean forceRootsChangedEvents) {
        Module module2 = this.getModuleOrCreateNew();
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
        this.updateModuleRoots(model, info);
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            if (model.isChanged()) {
                model.commit();
            } else {
                model.dispose();
            }
            if (forceRootsChangedEvents) {
                ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> {}, false, true);
            }
            for (Facet f : FacetManager.getInstance((Module)module2).getAllFacets()) {
                f.initFacet();
            }
        });
        this.registerWatchRoots(info.watchRoots);
    }

    public void updateModuleRoots(@NotNull ModifiableRootModel model, @NotNull RootsInfo info) {
        OCRootsSynchronizer.registerRoots(model, info);
    }

    @Nullable
    public Module getModuleIfExists() {
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length == 0) {
            return null;
        }
        if (modules.length > 1) {
            OCLog.LOG.warn(OCRootsSynchronizer.class.getSimpleName() + " doesn't currently support multi-module projects.\nThe first available module '" + modules[0].getName() + "' will be used.");
        }
        return modules[0];
    }

    @NotNull
    public Module getModuleOrCreateNew() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Module module2 = this.getModuleIfExists();
        if (module2 != null) {
            return module2;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile baseDir;
            IProjectStore store = ProjectKt.getStateStore((Project)this.myProject);
            String moduleDirPath = store.getDirectoryStorePath();
            if (moduleDirPath == null) {
                moduleDirPath = store.getProjectBasePath();
            }
            String moduleName = store.getProjectName();
            File moduleDir = new File(moduleDirPath);
            File imlFile = new File(moduleDir, FileUtil.createSequentFileName((File)moduleDir, (String)moduleName, (String)"iml"));
            Module newModule = ModuleManager.getInstance((Project)this.myProject).newModule(imlFile.getPath(), ModuleTypeManager.getInstance().getDefaultModuleType().getId());
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)newModule);
            ModifiableRootModel rootModel = rootManager.getModifiableModel();
            if (rootModel.getContentRoots().length == 0 && (baseDir = LocalFileSystem.getInstance().findFileByPath(store.getProjectBasePath())) != null) {
                rootModel.addContentEntry(baseDir);
            }
            rootModel.commit();
        });
        return this.getModuleIfExists();
    }

    private void registerWatchRoots(@NotNull List<File> roots) {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequest);
            this.myWatchRequest = null;
        }
        if (!roots.isEmpty()) {
            Function paths = file -> file.getPath();
            this.myWatchRequest = LocalFileSystem.getInstance().addRootsToWatch((Collection)ContainerUtil.map(roots, (Function)paths), true);
        }
    }

    private static void registerRoots(final ModifiableRootModel model, final @NotNull RootsInfo info) {
        model.clear();
        RootTree tree = new RootTree();
        tree.addAll(info.contentRoots, RootKind.CONTENT);
        tree.addAll(info.sourceFiles, RootKind.SOURCE);
        tree.addAll(info.generatedSourceFiles, RootKind.SOURCE_GENERATED);
        tree.addAll(info.explicitLibraryRoots, RootKind.EXPLICIT_LIBRARY);
        tree.addAll(info.explicitSourceFolders, RootKind.EXPLICIT_SOURCE);
        tree.addAll(info.explicitExcludeFolders, RootKind.EXPLICIT_EXCLUDE);
        tree.addAll(info.headerSearchRoots.systemHeaderRoots, RootKind.LIBRARY);
        tree.addAll(info.headerSearchRoots.excludeRoots, RootKind.LIBRARY_EXCLUDE);
        tree.addAll(OCRootsSynchronizer.removeDuplicatesAndSubdirs(info.headerSearchRoots.userHeaderRoots), RootKind.CONTENT);
        LibraryTable table = model.getModuleLibraryTable();
        Library library = table.createLibrary("Header Search Paths");
        final LibraryEx.ModifiableModelEx libraryModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        tree.accept(new RootTree.Visitor(){
            final Stack<State> stack = new Stack();
            State state;

            @Override
            public void enter() {
                this.stack.push(this.state);
                this.state = this.state == null ? new State() : new State(this.state);
            }

            @Override
            public boolean visit(@NotNull Set<RootItem> items) {
                RootItem sourceItem;
                if (items.isEmpty()) {
                    return true;
                }
                RootItem excludeItem = this.find(items, RootKind.EXPLICIT_EXCLUDE);
                if (excludeItem != null) {
                    if (this.state.contentEntry != null) {
                        this.state.contentEntry.addExcludeFolder(excludeItem.getUrl());
                    }
                    if (this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(excludeItem.getUrl());
                        this.state.isLibraryRoot = false;
                    }
                    return false;
                }
                RootItem contentItem = this.find(items, RootKind.CONTENT);
                if (contentItem != null && this.state.contentEntry == null) {
                    this.state.contentEntry = model.addContentEntry(contentItem.getUrl());
                    if (this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(contentItem.getUrl());
                        this.state.isLibraryRoot = false;
                    }
                }
                if ((sourceItem = this.find(items, RootKind.EXPLICIT_SOURCE)) != null) {
                    this.addSourceFolder(sourceItem);
                    this.state.isExplicitRoot = true;
                    return true;
                }
                RootItem libraryItem = this.find(items, RootKind.EXPLICIT_LIBRARY);
                if (libraryItem != null) {
                    this.addLibraryRoot(libraryItem);
                    this.state.isExplicitRoot = true;
                    return true;
                }
                if (this.state.isExplicitRoot) {
                    return true;
                }
                sourceItem = this.find(items, RootKind.SOURCE_GENERATED);
                if (sourceItem != null) {
                    this.addSourceFolder(sourceItem, true);
                    return true;
                }
                sourceItem = this.find(items, RootKind.SOURCE);
                if (sourceItem != null) {
                    this.addSourceFolder(sourceItem);
                    return true;
                }
                if (info.registerSystemHeaderRootUnderContentRootAsLibraries || this.state.contentEntry == null) {
                    RootItem libraryExclude = this.find(items, RootKind.LIBRARY_EXCLUDE);
                    if (libraryExclude != null && this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(libraryExclude.getUrl());
                        this.state.isLibraryRoot = false;
                    } else if (contentItem == null && (libraryItem = this.find(items, RootKind.LIBRARY)) != null) {
                        this.addLibraryRoot(libraryItem);
                    }
                }
                return true;
            }

            private void addSourceFolder(@NotNull RootItem item) {
                this.addSourceFolder(item, false);
            }

            private void addSourceFolder(@NotNull RootItem item, boolean isGenerated) {
                if (this.state.contentEntry == null) {
                    this.state.contentEntry = model.addContentEntry(item.getUrl());
                }
                if (this.state.sourceFolder == null || this.state.isGeneratedSources != isGenerated) {
                    JavaSourceRootType rootType = JavaSourceRootType.SOURCE;
                    JavaSourceRootProperties properties = rootType.createDefaultProperties();
                    properties.setForGeneratedSources(isGenerated);
                    this.state.sourceFolder = this.state.contentEntry.addSourceFolder(item.getUrl(), (JpsModuleSourceRootType)rootType, (JpsElement)properties);
                    this.state.isGeneratedSources = isGenerated;
                }
                if (this.state.isLibraryRoot) {
                    libraryModel.addExcludedRoot(item.getUrl());
                    this.state.isLibraryRoot = false;
                }
            }

            private void addLibraryRoot(@NotNull RootItem item) {
                if (!this.state.isLibraryRoot) {
                    String libraryRootUrl = item.getUrl();
                    libraryModel.addRoot(libraryRootUrl, OrderRootType.CLASSES);
                    libraryModel.addRoot(libraryRootUrl, OrderRootType.SOURCES);
                    this.state.isLibraryRoot = true;
                    this.state.sourceFolder = null;
                    this.state.isGeneratedSources = false;
                }
            }

            @Nullable
            private RootItem find(Set<RootItem> items, RootKind kind) {
                for (RootItem each : items) {
                    if (each.kind != kind) continue;
                    return each;
                }
                return null;
            }

            @Override
            public void exit() {
                this.state = this.stack.pop();
            }

            class State {
                @Nullable
                ContentEntry contentEntry;
                @Nullable
                SourceFolder sourceFolder;
                @Nullable
                ExcludeFolder excludeFolder;
                boolean isLibraryRoot;
                boolean isExplicitRoot;
                boolean isGeneratedSources;

                State() {
                }

                State(State other) {
                    this.contentEntry = other.contentEntry;
                    this.sourceFolder = other.sourceFolder;
                    this.excludeFolder = other.excludeFolder;
                    this.isLibraryRoot = other.isLibraryRoot;
                    this.isExplicitRoot = other.isExplicitRoot;
                    this.isGeneratedSources = other.isGeneratedSources;
                }
            }
        });
        libraryModel.commit();
    }

    private void synchronizeOnFileMoves(@NotNull MessageBusConnection connection) {
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Module module2 = OCRootsSynchronizer.this.getModuleIfExists();
                if (module2 == null) {
                    return;
                }
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
                ModuleFileIndex index = rootManager.getFileIndex();
                Map libraryModels = FactoryMap.create(key -> (LibraryEx.ModifiableModelEx)((ModuleLibraryOrderEntryImpl)key).getLibrary().getModifiableModel());
                THashSet rootsToExclude = new THashSet();
                Collections.addAll(rootsToExclude, rootManager.getContentRoots());
                Collections.addAll(rootsToExclude, rootManager.getSourceRoots());
                Collections.addAll(rootsToExclude, rootManager.getExcludeRoots());
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                    for (VirtualFile eachRoot : this.getSubRoots(((VFileMoveEvent)vFileEvent).getFile(), (Collection<VirtualFile>)rootsToExclude)) {
                        OrderEntry isInLibrary;
                        OrderEntry wasInLibrary = index.getOrderEntryForFile(((VFileMoveEvent)vFileEvent).getOldParent());
                        if (wasInLibrary instanceof ModuleLibraryOrderEntryImpl == (isInLibrary = index.getOrderEntryForFile(eachRoot.getParent())) instanceof ModuleLibraryOrderEntryImpl) continue;
                        if (isInLibrary instanceof ModuleLibraryOrderEntryImpl) {
                            ((LibraryEx.ModifiableModelEx)libraryModels.get(isInLibrary)).addExcludedRoot(eachRoot.getUrl());
                            continue;
                        }
                        ((LibraryEx.ModifiableModelEx)libraryModels.get(wasInLibrary)).removeExcludedRoot(eachRoot.getUrl());
                    }
                }
                for (LibraryEx.ModifiableModelEx modifiableModelEx : libraryModels.values()) {
                    modifiableModelEx.commit();
                }
            }

            private List<VirtualFile> getSubRoots(VirtualFile from, Collection<VirtualFile> roots) {
                ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
                VfsUtilCore.processFilesRecursively((VirtualFile)from, file -> {
                    if (roots.contains(file)) {
                        result.add((VirtualFile)file);
                    }
                    return true;
                });
                return result;
            }
        });
    }

    public static void collectHeaderSearchRoots(@NotNull Collection<? extends HeadersSearchRoot> headerRoots, @NotNull HeaderSearchRoots result) {
        for (HeadersSearchRoot headersSearchRoot : headerRoots) {
            OCRootsSynchronizer.collectHeaderSearchRoots(headersSearchRoot, result);
        }
    }

    public static void collectHeaderSearchRoots(final @NotNull HeadersSearchRoot root, final @NotNull HeaderSearchRoots result) {
        root.processChildren(new HeadersSearchRootProcessor(){

            @Override
            public boolean shouldProcessRootsOnly() {
                return true;
            }

            @Override
            @NotNull
            public HeadersSearchRootProcessor.FrameworkResult processFramework(@NotNull AppleFramework framework) {
                VirtualFile virtualFile = framework.getVirtualFile();
                if (virtualFile != null) {
                    result.excludeRoots.add(new File(virtualFile.getPath()));
                }
                return HeadersSearchRootProcessor.FrameworkResult.PROCESS_CHILDREN;
            }

            @Override
            public boolean process(@NotNull VirtualFile file) {
                if (file.isDirectory()) {
                    if (root.isUserHeaders()) {
                        result.userHeaderRoots.add(new File(file.getPath()));
                    } else {
                        result.systemHeaderRoots.add(new File(file.getPath()));
                    }
                }
                return true;
            }
        });
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable Collection<File> files) {
        if (files == null) {
            return false;
        }
        return files.stream().allMatch(file -> OCRootsSynchronizer.isUnder(parents, file));
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file) {
        return OCRootsSynchronizer.isUnder(parents, file, false);
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file, boolean strict) {
        if (parents == null || file == null) {
            return false;
        }
        for (File parent : parents) {
            if (!FileUtil.isAncestor((File)parent, (File)file, (boolean)strict)) continue;
            return true;
        }
        return false;
    }

    private static List<File> removeDuplicatesAndSubdirs(Collection<File> files) {
        ArrayList answer = ContainerUtil.newArrayList(files);
        Collections.sort(answer, (o1, o2) -> FileUtil.compareFiles((File)o1, (File)o2));
        Iterator it = answer.iterator();
        File prev = null;
        while (it.hasNext()) {
            File next = (File)it.next();
            if (prev != null && FileUtil.isAncestor((File)prev, (File)next, (boolean)false)) {
                it.remove();
                continue;
            }
            prev = next;
        }
        return answer;
    }

    private static class RootTree
    extends PathTree<RootTree, RootItem> {
        private RootTree() {
        }

        @Override
        protected RootTree createNewTree(@Nullable RootTree parent) {
            return new RootTree();
        }

        public void addAll(@NotNull Collection<File> files, @NotNull RootKind kind) {
            for (File each : files) {
                this.addItem(each.getPath(), new RootItem(each, kind));
            }
        }

        public void accept(@NotNull Visitor visitor) {
            visitor.enter();
            if (visitor.visit(this.getItems())) {
                for (RootTree each : this.getChildren()) {
                    each.accept(visitor);
                }
            }
            visitor.exit();
        }

        public static interface Visitor {
            public void enter();

            public boolean visit(@NotNull Set<RootItem> var1);

            public void exit();
        }
    }

    private static class RootItem {
        @NotNull
        final File file;
        @NotNull
        final RootKind kind;

        RootItem(@NotNull File file, @NotNull RootKind kind) {
            this.kind = kind;
            this.file = file;
        }

        @NotNull
        String getUrl() {
            return VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.file.getPath()));
        }
    }

    private static enum RootKind {
        CONTENT,
        SOURCE,
        SOURCE_GENERATED,
        LIBRARY,
        LIBRARY_EXCLUDE,
        EXPLICIT_SOURCE,
        EXPLICIT_LIBRARY,
        EXPLICIT_EXCLUDE;

    }

    public static class RootsInfo {
        @NotNull
        public final List<File> watchRoots = new ArrayList<File>();
        @NotNull
        public final List<File> contentRoots = new ArrayList<File>();
        @NotNull
        public final List<File> sourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> generatedSourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> explicitSourceFolders = new ArrayList<File>();
        @NotNull
        public final List<File> explicitLibraryRoots = new ArrayList<File>();
        @NotNull
        public final List<File> explicitExcludeFolders = new ArrayList<File>();
        @NotNull
        public final HeaderSearchRoots headerSearchRoots = new HeaderSearchRoots();
        public boolean registerSystemHeaderRootUnderContentRootAsLibraries = false;

        public void fillHeaderSearchRoots(@NotNull Collection<? extends HeadersSearchRoot> headerRoots) {
            OCRootsSynchronizer.collectHeaderSearchRoots(headerRoots, this.headerSearchRoots);
        }
    }

    public static class HeaderSearchRoots {
        @NotNull
        public final List<File> systemHeaderRoots = new ArrayList<File>();
        @NotNull
        public final List<File> userHeaderRoots = new ArrayList<File>();
        @NotNull
        public final List<File> excludeRoots = new ArrayList<File>();
    }
}

