/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.esotericsoftware.kryo.io.FastOutput;
import com.intellij.configurationStore.SettingsSavingComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.CompilerSettingsData;
import com.jetbrains.cidr.lang.workspace.ConfigurationData;
import com.jetbrains.cidr.lang.workspace.Internary;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurationImpl;
import com.jetbrains.cidr.lang.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceEventImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceFileMapper;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackersImpl;
import com.jetbrains.cidr.lang.workspace.OWorkspaceSerializer;
import com.jetbrains.cidr.lang.workspace.PrecompiledIncludeMap;
import com.jetbrains.cidr.lang.workspace.SourceData;
import com.jetbrains.cidr.lang.workspace.StateHolder;
import com.jetbrains.cidr.lang.workspace.WorkspaceData;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoots;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002DEB\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020%0)H\u0016J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020%0)2\b\u0010+\u001a\u0004\u0018\u00010\u0018H\u0016J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0017J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0007H\u0016J\b\u00101\u001a\u000202H\u0016J\f\u00103\u001a\b\u0012\u0004\u0012\u00020-0\u0017J\f\u00104\u001a\b\u0012\u0004\u0012\u00020-0\u0017J\b\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002062\u0006\u00108\u001a\u000209H\u0002J\u0011\u0010:\u001a\u000206H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0006\u0010<\u001a\u000206J\u001d\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020#H\u0000\u00a2\u0006\u0002\b@J\u0018\u0010A\u001a\u0002062\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020CH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006F"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace;", "Lcom/intellij/configurationStore/SettingsSavingComponent;", "Lcom/intellij/openapi/components/BaseComponent;", "project", "Lcom/intellij/openapi/project/Project;", "initialized", "", "(Lcom/intellij/openapi/project/Project;Z)V", "(Lcom/intellij/openapi/project/Project;)V", "_state", "Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "modificationTrackersImpl", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackersImpl;", "getProject$intellij_c", "()Lcom/intellij/openapi/project/Project;", "serializer", "Lcom/jetbrains/cidr/lang/workspace/OWorkspaceSerializer;", "getSerializer", "()Lcom/jetbrains/cidr/lang/workspace/OWorkspaceSerializer;", "serializer$delegate", "Lkotlin/Lazy;", "sources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSources", "()Ljava/util/Collection;", "state", "getState", "()Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "stateFile", "Ljava/nio/file/Path;", "getStateFile", "()Ljava/nio/file/Path;", "getClientVersion", "", "getConfigurationById", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "id", "", "getConfigurations", "", "getConfigurationsForFile", "sourceFile", "getHeaderExcludeRoots", "Ljava/io/File;", "getModifiableModel", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "clear", "getModificationTrackers", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers;", "getSystemHeaderRoots", "getUserHeaderRoots", "initComponent", "", "read", "ins", "Ljava/io/DataInputStream;", "save", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setInitialized", "updateState", "newState", "diff", "updateState$intellij_c", "write", "out", "Ljava/io/DataOutputStream;", "Companion", "ModifiableModelImpl", "intellij.c"})
public final class OCWorkspaceImpl
implements OCWorkspace,
SettingsSavingComponent,
BaseComponent {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private volatile boolean initialized;
    private StateHolder _state;
    private final Lazy serializer$delegate;
    private final OCWorkspaceModificationTrackersImpl modificationTrackersImpl;
    @NotNull
    private final Project project;
    private static final int SERIALIZATION_VERSION = 24;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(OCWorkspaceImpl.class), "serializer", "getSerializer()Lcom/jetbrains/cidr/lang/workspace/OWorkspaceSerializer;"))};
        Companion = new Companion(null);
    }

    private final StateHolder getState() {
        return this._state;
    }

    private final OWorkspaceSerializer getSerializer() {
        Lazy lazy = this.serializer$delegate;
        OCWorkspaceImpl oCWorkspaceImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (OWorkspaceSerializer)lazy.getValue();
    }

    public final void setInitialized() {
        this.initialized = true;
    }

    @Override
    public int getClientVersion() {
        return this.getState().getWorkspaceData().getClientVersion();
    }

    @NotNull
    public final Collection<File> getSystemHeaderRoots() {
        return this.getState().getWorkspaceData().getSystemHeaderRoots();
    }

    @NotNull
    public final Collection<File> getUserHeaderRoots() {
        return this.getState().getWorkspaceData().getUserHeaderRoots();
    }

    @NotNull
    public final Collection<File> getHeaderExcludeRoots() {
        return this.getState().getWorkspaceData().getHeaderExcludeRoots();
    }

    @Override
    @NotNull
    public List<OCResolveConfiguration> getConfigurations() {
        return this.getState().getConfigurations();
    }

    @Override
    @Nullable
    public OCResolveConfiguration getConfigurationById(@NotNull String id) {
        return this.getState().getConfigurationsIds().get(id);
    }

    @Override
    @NotNull
    public List<OCResolveConfiguration> getConfigurationsForFile(@Nullable VirtualFile sourceFile) {
        Map<VirtualFile, List<OCResolveConfiguration>> map2 = this.getState().getSourceFilesToConfigurations();
        List list = map2.get(sourceFile);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Collection<VirtualFile> getSources() {
        return this.getState().getSourceFilesToConfigurations().keySet();
    }

    @Override
    @NotNull
    public OCWorkspace.ModifiableModel getModifiableModel(boolean clear) {
        StateHolder stateHolder;
        StateHolder $receiver = stateHolder = this.getState();
        boolean bl = false;
        return new ModifiableModelImpl(this, clear ? StateHolder.Companion.createNewEmptyState() : $receiver);
    }

    @Override
    @NotNull
    public OCWorkspaceModificationTrackers getModificationTrackers() {
        return this.modificationTrackersImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initComponent() {
        if (this.project.isDefault()) {
            return;
        }
        Path stateFile = this.getStateFile();
        if (OCWorkspaceImplKt.getCheckCachesValidity() && PathKt.exists((Path)OCWorkspaceImplKt.getCacheDirBrokenMarker())) {
            PathKt.delete$default((Path)OCWorkspaceImplKt.getCacheDir(), (boolean)false, (int)1, null);
        }
        if (PathKt.isFile((Path)stateFile)) {
            try {
                Closeable closeable = PathKt.inputStream((Path)stateFile);
                int n = 8192;
                BufferedInputStream bufferedInputStream = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                InputStream inputStream = bufferedInputStream;
                closeable = new DataInputStream(inputStream);
                Throwable throwable = null;
                try {
                    DataInputStream it = (DataInputStream)closeable;
                    boolean bl = false;
                    this.read(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                try {
                    String message = "Cannot load OCWorkspace: " + stateFile;
                    if (e instanceof IOException) {
                        OCWorkspaceImplUtilKt.getLOG().warn(message, e);
                    } else {
                        OCWorkspaceImplUtilKt.getLOG().error(message, e);
                    }
                }
                finally {
                    PathKt.delete$default((Path)stateFile, (boolean)false, (int)1, null);
                }
            }
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object save(@NotNull Continuation<? super Unit> continuation) {
        if (this.project.isDefault()) {
            return Unit.INSTANCE;
        }
        StateHolder state = this.getState();
        Path stateFile = this.getStateFile();
        if (state.getWorkspaceData().getClientVersion() == 0 && state.getConfigurations().isEmpty()) {
            PathKt.delete$default((Path)stateFile, (boolean)false, (int)1, null);
            return Unit.INSTANCE;
        }
        if (stateFile.toFile().lastModified() > state.getTimestamp()) {
            return Unit.INSTANCE;
        }
        try {
            Closeable closeable = PathKt.outputStream((Path)stateFile);
            int n = 8192;
            BufferedOutputStream bufferedOutputStream = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            OutputStream outputStream = bufferedOutputStream;
            closeable = new DataOutputStream(outputStream);
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)closeable;
                boolean bl = false;
                this.write(state, it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            OCWorkspaceImplUtilKt.getLOG().warn("Cannot save OCWorkspace: " + stateFile, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            OCWorkspaceImplUtilKt.getLOG().warn("Cannot save OCWorkspace: " + stateFile, (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final Path getStateFile() {
        return OCWorkspaceImplKt.stateFile(this.project);
    }

    /*
     * WARNING - void declaration
     */
    private final void write(StateHolder state, DataOutputStream out) throws IOException {
        Collection<ConfigurationData> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        StateHolder stateHolder;
        StateHolder $receiver = stateHolder = state;
        boolean bl = false;
        out.writeInt(24);
        out.writeLong(state.getTimestamp());
        Iterable iterable = $receiver.getConfigurations();
        WorkspaceData workspaceData = $receiver.getWorkspaceData();
        OutputStream outputStream = out;
        OWorkspaceSerializer oWorkspaceSerializer = this.getSerializer();
        void var10_10 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            OCResolveConfigurationImpl oCResolveConfigurationImpl = (OCResolveConfigurationImpl)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            ConfigurationData configurationData = it.getData$intellij_c();
            collection.add(configurationData);
        }
        collection = (List)destination$iv$iv;
        oWorkspaceSerializer.writeStateData(outputStream, workspaceData, (List<ConfigurationData>)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void read(DataInputStream ins) throws IOException {
        Disposable disposable;
        block7: {
            disposable = Disposer.newDisposable();
            int internalVersion = ins.readInt();
            if (internalVersion == 24) break block7;
            Disposable disposable2 = disposable;
            if (disposable2 != null) {
                Disposable disposable3;
                Disposable it = disposable3 = disposable2;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            return;
        }
        try {
            Collection<OCResolveConfigurationImpl> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            long timestamp = ins.readLong();
            OWorkspaceSerializer oWorkspaceSerializer = this.getSerializer();
            InputStream inputStream = ins;
            OCWorkspaceFileMapper oCWorkspaceFileMapper = OCWorkspaceImplUtilKt.createFileMapper();
            Disposable disposable4 = disposable;
            if (disposable4 == null) {
                Intrinsics.throwNpe();
            }
            Pair<WorkspaceData, List<ConfigurationData>> dataAndConfigs = oWorkspaceSerializer.readStateData(inputStream, this.project, oCWorkspaceFileMapper, disposable4);
            Internary internator = new Internary();
            Iterable iterable = (Iterable)dataAndConfigs.second;
            WorkspaceData workspaceData = ((WorkspaceData)dataAndConfigs.first).unmodifiableCopy();
            long l = timestamp;
            Companion companion = Companion;
            OCWorkspaceImpl oCWorkspaceImpl = this;
            void var9_19 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ConfigurationData configurationData = (ConfigurationData)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                OCResolveConfigurationImpl oCResolveConfigurationImpl = new OCResolveConfigurationImpl(this, it.unmodifiableCopy(internator));
                collection.add(oCResolveConfigurationImpl);
            }
            collection = (List)destination$iv$iv;
            oCWorkspaceImpl.updateState$intellij_c(companion.newStateWith$intellij_c(l, workspaceData, (List<OCResolveConfigurationImpl>)collection, disposable), 0);
            disposable = null;
        }
        catch (Throwable throwable) {
            Disposable disposable5 = disposable;
            if (disposable5 != null) {
                Disposable disposable6;
                Disposable it = disposable6 = disposable5;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            throw throwable;
        }
    }

    public final void updateState$intellij_c(@NotNull StateHolder newState, int diff2) {
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)newState.getDisposable());
        StateHolder oldState = this._state;
        this._state = newState;
        Disposer.dispose((Disposable)oldState.getDisposable());
        if (this.initialized && diff2 != 0) {
            this.modificationTrackersImpl.fireWorkspaceChanged(new OCWorkspaceEventImpl((diff2 & 1) == 1, (diff2 & 2) == 2, (diff2 & 4) == 4));
        }
    }

    @NotNull
    public final Project getProject$intellij_c() {
        return this.project;
    }

    public OCWorkspaceImpl(@NotNull Project project2) {
        this.project = project2;
        this._state = StateHolder.Companion.createNewEmptyState();
        this.serializer$delegate = LazyKt.lazy((Function0)serializer.2.INSTANCE);
        this.modificationTrackersImpl = new OCWorkspaceModificationTrackersImpl(this.project);
    }

    public OCWorkspaceImpl(@NotNull Project project2, boolean initialized) {
        this(project2);
        this.initialized = initialized;
    }

    @JvmStatic
    @NotNull
    public static final OCWorkspaceImpl getInstanceImpl(@NotNull Project project2) {
        return Companion.getInstanceImpl(project2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001)B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0016J\b\u0010#\u001a\u00020\u001dH\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0016H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$ModifiableModelImpl;", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "owner", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;", "originalState", "Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "(Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;Lcom/jetbrains/cidr/lang/workspace/StateHolder;)V", "configurations", "", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfigurationImpl$ModifiableModelImpl;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable$intellij_c", "()Lcom/intellij/openapi/Disposable;", "mutableData", "Lcom/jetbrains/cidr/lang/workspace/WorkspaceData;", "started", "", "state", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$ModifiableModelImpl$State;", "addConfiguration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration$ModifiableModel;", "id", "name", "variant", "Lcom/jetbrains/cidr/lang/workspace/OCVariant;", "fileSeparators", "clear", "", "commit", "dispose", "getConfigurationById", "getConfigurations", "", "preCommit", "removeConfiguration", "configuration", "setClientVersion", "version", "", "State", "intellij.c"})
    public static final class ModifiableModelImpl
    implements OCWorkspace.ModifiableModel {
        private final long started;
        private State state;
        @NotNull
        private final Disposable disposable;
        private final WorkspaceData mutableData;
        private final Map<String, OCResolveConfigurationImpl.ModifiableModelImpl> configurations;
        private final OCWorkspaceImpl owner;

        @NotNull
        public final Disposable getDisposable$intellij_c() {
            return this.disposable;
        }

        @Override
        public void setClientVersion(int version) {
            this.mutableData.setClientVersion(version);
        }

        @Override
        public void clear() {
            this.mutableData.clear();
            this.configurations.clear();
        }

        @Override
        @NotNull
        public List<OCResolveConfiguration.ModifiableModel> getConfigurations() {
            return Collections.unmodifiableList(CollectionsKt.toList((Iterable)this.configurations.values()));
        }

        @Override
        @Nullable
        public OCResolveConfiguration.ModifiableModel getConfigurationById(@NotNull String id) {
            return this.configurations.get(id);
        }

        @Override
        @NotNull
        public OCResolveConfiguration.ModifiableModel addConfiguration(@NotNull String id, @NotNull String name2, @Nullable OCVariant variant, @NotNull String fileSeparators) {
            if (this.configurations.containsKey(id)) {
                throw (Throwable)new IllegalStateException("Configuration with id '" + id + "' already exists");
            }
            String displayName2 = OCResolveConfigurationImpl.Companion.getConfigurationDisplayName(name2, variant);
            ConfigurationData data = new ConfigurationData(id, name2, variant, displayName2, fileSeparators, new CompilerSettingsData(), MapsKt.emptyMap(), MapsKt.emptyMap(), new PrecompiledIncludeMap(MapsKt.emptyMap()), null, null);
            OCResolveConfigurationImpl config = new OCResolveConfigurationImpl(this.owner, data);
            OCResolveConfigurationImpl.ModifiableModelImpl model = new OCResolveConfigurationImpl.ModifiableModelImpl(config, this.disposable);
            Map<String, OCResolveConfigurationImpl.ModifiableModelImpl> map2 = this.configurations;
            String string = model.getUniqueId();
            OCResolveConfigurationImpl.ModifiableModelImpl modifiableModelImpl = model;
            map2.put(string, modifiableModelImpl);
            return model;
        }

        @Override
        public void removeConfiguration(@NotNull OCResolveConfiguration.ModifiableModel configuration) {
            this.configurations.remove(configuration.getUniqueId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void preCommit() {
            void rootsTime;
            void digestTime;
            void counter;
            OCWorkspaceImplUtilKt.checkNoDispatch();
            if (this.state != State.DEFAULT) {
                OCWorkspaceImplUtilKt.getLOG().error("Wrong state: " + (Object)((Object)this.state));
                return;
            }
            this.state = State.PRE_COMMITTED;
            THashSet alreadyProcessedRoots = new THashSet();
            OCRootsSynchronizer.HeaderSearchRoots rootsCollector = new OCRootsSynchronizer.HeaderSearchRoots();
            OWorkspaceSerializer serializer2 = new OWorkspaceSerializer(true);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (messageDigest == null) {
                Intrinsics.throwNpe();
            }
            MessageDigest digest = messageDigest;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Ref.LongRef longRef = new Ref.LongRef();
            longRef.element = 0L;
            Ref.LongRef longRef2 = new Ref.LongRef();
            longRef2.element = 0L;
            Closeable closeable = (Closeable)new FastOutput(65536, -1);
            Throwable throwable = null;
            try {
                FastOutput output = (FastOutput)closeable;
                boolean bl = false;
                Iterable $receiver$iv = this.configurations.values();
                for (Object element$iv : $receiver$iv) {
                    SourceData it;
                    OCResolveConfigurationImpl.ModifiableModelImpl config = (OCResolveConfigurationImpl.ModifiableModelImpl)element$iv;
                    boolean bl2 = false;
                    THashSet allConfigPchFiles = new THashSet();
                    config.getCompilerSettingsToCollect$intellij_c().forEach(new Consumer<OCResolveConfigurationImpl.ModifiableModelImpl.UniqueCompilerSettings>(allConfigPchFiles, output, this, (Ref.IntRef)counter, serializer2, digest, (Ref.LongRef)digestTime, alreadyProcessedRoots, rootsCollector, (Ref.LongRef)rootsTime){
                        final /* synthetic */ THashSet $allConfigPchFiles;
                        final /* synthetic */ FastOutput $output$inlined;
                        final /* synthetic */ ModifiableModelImpl this$0;
                        final /* synthetic */ Ref.IntRef $counter$inlined;
                        final /* synthetic */ OWorkspaceSerializer $serializer$inlined;
                        final /* synthetic */ MessageDigest $digest$inlined;
                        final /* synthetic */ Ref.LongRef $digestTime$inlined;
                        final /* synthetic */ THashSet $alreadyProcessedRoots$inlined;
                        final /* synthetic */ OCRootsSynchronizer.HeaderSearchRoots $rootsCollector$inlined;
                        final /* synthetic */ Ref.LongRef $rootsTime$inlined;
                        {
                            this.$allConfigPchFiles = tHashSet;
                            this.$output$inlined = fastOutput;
                            this.this$0 = modifiableModelImpl;
                            this.$counter$inlined = intRef;
                            this.$serializer$inlined = oWorkspaceSerializer;
                            this.$digest$inlined = messageDigest;
                            this.$digestTime$inlined = longRef;
                            this.$alreadyProcessedRoots$inlined = tHashSet2;
                            this.$rootsCollector$inlined = headerSearchRoots;
                            this.$rootsTime$inlined = longRef2;
                        }

                        public final void accept(OCResolveConfigurationImpl.ModifiableModelImpl.UniqueCompilerSettings it) {
                            int n = this.$counter$inlined.element;
                            this.$counter$inlined.element = n + 1;
                            long before = System.currentTimeMillis();
                            try {
                                it.getMergedSettings().setCalculatedCompilerKey(null);
                                this.$serializer$inlined.writeCompilerSettingsDataDirectly(this.$output$inlined, it.getLanguageKind(), it.getMergedSettings());
                                this.$digest$inlined.update(this.$output$inlined.getBuffer(), 0, this.$output$inlined.position());
                                it.getOriginalSettings().setCalculatedCompilerKey(new CompilerSettingsKey(StringUtil.toHexString((byte[])this.$digest$inlined.digest())));
                                this.$digest$inlined.reset();
                                this.$output$inlined.clear();
                                this.$digestTime$inlined.element += System.currentTimeMillis() - before;
                            }
                            catch (IOException e) {
                                throw (Throwable)new RuntimeException(e);
                            }
                            List<VirtualFile> list = it.getMergedSettings().getPchFiles();
                            if (list != null) {
                                List<VirtualFile> it2 = e = list;
                                boolean bl = false;
                                this.$allConfigPchFiles.addAll((Collection)it2);
                            }
                            before = System.currentTimeMillis();
                            HeadersSearchRoots headersSearchRoots = it.getMergedSettings().getHeaderSearchRoots();
                            List<E> list2 = headersSearchRoots != null ? headersSearchRoots.getAllRoots() : null;
                            List<E> list3 = list2;
                            if (list3 == null) {
                                list3 = CollectionsKt.emptyList();
                            }
                            for (HeadersSearchRoot eachRoot : list3) {
                                ProgressManager.checkCanceled();
                                if (!this.$alreadyProcessedRoots$inlined.add((Object)((Object)eachRoot))) continue;
                                OCRootsSynchronizer.collectHeaderSearchRoots(eachRoot, this.$rootsCollector$inlined);
                            }
                            this.$rootsTime$inlined.element += System.currentTimeMillis() - before;
                        }
                    });
                    THashSet tHashSet = new THashSet((Collection)config.getMutableData$intellij_c().getLanguagesData().keySet());
                    ConfigurationData configurationData = config.getMutableData$intellij_c();
                    THashSet $receiver = tHashSet;
                    boolean bl3 = false;
                    Iterable $receiver$iv2 = config.getMutableData$intellij_c().getSourcesData().values();
                    for (Object element$iv2 : $receiver$iv2) {
                        it = (SourceData)element$iv2;
                        boolean bl4 = false;
                        $receiver.add((Object)it.getLanguageKind());
                    }
                    THashSet tHashSet2 = tHashSet;
                    configurationData.setCalculatedEnabledLanguages((Set)tHashSet2);
                    tHashSet = new THashSet();
                    configurationData = config.getMutableData$intellij_c();
                    $receiver = tHashSet;
                    boolean bl5 = false;
                    config.getMutableData$intellij_c().getLanguagesData().forEach(new BiConsumer<OCLanguageKind, CompilerSettingsData>($receiver){
                        final /* synthetic */ THashSet $this_apply;

                        public final void accept(@NotNull OCLanguageKind langKind, @NotNull CompilerSettingsData settings) {
                            if (settings.hasCustomSettings()) {
                                this.$this_apply.add((Object)langKind);
                            }
                        }
                        {
                            this.$this_apply = tHashSet;
                        }
                    });
                    $receiver$iv2 = config.getMutableData$intellij_c().getSourcesData().values();
                    for (Object element$iv2 : $receiver$iv2) {
                        it = (SourceData)element$iv2;
                        boolean bl6 = false;
                        $receiver.add((Object)it.getLanguageKind());
                    }
                    tHashSet2 = tHashSet;
                    configurationData.setCalculatedEnabledLanguages((Set)tHashSet2);
                    config.getMutableData$intellij_c().setCalculatedAllPchFiles((Set)allConfigPchFiles);
                }
                output = Unit.INSTANCE;
            }
            catch (Throwable output) {
                throwable = output;
                throw output;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (OCWorkspaceImplUtilKt.getLOG().isDebugEnabled()) {
                OCWorkspaceImplUtilKt.getLOG().debug("Compiler key calculation for " + counter.element + " settings took " + StringUtil.formatDuration((long)digestTime.element));
                OCWorkspaceImplUtilKt.getLOG().debug("Roots collection tool took " + StringUtil.formatDuration((long)rootsTime.element));
            }
            Set<File> set = this.mutableData.getSystemHeaderRoots();
            if (set == null) {
                throw new TypeCastException("null cannot be cast to non-null type gnu.trove.THashSet<java.io.File>");
            }
            Closeable $receiver = closeable = (THashSet)set;
            boolean bl = false;
            $receiver.clear();
            $receiver.addAll(rootsCollector.systemHeaderRoots);
            Set<File> set2 = this.mutableData.getUserHeaderRoots();
            if (set2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type gnu.trove.THashSet<java.io.File>");
            }
            $receiver = closeable = (THashSet)set2;
            boolean bl7 = false;
            $receiver.clear();
            $receiver.addAll(rootsCollector.userHeaderRoots);
            Set<File> set3 = this.mutableData.getHeaderExcludeRoots();
            if (set3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type gnu.trove.THashSet<java.io.File>");
            }
            $receiver = closeable = (THashSet)set3;
            boolean bl8 = false;
            $receiver.clear();
            $receiver.addAll(rootsCollector.excludeRoots);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void commit() {
            void $receiver$iv$iv;
            Object newConfig;
            void $receiver$iv$iv2;
            ConfigurationData configurationData;
            Object object;
            Object object2;
            Object object3;
            OCResolveConfigurationImpl.ModifiableModelImpl it$iv$iv;
            void $receiver$iv$iv3;
            Map<String, OCResolveConfigurationImpl> configurationsIds;
            Map<String, OCResolveConfigurationImpl> $receiver$iv;
            if (this.state != State.PRE_COMMITTED) {
                OCWorkspaceImplUtilKt.getLOG().error("Wrong state: " + (Object)((Object)this.state));
                return;
            }
            this.state = State.COMMITTED;
            Internary internary = new Internary();
            Map<String, OCResolveConfigurationImpl> map2 = $receiver$iv = (configurationsIds = this.owner.getState().getConfigurationsIds());
            Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv3.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                Object k = it$iv$iv.getKey();
                object3 = (Map.Entry)element$iv$iv$iv;
                object2 = k;
                object = map3;
                boolean bl = false;
                configurationData = ((OCResolveConfigurationImpl)it.getValue()).getData$intellij_c();
                object.put(object2, configurationData);
            }
            Map oldConfigData = destination$iv$iv;
            Iterable $receiver$iv2 = this.configurations.values();
            destination$iv$iv = $receiver$iv2;
            Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void model;
                it$iv$iv = (OCResolveConfigurationImpl.ModifiableModelImpl)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                model.commit$intellij_c(internary);
                newConfig = model.getOwner$intellij_c();
                OCResolveConfigurationImpl oldConfig = configurationsIds.get(((OCResolveConfigurationImpl)newConfig).getUniqueId());
                if (oldConfig != null) {
                    oldConfig.setData$intellij_c(((OCResolveConfigurationImpl)newConfig).getData$intellij_c());
                    newConfig = oldConfig;
                }
                object2 = newConfig;
                object.add(object2);
            }
            List unmodifiableConfigs = (List)destination$iv$iv2;
            Map<String, OCResolveConfigurationImpl.ModifiableModelImpl> $receiver$iv3 = this.configurations;
            destination$iv$iv2 = $receiver$iv3;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv3.size()));
            Iterable $receiver$iv$iv$iv2 = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv2) {
                void it;
                void it$iv$iv2;
                newConfig = (Map.Entry)element$iv$iv$iv;
                object3 = destination$iv$iv3;
                Object k = it$iv$iv2.getKey();
                Map.Entry $i$f$map = (Map.Entry)element$iv$iv$iv;
                object2 = k;
                object = object3;
                boolean bl = false;
                configurationData = ((OCResolveConfigurationImpl.ModifiableModelImpl)it.getValue()).getOwner$intellij_c().getData$intellij_c();
                object.put(object2, configurationData);
            }
            Map newConfigData = destination$iv$iv3;
            int diff2 = OCWorkspaceImplKt.mapDiff(oldConfigData, newConfigData, 1, commit.diff.1.INSTANCE);
            this.owner.updateState$intellij_c(Companion.newStateWith$intellij_c(System.currentTimeMillis(), this.mutableData.unmodifiableCopy(), ContainerUtil.unmodifiableOrEmptyList((List)unmodifiableConfigs), this.disposable), diff2);
            if (OCWorkspaceImplUtilKt.getLOG().isDebugEnabled()) {
                OCWorkspaceImplUtilKt.getLOG().debug("OCWorkspace setup took  " + StringUtil.formatDuration((long)(System.currentTimeMillis() - this.started)));
            }
        }

        @Override
        public void dispose() {
            if (this.state == State.COMMITTED) {
                return;
            }
            Disposer.dispose((Disposable)this.disposable);
        }

        /*
         * WARNING - void declaration
         */
        public ModifiableModelImpl(@NotNull OCWorkspaceImpl owner2, @NotNull StateHolder originalState) {
            Map map2;
            void $receiver$iv$iv;
            void $receiver$iv;
            this.owner = owner2;
            this.started = System.currentTimeMillis();
            this.state = State.DEFAULT;
            this.disposable = Disposer.newDisposable();
            this.mutableData = originalState.getWorkspaceData().mutableCopy();
            Map<String, OCResolveConfigurationImpl> map3 = originalState.getConfigurationsIds();
            ModifiableModelImpl modifiableModelImpl = this;
            void var4_5 = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map2 = map4;
                boolean bl = false;
                OCResolveConfigurationImpl.ModifiableModelImpl modifiableModelImpl2 = new OCResolveConfigurationImpl.ModifiableModelImpl((OCResolveConfigurationImpl)it.getValue(), this.disposable);
                map2.put(k2, modifiableModelImpl2);
            }
            map2 = destination$iv$iv;
            modifiableModelImpl.configurations = MapsKt.toMutableMap((Map)map2);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$ModifiableModelImpl$State;", "", "(Ljava/lang/String;I)V", "DEFAULT", "PRE_COMMITTED", "COMMITTED", "intellij.c"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State DEFAULT;
            public static final /* enum */ State PRE_COMMITTED;
            public static final /* enum */ State COMMITTED;
            private static final /* synthetic */ State[] $VALUES;

            static {
                State[] stateArray = new State[3];
                State[] stateArray2 = stateArray;
                stateArray[0] = DEFAULT = new State();
                stateArray[1] = PRE_COMMITTED = new State();
                stateArray[2] = COMMITTED = new State();
                $VALUES = stateArray;
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$Companion;", "", "()V", "SERIALIZATION_VERSION", "", "getInstanceImpl", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "newStateWith", "Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "timestamp", "", "unmodifiableData", "Lcom/jetbrains/cidr/lang/workspace/WorkspaceData;", "unmodifiableConfigurations", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfigurationImpl;", "disposable", "Lcom/intellij/openapi/Disposable;", "newStateWith$intellij_c", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final OCWorkspaceImpl getInstanceImpl(@NotNull Project project2) {
            Object object = project2.getComponent(OCWorkspace.class);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl");
            }
            return (OCWorkspaceImpl)object;
        }

        @NotNull
        public final StateHolder newStateWith$intellij_c(long timestamp, @NotNull WorkspaceData unmodifiableData, @NotNull List<OCResolveConfigurationImpl> unmodifiableConfigurations, @NotNull Disposable disposable) {
            ArrayList<OCResolveConfigurationImpl> configs = new ArrayList<OCResolveConfigurationImpl>(unmodifiableConfigurations.size());
            THashMap configsIds = new THashMap(unmodifiableConfigurations.size());
            THashMap sourceFilesToConfigs = new THashMap();
            Iterable $receiver$iv = unmodifiableConfigurations;
            for (Object element$iv : $receiver$iv) {
                OCResolveConfigurationImpl config = (OCResolveConfigurationImpl)element$iv;
                boolean bl = false;
                configs.add(config);
                Map map2 = (Map)configsIds;
                String string = config.getUniqueId();
                OCResolveConfigurationImpl oCResolveConfigurationImpl = config;
                map2.put(string, oCResolveConfigurationImpl);
                for (VirtualFile eachSourceFile : config.getSources()) {
                    List fileConfigs = (List)sourceFilesToConfigs.get((Object)eachSourceFile);
                    if (fileConfigs == null) {
                        fileConfigs = new ArrayList();
                        Map map3 = (Map)sourceFilesToConfigs;
                        List list = fileConfigs;
                        map3.put(eachSourceFile, list);
                    }
                    fileConfigs.add(config);
                }
            }
            sourceFilesToConfigs.compact();
            for (Map.Entry each : sourceFilesToConfigs.entrySet()) {
                List value;
                List list = value = (List)each.getValue();
                if (list == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.ArrayList<*> /* = java.util.ArrayList<*> */");
                }
                ((ArrayList)list).trimToSize();
                each.setValue(ContainerUtil.unmodifiableOrEmptyList((List)value));
            }
            return new StateHolder(timestamp, unmodifiableData, ContainerUtil.unmodifiableOrEmptyList((List)configs), ContainerUtil.unmodifiableOrEmptyMap((Map)((Map)configsIds)), ContainerUtil.unmodifiableOrEmptyMap((Map)((Map)sourceFilesToConfigs)), disposable);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

