/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GCCCompiler
extends OCCompilerBase {
    private static final String COMMAND_PREFIX = "____CIDR_command_";
    private static final Pattern COMMAND_PATTERN = Pattern.compile("^____CIDR_command_(\\w+)->([^=]+)=(.+)$");
    public static final String QUOTES = "[\u2018\u2019`'\"]";
    private static final Pattern[] BAD_SWITCH_FILTER_RULES = new Pattern[]{Pattern.compile(".*error:.*?(-+\\S+) is not supported.*"), Pattern.compile(".*error:.*?[\u2018\u2019`'\"](-.+?)[\u2018\u2019`'\"].*"), Pattern.compile(".*error:\\s(.+):\\sNo such file or directory"), Pattern.compile(".*error: [\u2018\u2019`'\"](.+?)[\u2018\u2019`'\"].* not found")};
    private static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile("# 1 \"(.*)\" 1\\s*[\\r\\n]");
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile(".*:(?:\\s|(?:\\\\[\\r\\n]))+((?:[\\S&&[^\\\\]]+(?:\\\\[ ]?)*)*)");
    static final String CIDR_DEFINITIONS_END = "___CIDR_DEFINITIONS_END";
    static final String CIDR_FEATURES_START = "___CIDR_FEATURES_START";
    private static final String UNSUPPORTED_COMPILER = "This compiler might be unsupported.\nIf you are using GCC/Clang, please report the bug in https://youtrack.jetbrains.com/issues/CPP.";
    private static final Map<String, OCCompilerFeatures.Feature> featureFlags = new LinkedHashMap<String, OCCompilerFeatures.Feature>();

    public GCCCompiler(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env) {
        super(executable, workingDirectory, env);
    }

    @Nullable
    public String readVersion() {
        return this.doReadVersion(Collections.singletonList("--version"), (Function<ProcessOutput, String>)((Function)output -> {
            List lines = output.getStdoutLines();
            for (String each : lines) {
                if (StringUtil.isEmptyOrSpaces((String)each)) continue;
                return each;
            }
            return null;
        }));
    }

    @NotNull
    public static String getLanguageOption(@NotNull OCLanguageKind kind) {
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    return "-xc";
                }
                case OBJ_C: {
                    return "-xobjective-c";
                }
                case CPP: {
                    return "-xc++";
                }
                case OBJ_CPP: {
                    return "-xobjective-c++";
                }
            }
        }
        return "";
    }

    @Nullable
    public static OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        for (int i = 0; i < switches.size(); ++i) {
            String currentSwitch = switches.get(i);
            if (!currentSwitch.startsWith("-x")) continue;
            OCLanguageKind kind = GCCCompiler.resolveOptionLanguage(currentSwitch = currentSwitch.substring(2));
            if (kind != null) {
                return kind;
            }
            if (StringUtil.isEmptyOrSpaces((String)currentSwitch) && i < switches.size() - 1) {
                kind = GCCCompiler.resolveOptionLanguage(switches.get(i + 1));
            }
            return kind;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind resolveOptionLanguage(@NotNull String option) {
        String langName = option.trim();
        if ("objective-c".equals(langName)) {
            return CLanguageKind.OBJ_C;
        }
        if ("objective-c++".equals(langName)) {
            return CLanguageKind.OBJ_CPP;
        }
        if ("c".equals(langName)) {
            return CLanguageKind.C;
        }
        if ("c++".equals(langName)) {
            return CLanguageKind.CPP;
        }
        return null;
    }

    @NotNull
    protected CompilerSpecificSwitchBuilder getSwitchBuilder() {
        return new GCCSwitchBuilder();
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        ArrayList<String> warnLog = new ArrayList<String>();
        try {
            switches = switches.expandResponseFiles(this.myWorkingDirectory, this.myEnvironment, CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot expand response files in " + switches.getCommandLineString(CidrCompilerSwitches.Format.RAW), (Throwable)e);
        }
        CidrCompilerSwitches requestSwitches = this.getSwitchBuilder().withLanguageKind(languageKind).withSwitches(switches).withSwitch("-fpch-preprocess").withSwitch("-v").withSwitch("-dD").withSwitch("-E").withMacro(CIDR_DEFINITIONS_END).build();
        ProcessOutput output = this.runGCC(this.myEnvironment, requestSwitches, GCCCompiler.buildFeaturesCheckText(), warnLog);
        OutputSections sections = GCCCompiler.splitOutput(output.getStdout(), warnLog);
        Pair<String, Map<OCCompilerFeatures.Type<?>, Object>> definesAndFeatures = GCCCompiler.collectDefinitionsAndFeatures(sections, warnLog);
        String defines = (String)definesAndFeatures.first;
        Map features = (Map)definesAndFeatures.second;
        boolean isClang = GCCCompiler.isClang(defines);
        GCCCompiler.collectDiagnostics(switches, isClang, features);
        GCCCompiler.collectFeatureFlags(switches, features);
        boolean shouldEnableFrameworksWorkaround = this.myEnvironment.getHostMachine().getOSType() == OSType.MAC && !isClang;
        List<HeadersSearchPath> headersSearchPaths = GCCCompiler.collectHeaderSearchPaths(output, shouldEnableFrameworksWorkaround, this.myEnvironment, this.myWorkingDirectory);
        List<File> precompiledHeaders = this.getPrecompiledHeaders(switches, this.myEnvironment, sections.preprocessed, warnLog);
        GCCCompiler.addEmulatedWarning(warnLog);
        return new CompilerInfo(switches, defines, features, headersSearchPaths, precompiledHeaders, Collections.emptyList(), warnLog, output.getExitCode());
    }

    @NotNull
    static OutputSections splitOutput(String output, List<String> warnLog) {
        String defines;
        String preprocessed = "";
        String featureChecks = "";
        int definesEnd = output.indexOf(CIDR_DEFINITIONS_END);
        int featuresStart = output.indexOf(CIDR_FEATURES_START);
        Function lineStart = index -> {
            while (index > 0 && !StringUtil.isLineBreak((char)output.charAt(index - 1))) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index - 1);
            }
            return index;
        };
        if (definesEnd >= 0 && featuresStart >= 0) {
            defines = output.substring(0, (Integer)lineStart.fun((Object)definesEnd));
            preprocessed = output.substring(definesEnd + CIDR_DEFINITIONS_END.length() + 1, (Integer)lineStart.fun((Object)featuresStart));
            featureChecks = output.substring(featuresStart + CIDR_FEATURES_START.length() + 1);
        } else {
            warnLog.add("Unexpected compiler output. This compiler might be unsupported.\nIf you are using GCC/Clang, please report the bug in https://youtrack.jetbrains.com/issues/CPP.");
            LOG.warn("Unexpected compiler output: CIDR_DEFINITIONS_END=" + definesEnd + " CIDR_FEATURES_START=" + featuresStart);
            defines = output;
        }
        return new OutputSections(defines, preprocessed, featureChecks);
    }

    private static boolean isClang(CharSequence defines) {
        return StringUtil.contains((CharSequence)defines, (CharSequence)"__clang_version__");
    }

    @NotNull
    private List<File> getPrecompiledHeaders(@NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment environment, @NotNull String preprocessed, @NotNull List<String> warnLog) {
        LinkedHashSet<File> result = new LinkedHashSet<File>(1);
        List<String> args = switches.getList(CidrCompilerSwitches.Format.RAW);
        boolean isFirst = true;
        for (int i = 0; i < args.size(); ++i) {
            String pathPCH;
            String arg = args.get(i);
            if (!arg.startsWith("-include")) continue;
            if (arg.equals("-include")) {
                if (++i >= args.size()) break;
                pathPCH = this.preparePath(environment, args.get(i));
            } else {
                pathPCH = this.preparePath(environment, arg.substring("-include".length()));
            }
            File pch = new File(pathPCH);
            if (!pch.exists() || pch.isDirectory()) {
                File file = pch = isFirst ? this.extractOriginalPrecompiledHeaderFile(preprocessed, environment, pch, warnLog) : null;
            }
            if (pch != null) {
                result.add(pch);
            }
            isFirst = false;
        }
        return new SmartList(result);
    }

    @Nullable
    private File extractOriginalPrecompiledHeaderFile(@NotNull String preprocessed, @NotNull CidrToolEnvironment env, @NotNull File pch, @NotNull List<String> warnLog) {
        Matcher matcher;
        boolean isGCC = preprocessed.contains("#pragma GCC pch_preprocess");
        if (!isGCC && (matcher = GCCCompiler.matchSafely(INCLUDE_FILE_PATTERN, preprocessed)).find()) {
            String unescaped = OCStringLiteralUtil.unescapeAnsiStringCharacters(matcher.group(1));
            String path = this.preparePath(env, unescaped);
            return new File(path);
        }
        File dependencyFile = null;
        if (!pch.isDirectory()) {
            dependencyFile = new File(pch.getAbsolutePath() + ".d");
        } else {
            File[] files = pch.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().endsWith(".d")) continue;
                    dependencyFile = file;
                    break;
                }
            }
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            try {
                String data = FileUtil.loadFile((File)dependencyFile);
                Matcher dependency = GCCCompiler.matchSafely(DEPENDENCY_PATTERN, data);
                if (dependency.find()) {
                    String path = dependency.group(1).replaceAll("\\\\[ ]", " ");
                    File result = new File(this.preparePath(env, path));
                    return result.exists() ? result : null;
                }
            }
            catch (IOException e) {
                String warn = "Dependency file (which is used to get the original file name of a precompiled header)\nis corrupted or has invalid permissions: " + dependencyFile + "\nplease run PCH compilation with -MD (or -MMD) flag.";
                warnLog.add(warn);
                return null;
            }
        }
        if (isGCC) {
            String warn = "Cannot get the original file name of the precompiled header: " + pch + "\nplease run PCH compilation with -MD (or -MMD) flag.";
            warnLog.add(warn);
        }
        return null;
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(ProcessOutput output, boolean enableFrameworksWorkaround, CidrToolEnvironment environment, File workingDirectory) {
        ArrayList<HeadersSearchPath> headersSearchPaths = new ArrayList<HeadersSearchPath>();
        ArrayList<HeadersSearchPath> additionalFrameworks = enableFrameworksWorkaround ? new ArrayList<HeadersSearchPath>() : null;
        Boolean userHeaders = null;
        for (String each : output.getStderrLines()) {
            String file;
            if ("#include \"...\" search starts here:".equals(each = each.trim())) {
                userHeaders = true;
                continue;
            }
            if ("#include <...> search starts here:".equals(each)) {
                userHeaders = false;
                continue;
            }
            if ("End of search list.".equals(each)) break;
            if (userHeaders == null) continue;
            String trimmed = StringUtil.trimEnd((String)each, (String)" (framework directory)");
            boolean isFramework = false;
            if (!each.equals(trimmed)) {
                each = trimmed;
                isFramework = true;
                enableFrameworksWorkaround = false;
            }
            if ((file = environment.toLocalPath(workingDirectory, each = StringUtil.nullize((String)each.trim(), (boolean)true))) == null) continue;
            String canonicalPath = environment.getHostMachine().toCanonicalPath(file, true);
            headersSearchPaths.add(new HeadersSearchPath(canonicalPath, false, (boolean)userHeaders, isFramework));
            if (!enableFrameworksWorkaround) continue;
            additionalFrameworks.add(new HeadersSearchPath(canonicalPath, false, (boolean)userHeaders, true));
        }
        if (enableFrameworksWorkaround && additionalFrameworks != null) {
            headersSearchPaths.addAll(additionalFrameworks);
        }
        return headersSearchPaths;
    }

    @NotNull
    static Pair<String, Map<OCCompilerFeatures.Type<?>, Object>> collectDefinitionsAndFeatures(@NotNull OutputSections output, List<String> warnLog) {
        StringBuilder defines = new StringBuilder();
        LinkedHashMap<Enum, Comparable<Short>> cidrFeatures = new LinkedHashMap<Enum, Comparable<Short>>();
        for (String eachLine : StringUtil.splitByLines((String)output.defines)) {
            if ((eachLine = eachLine.trim()).isEmpty() || !eachLine.startsWith("#define ")) continue;
            defines.append(eachLine).append("\n");
        }
        boolean isClang = GCCCompiler.isClang(defines);
        if (isClang) {
            defines.append(GCCCompiler.getClangTestMacros());
        }
        for (String eachLine : StringUtil.splitByLines((String)output.featureChecks)) {
            Command command;
            Matcher matcher = GCCCompiler.matchSafely(COMMAND_PATTERN, eachLine);
            if (!matcher.find()) continue;
            try {
                command = Command.valueOf(matcher.group(1));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected command: " + matcher.group(1));
                continue;
            }
            String key = matcher.group(2);
            String value = matcher.group(3);
            try {
                switch (command) {
                    case SET_TYPE_SIZE: {
                        try {
                            cidrFeatures.put(OCCompilerFeatures.TypeSize.valueOf(key), Short.valueOf(Short.parseShort(value)));
                        }
                        catch (NumberFormatException e) {
                            warnLog.add("Cannot determine type size for " + key + ":" + value + "\n" + UNSUPPORTED_COMPILER);
                        }
                        break;
                    }
                    case SET_FEATURE: {
                        cidrFeatures.put(OCCompilerFeatures.Feature.valueOf(key), Boolean.valueOf(value.equals("1")));
                        break;
                    }
                    case ADD_DEFINITION: {
                        defines.append("#define ").append(key).append(" ").append(value).append("\n");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                warnLog.add("Invalid query: \"" + eachLine + "\"");
            }
        }
        defines.append("#define __extension__\n");
        defines.append(GCCCompiler.getGCCBuiltInFunctionMacros());
        return new Pair((Object)defines.toString(), cidrFeatures);
    }

    private static String buildFeaturesCheckText() {
        StringBuilder result = new StringBuilder("#define ___CIDR_FEATURES_START\n");
        class QueryBuilder {
            final /* synthetic */ StringBuilder val$result;

            QueryBuilder(StringBuilder stringBuilder) {
                this.val$result = stringBuilder;
            }

            void appendTypeSizeQuery(@NotNull String macro, @NotNull OCCompilerFeatures.TypeSize type) {
                this.val$result.append("#if defined(").append(macro).append(")\n");
                this.appendCommand(Command.SET_TYPE_SIZE, type.name(), macro);
                this.val$result.append("#endif\n");
            }

            void appendBuiltinQuery(@NotNull String condition, @NotNull String emulationMacroName, boolean supported) {
                if (supported) {
                    this.val$result.append("#if ").append(condition).append("\n");
                    this.appendEmulationMacroCommand(emulationMacroName, "1");
                    this.val$result.append("#else\n");
                }
                this.appendEmulationMacroCommand(emulationMacroName, "0");
                if (supported) {
                    this.val$result.append("#endif\n");
                }
            }

            void appendSetFeatureCommand(@NotNull String condition, @NotNull OCCompilerFeatures.Feature cidrFeature) {
                this.val$result.append("#if ").append(condition).append("\n");
                this.appendCommand(Command.SET_FEATURE, cidrFeature.name(), "1");
                if (cidrFeature == OCCompilerFeatures.Feature.OBJC_BOOL) {
                    this.appendCommand(Command.ADD_DEFINITION, "__objc_no", "((BOOL)0)");
                    this.appendCommand(Command.ADD_DEFINITION, "__objc_yes", "((BOOL)1)");
                }
                this.val$result.append("#else\n");
                this.appendCommand(Command.SET_FEATURE, cidrFeature.name(), "0");
                this.val$result.append("#endif\n");
            }

            private void appendCommand(Command type, String key, String value) {
                this.val$result.append(GCCCompiler.COMMAND_PREFIX).append((Object)type).append("->").append(key).append("=").append(value).append("\n");
            }

            private void appendEmulationMacroCommand(@Nullable String emulationMacroName, String value) {
                if (emulationMacroName != null) {
                    this.appendCommand(Command.ADD_DEFINITION, emulationMacroName, value);
                }
            }
        }
        QueryBuilder queryBuilder = new QueryBuilder(result);
        result.append("#if __clang__\n");
        result.append("#if !(defined (__has_extension)) && defined(__has_feature)\n  #define __has_extension __has_feature\n#endif\n#if !defined(__has_attribute)\n  #define __has_attribute(x) 0\n#endif\n#if !defined(__has_builtin)\n  #define __has_builtin(x) 0\n#endif\n#if !defined(__is_identifier)\n  #define __is_identifier(x) 1\n#endif\n");
        ClangFeatures.getAllFeatures().forEach(each -> {
            boolean supported = !ClangFeatures.getUnsupportedClangFeatures().contains(each);
            String featureCondition = "__has_feature(" + each + ")";
            String extensionCondition = "__has_extension(" + each + ")";
            queryBuilder.appendBuiltinQuery(featureCondition, GCCCompiler.clangFeatureMacro(each), supported);
            queryBuilder.appendBuiltinQuery(extensionCondition, GCCCompiler.clangExtensionMacro(each), supported);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(each);
            if (cidrFeature != null) {
                queryBuilder.appendSetFeatureCommand(featureCondition + " || " + extensionCondition, cidrFeature);
            }
        });
        ClangFeatures.getAllBuiltins().forEach(each -> {
            String condition = "__has_builtin(" + each + ")";
            queryBuilder.appendBuiltinQuery(condition, GCCCompiler.clangBuiltinMacro(each), true);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(each);
            if (cidrFeature != null) {
                queryBuilder.appendSetFeatureCommand(condition, cidrFeature);
            }
        });
        ClangFeatures.getAllAttributes().forEach(each -> queryBuilder.appendBuiltinQuery("__has_attribute(" + each + ")", GCCCompiler.clangAttributeMacro(each), true));
        queryBuilder.appendSetFeatureCommand("!__is_identifier(__auto_type)", OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
        result.append("#else\n");
        result.append("#define __CIDR_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)\n");
        LinkedHashMap<OCCompilerFeatures.Feature, String> checks = new LinkedHashMap<OCCompilerFeatures.Feature, String>();
        checks.put(OCCompilerFeatures.Feature.GCC_AUTO_TYPE, "!defined(__cplusplus) && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.C_STATIC_ASSERT, "!defined(__cplusplus) && __STDC_VERSION__ >= 201112L && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_AUTO_TYPE, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_NULLPTR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_EXCEPTIONS, "defined(__cplusplus) && __EXCEPTIONS");
        checks.put(OCCompilerFeatures.Feature.CXX_CONSTEXPR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40500");
        checks.put(OCCompilerFeatures.Feature.CXX_USER_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.forEach((feature, check) -> queryBuilder.appendSetFeatureCommand((String)check, (OCCompilerFeatures.Feature)feature));
        result.append("#endif\n");
        GCCCompiler.getTypeSizesMacros().forEach((type, macro) -> queryBuilder.appendTypeSizeQuery((String)macro, (OCCompilerFeatures.TypeSize)type));
        return result.toString();
    }

    @NotNull
    public static LinkedHashMap<OCCompilerFeatures.TypeSize, String> getTypeSizesMacros() {
        LinkedHashMap<OCCompilerFeatures.TypeSize, String> sizes = new LinkedHashMap<OCCompilerFeatures.TypeSize, String>();
        sizes.put(OCCompilerFeatures.TypeSize.WCHAR_T, "__SIZEOF_WCHAR_T__");
        sizes.put(OCCompilerFeatures.TypeSize.SHORT, "__SIZEOF_SHORT__");
        sizes.put(OCCompilerFeatures.TypeSize.INT, "__SIZEOF_INT__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG, "__SIZEOF_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.POINTER, "__SIZEOF_POINTER__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_LONG, "__SIZEOF_LONG_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.INT128_T, "__SIZEOF_INT128__");
        sizes.put(OCCompilerFeatures.TypeSize.FLOAT, "__SIZEOF_FLOAT__");
        sizes.put(OCCompilerFeatures.TypeSize.DOUBLE, "__SIZEOF_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, "__SIZEOF_LONG_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.SIZE_T, "__SIZEOF_SIZE_T__");
        sizes.put(OCCompilerFeatures.TypeSize.PTRDIFF_T, "__SIZEOF_PTRDIFF_T__");
        return sizes;
    }

    private static void collectDiagnostics(@NotNull CidrCompilerSwitches switches, boolean isClang, final Map<OCCompilerFeatures.Type<?>, Object> result) {
        THashSet set = new THashSet(switches.getList(CidrCompilerSwitches.Format.RAW));
        if (set.contains("-w")) {
            return;
        }
        boolean everythingEnabled = set.contains("-Weverything");
        boolean allWarningsEnabled = everythingEnabled || set.contains("-Wall");
        boolean pedanticAsErrors = set.contains("-pedantic-errors");
        boolean pedanticEnabled = everythingEnabled || pedanticAsErrors || set.contains("-pedantic") || set.contains("-Wpedantic");
        boolean warningsAsErrors = set.contains("-Werror");
        class Checker {
            final /* synthetic */ Set val$set;

            Checker() {
                this.val$set = set;
            }

            void add(OCCompilerFeatures.Diagnostic diagnostic, boolean globallyEnabled, boolean globallyEnabledAsError, String id) {
                OCCompilerFeatures.DiagnosticLevel level = this.getLevel(globallyEnabled, globallyEnabledAsError, id);
                result.put(diagnostic, level != null ? level : OCCompilerFeatures.DiagnosticLevel.DISABLED);
            }

            @Nullable
            private OCCompilerFeatures.DiagnosticLevel getLevel(boolean globallyEnabled, boolean globallyEnabledAsError, String id) {
                if (globallyEnabled && globallyEnabledAsError || this.val$set.contains("-Werror=" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.ERROR;
                }
                if (globallyEnabled || this.val$set.contains("-W" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.WARNING;
                }
                return null;
            }
        }
        Checker checker = new Checker();
        checker.add(OCCompilerFeatures.Diagnostic.MISSING_RETURN_FROM_NON_VOID, isClang || allWarningsEnabled, warningsAsErrors, "return-type");
        if (isClang) {
            checker.add(OCCompilerFeatures.Diagnostic.FOLDING_CONSTANT, pedanticEnabled, pedanticAsErrors, "gnu-folding-constant");
        }
    }

    private static void collectFeatureFlags(@NotNull CidrCompilerSwitches switches, Map<OCCompilerFeatures.Type<?>, Object> result) {
        THashSet set = new THashSet(switches.getList(CidrCompilerSwitches.Format.RAW));
        featureFlags.forEach((arg_0, arg_1) -> GCCCompiler.lambda$collectFeatureFlags$7((Set)set, result, arg_0, arg_1));
    }

    ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        Set skipOptions = ContainerUtil.set((Object[])new String[]{"-fdiagnostics-format", "-imacros", "-"});
        return this.tryRunGCC(environment, options, skipOptions, 0, 0, false, fileText, warnLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessOutput tryRunGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull Set<String> skipOptions, int optionsRetriesNumber, int timeoutsNumber, boolean skipResponseFile, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        ProcessOutput output;
        String clCommandLineString;
        String responseFileText;
        String responseFileArg;
        String gccPath;
        Path responseFile;
        block20: {
            CidrCompilerSwitches filteredOptions = this.filterOptions(options, skipOptions);
            responseFile = null;
            Path bodyFile = null;
            gccPath = this.myExecutable.getPath();
            HostMachine host = environment.getHostMachine();
            Path tmpDir = host.getTempDirectory();
            try {
                try {
                    responseFile = Files.createTempFile(tmpDir, "response-file", ".txt", new FileAttribute[0]);
                    responseFileArg = "@" + environment.toEnvPath(responseFile.toAbsolutePath().toString());
                    responseFileText = filteredOptions.getCommandLineString(CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
                    if (!skipResponseFile) {
                        PathKt.write((Path)responseFile, (String)responseFileText, (boolean)false);
                    }
                    bodyFile = Files.createTempFile(tmpDir, "compiler-file", "", new FileAttribute[0]);
                    PathKt.write((Path)bodyFile, (String)fileText, (boolean)false);
                }
                catch (IOException e) {
                    throw new ExecutionException("Unable to create temporary file", (Throwable)e);
                }
                GeneralCommandLine cl = new GeneralCommandLine();
                environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
                cl.setExePath(gccPath);
                cl.withWorkDirectory(this.myWorkingDirectory);
                cl.getEnvironment().put("LC_ALL", "C");
                if (!skipResponseFile) {
                    cl.addParameters(new String[]{responseFileArg});
                } else {
                    cl.addParameters(filteredOptions.getList(CidrCompilerSwitches.Format.RAW));
                }
                cl.addParameters(new String[]{environment.toEnvPath(bodyFile.toAbsolutePath().toString())});
                clCommandLineString = cl.getCommandLineString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running compiler: " + clCommandLineString + "\nArguments file contents: " + filteredOptions);
                }
                output = outCompilerRunner.run(cl, environment);
                if (bodyFile == null) break block20;
            }
            catch (Throwable throwable) {
                if (bodyFile != null) {
                    PathKt.delete(bodyFile, (boolean)false);
                }
                if (responseFile != null) {
                    PathKt.delete((Path)responseFile, (boolean)false);
                }
                throw throwable;
            }
            PathKt.delete((Path)bodyFile, (boolean)false);
        }
        if (responseFile != null) {
            PathKt.delete((Path)responseFile, (boolean)false);
        }
        String userFriendlyCommandLine = gccPath + " " + responseFileText.replaceFirst(Matcher.quoteReplacement(" -D___CIDR_DEFINITIONS_END"), "");
        if (output.isTimeout()) {
            if (timeoutsNumber < 1) {
                LOG.debug("Trying to run compiler after timeout");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber + 1, skipResponseFile, fileText, warnLog);
            }
            throw GCCCompiler.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            if (!skipResponseFile && output.getStderr().contains(responseFileArg)) {
                LOG.debug("Trying to run compiler without a @response file");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber, true, fileText, warnLog);
            }
            if (optionsRetriesNumber < 2 && GCCCompiler.collectSkipOptionsGcc(output.getStderrLines(), skipOptions, warnLog)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to run compiler with skipped options: " + StringUtil.join(skipOptions, (String)" "));
                }
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber + 1, timeoutsNumber, skipResponseFile, fileText, warnLog);
            }
            if (!GCCCompiler.allowResultsWithError(output)) {
                throw GCCCompiler.throwCompilerError(output, userFriendlyCommandLine);
            }
        }
        if (LOG.isDebugEnabled()) {
            String dbg = "Compiler finished `" + clCommandLineString + "` with " + output.getExitCode();
            if (LOG.isTraceEnabled()) {
                dbg = dbg + ":\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\nStdout:\n " + output.getStdout() + "\nStderr:\n " + output.getStderr() + "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n";
            }
            LOG.debug(dbg);
        }
        return output;
    }

    private static boolean allowResultsWithError(@NotNull ProcessOutput output) {
        if (!PlatformUtils.isAppCode() || output.getExitCode() != 1) {
            return false;
        }
        for (String line : output.getStderrLines()) {
            if (!line.contains("error: ") || line.startsWith("fatal error: module map file ") && line.endsWith(" not found")) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, final @NotNull Set<String> skipOptions) {
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(){
            boolean archAdded = false;
            boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                parameter = parameter.trim();
                boolean tokenIsSwitch = GCCCompiler.isOptionSwitch(parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (!skipOptions.contains(parameter)) {
                    if (parameter.startsWith("-o")) {
                        if (parameter.equals("-o")) {
                            this.skipOptionValue = true;
                        }
                        return false;
                    }
                    if (parameter.startsWith("-Werror") || parameter.startsWith("-Wno-error")) {
                        return false;
                    }
                    if ("-arch".equals(parameter)) {
                        if (this.archAdded) {
                            this.skipOptionValue = true;
                            return false;
                        }
                        this.archAdded = true;
                    }
                    if (parameter.startsWith("-include")) {
                        if ("-include".equals(parameter) && skipOptions.contains(nextParameter)) {
                            return false;
                        }
                        String includeArg = parameter.substring("-include".length());
                        if (skipOptions.contains(includeArg)) {
                            return false;
                        }
                    }
                    return true;
                }
                this.skipOptionValue = tokenIsSwitch;
                return false;
            }
        };
        return switches.filterOptions(argumentsFilter2);
    }

    private static boolean isOptionSwitch(@NotNull String option) {
        return option.startsWith("-");
    }

    static boolean collectSkipOptionsGcc(List<String> lines, Set<String> skipOptions, List<String> warnLog) {
        return GCCCompiler.collectOptionsToSkip(lines, skipOptions, warnLog, BAD_SWITCH_FILTER_RULES);
    }

    @NotNull
    protected String preparePath(@NotNull CidrToolEnvironment env, @NotNull String path) {
        return FileUtil.toCanonicalPath((String)env.toLocalPath(this.myWorkingDirectory, path));
    }

    public static String getClangTestMacros() {
        return "#define __has_feature(X) " + GCCCompiler.clangFeatureMacro("##X") + "\n#define __has_extension(X) " + GCCCompiler.clangExtensionMacro("##X") + "\n#define __has_attribute(X) " + GCCCompiler.clangAttributeMacro("##X") + "\n#define __has_builtin(X) " + GCCCompiler.clangBuiltinMacro("##X") + "\n";
    }

    @NotNull
    public static String getGCCBuiltInFunctionMacros() {
        return "#define __builtin_va_start(list, paramN) ((void)(list = sizeof(paramN)))\n#define __builtin_va_arg(list, type) ((type)list)\n#define __builtin_va_end(list) ((void)list)\n#define __builtin_va_copy(dest, src) ((void)(dest = src))\n#define __builtin_offsetof(type, member) ((size_t)(&(((type *)0)->member)))\n#define __builtin_types_compatible_p(X,Y) 1\n#define __builtin_choose_expr(C,T,E) T\n";
    }

    @NotNull
    public static String clangFeatureMacro(@NotNull String feature) {
        return "__CIDR_clang__has_feature_" + feature;
    }

    @NotNull
    static String clangExtensionMacro(@NotNull String extension) {
        return "__CIDR_clang__has_extension_" + extension;
    }

    @NotNull
    static String clangAttributeMacro(@NotNull String attribute) {
        return "__CIDR_clang__has_attribute_" + attribute;
    }

    @NotNull
    static String clangBuiltinMacro(@NotNull String extension) {
        return "__CIDR_clang__has_builtin_" + extension;
    }

    private static /* synthetic */ void lambda$collectFeatureFlags$7(Set set, Map result, String flag, OCCompilerFeatures.Feature feature) {
        if (set.contains(flag)) {
            result.put(feature, true);
        }
    }

    static {
        featureFlags.put("-fms-extensions", OCCompilerFeatures.Feature.MS_EXTENSIONS);
        featureFlags.put("-fms-compatibility", OCCompilerFeatures.Feature.MS_EXTENSIONS);
    }

    static class OutputSections {
        final String defines;
        final String preprocessed;
        final String featureChecks;

        OutputSections(@NotNull String defines, @NotNull String preprocessed, @NotNull String featureTests) {
            this.defines = defines;
            this.preprocessed = preprocessed;
            this.featureChecks = featureTests;
        }
    }

    private static enum Command {
        SET_TYPE_SIZE,
        SET_FEATURE,
        ADD_DEFINITION;

    }
}

