/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.PrecompiledInclude;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 *2\u00020\u0001:\u0002*+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JV\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u001e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eH\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0002J\b\u0010$\u001a\u0004\u0018\u00010\tJL\u0010%\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\"2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a8\u0006,"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase;", "executable", "Ljava/io/File;", "workingDir", "env", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;)V", "buildMacrosFileTest", "", "defines", "", "collectHeaderPathsAndDefinesListFromCommandLine", "Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$HeaderSearchPathsAndDefines;", "args", "collectInfo", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfo;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "output", "headersSearchPaths", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "includedHeaders", "includesMapping", "Lcom/jetbrains/cidr/lang/workspace/compiler/PrecompiledInclude;", "warnLog", "filterOptions", "skipOptions", "", "getForceIncludeHeaders", "getIncludeMapping", "isSwitch", "", "parameter", "readVersion", "runCompiler", "originalSwitches", "requestSwitches", "environment", "runWithSkippedOptions", "Companion", "HeaderSearchPathsAndDefines", "intellij.c"})
public final class MSVCCompiler
extends OCCompilerBase {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String readVersion() {
        return this.doReadVersion(CollectionsKt.emptyList(), (Function<ProcessOutput, String>)((Function)readVersion.1.INSTANCE));
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        CidrCompilerSwitches requestSwitches = new MSVCSwitchBuilder(null, 1, null).withLanguageKind(languageKind).withSwitches(switches).withSwitch("/Be").withSwitch("/Bd").withSwitch("/EP").build();
        boolean bl = false;
        CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
        CidrCompilerSwitches cidrCompilerSwitches = requestSwitches;
        CidrCompilerSwitches cidrCompilerSwitches2 = switches;
        OCLanguageKind oCLanguageKind = languageKind;
        MSVCCompiler mSVCCompiler = this;
        Set set = new LinkedHashSet();
        List list = new ArrayList();
        return mSVCCompiler.runCompiler(oCLanguageKind, cidrCompilerSwitches2, cidrCompilerSwitches, cidrToolEnvironment, bl, set, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompilerInfo runCompiler(OCLanguageKind languageKind, CidrCompilerSwitches originalSwitches, CidrCompilerSwitches requestSwitches, CidrToolEnvironment environment, boolean runWithSkippedOptions, Set<String> skipOptions, List<String> warnLog) throws ExecutionException {
        File responseFile = null;
        File macroFile = null;
        try {
            void headersSearchPaths;
            CidrCompilerSwitches requestSwitches2 = this.filterOptions(requestSwitches, skipOptions);
            String responseFileText = requestSwitches2.getCommandLineString(CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE);
            responseFile = FileUtil.createTempFile((String)"response-file", (String)"", (boolean)true);
            FileUtil.writeToFile((File)responseFile, (String)responseFileText);
            macroFile = FileUtil.createTempFile((String)"compiler-file", (String)"", (boolean)true);
            GeneralCommandLine cl = new GeneralCommandLine();
            environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            cl.setExePath(this.myExecutable.getPath());
            cl.withWorkDirectory(this.myWorkingDirectory);
            cl.addParameters(new String[]{"@" + environment.toEnvPath(responseFile.getAbsolutePath())});
            cl.addParameters(new String[]{environment.toEnvPath(macroFile.getAbsolutePath())});
            String userFriendlyCommandLine = cl.getCommandLineString() + " | @" + responseFile.getName() + '=' + responseFileText;
            OCCompilerBase.LOG.debug("Running 1st pass compiler: " + userFriendlyCommandLine);
            ProcessOutput output = OCCompilerBase.outCompilerRunner.run(cl, environment);
            if (output.isTimeout()) {
                throw (Throwable)OCCompilerBase.throwCompilerTimeout(userFriendlyCommandLine);
            }
            if (output.getExitCode() != 0) {
                if (!runWithSkippedOptions && MSVCCompilerKt.collectMSVCSkipOptions(output.getStderrLines(), skipOptions, warnLog)) {
                    if (OCCompilerBase.LOG.isDebugEnabled()) {
                        OCCompilerBase.LOG.debug("Re-running compiler with skipped options: " + CollectionsKt.joinToString$default((Iterable)skipOptions, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                    }
                    CompilerInfo compilerInfo = this.runCompiler(languageKind, originalSwitches, requestSwitches2, environment, runWithSkippedOptions, skipOptions, warnLog);
                    return compilerInfo;
                }
                throw (Throwable)OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine);
            }
            OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine);
            if (OCCompilerBase.LOG.isDebugEnabled()) {
                OCCompilerBase.LOG.debug("Compiler 1st output: \n" + output.getStderr());
            }
            List<String> cmdArgs = Companion.parseArguments(output.getStderrLines());
            HeaderSearchPathsAndDefines headerSearchPathsAndDefines = this.collectHeaderPathsAndDefinesListFromCommandLine(cmdArgs);
            List<HeadersSearchPath> list = headerSearchPathsAndDefines.component1();
            List<String> definesList = headerSearchPathsAndDefines.component2();
            FileUtil.writeToFile((File)macroFile, (String)this.buildMacrosFileTest(definesList));
            OCCompilerBase.LOG.debug("Running 2st pass compiler");
            output = OCCompilerBase.outCompilerRunner.run(cl, environment);
            OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine);
            List<File> includedHeaders = this.getForceIncludeHeaders(cmdArgs);
            List<PrecompiledInclude> includeMapping = this.getIncludeMapping(cmdArgs);
            OCCompilerBase.addEmulatedWarning(warnLog);
            CompilerInfo compilerInfo = this.collectInfo(languageKind, originalSwitches, output.getStdout(), (List<? extends HeadersSearchPath>)headersSearchPaths, includedHeaders, includeMapping, warnLog);
            return compilerInfo;
        }
        catch (IOException e) {
            throw (Throwable)new ExecutionException((Throwable)e);
        }
        finally {
            block12: {
                File it;
                File file;
                File file2 = responseFile;
                if (file2 != null) {
                    it = file = file2;
                    boolean bl = false;
                    FileUtil.delete((File)it);
                }
                File file3 = macroFile;
                if (file3 == null) break block12;
                it = file = file3;
                boolean bl = false;
                FileUtil.delete((File)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, @NotNull Set<String> skipOptions) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)skipOptions;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.isSwitch(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List skipSwitches = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object[])new String[]{"/Fa", "/Fd", "/Fe", "/Fi", "/Fm", "/Fo", "/Fr", "/FR", "/doc"}));
        Iterable $receiver$iv2 = skipOptions;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!this.isSwitch(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List skipValues = (List)destination$iv$iv2;
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(this, skipValues, skipSwitches){
            private boolean skipOptionValue;
            final /* synthetic */ MSVCCompiler this$0;
            final /* synthetic */ List $skipValues;
            final /* synthetic */ List $skipSwitches;

            public final boolean getSkipOptionValue$intellij_c() {
                return this.skipOptionValue;
            }

            public final void setSkipOptionValue$intellij_c(boolean bl) {
                this.skipOptionValue = bl;
            }

            @NotNull
            public Boolean apply(@NotNull String parameter, @Nullable String nextParameter) {
                boolean tokenIsSwitch = MSVCCompiler.access$isSwitch(this.this$0, parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (this.$skipValues.contains(parameter)) {
                    return false;
                }
                if (this.$skipSwitches.contains(parameter)) {
                    this.skipOptionValue = true;
                    return false;
                }
                Iterable $receiver$iv = this.$skipSwitches;
                for (T element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)parameter, (String)it, (boolean)false, (int)2, null)) continue;
                    return false;
                }
                if (Intrinsics.areEqual((Object)parameter, (Object)"/FI") && CollectionsKt.contains((Iterable)this.$skipValues, (Object)nextParameter)) {
                    return false;
                }
                if (StringsKt.startsWith$default((String)parameter, (String)"/FI", (boolean)false, (int)2, null)) {
                    String string = parameter;
                    int n = "/FI".length();
                    List list = this.$skipValues;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    String string4 = string3;
                    if (list.contains(string4)) {
                        return false;
                    }
                }
                return true;
            }
            {
                this.this$0 = $outer;
                this.$skipValues = $captured_local_variable$1;
                this.$skipSwitches = $captured_local_variable$2;
            }
        };
        return switches.filterOptions(argumentsFilter2);
    }

    private final boolean isSwitch(String parameter) {
        return StringsKt.startsWith$default((String)parameter, (String)"/", (boolean)false, (int)2, null);
    }

    private final String buildMacrosFileTest(List<String> defines) {
        StringBuilder builder = new StringBuilder();
        builder.append("__cidr_defines_start__\n");
        Iterable $receiver$iv = new LinkedHashSet(CollectionsKt.plus((Collection)MSVCCompilerKt.access$getBUILT_IN_MACROS$p(), (Iterable)defines));
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.append("#if (defined " + it + ")\n__cidr_define_" + it + ' ' + it + "\n#endif\n");
        }
        builder.append("__cidr_defines_end__\n");
        return builder.toString();
    }

    @NotNull
    public final HeaderSearchPathsAndDefines collectHeaderPathsAndDefinesListFromCommandLine(@NotNull List<String> args) {
        ArrayList<String> defines = new ArrayList<String>();
        ArrayList<HeadersSearchPath> headerPaths = new ArrayList<HeadersSearchPath>();
        boolean nextIsIncludePath = false;
        for (String each : args) {
            String string;
            if (nextIsIncludePath) {
                String path = FileUtil.toCanonicalPath((String)each);
                File file = FileUtil.isAbsolute((String)path) ? new File(path) : new File(this.myWorkingDirectory, path);
                headerPaths.add(new HeadersSearchPath(file, false, false));
                nextIsIncludePath = false;
                continue;
            }
            nextIsIncludePath = Intrinsics.areEqual((Object)each, (Object)"-I");
            if (!StringsKt.startsWith$default((String)each, (String)"-D", (boolean)false, (int)2, null)) continue;
            int eq = StringsKt.indexOfAny$default((CharSequence)each, (char[])new char[]{'=', '(', ' '}, (int)0, (boolean)false, (int)6, null);
            String string2 = each;
            int n = 2;
            int n2 = eq > -1 ? eq : each.length();
            ArrayList<String> arrayList = defines;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string2 = (string = string4);
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            arrayList.add(string);
        }
        return new HeaderSearchPathsAndDefines((List<? extends HeadersSearchPath>)headerPaths, (List<String>)defines);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches, @NotNull String output, @NotNull List<? extends HeadersSearchPath> headersSearchPaths, @NotNull List<? extends File> includedHeaders, @NotNull List<PrecompiledInclude> includesMapping, @NotNull List<String> warnLog) {
        int version;
        LinkedHashMap features;
        Object object;
        Object object2;
        Object $receiver$iv;
        String defines;
        block15: {
            block12: {
                Object object3;
                block14: {
                    block13: {
                        defines = "";
                        int definesStart = StringsKt.indexOf$default((CharSequence)output, (String)"__cidr_defines_start__\n", (int)0, (boolean)false, (int)6, null);
                        int definesEnd = StringsKt.indexOf$default((CharSequence)output, (String)"__cidr_defines_end__\n", (int)0, (boolean)false, (int)6, null);
                        if (definesStart > -1 && definesEnd > -1) {
                            String string;
                            String string2 = output;
                            int n = definesStart + "__cidr_defines_start__\n".length();
                            String string3 = string2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string4 = string3.substring(n, definesEnd);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            defines = string = string4;
                            StringBuilder builder = new StringBuilder();
                            boolean hasNewLine = false;
                            $receiver$iv = defines;
                            int index$iv = 0;
                            object2 = $receiver$iv;
                            for (int i = 0; i < object2.length(); ++i) {
                                void c;
                                char item$iv = object2.charAt(i);
                                int n2 = index$iv++;
                                char c2 = item$iv;
                                int i2 = n2;
                                boolean bl = false;
                                if (c == 10) {
                                    if (hasNewLine) continue;
                                    if (i2 == 0 || defines.charAt(i2 - 1) != '\\') {
                                        hasNewLine = true;
                                    }
                                } else {
                                    hasNewLine = false;
                                }
                                builder.append((char)c);
                            }
                            defines = builder.toString();
                            $receiver$iv = defines;
                            object = new Regex("^__cidr_define_", RegexOption.MULTILINE);
                            object2 = "#define ";
                            defines = string = object.replace((CharSequence)$receiver$iv, (String)object2);
                        }
                        features = new LinkedHashMap();
                        version = Companion.getMSCVersion(defines);
                        if (!languageKind.isCpp()) break block12;
                        $receiver$iv = features;
                        object = OCCompilerFeatures.LANGUAGE_STANDARD;
                        object3 = Companion.getMSVCLangVersion(defines);
                        if (object3 == null) break block13;
                        object2 = object3;
                        Object it = object2;
                        boolean bl = false;
                        object3 = OCLanguageStandard.getCppStandard((String)it);
                        if (object3 != null) break block14;
                    }
                    object3 = OCLanguageStandard.CPP11;
                }
                object2 = object3;
                $receiver$iv.put(object, object2);
                break block15;
            }
            $receiver$iv = features;
            object = OCCompilerFeatures.LANGUAGE_STANDARD;
            object2 = OCLanguageStandard.C11;
            $receiver$iv.put(object, object2);
        }
        if (version < 1900) {
            $receiver$iv = features;
            object = OCCompilerFeatures.Feature.CXX_CONSTEXPR;
            object2 = false;
            $receiver$iv.put(object, object2);
            $receiver$iv = features;
            object = OCCompilerFeatures.Feature.CXX_USER_LITERALS;
            object2 = false;
            $receiver$iv.put(object, object2);
            $receiver$iv = features;
            object = OCCompilerFeatures.Feature.CXX_BINARY_LITERALS;
            object2 = false;
            $receiver$iv.put(object, object2);
            $receiver$iv = features;
            object = OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS;
            object2 = false;
            $receiver$iv.put(object, object2);
            $receiver$iv = features;
            object = OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION;
            object2 = false;
            $receiver$iv.put(object, object2);
        }
        if (version < 1800) {
            $receiver$iv = features;
            object = OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT;
            object2 = false;
            $receiver$iv.put(object, object2);
            $receiver$iv = features;
            object = OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS;
            object2 = false;
            $receiver$iv.put(object, object2);
        }
        $receiver$iv = features;
        object = OCCompilerFeatures.Feature.IS_BASE_OF;
        object2 = true;
        $receiver$iv.put(object, object2);
        boolean is64 = Companion.is64Bit(defines);
        object = features;
        object2 = OCCompilerFeatures.TypeSize.WCHAR_T;
        Short s = 2;
        object.put(object2, s);
        object = features;
        object2 = OCCompilerFeatures.TypeSize.INT;
        s = 4;
        object.put(object2, s);
        object = features;
        object2 = OCCompilerFeatures.TypeSize.LONG;
        s = 4;
        object.put(object2, s);
        object = features;
        object2 = OCCompilerFeatures.TypeSize.LONG_LONG;
        s = 8;
        object.put(object2, s);
        object = features;
        object2 = OCCompilerFeatures.TypeSize.FLOAT;
        s = 4;
        object.put(object2, s);
        object = features;
        object2 = OCCompilerFeatures.TypeSize.DOUBLE;
        s = 8;
        object.put(object2, s);
        object = features;
        object2 = OCCompilerFeatures.TypeSize.LONG_DOUBLE;
        s = 8;
        object.put(object2, s);
        object = features;
        object2 = OCCompilerFeatures.TypeSize.SIZE_T;
        s = is64 ? (short)8 : 4;
        object.put(object2, s);
        return new CompilerInfo(switches, defines, features, headersSearchPaths, includedHeaders, includesMapping, warnLog, 0, 128, null);
    }

    private final List<File> getForceIncludeHeaders(List<String> args) {
        String forceIncludeCmd = "-FI";
        LinkedHashSet<File> result = new LinkedHashSet<File>(1);
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (!StringsKt.startsWith$default((String)arg, (String)forceIncludeCmd, (boolean)false, (int)2, null) || ++i >= args.size()) continue;
            String path = args.get(i);
            File file = FileUtil.isWindowsAbsolutePath((String)path) ? new File(path) : new File(this.myWorkingDirectory, path);
            result.add(file);
        }
        return (List)new SmartList((Collection)result);
    }

    @NotNull
    public final List<PrecompiledInclude> getIncludeMapping(@NotNull List<String> args) {
        String pchCreationCmd = "-Yc";
        String pchUsingCmd = "-Yu";
        String pchPathCmd = "-Fp";
        String initHeaderName = null;
        String usedHeaderName = null;
        String pchPath = null;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i);
            if (++i == args.size()) break;
            String nextArg = args.get(i);
            boolean nextArgIsSwith = StringsKt.startsWith$default((CharSequence)nextArg, (char)'-', (boolean)false, (int)2, null);
            if (nextArgIsSwith) continue;
            String string = arg;
            if (Intrinsics.areEqual((Object)string, (Object)pchPathCmd)) {
                pchPath = nextArg;
            } else if (Intrinsics.areEqual((Object)string, (Object)pchCreationCmd)) {
                initHeaderName = nextArg;
            } else if (Intrinsics.areEqual((Object)string, (Object)pchUsingCmd)) {
                usedHeaderName = nextArg;
            }
            ++i;
        }
        SmartList result = new SmartList();
        if (pchPath != null) {
            File pchFile = FileUtil.isAbsolute((String)pchPath) ? new File(pchPath) : new File(this.myWorkingDirectory, pchPath);
            String canonicalPCHPath = FileUtil.toCanonicalPath((String)pchFile.getPath());
            if (initHeaderName != null) {
                result.add((Object)new PrecompiledInclude(canonicalPCHPath, initHeaderName, true));
            }
            if (usedHeaderName != null) {
                result.add((Object)new PrecompiledInclude(canonicalPCHPath, usedHeaderName, false));
            }
        }
        return (List)result;
    }

    public MSVCCompiler(@NotNull File executable, @NotNull File workingDir, @NotNull CidrToolEnvironment env) {
        super(executable, workingDir, env);
    }

    public static final /* synthetic */ boolean access$isSwitch(MSVCCompiler $this, String parameter) {
        return $this.isSwitch(parameter);
    }

    @JvmStatic
    public static final int getMSCVersion(@NotNull CharSequence defines) {
        return Companion.getMSCVersion(defines);
    }

    @JvmStatic
    @Nullable
    public static final String getMSVCLangVersion(@NotNull CharSequence defines) {
        return Companion.getMSVCLangVersion(defines);
    }

    @JvmStatic
    public static final boolean is64Bit(@NotNull CharSequence defines) {
        return Companion.is64Bit(defines);
    }

    @JvmStatic
    @NotNull
    public static final List<String> parseArguments(@NotNull List<String> lines) {
        return Companion.parseArguments(lines);
    }

    @JvmStatic
    private static final List<String> splitArguments(String line) {
        return MSVCCompiler.Companion.splitArguments(line);
    }

    @JvmStatic
    @Nullable
    public static final OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        return Companion.resolveLanguage(switches);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$HeaderSearchPathsAndDefines;", "", "headersSearchPaths", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "defines", "", "(Ljava/util/List;Ljava/util/List;)V", "getDefines", "()Ljava/util/List;", "getHeadersSearchPaths", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.c"})
    public static final class HeaderSearchPathsAndDefines {
        @NotNull
        private final List<HeadersSearchPath> headersSearchPaths;
        @NotNull
        private final List<String> defines;

        @NotNull
        public final List<HeadersSearchPath> getHeadersSearchPaths() {
            return this.headersSearchPaths;
        }

        @NotNull
        public final List<String> getDefines() {
            return this.defines;
        }

        public HeaderSearchPathsAndDefines(@NotNull List<? extends HeadersSearchPath> headersSearchPaths, @NotNull List<String> defines) {
            this.headersSearchPaths = headersSearchPaths;
            this.defines = defines;
        }

        @NotNull
        public final List<HeadersSearchPath> component1() {
            return this.headersSearchPaths;
        }

        @NotNull
        public final List<String> component2() {
            return this.defines;
        }

        @NotNull
        public final HeaderSearchPathsAndDefines copy(@NotNull List<? extends HeadersSearchPath> headersSearchPaths, @NotNull List<String> defines) {
            return new HeaderSearchPathsAndDefines(headersSearchPaths, defines);
        }

        @NotNull
        public static /* synthetic */ HeaderSearchPathsAndDefines copy$default(HeaderSearchPathsAndDefines headerSearchPathsAndDefines, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = headerSearchPathsAndDefines.headersSearchPaths;
            }
            if ((n & 2) != 0) {
                list2 = headerSearchPathsAndDefines.defines;
            }
            return headerSearchPathsAndDefines.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "HeaderSearchPathsAndDefines(headersSearchPaths=" + this.headersSearchPaths + ", defines=" + this.defines + ")";
        }

        public int hashCode() {
            List<HeadersSearchPath> list = this.headersSearchPaths;
            List<String> list2 = this.defines;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HeaderSearchPathsAndDefines)) break block3;
                    HeaderSearchPathsAndDefines headerSearchPathsAndDefines = (HeaderSearchPathsAndDefines)object;
                    if (!Intrinsics.areEqual(this.headersSearchPaths, headerSearchPathsAndDefines.headersSearchPaths) || !Intrinsics.areEqual(this.defines, headerSearchPathsAndDefines.defines)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0007J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0012\u001a\u00020\bH\u0003\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$Companion;", "", "()V", "getMSCVersion", "", "defines", "", "getMSVCLangVersion", "", "is64Bit", "", "parseArguments", "", "lines", "resolveLanguage", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "splitArguments", "line", "intellij.c"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final int getMSCVersion(@NotNull CharSequence defines) {
            MatchResult matchResult;
            MatchResult matchResult2 = Regex.find$default((Regex)new Regex("#define\\s+_MSC_VER\\s+(\\d+)"), (CharSequence)defines, (int)0, (int)2, null);
            Object object = matchResult2;
            if (matchResult2 == null) return 0;
            MatchResult it = matchResult = object;
            boolean bl = false;
            Integer n = Integer.valueOf((String)it.getGroupValues().get(1));
            object = n;
            if (n == null) return 0;
            int n2 = (Integer)object;
            return n2;
        }

        @JvmStatic
        @Nullable
        public final String getMSVCLangVersion(@NotNull CharSequence defines) {
            String string;
            MatchResult matchResult = Regex.find$default((Regex)new Regex("#define\\s+_MSVC_LANG\\s+(\\d+L?)"), (CharSequence)defines, (int)0, (int)2, null);
            if (matchResult != null) {
                MatchResult matchResult2;
                MatchResult it = matchResult2 = matchResult;
                boolean bl = false;
                string = (String)it.getGroupValues().get(1);
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        public final boolean is64Bit(@NotNull CharSequence defines) {
            boolean bl;
            MatchResult matchResult = Regex.find$default((Regex)new Regex("#define\\s+_WIN64\\s+1"), (CharSequence)defines, (int)0, (int)2, null);
            if (matchResult != null) {
                MatchResult matchResult2;
                MatchResult it = matchResult2 = matchResult;
                boolean bl2 = false;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public final List<String> parseArguments(@NotNull List<String> lines) {
            Object v0;
            block2: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)lines;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!(StringsKt.startsWith$default((String)it, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"'", (boolean)false, (int)2, null))) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            String string = v0;
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String cmd = string;
            return this.splitArguments(StringsKt.trimEnd((String)StringsKt.trimStart((String)cmd, (char[])new char[]{'`'}), (char[])new char[]{'\''}));
        }

        @JvmStatic
        private final List<String> splitArguments(String line) {
            ArrayList<String> result = new ArrayList<String>();
            List raw = ParametersListUtil.parse((String)line);
            StringBuilder parsingArgument = new StringBuilder();
            for (String eachArg : raw) {
                CharSequence charSequence;
                if (StringsKt.startsWith$default((String)eachArg, (String)"-", (boolean)false, (int)2, null)) {
                    charSequence = parsingArgument;
                    if (charSequence.length() > 0) {
                        result.add(parsingArgument.toString());
                        parsingArgument.setLength(0);
                    }
                    if (StringsKt.startsWith$default((String)eachArg, (String)"-Yc", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eachArg, (String)"-Yu", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eachArg, (String)"-Fp", (boolean)false, (int)2, null)) {
                        String string;
                        charSequence = eachArg;
                        int n = 0;
                        int n2 = 3;
                        Serializable serializable = result;
                        CharSequence charSequence2 = charSequence;
                        if (charSequence2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)((String)charSequence2).substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        ((ArrayList)serializable).add(string);
                        if (eachArg.length() <= 3) continue;
                        charSequence = eachArg;
                        n = 3;
                        serializable = parsingArgument;
                        CharSequence charSequence3 = charSequence;
                        if (charSequence3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = ((String)charSequence3).substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                        string = string2;
                        ((StringBuilder)serializable).append(string);
                        continue;
                    }
                    result.add(eachArg);
                    continue;
                }
                charSequence = parsingArgument;
                if (charSequence.length() > 0) {
                    parsingArgument.append(" ");
                }
                parsingArgument.append(eachArg);
            }
            CharSequence charSequence = parsingArgument;
            if (charSequence.length() > 0) {
                result.add(parsingArgument.toString());
            }
            return result;
        }

        @JvmStatic
        @Nullable
        public final OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
            Object v0;
            block1: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)switches;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!(StringsKt.startsWith((String)it, (String)"/Tc", (boolean)true) || StringsKt.startsWith((String)it, (String)"/Tp", (boolean)true))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            String string = v0;
            return string == null ? null : (StringsKt.startsWith((String)string, (String)"/Tc", (boolean)true) ? (OCLanguageKind)CLanguageKind.C : (OCLanguageKind)CLanguageKind.CPP);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

