/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCompilerBase
implements OCCompiler {
    public static final Logger LOG = Logger.getInstance((String)("#" + OCCompilerBase.class.getPackage().getName()));
    protected static final int COMPILER_TIMEOUT = 30000;
    private static boolean ourEmulateCompilerWarning = false;
    private static final CompilerRunner DEFAULT_RUNNER;
    @NotNull
    protected static volatile CompilerRunner outCompilerRunner;
    @NotNull
    protected final File myExecutable;
    @NotNull
    protected final File myWorkingDirectory;
    @NotNull
    protected final CidrToolEnvironment myEnvironment;

    @NotNull
    public static OCCompiler getCompilerInstance(@NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment) {
        if (compilerKind == OCCompilerKind.UNKNOWN) {
            compilerKind = OCCompilerBase.resolveCompiler(compilerExecutable);
        }
        return compilerKind.getCompilerInstance(compilerExecutable, compilerWorkingDirectory, environment);
    }

    @NotNull
    public static OCCompilerKind resolveCompiler(@NotNull File compilerExecutable) {
        return OCCompilerResolver.getInstance().resolve(compilerExecutable);
    }

    @Nullable
    public static OCLanguageKind resolveLanguage(@NotNull OCCompilerKind compilerKind, @NotNull List<String> switches) {
        return compilerKind.resolveLanguage(switches);
    }

    public static void setCompilerRunnerInTests(@Nullable CompilerRunner runner) {
        outCompilerRunner = runner == null ? DEFAULT_RUNNER : runner;
    }

    public static void setCompilerErrorInTests(boolean emulate) {
        OCCompilerBase.setCompilerRunnerInTests(!emulate ? null : new CompilerRunner(){

            @Override
            @NotNull
            public ProcessOutput run(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment env) {
                ProcessOutput output = new ProcessOutput(2);
                output.appendStderr("Emulated compiler error");
                return output;
            }
        });
    }

    public static void setCompilerWarningInTests(boolean emulate) {
        ourEmulateCompilerWarning = emulate;
    }

    public OCCompilerBase(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env) {
        this.myExecutable = executable;
        this.myWorkingDirectory = workingDirectory;
        this.myEnvironment = env;
    }

    @NotNull
    public abstract CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches var1, @NotNull Set<String> var2);

    @NotNull
    public File getExecutable() {
        return this.myExecutable;
    }

    @Nullable
    protected String doReadVersion(@NotNull List<String> arguments, Function<ProcessOutput, String> versionParser) {
        ProcessOutput output;
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath(this.myExecutable.getPath());
        cl.addParameters(arguments);
        try {
            output = outCompilerRunner.run(cl, this.myEnvironment);
            if (output.isTimeout()) {
                throw new ExecutionException("process timed out");
            }
        }
        catch (ExecutionException e) {
            LOG.info("Cannot read compiler version: " + cl.getCommandLineString(), (Throwable)e);
            return null;
        }
        String result = (String)versionParser.fun((Object)output);
        if (result == null) {
            LOG.info("Cannot read compiler version: " + cl.getCommandLineString() + "\n" + output.getStderr() + "\n" + output.getStdout());
        }
        return result;
    }

    protected static void checkCompilerOutput(@NotNull ProcessOutput output, @NotNull String userFriendlyCommandLine) throws ExecutionException {
        if (output.isTimeout()) {
            throw OCCompilerBase.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            throw OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine);
        }
    }

    protected static ExecutionException throwCompilerTimeout(@NotNull String userFriendlyCommandLine) throws ExecutionException {
        throw new ExecutionException("Compiler command timed out: " + userFriendlyCommandLine);
    }

    protected static ExecutionException throwCompilerError(@NotNull ProcessOutput output, @NotNull String userFriendlyCommandLine) throws ExecutionException {
        String message = "Compiler exited with error code " + output.getExitCode() + ": " + userFriendlyCommandLine + "\n" + output.getStderr() + "\n";
        throw new ExecutionException(StringUtil.first((String)message, (int)0x100000, (boolean)true));
    }

    protected static boolean collectOptionsToSkip(@NotNull List<String> lines, @NotNull Set<String> skipOptions, @NotNull List<String> warnLog, Pattern ... errorPatterns) {
        boolean hasNewSkipOptions = false;
        block0: for (String eachError : lines) {
            eachError = eachError.trim();
            for (Pattern rule : errorPatterns) {
                Matcher badOptionOrSwitch = OCCompilerBase.matchSafely(rule, eachError);
                if (!badOptionOrSwitch.matches()) continue;
                hasNewSkipOptions |= skipOptions.add(badOptionOrSwitch.group(1));
                warnLog.add(badOptionOrSwitch.group(0));
                continue block0;
            }
        }
        return hasNewSkipOptions;
    }

    protected static void addEmulatedWarning(@NotNull List<String> warnLog) {
        if (ourEmulateCompilerWarning) {
            warnLog.add("Emulated compiler warning");
        }
    }

    @NotNull
    protected static Matcher matchSafely(Pattern pattern, String eachLine) {
        try {
            return pattern.matcher(eachLine);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error in regexp: `" + pattern.pattern() + "` line: `" + eachLine + "`", e);
        }
    }

    static {
        outCompilerRunner = DEFAULT_RUNNER = new CompilerRunner();
    }

    public static class CompilerRunner {
        @NotNull
        public ProcessOutput run(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment env) throws ExecutionException {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator == null) {
                indicator = new EmptyProgressIndicator();
            }
            ProcessOutput output = env.getHostMachine().runProcess(cl, indicator, 30000);
            ProgressManager.checkCanceled();
            return output;
        }
    }
}

