/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompilerFeatures {
    public static final Type<OCLanguageStandard> LANGUAGE_STANDARD = new Type<OCLanguageStandard>(){

        public String toString() {
            return "LANGUAGE_STANDARD";
        }

        @Override
        @NotNull
        public OCLanguageStandard getDefault() {
            return OCLanguageStandard.CPP98;
        }

        @Override
        @NotNull
        public OCLanguageStandard compute(@NotNull OCImmutableInclusionContext context) {
            if (context.getLanguageKind().isCpp()) {
                return OCLanguageStandard.getCppStandard(OCCompilerFeatures.getSubstitution(context, "__cplusplus"));
            }
            return OCLanguageStandard.getCStandard(OCCompilerFeatures.getSubstitution(context, "__STDC_VERSION__"));
        }
    };
    public static final short BIT_8 = 1;
    public static final short BIT_16 = 2;
    public static final short BIT_32 = 4;
    public static final short BIT_64 = 8;
    public static final short BIT_128 = 16;
    private static final Key<Map<Type, Object>> ENABLED_FEATURES = Key.create((String)"ENABLED_FEATURES");

    @NotNull
    public static <T> T getFeatureForFile(@Nullable PsiFile file, @Nullable OCImmutableInclusionContext fileContext, @NotNull Type<T> key) {
        Function<OCImmutableInclusionContext, Object> fun = context -> {
            Object value;
            if (file == null && context == null) {
                return null;
            }
            if (context != null && context.getConfiguration() == null && file != null) {
                context = null;
            }
            if (context == null) {
                if (!(file instanceof OCFile)) {
                    return null;
                }
                context = OCInclusionContextUtil.headerContext(file);
            }
            if ((value = OCCompilerFeatures.getForTests(context.getProject(), key)) != null) {
                return value;
            }
            return context.getCompilerFeature(key);
        };
        Object result = fun.apply(fileContext);
        return (T)(result == null ? key.getDefault() : result);
    }

    @Nullable
    private static String getSubstitution(@NotNull OCImmutableInclusionContext context, @NotNull String id) {
        OCMacroSymbol macro = context.getDefinition(id);
        return macro == null ? null : macro.getSubstitution();
    }

    public static boolean isFeatureEnabled(@Nullable PsiFile file, @NotNull Feature feature) {
        return Boolean.TRUE.equals(OCCompilerFeatures.getFeatureForFile(file, null, feature));
    }

    public static boolean isFeatureEnabled(@Nullable OCImmutableInclusionContext context, @NotNull Feature feature) {
        return Boolean.TRUE.equals(OCCompilerFeatures.getFeatureForFile(null, context, feature));
    }

    @NotNull
    public static DiagnosticLevel getDiagnosticLevel(@Nullable PsiFile file, @NotNull Diagnostic diagnostic) {
        return OCCompilerFeatures.getFeatureForFile(file, null, diagnostic);
    }

    public static boolean isArcDisabled(@NotNull PsiFile file) {
        return Boolean.FALSE.equals(OCCompilerFeatures.getFeatureForFile(file, null, Feature.OBJC_ARC));
    }

    public static boolean isArcEnabled(@NotNull PsiFile file) {
        return Boolean.TRUE.equals(OCCompilerFeatures.getFeatureForFile(file, null, Feature.OBJC_ARC));
    }

    public static boolean supportsIvarsInImplementation() {
        return true;
    }

    public static boolean supportsIvarsInCategories() {
        return true;
    }

    public static boolean supportsLaterMethodDeclaration() {
        return true;
    }

    public static boolean supportsAutosynthesis(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsAutosynthesis(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsNullability(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.NULLABILITY);
    }

    public static boolean supportsNullability(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.NULLABILITY);
    }

    public static boolean supportsGccAutoType(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.GCC_AUTO_TYPE);
    }

    public static boolean supportsGccAutoType(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.GCC_AUTO_TYPE);
    }

    public static boolean supportsAvailableExpression(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.BUILTIN_AVAILABLE);
    }

    public static boolean supportsAvailableExpression(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.BUILTIN_AVAILABLE);
    }

    public static boolean supportsClassProperty(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_CLASS_PROPERTY);
    }

    public static boolean supportsClassProperty(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.OBJC_CLASS_PROPERTY);
    }

    public static boolean supportsMsvcExtensions(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.MS_EXTENSIONS);
    }

    public static boolean supportsMsvcExtensions(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.MS_EXTENSIONS);
    }

    public static boolean supportsExplicitAtomic(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_PROPERTY_EXPLICIT_ATOMIC);
    }

    public static boolean supportsInstancetype(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_INSTANCETYPE);
    }

    public static boolean supportsSubscripting(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_SUBSCRIPTING);
    }

    public static boolean supportsObjectLiterals(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_ARRAY_LITERALS) && OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_DICTIONARY_LITERALS);
    }

    public static boolean supportsCxxAutoType(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_AUTO_TYPE);
    }

    public static boolean supportsCxxReturnTypeDeduction(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_RETURN_TYPE_DEDUCTION);
    }

    public static boolean supportsCxxGenericLambdas(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_GENERIC_LAMBDAS);
    }

    public static boolean supportsOverrideControl(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_OVERRIDE_CONTROL);
    }

    public static boolean supportsInitializerLists(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_GENERALIZED_INITIALIZERS);
    }

    public static boolean supportsNullptr(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_NULLPTR);
    }

    public static boolean supportsInClassInitialization(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_NONSTATIC_MEMBER_INIT);
    }

    @Nullable
    private static <T> T getForTests(@NotNull Project project2, @NotNull Type<T> type) {
        Map features = (Map)ENABLED_FEATURES.get((UserDataHolder)project2);
        return features == null ? null : (T)features.get(type);
    }

    public static <T> void set(@NotNull Project project2, Type<T> feature, T value) {
        ConcurrentHashMap<Type<T>, T> enabledFeatures = (ConcurrentHashMap<Type<T>, T>)ENABLED_FEATURES.get((UserDataHolder)project2);
        if (enabledFeatures == null) {
            enabledFeatures = new ConcurrentHashMap<Type<T>, T>();
            project2.putUserData(ENABLED_FEATURES, enabledFeatures);
        }
        enabledFeatures.put(feature, value);
    }

    public static void resetFeatures(@NotNull Project project2) {
        project2.putUserData(ENABLED_FEATURES, null);
    }

    public static enum Diagnostic implements Type<DiagnosticLevel>
    {
        MISSING_RETURN_FROM_NON_VOID(DiagnosticLevel.WARNING),
        FOLDING_CONSTANT(DiagnosticLevel.ERROR);

        @NotNull
        private final DiagnosticLevel myDefault;

        private Diagnostic(DiagnosticLevel def) {
            this.myDefault = def;
        }

        @Override
        @NotNull
        public DiagnosticLevel getDefault() {
            return this.myDefault;
        }
    }

    public static enum DiagnosticLevel {
        DISABLED,
        WARNING,
        ERROR;


        public boolean isEnabled() {
            return this != DISABLED;
        }
    }

    public static enum TypeSize implements Type<Short>
    {
        BOOL(1),
        CHAR(1),
        CHAR16_T(2),
        CHAR32_T(4),
        WCHAR_T(4),
        SHORT(2),
        INT(4),
        LONG(4),
        SIZE_T(INT),
        PTRDIFF_T(SIZE_T),
        POINTER(SIZE_T),
        LONG_LONG(8),
        INT128_T(16),
        FLOAT(4),
        DOUBLE(8),
        LONG_DOUBLE(8);

        @Nullable
        private final TypeSize myBaseType;
        private final short myDefault;

        private TypeSize(short def) {
            this.myBaseType = null;
            this.myDefault = def;
        }

        private TypeSize(TypeSize baseType) {
            this.myBaseType = baseType;
            this.myDefault = this.myBaseType.getDefault();
        }

        @Override
        @NotNull
        public Short getDefault() {
            return this.myDefault;
        }

        @Override
        @Nullable
        public Short compute(@NotNull OCImmutableInclusionContext context) {
            if (this.myBaseType != null) {
                return context.getCompilerFeature(this.myBaseType);
            }
            return null;
        }
    }

    public static enum Feature implements Type<Boolean>
    {
        C_STATIC_ASSERT(OCLanguageStandard.C11),
        CXX_EXCEPTIONS(OCLanguageStandard.CPP98),
        CXX_AUTO_TYPE(OCLanguageStandard.CPP11),
        CXX_OVERRIDE_CONTROL(OCLanguageStandard.CPP11),
        CXX_GENERALIZED_INITIALIZERS(OCLanguageStandard.CPP11),
        CXX_NULLPTR(OCLanguageStandard.CPP11),
        CXX_NONSTATIC_MEMBER_INIT(OCLanguageStandard.CPP11),
        CXX_CONSTEXPR(OCLanguageStandard.CPP11),
        CXX_RAW_STRING_LITERALS(OCLanguageStandard.CPP11),
        CXX_USER_LITERALS(OCLanguageStandard.CPP11),
        CXX_BINARY_LITERALS(OCLanguageStandard.CPP14),
        CXX_RETURN_TYPE_DEDUCTION(OCLanguageStandard.CPP14),
        CXX_GENERIC_LAMBDAS(OCLanguageStandard.CPP14),
        OBJC_ARC,
        OBJC_BOOL,
        OBJC_DEFAULT_SYNTHESIZE_PROPERTIES,
        OBJC_PROPERTY_EXPLICIT_ATOMIC,
        OBJC_INSTANCETYPE,
        OBJC_SUBSCRIPTING,
        OBJC_ARRAY_LITERALS,
        OBJC_DICTIONARY_LITERALS,
        OBJC_CLASS_PROPERTY,
        UNDERLYING_TYPE,
        IS_BASE_OF,
        NULLABILITY,
        GCC_AUTO_TYPE,
        BUILTIN_AVAILABLE,
        MS_EXTENSIONS{

            @Override
            @NotNull
            public Boolean compute(@NotNull OCImmutableInclusionContext context) {
                return "1".equals(OCCompilerFeatures.getSubstitution(context, "_MSC_EXTENSIONS"));
            }
        };

        @Nullable
        private final OCLanguageStandard myAvailableInStandard;

        private Feature() {
            this((OCLanguageStandard)null);
        }

        private Feature(OCLanguageStandard availableInStandard) {
            this.myAvailableInStandard = availableInStandard;
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            return Boolean.TRUE.equals(this.doComputeForLanguageStandard(null));
        }

        @Override
        @Nullable
        public Boolean compute(@NotNull OCImmutableInclusionContext context) {
            return this.doComputeForLanguageStandard(context);
        }

        @Nullable
        private Boolean doComputeForLanguageStandard(@Nullable OCImmutableInclusionContext contextOrNullForDefault) {
            if (this.myAvailableInStandard != null) {
                OCLanguageStandard standard = contextOrNullForDefault == null ? LANGUAGE_STANDARD.getDefault() : OCCompilerFeatures.getFeatureForFile(null, contextOrNullForDefault, LANGUAGE_STANDARD);
                return standard.supports(this.myAvailableInStandard);
            }
            return null;
        }

        @Nullable
        public OCLanguageStandard getAvailableInStandard() {
            return this.myAvailableInStandard;
        }
    }

    public static interface Type<T>
    extends Serializable {
        @NotNull
        public T getDefault();

        @Nullable
        default public T compute(@NotNull OCImmutableInclusionContext context) {
            return null;
        }
    }
}

