/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import icons.CidrLangIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AppleFramework
extends HeadersRoot {
    public static boolean SORTED_ITERATION = ApplicationManager.getApplication().isUnitTestMode();
    public static final String HEADERS_DIR_NAME = "Headers";
    public static final String PRIVATE_HEADERS_DIR_NAME = "PrivateHeaders";
    public static final String MODULES_DIR_NAME = "Modules";
    public static final String FRAMEWORKS_DIR_NAME = "Frameworks";
    public static final String[] HEADERS_DIR_NAMES = new String[]{"Headers", "PrivateHeaders"};
    @NotNull
    private final String myName;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    public static final Condition<VirtualFile> FRAMEWORK_CONDITION = file -> file.isDirectory() && file.getName().endsWith(".framework");
    private static final Comparator<VirtualFile> FILE_NAME_COMPARATOR = SORTED_ITERATION ? Comparator.comparing(VirtualFile::getName) : null;

    protected AppleFramework(@NotNull Project project2, @Nullable OCResolveConfiguration configuration, @NotNull String name2) {
        super(project2);
        this.myName = name2;
        this.myConfiguration = configuration;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    @Nullable
    public abstract VirtualFile getVirtualFile();

    @Nullable
    public abstract PsiFileSystemItem getParentSdkOrFrameworkItem();

    public boolean isLibrary() {
        return false;
    }

    @Nullable
    public VirtualFile getMainFile() {
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule(null);
        if (module2 != null) {
            return ModuleMapResolveService.getInstance(this.myProject).getUmbrellaHeader(module2);
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> getPublicHeadersToInclude() {
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule(null);
        if (module2 != null) {
            return ModuleMapResolveService.getInstance(this.myProject).getIncludeHeaders(module2, null);
        }
        return Collections.emptyList();
    }

    @Nullable
    protected ModuleMapModuleSymbol getMainFrameworkModule(@Nullable OCResolveConfiguration configuration) {
        ModuleMapFileSymbol moduleMap = this.getModuleMap(configuration);
        return moduleMap != null ? moduleMap.findModule(this.getName()) : null;
    }

    public abstract boolean containsHeader(@Nullable VirtualFile var1);

    public boolean process(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        if (!processed.add(this.getName())) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            return this.processChildren(processor2);
        }
        if (this.isValid()) {
            return AppleFramework.processFileSystemItem(processor2, (PsiFileSystemItem)this);
        }
        return true;
    }

    @Nullable
    protected Boolean processAsRoot(HeadersSearchRootProcessor searchRootProcessor) {
        return searchRootProcessor.processFramework((AppleFramework)this).returnValue;
    }

    public static boolean processFrameworksUnder(@NotNull PsiFileSystemItem parentSdkOrFramework, @Nullable VirtualFile root, @NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        Project project2 = parentSdkOrFramework.getProject();
        if (root != null && root.isValid() && root.isDirectory() && !project2.isDisposed()) {
            List frameworks = ContainerUtil.filter((Object[])root.getChildren(), FRAMEWORK_CONDITION);
            if (SORTED_ITERATION) {
                Collections.sort(frameworks, FILE_NAME_COMPARATOR);
            }
            for (VirtualFile frameworkPath : frameworks) {
                RealFramework framework = new RealFramework(project2, frameworkPath, parentSdkOrFramework);
                if (framework.process(processor2, processed)) continue;
                return false;
            }
        }
        return true;
    }

    public Icon getIcon(int flags) {
        return CidrLangIcons.Framework;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AppleFramework framework = (AppleFramework)((Object)o);
        return this.myName.equals(framework.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public abstract String toString();
}

