/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapInCollectionPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.SurrogateSearchRoot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHeadersRoot
extends HeadersRoot
implements SurrogateSearchRoot {
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    protected final List<VirtualFile> myHeaders;
    private final boolean myIsUserHeaders;
    private final int myHashCodeCache;

    public CustomHeadersRoot(@NotNull Project project2, @Nullable VirtualFile root, @NotNull Collection<VirtualFile> headers, boolean isUserHeaders) {
        this(project2, root, headers, isUserHeaders, true);
    }

    protected CustomHeadersRoot(@NotNull Project project2, @Nullable VirtualFile root, @NotNull Collection<VirtualFile> headers, boolean isUserHeaders, boolean sort) {
        super(project2);
        this.myRoot = root;
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(headers);
        if (sort) {
            filesList.sort((o1, o2) -> FileUtil.comparePaths((String)o1.getPath(), (String)o2.getPath()));
        }
        this.myHeaders = ContainerUtil.unmodifiableOrEmptyList(filesList);
        this.myIsUserHeaders = isUserHeaders;
        int hashCode = Objects.hashCode(this.myRoot);
        hashCode = 31 * hashCode + this.myHeaders.hashCode();
        this.myHashCodeCache = hashCode = 31 * hashCode + Boolean.hashCode(this.myIsUserHeaders);
    }

    @NotNull
    public String getName() {
        return "Custom Headers";
    }

    @Override
    public boolean isUserHeaders() {
        return this.myIsUserHeaders;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myRoot;
    }

    @NotNull
    public List<VirtualFile> getHeaders() {
        return this.myHeaders;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (processor2 instanceof HeadersSearchRootProcessor && ((HeadersSearchRootProcessor)processor2).shouldProcessRootsOnly()) {
            return true;
        }
        return this.processCustomFileSet(processor2, this.myHeaders, false);
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapInCollectionPathResolver((VirtualFile)(this.myRoot == null ? NullVirtualFile.INSTANCE : this.myRoot), this.myHeaders);
    }

    @Override
    @Nullable
    protected ModuleMapFile getModuleMapFile() {
        VirtualFile virtualFile = (VirtualFile)ContainerUtil.find(this.myHeaders, file -> FileUtil.pathsEqual((String)"module.modulemap", (String)file.getName()));
        if (virtualFile == null) {
            virtualFile = (VirtualFile)ContainerUtil.find(this.myHeaders, file -> FileUtil.pathsEqual((String)"module.map", (String)file.getName()));
        }
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        try {
            return ModuleMapFileImpl.createFromText(VfsUtilCore.loadText((VirtualFile)virtualFile), PsiManager.getInstance((Project)this.myProject));
        }
        catch (IOException e) {
            OCLog.LOG.error("Failed to read module map from " + virtualFile, (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.getName() + ", size: " + this.myHeaders.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomHeadersRoot root = (CustomHeadersRoot)o;
        return this.myIsUserHeaders == root.myIsUserHeaders && this.myHashCodeCache == root.myHashCodeCache && Objects.equals(this.myRoot, root.myRoot) && this.myHeaders.equals(root.myHeaders);
    }

    public int hashCode() {
        return this.myHashCodeCache;
    }
}

