/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.FrameworkRootModuleMapCollector;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FrameworksSearchRoot
extends FrameworksRoot {
    @NotNull
    private final VirtualFile myRoot;

    public FrameworksSearchRoot(@NotNull Project project2, @NotNull VirtualFile root) {
        super(project2);
        this.myRoot = root;
    }

    @NotNull
    public String getName() {
        return "Frameworks Search Root";
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myRoot;
    }

    @Override
    public boolean processFrameworks(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed, boolean includeSdkFrameworks) {
        return AppleFramework.processFrameworksUnder((PsiFileSystemItem)this, this.myRoot, processor2, processed);
    }

    @Override
    @NotNull
    public Collection<? extends HeadersSearchRoot> getPossibleModuleMapLocations() {
        ArrayList roots = ContainerUtil.newArrayList();
        this.processChildren(new FrameworkRootModuleMapCollector(this.myProject, roots));
        return roots;
    }

    public String toString() {
        return "FrameworksSearchRoot: " + this.myRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FrameworksSearchRoot root = (FrameworksSearchRoot)((Object)o);
        return this.myRoot.equals(root.myRoot);
    }

    public int hashCode() {
        return this.myRoot.hashCode();
    }
}

