/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jetbrains.annotations.NotNull;

public class HeadersSearchPath {
    private static final int RECURSIVE = 1;
    private static final int USER = 2;
    private static final int FRAMEWORK = 4;
    @NotNull
    private final String myFilePath;
    private final int myFlags;

    public HeadersSearchPath(@NotNull File file, boolean recursive, boolean userHeader) {
        this(file, recursive, userHeader, false);
    }

    public HeadersSearchPath(@NotNull File file, boolean recursive, boolean userHeader, boolean frameworksSearchPath) {
        this(file.getPath(), recursive, userHeader, frameworksSearchPath);
    }

    public HeadersSearchPath(@NotNull String filePath2, boolean recursive, boolean userHeader, boolean frameworksSearchPath) {
        this(filePath2, (recursive ? 1 : 0) | (userHeader ? 2 : 0) | (frameworksSearchPath ? 4 : 0));
    }

    public HeadersSearchPath(@NotNull HeadersSearchPath headersSearchPath, @NotNull File file) {
        this(file.getPath(), headersSearchPath.myFlags);
    }

    private HeadersSearchPath(@NotNull String filePath2, int flags) {
        this.myFilePath = filePath2;
        this.myFlags = flags;
    }

    @NotNull
    public static HeadersSearchPath read(@NotNull ObjectInputStream in) throws IOException {
        try {
            return new HeadersSearchPath((String)in.readObject(), in.readInt());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public void write(@NotNull ObjectOutputStream out) throws IOException {
        out.writeObject(this.getPath());
        out.writeInt(this.myFlags);
    }

    @NotNull
    public File getFile() {
        return new File(this.myFilePath);
    }

    @NotNull
    public String getPath() {
        return this.myFilePath;
    }

    public boolean isRecursive() {
        return (this.myFlags & 1) != 0;
    }

    public boolean isUserHeaders() {
        return (this.myFlags & 2) != 0;
    }

    public boolean isFrameworksSearchPath() {
        return (this.myFlags & 4) != 0;
    }

    public String toString() {
        return "HeadersSearchPath{" + this.myFilePath + ", " + (this.isUserHeaders() ? "user" : "system") + ", " + (this.isRecursive() ? "recursive" : "non-recursive") + (this.isFrameworksSearchPath() ? ", frameworks" : "") + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersSearchPath that = (HeadersSearchPath)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        return FileUtil.pathsEqual((String)this.myFilePath, (String)that.myFilePath);
    }

    public int hashCode() {
        int result = FileUtil.pathHashCode((String)this.myFilePath);
        result = 31 * result + this.myFlags;
        return result;
    }
}

