/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.modulemap.ModuleMapModules;
import com.jetbrains.cidr.lang.modulemap.ModuleMapModulesBuilder;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbolBuilder;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapEmptyFileSymbolImpl;
import com.jetbrains.cidr.lang.symbols.symtable.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderMapRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedFilesProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeadersSearchRoot
extends SyntheticFileSystemItem {
    @Nullable
    public static HeadersSearchRoot createFromHeaderSearchPath(@NotNull Project project2, @NotNull HeadersSearchPath searchPath, @NotNull Disposable parentDisposable) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(searchPath.getFile());
        return HeadersSearchRoot.createFromHeaderSearchPath(project2, searchPath, virtualFile, parentDisposable);
    }

    @Nullable
    public static HeadersSearchRoot createFromHeaderSearchPath(@NotNull Project project2, @NotNull HeadersSearchPath searchPath, @Nullable VirtualFile preparedVirtualFile, @NotNull Disposable parentDisposable) {
        HeaderMapRoot headerMapRoot = OCHeaderMapManager.getInstance(project2).createHeaderMapRoot(searchPath, preparedVirtualFile, parentDisposable);
        if (headerMapRoot != null || preparedVirtualFile == null || !preparedVirtualFile.isDirectory()) {
            return headerMapRoot;
        }
        return searchPath.isFrameworksSearchPath() ? new FrameworksSearchRoot(project2, preparedVirtualFile) : new IncludedHeadersRoot(project2, preparedVirtualFile, searchPath.isRecursive(), searchPath.isUserHeaders());
    }

    HeadersSearchRoot(Project project2) {
        super(project2);
    }

    public PsiFileSystemItem getParent() {
        return null;
    }

    @Nullable
    public abstract VirtualFile getVirtualFile();

    @NotNull
    public ModuleMapModules collectDeclaredModules(@Nullable OCResolveConfiguration configuration) {
        return this.collectDeclaredModules(configuration, null);
    }

    @NotNull
    public ModuleMapModules collectDeclaredModules(@Nullable OCResolveConfiguration configuration, @Nullable SerializationSession serializationSession) {
        ModuleMapModulesBuilder builder = new ModuleMapModulesBuilder();
        ModuleMapFileSymbol map2 = this.getModuleMap(configuration, serializationSession);
        if (map2 != null) {
            builder.add(map2.getAllModulesRecursively());
        }
        return builder.build();
    }

    @NotNull
    public Collection<? extends HeadersSearchRoot> getPossibleModuleMapLocations() {
        return Collections.singletonList(this);
    }

    @Nullable
    public ModuleMapFileSymbol getModuleMap(@Nullable OCResolveConfiguration configuration) {
        return this.getModuleMap(configuration, null);
    }

    @Nullable
    public ModuleMapFileSymbol getModuleMap(@Nullable OCResolveConfiguration configuration, @Nullable SerializationSession serializationSession) {
        ModuleMapCache moduleMapCache = ModuleMapCache.getInstance(this.myProject);
        ModuleMapFileSymbol moduleMap = moduleMapCache.get(this, configuration);
        if (moduleMap == null) {
            ModuleMapFile file = this.getModuleMapFile();
            moduleMap = file != null ? this.buildModuleMap(file, configuration, serializationSession) : ModuleMapEmptyFileSymbolImpl.INSTANCE;
            moduleMap = moduleMapCache.cacheOrGet(this, configuration, moduleMap);
        }
        return moduleMap == ModuleMapEmptyFileSymbolImpl.INSTANCE ? null : moduleMap;
    }

    @NotNull
    protected ModuleMapFileSymbol buildModuleMap(@NotNull ModuleMapFile file, @Nullable OCResolveConfiguration configuration, @Nullable SerializationSession serializationSession) {
        return (ModuleMapFileSymbol)ReadAction.compute(() -> new ModuleMapSymbolBuilder(this.myProject, configuration, this.createModuleMapPathResolver(), serializationSession).processFile(file));
    }

    @Nullable
    protected ModuleMapFile getModuleMapFile() {
        File moduleMapFile = this.findModuleMapFile();
        if (moduleMapFile != null && moduleMapFile.isFile()) {
            try {
                return ModuleMapFileImpl.createFromText(FileUtil.loadFile((File)moduleMapFile), PsiManager.getInstance((Project)this.myProject));
            }
            catch (IOException e) {
                OCLog.LOG.info("IOException reading module map at path " + moduleMapFile.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        throw new IllegalStateException("createModuleMapPathResolver() is not implemented for a HeadersSearchRoot with findModuleMapFile() implemented");
    }

    public boolean hasModuleMap() {
        return this.findModuleMapFile() != null;
    }

    @Nullable
    protected File findModuleMapFile() {
        return null;
    }

    public boolean isUserHeaders() {
        return false;
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base) {
        return this.processUnder(processor2, base, null);
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base, @Nullable Condition<VirtualFile> condition) {
        return this.processUnder(processor2, base, false, condition);
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base, boolean recursive, @Nullable Condition<VirtualFile> condition) {
        if (base == null) {
            return true;
        }
        if (IncludedFilesProcessor.shouldSkip(base, processor2)) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            if (!IncludedFilesProcessor.processFile(this.myProject, base, condition, processor2)) {
                return false;
            }
            if (((HeadersSearchRootProcessor)processor2).shouldProcessRootsOnly()) {
                return true;
            }
        }
        if (processor2 instanceof SpecificNameItemProcessor) {
            String name2 = ((SpecificNameItemProcessor)processor2).getName();
            VirtualFile file = base.findChild(name2);
            return file == null || IncludedFilesProcessor.processFile(this.myProject, file, condition, processor2);
        }
        if (!base.isValid()) {
            return true;
        }
        VirtualFile[] children = base.getChildren();
        return children == null || IncludedFilesProcessor.processFiles(this.myProject, Arrays.asList(children), condition, recursive, processor2);
    }

    protected boolean processCustomFileSet(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Iterable<VirtualFile> files, boolean recursive) {
        return IncludedFilesProcessor.processFiles(this.myProject, files, null, recursive, processor2);
    }
}

