/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.IncludedHeadersRootModuleMapCollector;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapDefaultPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class IncludedHeadersRoot
extends HeadersRoot {
    @NotNull
    private final VirtualFile myIncludedDir;
    private final boolean myRecursive;
    private final boolean myUserHeaders;

    public IncludedHeadersRoot(@NotNull Project project2, @NotNull VirtualFile includedDir, boolean recursive, boolean userHeaders) {
        super(project2);
        this.myIncludedDir = includedDir;
        this.myRecursive = recursive;
        this.myUserHeaders = userHeaders;
    }

    @NotNull
    public String getName() {
        return "Included Headers";
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myIncludedDir;
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapDefaultPathResolver(this.myIncludedDir);
    }

    @Override
    @NotNull
    protected File findModuleMapFile() {
        File file = new File(this.myIncludedDir.getPath(), "module.modulemap");
        if (!file.exists()) {
            file = new File(this.myIncludedDir.getPath(), "module.map");
        }
        return file;
    }

    public boolean isRecursive() {
        return this.myRecursive;
    }

    @Override
    public boolean isUserHeaders() {
        return this.myUserHeaders;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return this.processUnder(processor2, this.myIncludedDir, this.myRecursive, null);
    }

    @Override
    @NotNull
    public Collection<? extends HeadersSearchRoot> getPossibleModuleMapLocations() {
        ArrayList roots = ContainerUtil.newArrayList();
        this.processUnder(new IncludedHeadersRootModuleMapCollector(this.myProject, this.myUserHeaders, roots), this.myIncludedDir, false, null);
        return roots;
    }

    public String toString() {
        return this.getName() + " @ " + this.myIncludedDir + ": " + (this.myUserHeaders ? "user" : "system") + (this.myRecursive ? " [recursive]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IncludedHeadersRoot root = (IncludedHeadersRoot)((Object)o);
        if (this.myRecursive != root.myRecursive) {
            return false;
        }
        if (this.myUserHeaders != root.myUserHeaders) {
            return false;
        }
        return this.myIncludedDir.equals(root.myIncludedDir);
    }

    public int hashCode() {
        int result = this.myIncludedDir.hashCode();
        result = 31 * result + (this.myRecursive ? 1 : 0);
        result = 31 * result + (this.myUserHeaders ? 1 : 0);
        return result;
    }
}

