/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathTree<Self extends PathTree<Self, T>, T> {
    @Nullable
    protected THashSet<T> myItems;
    @Nullable
    protected THashMap<String, Self> myChildren;

    public void addItem(@NotNull String path, @NotNull T item) {
        Self subTree = this.getNotNullSubTree(path);
        super.getItemsForWrite().add(item);
    }

    public int removeItem(@NotNull String path, @NotNull T ref) {
        THashSet<T> references;
        Self subTree = this.getSubTree(path, SearchStrategy.NULL_IF_NOT_FOUND);
        if (subTree != null && (references = ((PathTree)subTree).myItems) != null) {
            references.remove(ref);
            return references.size();
        }
        return 0;
    }

    @NotNull
    public Set<T> getItems() {
        return this.myItems == null ? Collections.emptySet() : this.myItems;
    }

    @NotNull
    public Collection<Self> getChildren() {
        return this.myChildren == null ? Collections.emptySet() : this.myChildren.values();
    }

    @NotNull
    protected Self getNotNullSubTree(@NotNull String path) {
        return this.getSubTree(path, SearchStrategy.BUILD_IF_NOT_FOUND);
    }

    @Deprecated
    @Nullable
    public Self getSubTree(@NotNull String path, boolean createSubtrees) {
        return this.getSubTree(path, createSubtrees ? SearchStrategy.BUILD_IF_NOT_FOUND : SearchStrategy.NULL_IF_NOT_FOUND);
    }

    @Nullable
    public Self getSubTree(@NotNull String path, @NotNull SearchStrategy strategy) {
        return this.getSubTree(StringUtil.split((String)FileUtil.toCanonicalPath((String)path), (String)"/", (boolean)true, (boolean)false), strategy);
    }

    @Nullable
    private Self getSubTree(@NotNull List<String> pathComps, SearchStrategy strategy) {
        Self result = this.self();
        int pathCompsCount = pathComps.size();
        for (int i = 0; i < pathCompsCount && result != null; ++i) {
            Self t = result;
            String key = pathComps.get(i);
            Self st = super.getChild(key);
            if (st == null) {
                if (strategy == SearchStrategy.BUILD_IF_NOT_FOUND) {
                    st = super.createChild(key);
                } else if (strategy == SearchStrategy.DEEPEST_EXISTING_PREFIX) {
                    return result;
                }
            }
            result = st;
        }
        return result;
    }

    protected Self self() {
        return (Self)this;
    }

    protected abstract Self createNewTree(@Nullable Self var1);

    @NotNull
    private Set<T> getItemsForWrite() {
        if (this.myItems == null) {
            this.myItems = new THashSet();
        }
        return this.myItems;
    }

    @Nullable
    private Self getChild(@NotNull String key) {
        if (this.myChildren == null) {
            return null;
        }
        return (Self)((PathTree)this.myChildren.get((Object)key));
    }

    private Self createChild(@NotNull String name2) {
        if (this.myChildren == null) {
            this.myChildren = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
        }
        Self tree = this.createNewTree(this.self());
        this.myChildren.put((Object)name2, tree);
        return tree;
    }

    public static enum SearchStrategy {
        NULL_IF_NOT_FOUND,
        BUILD_IF_NOT_FOUND,
        DEEPEST_EXISTING_PREFIX;

    }
}

