/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.psi.impl.legacy.ModuleMapLegacyFileImpl;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapRealFrameworkPathResolver;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RealFramework
extends AppleFramework {
    @Nullable
    private final PsiFileSystemItem myParent;
    @NotNull
    private final VirtualFile myBaseFile;

    public RealFramework(@NotNull Project project2, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        this(project2, null, baseFile, parentSdkOrFramework);
    }

    public RealFramework(@NotNull Project project2, @Nullable OCResolveConfiguration configuration, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        super(project2, configuration, baseFile.getNameWithoutExtension());
        this.myParent = parentSdkOrFramework;
        this.myBaseFile = baseFile;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParent() {
        return this.myBaseFile.isValid() ? this.myManager.findDirectory(this.myBaseFile) : null;
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapRealFrameworkPathResolver(this.myBaseFile);
    }

    @Override
    @Nullable
    protected File findModuleMapFile() {
        File moduleMapFile = null;
        File modulesDir = new File(this.myBaseFile.getPath(), "Modules");
        if (modulesDir.exists() && modulesDir.isDirectory()) {
            moduleMapFile = new File(modulesDir, "module.modulemap");
        }
        if (moduleMapFile == null || !moduleMapFile.exists()) {
            moduleMapFile = new File(this.myBaseFile.getPath(), "module.map");
        }
        if (!moduleMapFile.exists()) {
            moduleMapFile = null;
        }
        return moduleMapFile;
    }

    @Override
    @NotNull
    protected ModuleMapFile getModuleMapFile() {
        ModuleMapFile file = super.getModuleMapFile();
        if (file == null) {
            file = new ModuleMapLegacyFileImpl(this.getName(), this.myProject);
        }
        return file;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParentSdkOrFrameworkItem() {
        return this.myParent;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myBaseFile;
    }

    @Override
    public boolean containsHeader(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule(this.getConfiguration());
        if (module2 == null) {
            return false;
        }
        return module2.getPathResolver().containsHeader(file);
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        Boolean result;
        if (processor2 instanceof HeadersSearchRootProcessor && (result = this.processAsRoot((HeadersSearchRootProcessor)processor2)) != null) {
            return result;
        }
        if (this.myBaseFile.isValid()) {
            for (String eachDir : HEADERS_DIR_NAMES) {
                if (this.processUnder(processor2, this.myBaseFile.findChild(eachDir))) continue;
                return false;
            }
            if (!RealFramework.processFrameworksUnder((PsiFileSystemItem)this, this.myBaseFile.findChild("Frameworks"), processor2, (Set<String>)new THashSet())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealFramework framework = (RealFramework)((Object)o);
        return this.myBaseFile.equals(framework.myBaseFile);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myBaseFile.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "AppleFramework: [" + this.getName() + ": " + this.myBaseFile.getPath() + "]";
    }
}

