/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrExcludePolicy
implements DirectoryIndexExcludePolicy {
    @NotNull
    private final Project myProject;

    public CidrExcludePolicy(@NotNull Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public String[] getExcludeUrlsForProject() {
        List<CidrWorkspace> workspaces = CidrWorkspace.getInitializedWorkspaces(this.myProject);
        if (workspaces.isEmpty()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return (String[])ReadAction.compute(() -> (String[])workspaces.stream().map(workspace -> workspace.collectExcludeUrls()).flatMap(Collection::stream).distinct().toArray(String[]::new));
    }

    @NotNull
    public VirtualFilePointer[] getExcludeRootsForModule(@NotNull ModuleRootModel rootModel) {
        return VirtualFilePointer.EMPTY_ARRAY;
    }
}

