/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.project.CidrChangeProjectContentRootAction;
import com.jetbrains.cidr.project.CidrRootConfigurationListener;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceProvider;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceUtilKt;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrWorkspace {
    @Nullable
    protected static BalloonNotifier ourBalloonNotifier;
    @NotNull
    protected final Project myProject;
    @Nullable
    protected volatile File myProjectDir;
    @Nullable
    protected volatile File myContentRoot;
    private volatile boolean myReportFilesOutsideRoots;
    private volatile boolean myIgnoreFilesOutsideOfProjectRoot;
    @NotNull
    protected final OCRootsSynchronizer myRootsSynchronizer;
    protected final Disposable myBusConnectionDisposable = Disposer.newDisposable();
    private boolean myUpdateContentRootsRecursionProtection;

    @NotNull
    public static List<CidrWorkspace> getInitializedWorkspaces(@NotNull Project project2) {
        return ContainerUtil.filter(CidrWorkspace.getWorkspaces(project2), it -> it != null && it.isInitialized());
    }

    @NotNull
    public static List<CidrWorkspace> getWorkspaces(@NotNull Project project2) {
        return CidrWorkspaceProvider.EP_NAME.getExtensionList().stream().map(provider2 -> provider2.getWorkspace(project2)).filter(workspace -> workspace != null).collect(Collectors.toList());
    }

    protected CidrWorkspace(@NotNull Project project2) {
        this.myProject = project2;
        if (!CidrWorkspaceUtilKt.shouldLoadWorkspaceForProject(project2)) {
            this.myRootsSynchronizer = null;
            return;
        }
        this.myRootsSynchronizer = new OCRootsSynchronizer(project2);
    }

    public abstract boolean isInitialized();

    @NotNull
    protected abstract OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable Module var1, @Nullable File var2);

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public File getProjectSubDir(@NotNull File subdir) {
        if (subdir.isAbsolute()) {
            return subdir;
        }
        return new File(this.getProjectDir(), subdir.getPath()).getAbsoluteFile();
    }

    @NotNull
    public File getProjectDir() {
        File projectDir = this.myProjectDir;
        if (projectDir == null) {
            String basePath = this.myProject.getBasePath();
            if (basePath == null) {
                throw new NullPointerException("Project base path is null. default = " + this.myProject.isDefault());
            }
            projectDir = new File(basePath);
        }
        return projectDir.getAbsoluteFile();
    }

    protected void initializeAndStart() {
        Disposer.register((Disposable)this.myProject, (Disposable)this.myBusConnectionDisposable);
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this.myBusConnectionDisposable);
        connection.subscribe(CidrRootConfigurationListener.TOPIC, (Object)new CidrRootConfigurationListener(){

            @Override
            public void configurationChanged() {
                CidrWorkspace.this.updateContentRoots();
            }
        });
        this.myRootsSynchronizer.startListening();
    }

    protected void shutdown() {
        this.myRootsSynchronizer.shutdown();
        Disposer.dispose((Disposable)this.myBusConnectionDisposable);
    }

    public final List<String> collectExcludeUrls() {
        return ContainerUtil.map(this.collectExcludeRoots(this.myContentRoot, true), file -> VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)file.getPath())));
    }

    @NotNull
    public List<File> collectExcludeRoots(@Nullable File contentRoot, boolean includePotentialNotYetExistingExcludes) {
        return Collections.emptyList();
    }

    @Nullable
    protected File beforeUpdateContentRoots(@Nullable File contentRoot) {
        return contentRoot;
    }

    protected void afterUpdateContentRoots(@Nullable File contentRoot) {
    }

    public void updateContentRoots() {
        this.updateContentRoots(false);
    }

    protected void updateContentRoots(boolean forceRootChangesEvents) {
        this.updateContentRoots(this.myContentRoot, forceRootChangesEvents);
    }

    protected void updateContentRoots(@Nullable File contentRoot) {
        this.updateContentRoots(contentRoot, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContentRoots(@Nullable File contentRoot, boolean forceRootChangesEvents) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myProject.isDefault()) {
            return;
        }
        if (this.myUpdateContentRootsRecursionProtection) {
            return;
        }
        this.myUpdateContentRootsRecursionProtection = true;
        try {
            contentRoot = this.beforeUpdateContentRoots(contentRoot);
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            this.collectExcludeRoots(contentRoot, false).forEach(it -> {
                changeListManager.addDirectoryToIgnoreImplicitly(FileUtil.toCanonicalPath((String)it.getPath()));
                while ((it = it.getParentFile()) != null) {
                    changeListManager.removeImplicitlyIgnoredDirectory(FileUtil.toCanonicalPath((String)it.getPath()));
                }
            });
            OCRootsSynchronizer.RootsInfo rootsInfo = this.collectRootsInfo(this.myRootsSynchronizer.getModuleOrCreateNew(), contentRoot);
            boolean reportOutsideFiles = this.outsideFilesExist(rootsInfo);
            if (!reportOutsideFiles) {
                this.myIgnoreFilesOutsideOfProjectRoot = false;
            }
            this.myReportFilesOutsideRoots = reportOutsideFiles;
            this.myRootsSynchronizer.updateRoots(rootsInfo, forceRootChangesEvents);
            this.afterUpdateContentRoots(contentRoot);
        }
        finally {
            this.myUpdateContentRootsRecursionProtection = false;
        }
    }

    protected boolean outsideFilesExist(@NotNull OCRootsSynchronizer.RootsInfo rootsInfo) {
        return !OCRootsSynchronizer.isUnder(rootsInfo.contentRoots, rootsInfo.sourceFiles);
    }

    protected void reportFilesOutsideContentRoot(@NotNull String message, @Nullable String toolWindowId) {
        if (this.myReportFilesOutsideRoots && !this.myIgnoreFilesOutsideOfProjectRoot) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            final HyperlinkAdapter listener = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    if ("change".equals(e.getDescription())) {
                        CidrChangeProjectContentRootAction.perform(CidrWorkspace.this.myProject, CidrWorkspace.this);
                    } else if ("ignore".equals(e.getDescription())) {
                        CidrWorkspace.this.myIgnoreFilesOutsideOfProjectRoot = true;
                    }
                }
            };
            if (ourBalloonNotifier != null) {
                ourBalloonNotifier.notify(MessageType.WARNING, message, (HyperlinkListener)listener);
            } else if (toolWindowId != null) {
                ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon(toolWindowId, MessageType.WARNING, message, null, (HyperlinkListener)listener);
            } else {
                NotificationListener notificationListener = new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        listener.hyperlinkUpdate(event);
                        notification.expire();
                    }
                };
                Notification notification = NotificationGroup.balloonGroup((String)"Workspace").createNotification(null, null, message, NotificationType.WARNING, notificationListener);
                notification.notify(this.myProject);
            }
        }
    }

    public void updateContentRoots(@NotNull ModifiableRootModel model) {
        this.myRootsSynchronizer.updateModuleRoots(model, this.collectRootsInfo(model.getModule(), this.myContentRoot));
    }

    public void changeContentRoot(@Nullable VirtualFile contentRoot) {
        this.myIgnoreFilesOutsideOfProjectRoot = false;
        this.updateContentRoots(contentRoot == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot));
    }

    @Nullable
    public VirtualFile getEffectiveContentRoot() {
        File root = this.myContentRoot;
        return root == null ? null : LocalFileSystem.getInstance().findFileByIoFile(root);
    }

    @Nullable
    public Module getModule() {
        return this.myRootsSynchronizer.getModuleIfExists();
    }

    @Nullable
    public File getCurrentContentRootIOFile() {
        return this.myContentRoot;
    }

    @NotNull
    public State getBaseState() {
        return new State(this.myProjectDir, this.myContentRoot, this.myIgnoreFilesOutsideOfProjectRoot);
    }

    public void loadBaseState(@NotNull State state) {
        this.myProjectDir = state.myProjectDir;
        this.myContentRoot = state.myContentRoot;
        this.myIgnoreFilesOutsideOfProjectRoot = state.myIgnoreFilesOutsideOfProjectRoot;
    }

    public static void setBalloonNotifierInTests(@Nullable BalloonNotifier notifier) {
        ourBalloonNotifier = notifier;
    }

    public static interface BalloonNotifier {
        public void notify(@NotNull MessageType var1, @NotNull String var2, @NotNull HyperlinkListener var3);
    }

    public static class State {
        @Nullable
        public File myProjectDir = null;
        @Nullable
        public File myContentRoot = null;
        public boolean myIgnoreFilesOutsideOfProjectRoot = false;

        public State() {
        }

        public State(@Nullable File projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
            this.myProjectDir = projectDir;
            this.myContentRoot = contentRoot;
            this.myIgnoreFilesOutsideOfProjectRoot = ignoreFilesOutsideOfProjectRoot;
        }

        @NotNull
        public Element createElement() {
            return State.createStateElement(this);
        }

        @NotNull
        public static Element createStateElement(@Nullable File projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
            return State.createStateElement(new State(projectDir, contentRoot, ignoreFilesOutsideOfProjectRoot));
        }

        @NotNull
        public static Element createStateElement(@NotNull State state) {
            Element element = new Element("state");
            if (state.myIgnoreFilesOutsideOfProjectRoot) {
                element.setAttribute("IGNORE_OUTSIDE_FILES", "true");
            }
            if (state.myProjectDir != null) {
                element.setAttribute("PROJECT_DIR", FileUtil.toSystemIndependentName((String)state.myProjectDir.getPath()));
            }
            if (state.myContentRoot != null) {
                Element contentRootElement = new Element("contentRoot");
                contentRootElement.setAttribute("DIR", FileUtil.toSystemIndependentName((String)state.myContentRoot.getPath()));
                element.addContent(contentRootElement);
            }
            return element;
        }

        @NotNull
        public static State loadStateElement(@NotNull Element element) {
            State state = new State();
            state.loadElement(element);
            return state;
        }

        public void loadElement(@NotNull Element element) {
            String projectDirString = element.getAttributeValue("PROJECT_DIR");
            this.myProjectDir = projectDirString == null ? null : new File(projectDirString);
            Element contentRootElement = element.getChild("contentRoot");
            String contentRootDirString = contentRootElement == null ? null : contentRootElement.getAttributeValue("DIR");
            this.myContentRoot = contentRootDirString == null ? null : new File(contentRootDirString);
            this.myIgnoreFilesOutsideOfProjectRoot = Boolean.parseBoolean(element.getAttributeValue("IGNORE_OUTSIDE_FILES"));
        }
    }
}

