/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestingFrameworkUsagesCollector
extends ProjectUsagesCollector {
    public static final String GROUP_ID = "cidr.testingFrameworks";

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project2) {
        TObjectIntHashMap data = new TObjectIntHashMap();
        List configurationsList = (List)ReadAction.compute(() -> RunManager.getInstance((Project)project2).getAllConfigurationsList());
        for (RunConfiguration runConfiguration : configurationsList) {
            String name2 = CidrTestingFrameworkUsagesCollector.getFrameworkId(runConfiguration);
            if (name2 == null) continue;
            if (!data.containsKey((Object)name2)) {
                data.put((Object)name2, 0);
            }
            data.increment((Object)name2);
        }
        return ContainerUtil.map2Set((Object[])data.keys(), o -> {
            String key = (String)o;
            return new UsageDescriptor(key, data.get((Object)key));
        });
    }

    @Nullable
    public static String getFrameworkId(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration instanceof CidrTestRunConfiguration) {
            return (String)ReadAction.compute(() -> {
                CidrTestRunConfigurationData testData = ((CidrTestRunConfiguration)runConfiguration).getTestData();
                boolean canReportID = StatisticsUtilKt.getPluginType(testData.getClass()).isDevelopedByJetBrains();
                return canReportID ? testData.getTestingFrameworkId() : "thirdparty";
            });
        }
        return null;
    }

    @NotNull
    public String getGroupId() {
        return GROUP_ID;
    }
}

