/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHost
implements HostMachine {
    public static final LocalHost INSTANCE = new LocalHost();

    private LocalHost() {
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    @NotNull
    public OSType getOSType() {
        return OSType.getCurrent();
    }

    @Override
    @NotNull
    public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        return CidrToolsUtil.runProcess((BaseProcessHandler)new CapturingProcessHandler(cl), indicator, timeout);
    }

    @Override
    @NotNull
    public BaseProcessHandler createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty) throws ExecutionException {
        ColoredProcessHandler processHandler = colored ? new ColoredProcessHandler(cl) : new CapturingProcessHandler(cl);
        CidrToolsUtil.setHasPty((OSProcessHandler)processHandler, usePty);
        return processHandler;
    }

    @Override
    public void destroyProcess(@NotNull BaseProcessHandler handler) {
        handler.destroyProcess();
    }

    @Override
    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        OSProcessUtil.killProcessTree((Process)handler.getProcess());
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException {
        return Arrays.asList(OSProcessUtil.getProcessList());
    }

    @Override
    public int sendSignal(int pid, @NotNull String signalName) {
        if (this.getOSType() == OSType.WIN) {
            throw new UnsupportedOperationException("Not supported for Windows OS, use winbreak instead");
        }
        return UnixProcessManager.sendSignal((int)pid, (String)signalName);
    }

    @Override
    @NotNull
    public Path getPath(String first, String ... more) {
        return Paths.get(first, more);
    }

    @Override
    public String toCanonicalPath(@NotNull String path, boolean resolveSymlink) {
        return FileUtil.toCanonicalPath((String)path, (boolean)resolveSymlink);
    }

    @Override
    @NotNull
    public Path getTempDirectory() {
        return Paths.get(FileUtil.getTempDirectory(), new String[0]);
    }

    @Override
    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        return FileUtil.createTempDirectory((String)prefix, (String)suffix).toPath();
    }

    @Override
    @NotNull
    public NamedPipe openNamedPipe() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull Path file) {
        return file.toFile();
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull File file) {
        return file;
    }

    @Override
    @NotNull
    public List<File> resolveAndCache(@NotNull List<String> paths) {
        return ContainerUtil.map(paths, p -> new File((String)p));
    }
}

