/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathMapper;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PathMapperWrapper
implements PathMapper {
    @NotNull
    private final PathMapper myPathMapper;

    public PathMapperWrapper(@NotNull PathMapper mapper) {
        this.myPathMapper = mapper;
    }

    public boolean isEmpty() {
        return this.myPathMapper.isEmpty();
    }

    public boolean canReplaceLocal(@NotNull String localPath) {
        return this.myPathMapper.canReplaceLocal(localPath);
    }

    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        return this.myPathMapper.convertToLocal(remotePath);
    }

    public boolean canReplaceRemote(@NotNull String remotePath) {
        return this.myPathMapper.canReplaceRemote(remotePath);
    }

    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        return this.myPathMapper.convertToRemote(localPath);
    }

    @NotNull
    public List<String> convertToRemote(@NotNull Collection<String> paths) {
        return this.myPathMapper.convertToRemote(paths);
    }

    public static PathMapper wrapOnWindows(@NotNull PathMapper pathMapper) {
        if (SystemInfo.isWindows) {
            return new PathMapperWrapper(pathMapper){

                @Override
                @NotNull
                public String convertToRemote(@NotNull String localPath) {
                    return FileUtil.toSystemIndependentName((String)super.convertToRemote(localPath));
                }
            };
        }
        return pathMapper;
    }
}

