/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import org.jetbrains.annotations.NotNull;

public class RemoteHostUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.remote");
    public static final int DEFAULT_COMMAND_TIMEOUT = StringUtil.parseInt((String)System.getProperty("cidr.remote.command.timeout"), (int)5000);

    @NotNull
    public static String resolveSymlink(@NotNull HostMachine host, @NotNull String path) {
        try {
            RemoteHostUtil.assertRemoteUnixOnly(host);
            LOG.debug("Resolve symlink: " + path);
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"readlink", "-f", path});
            ProcessOutput output = host.runProcess(cmd, null, DEFAULT_COMMAND_TIMEOUT);
            if (output.checkSuccess(LOG)) {
                String stdout = output.getStdout().trim();
                if (output.getExitCode() == 0 && StringUtil.isNotEmpty((String)stdout)) {
                    return stdout;
                }
            }
        }
        catch (ExecutionException e) {
            LOG.debug("Error while resolving symlink: " + path, (Throwable)e);
        }
        return path;
    }

    private static void assertRemoteUnixOnly(@NotNull HostMachine host) throws ExecutionException {
        if (!host.isRemote() || host.getOSType() == OSType.WIN) {
            throw new ExecutionException((Throwable)new UnsupportedOperationException(host.getName()));
        }
    }
}

