/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemUtil {
    private SystemUtil() {
    }

    public static String toLocalPath(@NotNull PathMapper pathMapper, @Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        String localPath = absoluteOrRelativeEnvPath;
        if (localBaseDir != null && !FileUtil.isUnixAbsolutePath((String)absoluteOrRelativeEnvPath)) {
            localPath = localBaseDir.getPath() + "/" + absoluteOrRelativeEnvPath;
        }
        return pathMapper.convertToLocal(localPath);
    }

    public static List<String> removeRedundant(@NotNull List<String> pathList) {
        if (pathList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>(pathList);
        ArrayList<String> result = new ArrayList<String>(paths.size());
        Collections.sort(paths);
        String cur = (String)paths.get(0);
        result.add(cur);
        for (String path : paths) {
            if (path.startsWith(cur)) continue;
            cur = path;
            result.add(cur);
        }
        return result;
    }
}

