/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiFile;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cmake.settings.Case;
import icons.CMakeIcons;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCompletionUtils {
    @NotNull
    public static LookupElementBuilder createStandardCommandItem(@NotNull String command, boolean boldCompletion, boolean putCaretInsideParentheses, @NotNull List<CMakeArgument> argumentList) {
        return CMakeCompletionUtils.createStandardCommandItem(command, boldCompletion, true, putCaretInsideParentheses, argumentList, null);
    }

    @NotNull
    private static LookupElementBuilder createStandardCommandItem(@NotNull String command, boolean boldCompletion, boolean addParentheses, boolean putCaretInsideParentheses, @NotNull List<CMakeArgument> argumentList, @Nullable Object equalsObject) {
        LookupElementBuilder lookupElementBuilder;
        if (addParentheses || putCaretInsideParentheses) {
            StringBuilder argumentsBuilder = new StringBuilder();
            argumentsBuilder.append('(');
            for (CMakeArgument argument : argumentList) {
                argumentsBuilder.append(argument.getLiteralNotNull().getText()).append(' ');
            }
            if (!argumentList.isEmpty()) {
                argumentsBuilder.deleteCharAt(argumentsBuilder.length() - 1);
            }
            argumentsBuilder.append(')');
            lookupElementBuilder = LookupElementBuilder.create((Object)new String(command + argumentsBuilder + (equalsObject != null ? equalsObject.toString() : "")), (String)command);
            lookupElementBuilder = lookupElementBuilder.withTailText(argumentsBuilder.toString());
        } else {
            lookupElementBuilder = LookupElementBuilder.create((Object)new String(command), (String)command);
        }
        if (boldCompletion) {
            lookupElementBuilder = lookupElementBuilder.bold();
        }
        if (addParentheses) {
            lookupElementBuilder = putCaretInsideParentheses || !argumentList.isEmpty() ? lookupElementBuilder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.getInstance((boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false)) : lookupElementBuilder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.getInstance((boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false));
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static String convertCommandToProperCase(@NotNull PsiFile file, @NotNull String textToComplete) {
        CMakeCodeStyleSettings cMakeSettings = (CMakeCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, CMakeCodeStyleSettings.class);
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.DO_NOT_CHANGE.getValue()) {
            return textToComplete;
        }
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.TO_LOWER.getValue()) {
            return textToComplete.toLowerCase(Locale.getDefault());
        }
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.TO_UPPER.getValue()) {
            return textToComplete.toUpperCase(Locale.getDefault());
        }
        return "";
    }

    @NotNull
    public static LookupElement createCommandItem(@NotNull String textToComplete, @NotNull String filename, @NotNull List<CMakeArgument> argumentsInCompletion, boolean isFunctionName, boolean addParentheses) {
        Icon icon = CMakeCompletionUtils.getRoutineIcon(isFunctionName);
        LookupElementBuilder lookupElementBuilder = CMakeCompletionUtils.createStandardCommandItem(textToComplete, false, addParentheses, false, argumentsInCompletion, filename + isFunctionName).withIcon(icon);
        return lookupElementBuilder.appendTailText(CMakeCompletionUtils.getStandardCMakeCompletionTailText(filename), true);
    }

    @NotNull
    @Contract(pure=true)
    private static String getStandardCMakeCompletionTailText(@NotNull String filename) {
        return " (in " + filename + ")";
    }

    @NotNull
    public static Icon getRoutineIcon(boolean isFunctionName) {
        return isFunctionName ? CMakeCompletionUtils.getFunctionIcon() : CMakeCompletionUtils.getMacroIcon();
    }

    @Contract(pure=true)
    @NotNull
    public static Icon getMacroIcon() {
        return CMakeIcons.CMake_Macro;
    }

    @Contract(pure=true)
    @NotNull
    public static Icon getFunctionIcon() {
        return CMakeIcons.CMake_Function;
    }
}

