/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion.contributors.providers;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.CMakePolicy;
import com.jetbrains.cmake.completion.CMakeRecognizedGnuLanguage;
import com.jetbrains.cmake.completion.CMakeRecognizedLanguage;
import com.jetbrains.cmake.completion.contributors.providers.AbstractCMakeCompletionProvider;
import com.jetbrains.cmake.completion.contributors.providers.CMakeVariableProviderUtils;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CMakeVariableProvider
extends AbstractCMakeCompletionProvider {
    private static final String CMAKE_VARIABLE_PREFIX = "${";
    private static final String[] INFORMATION_VARIABLES;
    private static final String[] CHANGING_INFORMATION_VARIABLES;
    private static final String CMAKE_POLICY_DEFAULT_VARIABLE_PREFIX = "CMAKE_POLICY_DEFAULT_";
    private static final String CMAKE_POLICY_WARNING_VARIABLE_PREFIX = "CMAKE_POLICY_WARNING_";
    private static final String[] BEHAVIOR_VARIABLES;
    private static final String[] CHANGING_BEHAVIOR_VARIABLES;
    public static final String[] CMAKE_POLICY_DEFAULT_HARDCODED;
    public static final String[] CMAKE_POLICY_WARNING_HARDCODED;
    private static final String[] SYSTEM_DESCRIPTION_VARIABLES;
    private static final String[] BUILD_CONTROL_VARIABLES;
    private static final String[] CMAKE_INCLUDE_WHAT_YOU_USE_HARDCODED;
    private static final String[] CMAKE_VISIBILITY_PRESET_HARDCODED;
    private static final String[] LANGUAGES_VARIABLES;
    private static final String CMAKE_COMPILER_IS_GNU_PREFIX = "CMAKE_COMPILER_IS_GNU";
    private static final String[] CMAKE_COMPILER_IS_GNU_VARIABLES;
    private static final String[] CHANGING_RECOGNIZED_LANGUAGES_VARIABLES;
    private static final String[] CHANGING_RECOGNIZED_LANGUAGES_VARIABLES_HARDCODED;
    private static final String[] CTEST_VARIABLES;
    private static final String[] CPACK_VARIABLES;
    private static final String[][] ALL_COMPLETION_VARIABLE_ARRAYS;
    private static final List<String> ALL_VARIABLES;
    static final String[] ALL_COMPLETION_VARIABLES;

    private static String[] createHardcodedVariablesFromCMakeLanguages(String prefix, String suffix) {
        String[] hardcodedVariables = new String[CMakeRecognizedLanguage.values().length];
        for (int i = 0; i < hardcodedVariables.length; ++i) {
            hardcodedVariables[i] = prefix + (Object)((Object)CMakeRecognizedLanguage.values()[i]) + suffix;
        }
        return hardcodedVariables;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        CMakeVariableProvider.addCompletions(parameters, result, CMAKE_VARIABLE_PREFIX, ALL_COMPLETION_VARIABLES);
    }

    protected static void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull String variablePrefix, @NotNull String[] completionVariables) {
        int indexOfVariableStart;
        String textToComplete = parameters.getPosition().getText();
        int variablePrefixLength = variablePrefix.length();
        IElementType type = parameters.getPosition().getNode().getElementType();
        int indexOfCaretInText = textToComplete.indexOf("IntellijIdeaRulezzz");
        if (indexOfCaretInText != -1 && (indexOfVariableStart = textToComplete.substring(0, indexOfCaretInText).lastIndexOf(variablePrefix)) + variablePrefixLength <= indexOfCaretInText) {
            if (textToComplete.startsWith(variablePrefix) && type != CMakeTokenTypes.LITERAL) {
                String matcherText = textToComplete.substring(0, indexOfCaretInText);
                CMakeVariableProvider.completeResults(matcherText, variablePrefixLength, parameters, result, completionVariables);
            } else if (type == CMakeTokenTypes.LITERAL) {
                boolean shouldComplete;
                boolean bl = shouldComplete = indexOfVariableStart >= 0 && (indexOfVariableStart == 0 || textToComplete.charAt(indexOfVariableStart - 1) != '\\');
                if (shouldComplete) {
                    String literalSuffix;
                    int possibleSuffixStart;
                    int prefixStart = 0;
                    int indexOfVariableStartInMatcherText = indexOfVariableStart + variablePrefixLength;
                    if (CMakeVariableProvider.incrementLiteralStartIndexForCompletionMatcher(textToComplete)) {
                        ++prefixStart;
                        --indexOfVariableStartInMatcherText;
                    }
                    String matcherText = textToComplete.substring(prefixStart, indexOfCaretInText);
                    int suffixEnd = textToComplete.length();
                    if (textToComplete.endsWith("\"")) {
                        --suffixEnd;
                    }
                    if ((possibleSuffixStart = indexOfCaretInText + "IntellijIdeaRulezzz ".length()) < textToComplete.length() && possibleSuffixStart < suffixEnd) {
                        literalSuffix = textToComplete.substring(possibleSuffixStart, suffixEnd);
                    } else {
                        int suffixStart = indexOfCaretInText + "IntellijIdeaRulezzz".length();
                        literalSuffix = textToComplete.substring(suffixStart, suffixEnd);
                    }
                    CMakeVariableProvider.completeResults(matcherText, indexOfVariableStartInMatcherText, parameters, result, literalSuffix, completionVariables);
                }
            }
        }
    }

    private static void completeResults(@NotNull String matcherText, int indexOfFirstVariableChar, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull String[] completionVariables) {
        CMakeVariableProvider.completeResults(matcherText, indexOfFirstVariableChar, parameters, result, "", completionVariables);
    }

    private static void completeResults(@NotNull String matcherText, int indexOfFirstVariableChar, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull String literalSuffix, @NotNull String[] completionVariables) {
        CMakeVariableProvider.completeResults(matcherText, indexOfFirstVariableChar, result, completionVariables, literalSuffix);
        if (CMakeVariableProviderUtils.shouldCreatePolicyCompletions(parameters) && CMakeVariableProvider.isInsideVariable(parameters)) {
            CMakeVariableProvider.completeResults(matcherText, indexOfFirstVariableChar, result, CMAKE_POLICY_DEFAULT_HARDCODED, literalSuffix);
            CMakeVariableProvider.completeResults(matcherText, indexOfFirstVariableChar, result, CMAKE_POLICY_WARNING_HARDCODED, literalSuffix);
        }
    }

    private static boolean isInsideVariable(@NotNull CompletionParameters parameters) {
        return parameters.getPosition().getText().contains(CMAKE_VARIABLE_PREFIX);
    }

    private static boolean incrementLiteralStartIndexForCompletionMatcher(String text) {
        return text.startsWith("\"");
    }

    private static void completeResults(@NotNull String matcherText, int indexOfFirstVariableChar, @NotNull CompletionResultSet result, @NotNull String[] completionVariables, @NotNull String literalSuffix) {
        List lookupElements = ContainerUtil.map((Object[])completionVariables, s -> LookupElementBuilder.create((String)s).withInsertHandler(CMakeVariableProvider.createParenthesisClosingHandler(literalSuffix)));
        result = CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE == 3 && indexOfFirstVariableChar != -1 ? result.withPrefixMatcher((PrefixMatcher)new FirstLetterCaseMatcher(matcherText.substring(indexOfFirstVariableChar), indexOfFirstVariableChar)) : result.withPrefixMatcher(matcherText.substring(Math.max(0, indexOfFirstVariableChar)));
        result.addAllElements((Iterable)lookupElements);
    }

    @NotNull
    private static InsertHandler<LookupElement> createParenthesisClosingHandler(final @NotNull String literalSuffix) {
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                int possibleTrailingParenthesisIndex = context.getStartOffset() + item.getLookupString().length();
                boolean addTrailingParenthesis = possibleTrailingParenthesisIndex < context.getDocument().getText().length() ? context.getDocument().getText().charAt(possibleTrailingParenthesisIndex) != '}' : true;
                boolean replacingCompletion = context.getCompletionChar() == '\t';
                int caretOffset = 0;
                if (addTrailingParenthesis) {
                    if (replacingCompletion) {
                        boolean needToInsertClosingParenthesis;
                        int closingParenthesis = literalSuffix.indexOf("}");
                        boolean bl = needToInsertClosingParenthesis = closingParenthesis == -1;
                        if (needToInsertClosingParenthesis) {
                            context.getDocument().insertString(context.getTailOffset(), (CharSequence)("}" + literalSuffix));
                            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset() - literalSuffix.length() + caretOffset);
                        } else {
                            String realSuffixToAppend = literalSuffix.substring(closingParenthesis);
                            context.getDocument().insertString(context.getTailOffset(), (CharSequence)realSuffixToAppend);
                            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset() - realSuffixToAppend.length() + caretOffset + 1);
                        }
                    } else {
                        context.getDocument().insertString(context.getTailOffset(), (CharSequence)"}");
                        context.getEditor().getCaretModel().moveToOffset(context.getTailOffset() + caretOffset);
                    }
                } else {
                    context.getEditor().getCaretModel().moveToOffset(Math.min(context.getDocument().getTextLength(), context.getTailOffset() + caretOffset + 1));
                }
            }
        };
    }

    public static String[] getAllCompletionVariables() {
        return ArrayUtil.toStringArray(ALL_VARIABLES);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var4_13;
        int i;
        INFORMATION_VARIABLES = new String[]{"CACHE", "CMAKE_ARGC", "CMAKE_ARGV0", "CMAKE_AR", "CMAKE_BINARY_DIR", "CMAKE_BUILD_TOOL", "CMAKE_BUILD_RPATH", "CMAKE_BUILD_RPATH_USE_ORIGIN", "CMAKE_CACHEFILE_DIR", "CMAKE_CACHE_MAJOR_VERSION", "CMAKE_CACHE_MINOR_VERSION", "CMAKE_CACHE_PATCH_VERSION", "CMAKE_CFG_INTDIR", "CMAKE_COMMAND", "CMAKE_CROSSCOMPILING", "CMAKE_CROSSCOMPILING_EMULATOR", "CMAKE_CTEST_COMMAND", "CMAKE_CUDA_HOST_COMPILER", "CMAKE_CUDA_EXTENSIONS", "CMAKE_CUDA_SEPARABLE_COMPILATION", "CMAKE_CUDA_STANDARD", "CMAKE_CUDA_STANDARD_REQUIRED", "CMAKE_CUDA_TOOLKIT_INCLUDE_DIRECTORIES", "CMAKE_CURRENT_BINARY_DIR", "CMAKE_CURRENT_LIST_DIR", "CMAKE_CURRENT_LIST_FILE", "CMAKE_CURRENT_LIST_LINE", "CMAKE_CURRENT_SOURCE_DIR", "CMAKE_DL_LIBS", "CMAKE_DOTNET_TARGET_FRAMEWORK_VERSION", "CMAKE_ECLIPSE_GENERATE_LINKED_RESOURCES", "CMAKE_ECLIPSE_GENERATE_SOURCE_PROJECT", "CMAKE_ECLIPSE_MAKE_ARGUMENTS", "CMAKE_ECLIPSE_VERSION", "CMAKE_EDIT_COMMAND", "CMAKE_EXECUTABLE_SUFFIX", "CMAKE_EXTRA_GENERATOR", "CMAKE_EXTRA_SHARED_LIBRARY_SUFFIXES", "CMAKE_FIND_PACKAGE_NAME", "CMAKE_FIND_PACKAGE_SORT_ORDER", "CMAKE_FIND_PACKAGE_SORT_DIRECTION", "CMAKE_GENERATOR", "CMAKE_GENERATOR_INSTANCE", "CMAKE_GENERATOR_PLATFORM", "CMAKE_GENERATOR_TOOLSET", "CMAKE_HOME_DIRECTORY", "CMAKE_IMPORT_LIBRARY_PREFIX", "CMAKE_IMPORT_LIBRARY_SUFFIX", "CMAKE_JOB_POOLS", "CMAKE_JOB_POOL_COMPILE", "CMAKE_JOB_POOL_LINK", "CMAKE_LINK_LIBRARY_SUFFIX", "CMAKE_MAJOR_VERSION", "CMAKE_MAKE_PROGRAM", "CMAKE_MATCH_<n>", "CMAKE_MATCH_COUNT", "CMAKE_MAXIMUM_RECURSION_DEPTH", "CMAKE_MINIMUM_REQUIRED_VERSION", "CMAKE_MINOR_VERSION", "CMAKE_PARENT_LIST_FILE", "CMAKE_PATCH_VERSION", "CMAKE_PROJECT_DESCRIPTION", "CMAKE_PROJECT_HOMEPAGE_URL", "CMAKE_PROJECT_NAME", "CMAKE_PROJECT_VERSION", "CMAKE_PROJECT_VERSION_MAJOR", "CMAKE_PROJECT_VERSION_MINOR", "CMAKE_PROJECT_VERSION_PATCH", "CMAKE_PROJECT_VERSION_TWEAK", "CMAKE_RANLIB", "CMAKE_ROOT", "CMAKE_RULE_MESSAGES", "CMAKE_SCRIPT_MODE_FILE", "CMAKE_SHARED_LIBRARY_PREFIX", "CMAKE_SHARED_LIBRARY_SUFFIX", "CMAKE_SHARED_MODULE_PREFIX", "CMAKE_SHARED_MODULE_SUFFIX", "CMAKE_SIZEOF_VOID_P", "CMAKE_SKIP_INSTALL_RULES", "CMAKE_SKIP_RPATH", "CMAKE_SOURCE_DIR", "CMAKE_STATIC_LIBRARY_PREFIX", "CMAKE_STATIC_LIBRARY_SUFFIX", "CMAKE_TOOLCHAIN_FILE", "CMAKE_TWEAK_VERSION", "CMAKE_VERBOSE_MAKEFILE", "CMAKE_VERSION", "CMAKE_VS_GLOBALS", "CMAKE_VS_DEVENV_COMMAND", "CMAKE_VS_INTEL_Fortran_PROJECT_VERSION", "CMAKE_VS_MSBUILD_COMMAND", "CMAKE_VS_MSDEV_COMMAND", "CMAKE_VS_NsightTegra_VERSION", "CMAKE_VS_PLATFORM_NAME", "CMAKE_VS_PLATFORM_TOOLSET", "CMAKE_VS_PLATFORM_TOOLSET_CUDA", "CMAKE_VS_PLATFORM_TOOLSET_HOST_ARCHITECTURE", "CMAKE_VS_PLATFORM_TOOLSET_VERSION", "CMAKE_VS_SDK_EXCLUDE_DIRECTORIES", "CMAKE_VS_SDK_EXECUTABLE_DIRECTORIES", "CMAKE_VS_SDK_INCLUDE_DIRECTORIES", "CMAKE_VS_SDK_LIBRARY_DIRECTORIES", "CMAKE_VS_SDK_LIBRARY_WINRT_DIRECTORIES", "CMAKE_VS_SDK_REFERENCE_DIRECTORIES", "CMAKE_VS_SDK_SOURCE_DIRECTORIES", "CMAKE_XCODE_GENERATE_SCHEME", "CMAKE_XCODE_GENERATE_TOP_LEVEL_PROJECT_ONLY", "CMAKE_XCODE_PLATFORM_TOOLSET", "CMAKE_XCODE_SCHEME_ADDRESS_SANITIZER", "CMAKE_XCODE_SCHEME_ADDRESS_SANITIZER_USE_AFTER_RETURN", "CMAKE_XCODE_SCHEME_DISABLE_MAIN_THREAD_CHECKER", "CMAKE_XCODE_SCHEME_DYNAMIC_LIBRARY_LOADS", "CMAKE_XCODE_SCHEME_DYNAMIC_LINKER_API_USAGE", "CMAKE_XCODE_SCHEME_GUARD_MALLOC", "CMAKE_XCODE_SCHEME_MAIN_THREAD_CHECKER_STOP", "CMAKE_XCODE_SCHEME_MALLOC_GUARD_EDGES", "CMAKE_XCODE_SCHEME_MALLOC_SCRIBBLE", "CMAKE_XCODE_SCHEME_MALLOC_STACK", "CMAKE_XCODE_SCHEME_THREAD_SANITIZER", "CMAKE_XCODE_SCHEME_THREAD_SANITIZER_STOP", "CMAKE_XCODE_SCHEME_UNDEFINED_BEHAVIOUR_SANITIZER", "CMAKE_XCODE_SCHEME_UNDEFINED_BEHAVIOUR_SANITIZER_STOP", "CMAKE_XCODE_SCHEME_ZOMBIE_OBJECTS", "PROJECT_BINARY_DIR", "PROJECT_DESCRIPTION", "PROJECT_HOMEPAGE_URL", "PROJECT_NAME", "PROJECT_SOURCE_DIR", "PROJECT_VERSION", "PROJECT_VERSION_MAJOR", "PROJECT_VERSION_MINOR", "PROJECT_VERSION_PATCH", "PROJECT_VERSION_TWEAK"};
        CHANGING_INFORMATION_VARIABLES = new String[]{"<PROJECT-NAME>_BINARY_DIR", "<PROJECT-NAME>_DESCRIPTION", "<PROJECT-NAME>_HOMEPAGE_URL", "<PROJECT-NAME>_SOURCE_DIR", "<PROJECT-NAME>_VERSION", "<PROJECT-NAME>_VERSION_MAJOR", "<PROJECT-NAME>_VERSION_MINOR", "<PROJECT-NAME>_VERSION_PATCH", "<PROJECT-NAME>_VERSION_TWEAK", "<PackageName>_ROOT"};
        BEHAVIOR_VARIABLES = new String[]{"BUILD_SHARED_LIBS", "CMAKE_ABSOLUTE_DESTINATION_FILES", "CMAKE_APPBUNDLE_PATH", "CMAKE_BACKWARDS_COMPATIBILITY", "CMAKE_BUILD_TYPE", "CMAKE_COLOR_MAKEFILE", "CMAKE_CONFIGURATION_TYPES", "CMAKE_DEBUG_TARGET_PROPERTIES", "CMAKE_DEPENDS_IN_PROJECT_ONLY", "CMAKE_DIRECTORY_LABELS", "CMAKE_ENABLE_EXPORTS", "CMAKE_ERROR_DEPRECATED", "CMAKE_ERROR_ON_ABSOLUTE_INSTALL_DESTINATION", "CMAKE_EXPORT_COMPILE_COMMANDS", "CMAKE_EXPORT_NO_PACKAGE_REGISTRY", "CMAKE_SUBLIME_TEXT_2_ENV_SETTINGS", "CMAKE_SUBLIME_TEXT_2_EXCLUDE_BUILD_TREE", "CMAKE_SUPPRESS_REGENERATION", "CMAKE_SYSROOT", "CMAKE_SYSROOT_COMPILE", "CMAKE_SYSROOT_LINK", "CMAKE_FIND_APPBUNDLE", "CMAKE_FIND_FRAMEWORK", "CMAKE_FIND_LIBRARY_CUSTOM_LIB_SUFFIX", "CMAKE_FIND_LIBRARY_PREFIXES", "CMAKE_FIND_LIBRARY_SUFFIXES", "CMAKE_FIND_NO_INSTALL_PREFIX", "CMAKE_FIND_PACKAGE_NO_PACKAGE_REGISTRY", "CMAKE_FIND_PACKAGE_NO_SYSTEM_PACKAGE_REGISTRY", "CMAKE_FIND_PACKAGE_RESOLVE_SYMLINKS", "CMAKE_FIND_PACKAGE_WARN_NO_MODULE", "CMAKE_FIND_ROOT_PATH", "CMAKE_FIND_ROOT_PATH_MODE_INCLUDE", "CMAKE_FIND_ROOT_PATH_MODE_LIBRARY", "CMAKE_FIND_ROOT_PATH_MODE_PACKAGE", "CMAKE_FIND_ROOT_PATH_MODE_PROGRAM", "CMAKE_FOLDER", "CMAKE_FRAMEWORK_PATH", "CMAKE_IGNORE_PATH", "CMAKE_INCLUDE_PATH", "CMAKE_INCLUDE_DIRECTORIES_BEFORE", "CMAKE_INCLUDE_DIRECTORIES_PROJECT_BEFORE", "CMAKE_INSTALL_DEFAULT_COMPONENT_NAME", "CMAKE_INSTALL_DEFAULT_DIRECTORY_PERMISSIONS", "CMAKE_INSTALL_MESSAGE", "CMAKE_INSTALL_PREFIX", "CMAKE_INSTALL_PREFIX_INITIALIZED_TO_DEFAULT", "CMAKE_LIBRARY_PATH", "CMAKE_MFC_FLAG", "CMAKE_MODULE_PATH", "CMAKE_MSVCIDE_RUN_PATH", "CMAKE_NETRC", "CMAKE_NETRC_FILE", "CMAKE_NINJA_OUTPUT_PATH_PREFIX", "CMAKE_NOT_USING_CONFIG_FLAGS", "CMAKE_PREFIX_PATH", "CMAKE_PROGRAM_PATH", "CMAKE_SKIP_INSTALL_ALL_DEPENDENCY", "CMAKE_STAGING_PREFIX", "CMAKE_STANDARD_LIBRARIES", "CMAKE_SYSTEM_APPBUNDLE_PATH", "CMAKE_SYSTEM_FRAMEWORK_PATH", "CMAKE_SYSTEM_IGNORE_PATH", "CMAKE_SYSTEM_INCLUDE_PATH", "CMAKE_SYSTEM_LIBRARY_PATH", "CMAKE_SYSTEM_PREFIX_PATH", "CMAKE_SYSTEM_PROGRAM_PATH", "CMAKE_USER_MAKE_RULES_OVERRIDE", "CMAKE_WARN_DEPRECATED", "CMAKE_WARN_ON_ABSOLUTE_INSTALL_DESTINATION"};
        CHANGING_BEHAVIOR_VARIABLES = new String[]{"CMAKE_DISABLE_FIND_PACKAGE_<PackageName>", "CMAKE_PROJECT_<PROJECT-NAME>_INCLUDE", "CMAKE_POLICY_DEFAULT_CMP<NNNN>", "CMAKE_POLICY_WARNING_CMP<NNNN>"};
        CMAKE_POLICY_DEFAULT_HARDCODED = new String[CMakePolicy.knownPoliciesNumber()];
        CMAKE_POLICY_WARNING_HARDCODED = new String[CMakePolicy.knownPoliciesNumber()];
        for (i = 0; i < CMAKE_POLICY_DEFAULT_HARDCODED.length; ++i) {
            CMakeVariableProvider.CMAKE_POLICY_DEFAULT_HARDCODED[i] = CMAKE_POLICY_DEFAULT_VARIABLE_PREFIX + CMakePolicy.getPolicyName(i);
        }
        for (i = 0; i < CMAKE_POLICY_WARNING_HARDCODED.length; ++i) {
            CMakeVariableProvider.CMAKE_POLICY_WARNING_HARDCODED[i] = CMAKE_POLICY_WARNING_VARIABLE_PREFIX + CMakePolicy.getPolicyName(i);
        }
        SYSTEM_DESCRIPTION_VARIABLES = new String[]{"ANDROID", "APPLE", "BORLAND", "CMAKE_CL_64", "CMAKE_CODEBLOCKS_COMPILER_ID", "CMAKE_CODEBLOCKS_EXCLUDE_EXTERNAL_FILES", "CMAKE_CODELITE_USE_TARGETS", "CMAKE_COMPILER_2005", "CMAKE_HOST_APPLE", "CMAKE_HOST_SOLARIS", "CMAKE_HOST_SYSTEM_NAME", "CMAKE_HOST_SYSTEM_PROCESSOR", "CMAKE_HOST_SYSTEM", "CMAKE_HOST_SYSTEM_VERSION", "CMAKE_HOST_UNIX", "CMAKE_HOST_WIN32", "CMAKE_LIBRARY_ARCHITECTURE_REGEX", "CMAKE_LIBRARY_ARCHITECTURE", "CMAKE_OBJECT_PATH_MAX", "CMAKE_SYSTEM_NAME", "CMAKE_SYSTEM_PROCESSOR", "CMAKE_SYSTEM", "CMAKE_SYSTEM_VERSION", "CMAKE_Swift_LANGUAGE_VERSION", "CYGWIN", "GHS-MULTI", "IOS", "MINGW", "MSVC10", "MSVC11", "MSVC12", "MSVC14", "MSVC60", "MSVC70", "MSVC71", "MSVC80", "MSVC90", "MSVC_IDE", "MSVC_TOOLSET_VERSION", "MSVC", "MSVC_VERSION", "MSYS", "UNIX", "WIN32", "WINCE", "WINDOWS_PHONE", "WINDOWS_STORE", "XCODE", "XCODE_VERSION"};
        BUILD_CONTROL_VARIABLES = new String[]{"CMAKE_ANDROID_ANT_ADDITIONAL_OPTIONS", "CMAKE_ANDROID_API", "CMAKE_ANDROID_API_MIN", "CMAKE_ANDROID_ARCH", "CMAKE_ANDROID_ARCH_ABI", "CMAKE_ANDROID_ARM_MODE", "CMAKE_ANDROID_ARM_NEON", "CMAKE_ANDROID_ASSETS_DIRECTORIES", "CMAKE_ANDROID_GUI", "CMAKE_ANDROID_JAR_DEPENDENCIES", "CMAKE_ANDROID_JAR_DIRECTORIES", "CMAKE_ANDROID_JAVA_SOURCE_DIR", "CMAKE_ANDROID_NATIVE_LIB_DEPENDENCIES", "CMAKE_ANDROID_NATIVE_LIB_DIRECTORIES", "CMAKE_ANDROID_NDK", "CMAKE_ANDROID_NDK_DEPRECATED_HEADERS", "CMAKE_ANDROID_NDK_TOOLCHAIN_HOST_TAG", "CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION", "CMAKE_ANDROID_PROCESS_MAX", "CMAKE_ANDROID_PROGUARD", "CMAKE_ANDROID_PROGUARD_CONFIG_PATH", "CMAKE_ANDROID_SECURE_PROPS_PATH", "CMAKE_ANDROID_SKIP_ANT_STEP", "CMAKE_ANDROID_STANDALONE_TOOLCHAIN", "CMAKE_ANDROID_STL_TYPE", "CMAKE_ARCHIVE_OUTPUT_DIRECTORY", "CMAKE_ARCHIVE_OUTPUT_DIRECTORY_<CONFIG>", "CMAKE_AUTOGEN_ORIGIN_DEPENDS", "CMAKE_AUTOGEN_PARALLEL", "CMAKE_AUTOGEN_VERBOSE", "CMAKE_AUTOMOC", "CMAKE_AUTOMOC_COMPILER_PREDEFINES", "CMAKE_AUTOMOC_DEPEND_FILTERS", "CMAKE_AUTOMOC_MACRO_NAMES", "CMAKE_AUTOMOC_MOC_OPTIONS", "CMAKE_AUTOMOC_RELAXED_MODE", "CMAKE_AUTORCC", "CMAKE_AUTORCC_OPTIONS", "CMAKE_AUTOUIC", "CMAKE_AUTOUIC_OPTIONS", "CMAKE_AUTOUIC_SEARCH_PATHS", "CMAKE_BUILD_WITH_INSTALL_NAME_DIR", "CMAKE_BUILD_WITH_INSTALL_RPATH", "CMAKE_COMPILE_PDB_OUTPUT_DIRECTORY", "CMAKE_COMPILE_PDB_OUTPUT_DIRECTORY_<CONFIG>", "CMAKE_DEBUG_POSTFIX", "CMAKE_<CONFIG>_POSTFIX", "CMAKE_EXE_LINKER_FLAGS", "CMAKE_EXE_LINKER_FLAGS_INIT", "CMAKE_EXE_LINKER_FLAGS_<CONFIG>", "CMAKE_EXE_LINKER_FLAGS_<CONFIG>_INIT", "CMAKE_Fortran_FORMAT", "CMAKE_Fortran_MODULE_DIRECTORY", "CMAKE_GHS_NO_SOURCE_GROUP_FILE", "CMAKE_GLOBAL_AUTOGEN_TARGET", "CMAKE_GLOBAL_AUTOGEN_TARGET_NAME", "CMAKE_GLOBAL_AUTORCC_TARGET", "CMAKE_GLOBAL_AUTORCC_TARGET_NAME", "CMAKE_GNUtoMS", "CMAKE_INCLUDE_CURRENT_DIR_IN_INTERFACE", "CMAKE_INCLUDE_CURRENT_DIR", "CMAKE_INSTALL_NAME_DIR", "CMAKE_INSTALL_RPATH", "CMAKE_INSTALL_RPATH_USE_LINK_PATH", "CMAKE_IOS_INSTALL_COMBINED", "CMAKE_LIBRARY_OUTPUT_DIRECTORY", "CMAKE_LIBRARY_OUTPUT_DIRECTORY_<CONFIG>", "CMAKE_LIBRARY_PATH_FLAG", "CMAKE_LINK_DEF_FILE_FLAG", "CMAKE_LINK_DEPENDS_NO_SHARED", "CMAKE_LINK_DIRECTORIES_BEFORE", "CMAKE_LINK_INTERFACE_LIBRARIES", "CMAKE_LINK_LIBRARY_FILE_FLAG", "CMAKE_LINK_LIBRARY_FLAG", "CMAKE_LINK_SEARCH_END_STATIC", "CMAKE_LINK_SEARCH_START_STATIC", "CMAKE_LINK_WHAT_YOU_USE", "CMAKE_MACOSX_BUNDLE", "CMAKE_MACOSX_RPATH", "CMAKE_MAP_IMPORTED_CONFIG_<CONFIG>", "CMAKE_MODULE_LINKER_FLAGS", "CMAKE_MODULE_LINKER_FLAGS_INIT", "CMAKE_MODULE_LINKER_FLAGS_<CONFIG>", "CMAKE_MODULE_LINKER_FLAGS_<CONFIG>_INIT", "CMAKE_NO_BUILTIN_CHRPATH", "CMAKE_NO_SYSTEM_FROM_IMPORTED", "CMAKE_OSX_ARCHITECTURES", "CMAKE_OSX_DEPLOYMENT_TARGET", "CMAKE_OSX_SYSROOT", "CMAKE_PDB_OUTPUT_DIRECTORY", "CMAKE_PDB_OUTPUT_DIRECTORY_<CONFIG>", "CMAKE_POSITION_INDEPENDENT_CODE", "CMAKE_RUNTIME_OUTPUT_DIRECTORY", "CMAKE_RUNTIME_OUTPUT_DIRECTORY_<CONFIG>", "CMAKE_SHARED_LINKER_FLAGS", "CMAKE_SHARED_LINKER_FLAGS_<CONFIG>_INIT", "CMAKE_SHARED_LINKER_FLAGS_INIT", "CMAKE_SHARED_LINKER_FLAGS_<CONFIG>", "CMAKE_SKIP_BUILD_RPATH", "CMAKE_SKIP_INSTALL_RPATH", "CMAKE_STATIC_LINKER_FLAGS", "CMAKE_STATIC_LINKER_FLAGS_<CONFIG>", "CMAKE_STATIC_LINKER_FLAGS_<CONFIG>_INIT", "CMAKE_STATIC_LINKER_FLAGS_INIT", "CMAKE_TRY_COMPILE_CONFIGURATION", "CMAKE_TRY_COMPILE_PLATFORM_VARIABLES", "CMAKE_TRY_COMPILE_TARGET_TYPE", "CMAKE_USE_RELATIVE_PATHS", "CMAKE_VISIBILITY_INLINES_HIDDEN", "CMAKE_VS_INCLUDE_INSTALL_TO_DEFAULT_BUILD", "CMAKE_VS_INCLUDE_PACKAGE_TO_DEFAULT_BUILD", "CMAKE_VS_WINDOWS_TARGET_PLATFORM_VERSION", "CMAKE_VS_WINRT_BY_DEFAULT", "CMAKE_WIN32_EXECUTABLE", "CMAKE_WINDOWS_EXPORT_ALL_SYMBOLS", "CMAKE_XCODE_ATTRIBUTE_<an-attribute>", "EXECUTABLE_OUTPUT_PATH", "LIBRARY_OUTPUT_PATH"};
        CMAKE_INCLUDE_WHAT_YOU_USE_HARDCODED = CMakeVariableProvider.createHardcodedVariablesFromCMakeLanguages("CMAKE_", "_INCLUDE_WHAT_YOU_USE");
        CMAKE_VISIBILITY_PRESET_HARDCODED = CMakeVariableProvider.createHardcodedVariablesFromCMakeLanguages("CMAKE_", "_VISIBILITY_PRESET");
        LANGUAGES_VARIABLES = new String[]{"CMAKE_C_COMPILE_FEATURES", "CMAKE_C_EXTENSIONS", "CMAKE_C_STANDARD", "CMAKE_C_STANDARD_REQUIRED", "CMAKE_CXX_COMPILE_FEATURES", "CMAKE_CXX_EXTENSIONS", "CMAKE_CXX_STANDARD", "CMAKE_CXX_STANDARD_REQUIRED", "CMAKE_Fortran_MODDIR_DEFAULT", "CMAKE_Fortran_MODDIR_FLAG", "CMAKE_Fortran_MODOUT_FLAG", "CMAKE_INTERPROCEDURAL_OPTIMIZATION", "CMAKE_INTERPROCEDURAL_OPTIMIZATION_<CONFIG>", "CMAKE_INTERNAL_PLATFORM_ABI"};
        CMAKE_COMPILER_IS_GNU_VARIABLES = new String[CMakeRecognizedGnuLanguage.values().length];
        CMakeRecognizedGnuLanguage[] gnuLanguages = CMakeRecognizedGnuLanguage.values();
        for (int i2 = 0; i2 < gnuLanguages.length; ++i2) {
            CMakeVariableProvider.CMAKE_COMPILER_IS_GNU_VARIABLES[i2] = CMAKE_COMPILER_IS_GNU_PREFIX + gnuLanguages[i2].getLanguage();
        }
        CHANGING_RECOGNIZED_LANGUAGES_VARIABLES = new String[]{"CMAKE_COMPILER_IS_GNU<LANG>", "CMAKE_<LANG>_ANDROID_TOOLCHAIN_MACHINE", "CMAKE_<LANG>_ANDROID_TOOLCHAIN_PREFIX", "CMAKE_<LANG>_ANDROID_TOOLCHAIN_SUFFIX", "CMAKE_<LANG>_ARCHIVE_APPEND", "CMAKE_<LANG>_ARCHIVE_CREATE", "CMAKE_<LANG>_ARCHIVE_FINISH", "CMAKE_<LANG>_COMPILE_OBJECT", "CMAKE_<LANG>_COMPILER_ABI", "CMAKE_<LANG>_COMPILER_AR", "CMAKE_<LANG>_COMPILER_ARCHITECTURE_ID", "CMAKE_<LANG>_COMPILER_ID", "CMAKE_<LANG>_COMPILER_LAUNCHER", "CMAKE_<LANG>_COMPILER_LOADED", "CMAKE_<LANG>_COMPILER_PREDEFINES_COMMAND", "CMAKE_<LANG>_COMPILER_RANLIB", "CMAKE_<LANG>_CLANG_TIDY", "CMAKE_<LANG>_CPPCHECK", "CMAKE_<LANG>_CPPLINT", "CMAKE_<LANG>_COMPILER", "CMAKE_<LANG>_COMPILER_EXTERNAL_TOOLCHAIN", "CMAKE_<LANG>_COMPILER_TARGET", "CMAKE_<LANG>_COMPILER_VERSION", "CMAKE_<LANG>_COMPILER_VERSION_INTERNAL", "CMAKE_<LANG>_CREATE_SHARED_LIBRARY", "CMAKE_<LANG>_CREATE_SHARED_MODULE", "CMAKE_<LANG>_CREATE_STATIC_LIBRARY", "CMAKE_<LANG>_FLAGS_DEBUG", "CMAKE_<LANG>_FLAGS_DEBUG_INIT", "CMAKE_<LANG>_FLAGS_INIT", "CMAKE_<LANG>_FLAGS_MINSIZEREL", "CMAKE_<LANG>_FLAGS_MINSIZEREL_INIT", "CMAKE_<LANG>_FLAGS_RELEASE", "CMAKE_<LANG>_FLAGS_RELEASE_INIT", "CMAKE_<LANG>_FLAGS_RELWITHDEBINFO", "CMAKE_<LANG>_FLAGS_RELWITHDEBINFO_INIT", "CMAKE_<LANG>_FLAGS", "CMAKE_<LANG>_FLAGS_<CONFIG>", "CMAKE_<LANG>_FLAGS_<CONFIG>_INIT", "CMAKE_<LANG>_GHS_KERNEL_FLAGS_<CONFIG>", "CMAKE_<LANG>_GHS_KERNEL_FLAGS_DEBUG", "CMAKE_<LANG>_GHS_KERNEL_FLAGS_MINSIZEREL", "CMAKE_<LANG>_GHS_KERNEL_FLAGS_RELEASE", "CMAKE_<LANG>_GHS_KERNEL_FLAGS_RELWITHDEBINFO", "CMAKE_<LANG>_IGNORE_EXTENSIONS", "CMAKE_<LANG>_IMPLICIT_INCLUDE_DIRECTORIES", "CMAKE_<LANG>_IMPLICIT_LINK_DIRECTORIES", "CMAKE_<LANG>_IMPLICIT_LINK_FRAMEWORK_DIRECTORIES", "CMAKE_<LANG>_IMPLICIT_LINK_LIBRARIES", "CMAKE_<LANG>_LIBRARY_ARCHITECTURE", "CMAKE_<LANG>_LINKER_PREFERENCE_PROPAGATES", "CMAKE_<LANG>_LINKER_PREFERENCE", "CMAKE_<LANG>_LINKER_WRAPPER_FLAG", "CMAKE_<LANG>_LINKER_WRAPPER_FLAG_SEP", "CMAKE_<LANG>_LINK_EXECUTABLE", "CMAKE_<LANG>_OUTPUT_EXTENSION", "CMAKE_<LANG>_PLATFORM_ID", "CMAKE_<LANG>_SIMULATE_ID", "CMAKE_<LANG>_SIMULATE_VERSION", "CMAKE_<LANG>_SIZEOF_DATA_PTR", "CMAKE_<LANG>_SOURCE_FILE_EXTENSIONS", "CMAKE_<LANG>_STANDARD_INCLUDE_DIRECTORIES", "CMAKE_<LANG>_STANDARD_LIBRARIES", "CMAKE_USER_MAKE_RULES_OVERRIDE_<LANG>", "CMAKE_<LANG>_INCLUDE_WHAT_YOU_USE", "CMAKE_<LANG>_VISIBILITY_PRESET"};
        CHANGING_RECOGNIZED_LANGUAGES_VARIABLES_HARDCODED = new String[CHANGING_RECOGNIZED_LANGUAGES_VARIABLES.length * CMakeRecognizedLanguage.values().length];
        int i3 = 0;
        for (String string : CHANGING_RECOGNIZED_LANGUAGES_VARIABLES) {
            for (CMakeRecognizedLanguage cMakeRecognizedLanguage : CMakeRecognizedLanguage.values()) {
                String patchedVariable;
                CMakeVariableProvider.CHANGING_RECOGNIZED_LANGUAGES_VARIABLES_HARDCODED[i3] = patchedVariable = string.replace("<LANG>", cMakeRecognizedLanguage.getLanguage());
                ++i3;
            }
        }
        CTEST_VARIABLES = new String[]{"CTEST_BINARY_DIRECTORY", "CTEST_BUILD_COMMAND", "CTEST_BUILD_NAME", "CTEST_BZR_COMMAND", "CTEST_BZR_UPDATE_OPTIONS", "CTEST_CHANGE_ID", "CTEST_CHECKOUT_COMMAND", "CTEST_CONFIGURATION_TYPE", "CTEST_CONFIGURE_COMMAND", "CTEST_COVERAGE_COMMAND", "CTEST_COVERAGE_EXTRA_FLAGS", "CTEST_CURL_OPTIONS", "CTEST_CUSTOM_COVERAGE_EXCLUDE", "CTEST_CUSTOM_ERROR_EXCEPTION", "CTEST_CUSTOM_ERROR_MATCH", "CTEST_CUSTOM_ERROR_POST_CONTEXT", "CTEST_CUSTOM_ERROR_PRE_CONTEXT", "CTEST_CUSTOM_MAXIMUM_FAILED_TEST_OUTPUT_SIZE", "CTEST_CUSTOM_MAXIMUM_NUMBER_OF_ERRORS", "CTEST_CUSTOM_MAXIMUM_NUMBER_OF_WARNINGS", "CTEST_CUSTOM_MAXIMUM_PASSED_TEST_OUTPUT_SIZE", "CTEST_CUSTOM_MEMCHECK_IGNORE", "CTEST_CUSTOM_POST_MEMCHECK", "CTEST_CUSTOM_POST_TEST", "CTEST_CUSTOM_PRE_MEMCHECK", "CTEST_CUSTOM_PRE_TEST", "CTEST_CUSTOM_TEST_IGNORE", "CTEST_CUSTOM_TESTS_IGNORE", "CTEST_CUSTOM_WARNING_EXCEPTION", "CTEST_CUSTOM_WARNING_MATCH", "CTEST_CVS_CHECKOUT", "CTEST_CVS_COMMAND", "CTEST_CVS_UPDATE_OPTIONS", "CTEST_DROP_LOCATION", "CTEST_DROP_METHOD", "CTEST_DROP_SITE", "CTEST_DROP_SITE_CDASH", "CTEST_DROP_SITE_PASSWORD", "CTEST_DROP_SITE_USER", "CTEST_EXTRA_COVERAGE_GLOB", "CTEST_GIT_COMMAND", "CTEST_GIT_INIT_SUBMODULES", "CTEST_GIT_UPDATE_CUSTOM", "CTEST_GIT_UPDATE_OPTIONS", "CTEST_HG_COMMAND", "CTEST_HG_UPDATE_OPTIONS", "CTEST_LABELS_FOR_SUBPROJECTS", "CTEST_MEMORYCHECK_COMMAND", "CTEST_MEMORYCHECK_COMMAND_OPTIONS", "CTEST_MEMORYCHECK_SANITIZER_OPTIONS", "CTEST_MEMORYCHECK_SUPPRESSIONS_FILE", "CTEST_MEMORYCHECK_TYPE", "CTEST_NIGHTLY_START_TIME", "CTEST_P4_CLIENT", "CTEST_P4_COMMAND", "CTEST_P4_OPTIONS", "CTEST_P4_UPDATE_OPTIONS", "CTEST_RUN_CURRENT_SCRIPT", "CTEST_SCP_COMMAND", "CTEST_SITE", "CTEST_SOURCE_DIRECTORY", "CTEST_SUBMIT_URL", "CTEST_SVN_COMMAND", "CTEST_SVN_OPTIONS", "CTEST_SVN_UPDATE_OPTIONS", "CTEST_TEST_LOAD", "CTEST_TEST_TIMEOUT", "CTEST_TRIGGER_SITE", "CTEST_UPDATE_COMMAND", "CTEST_UPDATE_OPTIONS", "CTEST_UPDATE_VERSION_ONLY", "CTEST_USE_LAUNCHERS"};
        CPACK_VARIABLES = new String[]{"CMAKE_CPACK_COMMAND", "CPACK_ABSOLUTE_DESTINATION_FILES", "CPACK_COMPONENT_INCLUDE_TOPLEVEL_DIRECTORY", "CPACK_ERROR_ON_ABSOLUTE_INSTALL_DESTINATION", "CPACK_INCLUDE_TOPLEVEL_DIRECTORY", "CPACK_INSTALL_DEFAULT_DIRECTORY_PERMISSIONS", "CPACK_INSTALL_SCRIPT", "CPACK_PACKAGING_INSTALL_PREFIX", "CPACK_SET_DESTDIR", "CPACK_WARN_ON_ABSOLUTE_INSTALL_DESTINATION"};
        ALL_COMPLETION_VARIABLE_ARRAYS = new String[][]{INFORMATION_VARIABLES, BEHAVIOR_VARIABLES, SYSTEM_DESCRIPTION_VARIABLES, BUILD_CONTROL_VARIABLES, LANGUAGES_VARIABLES, CTEST_VARIABLES, CPACK_VARIABLES, CMAKE_INCLUDE_WHAT_YOU_USE_HARDCODED, CMAKE_VISIBILITY_PRESET_HARDCODED, CMAKE_COMPILER_IS_GNU_VARIABLES, CHANGING_RECOGNIZED_LANGUAGES_VARIABLES_HARDCODED};
        ALL_VARIABLES = ContainerUtil.collect(ContainerUtil.concat((Object[][])new String[][]{INFORMATION_VARIABLES, BEHAVIOR_VARIABLES, SYSTEM_DESCRIPTION_VARIABLES, BUILD_CONTROL_VARIABLES, LANGUAGES_VARIABLES, CTEST_VARIABLES, CPACK_VARIABLES, CHANGING_RECOGNIZED_LANGUAGES_VARIABLES, CMAKE_COMPILER_IS_GNU_VARIABLES, CHANGING_BEHAVIOR_VARIABLES, CHANGING_INFORMATION_VARIABLES}).iterator());
        int totalVariables = 0;
        for (String string : ALL_COMPLETION_VARIABLE_ARRAYS) {
            totalVariables += ((String)string).length;
        }
        ALL_COMPLETION_VARIABLES = new String[totalVariables];
        int currentVariableNumber = 0;
        String[][] stringArray = ALL_COMPLETION_VARIABLE_ARRAYS;
        int n = stringArray.length;
        boolean bl = false;
        while (var4_13 < n) {
            String[] nextVariableArray;
            String[] stringArray2 = nextVariableArray = stringArray[var4_13];
            int n2 = stringArray2.length;
            for (int j = 0; j < n2; ++j) {
                String nextVariable;
                CMakeVariableProvider.ALL_COMPLETION_VARIABLES[currentVariableNumber] = nextVariable = stringArray2[j];
                ++currentVariableNumber;
            }
            ++var4_13;
        }
    }

    private static class FirstLetterCaseMatcher
    extends CamelHumpMatcher {
        private final int myIndexOfFirstVariableChar;

        FirstLetterCaseMatcher(@NotNull String prefix, int indexOfFirstVariableChar) {
            super(prefix);
            this.myIndexOfFirstVariableChar = indexOfFirstVariableChar;
        }

        public boolean prefixMatches(@NotNull String name2) {
            return (this.myPrefix.length() > 0 && Character.isUpperCase(this.myPrefix.charAt(0)) || this.myPrefix.length() == 0) && super.prefixMatches(name2);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            return new FirstLetterCaseMatcher(prefix, this.myIndexOfFirstVariableChar);
        }
    }
}

