/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cmake.formatting.CMakeFormattingUtils;
import com.jetbrains.cmake.formatting.CMakeSpacingProcessor;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCodeBlock
extends AbstractBlock {
    @NotNull
    private static final TokenSet INDENT_SET = TokenSet.create((IElementType[])new IElementType[]{CMakeTokenTypes.C_MAKE_MACRO_COMMAND, CMakeTokenTypes.C_MAKE_FUNCTION_COMMAND, CMakeTokenTypes.C_MAKE_WHILE_COMMAND, CMakeTokenTypes.C_MAKE_FOREACH_COMMAND, CMakeTokenTypes.C_MAKE_IF_COMMAND, CMakeTokenTypes.C_MAKE_ELSE_COMMAND, CMakeTokenTypes.C_MAKE_ELSE_IF_COMMAND});
    @NotNull
    private static final TokenSet INDENT_RESET = TokenSet.create((IElementType[])new IElementType[]{CMakeTokenTypes.C_MAKE_END_MACRO_COMMAND, CMakeTokenTypes.C_MAKE_END_FUNCTION_COMMAND, CMakeTokenTypes.C_MAKE_END_WHILE_COMMAND, CMakeTokenTypes.C_MAKE_END_FOREACH_COMMAND, CMakeTokenTypes.C_MAKE_END_IF_COMMAND});
    @Nullable
    CMakeCodeBlock myParentBlock;
    @NotNull
    private final CMakeSpacingProcessor myGlobalCMakeSpacingProcessor;
    @NotNull
    private final CommonCodeStyleSettings mySettings;
    @Nullable
    private final Wrap myWrap;
    @Nullable
    private final Indent myIndent;

    public CMakeCodeBlock(@Nullable CMakeCodeBlock parentNode, @NotNull CMakeSpacingProcessor cMakeSpacingProcessor, @NotNull CommonCodeStyleSettings settings, @NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Wrap wrap, @Nullable Indent indent) {
        super(node, wrap, alignment);
        this.myParentBlock = parentNode;
        this.myGlobalCMakeSpacingProcessor = cMakeSpacingProcessor;
        this.mySettings = settings;
        this.myWrap = wrap;
        this.myIndent = indent;
    }

    public CMakeCodeBlock(@NotNull PsiFile file, @NotNull CommonCodeStyleSettings settings) {
        this(null, new CMakeSpacingProcessor(settings), settings, (ASTNode)file.getNode(), null, null, Indent.getNoneIndent());
    }

    @NotNull
    protected List<Block> buildChildren() {
        if (this.isLeaf()) {
            return EMPTY;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (ASTNode childNode = this.myNode.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (childNode.getElementType() == CMakeTokenTypes.EOL || childNode instanceof PsiWhiteSpace || childNode.getText().trim().length() <= 0) continue;
            Indent indent = CMakeCodeBlock.calculateChildIndent(this, childNode);
            Alignment alignment = this.calculateChildAlignment(this, childNode, blocks);
            CMakeCodeBlock childBlock = new CMakeCodeBlock(this, this.myGlobalCMakeSpacingProcessor, this.mySettings, childNode, alignment, this.myWrap, indent);
            blocks.add((Block)childBlock);
        }
        return blocks;
    }

    @NotNull
    public TextRange getTextRange() {
        boolean isEndOfFile;
        TextRange range = this.myNode.getTextRange();
        ASTNode lastChildNode = this.myNode.getLastChildNode();
        boolean myNodeEndsWithEol = lastChildNode != null && lastChildNode.getElementType() == CMakeTokenTypes.EOL;
        boolean bl = isEndOfFile = this.myNode.getTreeNext() == null;
        if (myNodeEndsWithEol && !isEndOfFile) {
            return new TextRange(range.getStartOffset(), range.getEndOffset() - lastChildNode.getTextLength());
        }
        return range;
    }

    private static boolean isCommandArgument(@NotNull ASTNode parentNode, @NotNull ASTNode node) {
        return parentNode.getElementType() == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS && (node.getElementType() == CMakeTokenTypes.C_MAKE_ARGUMENT || node.getElementType() == CMakeTokenTypes.COMMENT || node.getElementType() == CMakeTokenTypes.QUOTE || node.getElementType() == CMakeTokenTypes.BRACKET_ARG_START || node.getElementType() == CMakeTokenTypes.BRACKET_ARG_END);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        int previousChildIndex;
        if (newChildIndex == 0) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        List subBlocks = this.getSubBlocks();
        CMakeCodeBlock previousChild = (CMakeCodeBlock)((Object)subBlocks.get(previousChildIndex));
        IElementType currentElementType = this.getNode().getElementType();
        Indent indent = INDENT_SET.contains(currentElementType) ? Indent.getNormalIndent() : (currentElementType == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS ? Indent.getContinuationIndent() : this.getIndent());
        for (previousChildIndex = newChildIndex - 1; previousChildIndex >= 0 && (previousChild.getNode().getElementType() == CMakeTokenTypes.COMMENT || previousChild.getNode().getElementType() == CMakeTokenTypes.SEMI); --previousChildIndex) {
            previousChild = (CMakeCodeBlock)((Object)subBlocks.get(previousChildIndex));
        }
        Alignment alignment = previousChild.getAlignment();
        if (currentElementType == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS || currentElementType == CMakeTokenTypes.RPAR || previousChild.getNode().getElementType() == CMakeTokenTypes.C_MAKE_COMMAND && currentElementType == CMakeElementTypes.CMAKE_FILE && previousChild.getNode().getLastChildNode().findChildByType(TokenType.ERROR_ELEMENT) != null) {
            indent = Indent.getContinuationIndent();
        }
        return new ChildAttributes(indent, alignment);
    }

    @NotNull
    private static Indent calculateChildIndent(@NotNull CMakeCodeBlock parentNode, @NotNull ASTNode node) {
        Indent indent;
        ASTNode parentAstNode = parentNode.getNode();
        IElementType parentType = parentAstNode.getElementType();
        IElementType nodeType = node.getElementType();
        if (nodeType == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (CMakeCodeBlock.isCommandArgument(parentAstNode, node)) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (node.getElementType() == CMakeTokenTypes.RPAR && (indent = CMakeFormattingUtils.rparShouldBeIndented(parentNode, node, Indent.getContinuationIndent(), Indent.getNoneIndent())) != null) {
            return indent;
        }
        if (INDENT_RESET.contains(nodeType)) {
            return Indent.getNoneIndent();
        }
        if (nodeType == CMakeTokenTypes.C_MAKE_BODY_BLOCK && INDENT_SET.contains(parentType)) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    @Nullable
    private Alignment calculateChildAlignment(@NotNull CMakeCodeBlock parentNode, @NotNull ASTNode node, List<Block> previousBlocks) {
        if (!this.mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS) {
            return null;
        }
        if ((node.getElementType() == CMakeTokenTypes.C_MAKE_ARGUMENT || node.getElementType() == CMakeTokenTypes.RPAR || node.getElementType() == CMakeTokenTypes.COMMENT) && parentNode.getNode().getElementType() == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS) {
            int previousArgumentBlockIndex = CMakeCodeBlock.findLastArgumentBlock(previousBlocks);
            if (previousArgumentBlockIndex >= 0) {
                Alignment alignment;
                CMakeCodeBlock previousArgumentBlock = (CMakeCodeBlock)previousBlocks.get(previousArgumentBlockIndex);
                if (node.getElementType() == CMakeTokenTypes.RPAR && (alignment = CMakeFormattingUtils.rparShouldBeIndented(parentNode, node, previousArgumentBlock.getAlignment(), Alignment.createAlignment())) != null) {
                    return alignment;
                }
                if (previousArgumentBlock.getAlignment() != null && node.getElementType() != CMakeTokenTypes.RPAR) {
                    return previousArgumentBlock.getAlignment();
                }
                return Alignment.createAlignment();
            }
            if (node.getElementType() == CMakeTokenTypes.C_MAKE_ARGUMENT || node.getElementType() == CMakeTokenTypes.COMMENT) {
                for (ASTNode possibleLeftParenthesis = node; possibleLeftParenthesis != null && possibleLeftParenthesis.getElementType() != CMakeTokenTypes.LPAR; possibleLeftParenthesis = possibleLeftParenthesis.getTreePrev()) {
                }
                return Alignment.createAlignment();
            }
        }
        return null;
    }

    private static int findLastArgumentBlock(List<Block> blocks) {
        for (int currentBlockIndex = blocks.size() - 1; currentBlockIndex >= 0; --currentBlockIndex) {
            CMakeCodeBlock block = (CMakeCodeBlock)blocks.get(currentBlockIndex);
            if (block.getNode().getElementType() != CMakeTokenTypes.C_MAKE_ARGUMENT) continue;
            return currentBlockIndex;
        }
        return -1;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        return this.myGlobalCMakeSpacingProcessor.getSpacing(this, child1, child2);
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    public boolean isLeaf() {
        return this.myNode instanceof LeafElement;
    }
}

