/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.interpreter;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeScope {
    private HashMap<String, String> myVars = new HashMap();

    @Nullable
    public String getVariableValue(@NotNull String name2) {
        return this.myVars.get(name2);
    }

    public void setVariableValue(@NotNull String name2, @Nullable String value) {
        if (StringUtil.isEmpty((String)value)) {
            this.myVars.remove(name2);
        } else {
            this.myVars.put(name2, value);
        }
    }

    @Nullable
    public String eval(@NotNull String str) {
        if (!str.contains("${") && !str.contains("\\")) {
            return str;
        }
        ArrayList<StringFragment> fragments = new ArrayList<StringFragment>();
        CMakeScope.parseFragments(str, 0, fragments, 0);
        return CMakeScope.evalFragments(fragments, this);
    }

    @Nullable
    public static String evalFragments(@NotNull List<StringFragment> fragments, @NotNull CMakeScope scope) {
        StringBuilder result = new StringBuilder();
        for (StringFragment fragment : fragments) {
            if (fragment.eval(scope, result)) continue;
            return null;
        }
        return result.toString();
    }

    private static int parseFragments(@NotNull String str, int from, @NotNull List<StringFragment> fragments, int braceDepth) {
        int cur;
        int len = str.length();
        if (from >= len) {
            return from;
        }
        for (cur = from; cur < len; ++cur) {
            char c = str.charAt(cur);
            if (c == '\\') {
                String prefix = str.substring(from, cur);
                String suffix = "";
                if (++cur < len) {
                    char next = str.charAt(cur);
                    suffix = next == ';' ? "\\;" : Character.toString(next);
                }
                fragments.add(new PlainStringFragment(prefix + suffix));
                from = ++cur;
            } else {
                if (c == '}' && braceDepth > 0) break;
                if (c == '$' && cur + 1 < len && str.charAt(cur + 1) == '{') {
                    ArrayList<StringFragment> fs;
                    int start;
                    if (from < cur) {
                        fragments.add(new PlainStringFragment(str.substring(from, cur)));
                    }
                    boolean valid = (cur = CMakeScope.parseFragments(str, start = cur + 2, fs = new ArrayList<StringFragment>(), braceDepth + 1)) < len;
                    fragments.add(new VarStringFragment(str.substring(start, cur), fs, valid));
                    from = cur + 1;
                }
            }
            if (cur >= len) break;
        }
        if (from < cur) {
            fragments.add(new PlainStringFragment(str.substring(from, cur)));
        }
        return cur;
    }

    private static class VarStringFragment
    extends StringFragment {
        @NotNull
        private final List<StringFragment> myFragments;
        private final boolean myValid;

        VarStringFragment(@NotNull String string, @NotNull List<StringFragment> fragments, boolean valid) {
            super(string);
            this.myFragments = fragments;
            this.myValid = valid;
        }

        @Override
        public boolean eval(@NotNull CMakeScope scope, @NotNull StringBuilder result) {
            if (!this.isValid()) {
                return false;
            }
            String name2 = CMakeScope.evalFragments(this.myFragments, scope);
            if (name2 == null) {
                return false;
            }
            String value = scope.getVariableValue(name2);
            if (value == null) {
                return false;
            }
            result.append(value);
            return true;
        }

        @Override
        public boolean isValid() {
            return this.myValid;
        }
    }

    private static class PlainStringFragment
    extends StringFragment {
        PlainStringFragment(String string) {
            super(string);
        }

        @Override
        public boolean eval(@NotNull CMakeScope scope, @NotNull StringBuilder result) {
            result.append(this.getFragmentString());
            return true;
        }

        @Override
        boolean isValid() {
            return true;
        }
    }

    private static abstract class StringFragment {
        @NotNull
        private final String myString;

        StringFragment(@NotNull String string) {
            this.myString = string;
        }

        public abstract boolean eval(@NotNull CMakeScope var1, @NotNull StringBuilder var2);

        @NotNull
        protected String getFragmentString() {
            return this.myString;
        }

        abstract boolean isValid();
    }
}

