/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.editor.CMakeArgumentPresentation;
import com.jetbrains.cmake.interpreter.CMakeInterpreter;
import com.jetbrains.cmake.interpreter.CMakeScope;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeArgumentManipulator;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeElementBase;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.resolve.CMakeCommandReference;
import com.jetbrains.cmake.resolve.CMakeCommandReferenceHelper;
import com.jetbrains.cmake.resolve.CMakeRenameUtils;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeArgumentImplMixin
extends CMakeElementBase
implements CMakeArgument {
    public CMakeArgumentImplMixin(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PsiElement getLiteralNotNull() {
        CMakeLiteral literal = this.getCMakeLiteral();
        assert (literal != null);
        return literal;
    }

    @Override
    public boolean isBracketArgument() {
        return this.getFirstChild().getNode().getElementType() == CMakeTokenTypes.BRACKET_ARG_START;
    }

    @Override
    public boolean isQuotedArgument() {
        return this.getFirstChild().getNode().getElementType() == CMakeTokenTypes.QUOTE;
    }

    @Override
    public void expandIntoArgumentList(@NotNull List<String> result, @NotNull CMakeScope scope) {
        String literalText = this.getLiteralNotNull().getText();
        if (this.isBracketArgument()) {
            result.add(literalText);
        } else {
            boolean isQuoted = this.isQuotedArgument();
            String value = scope.eval(literalText);
            if (value != null) {
                if (isQuoted) {
                    result.add(value);
                } else {
                    CMakeInterpreter.expandListArgument(value, result);
                }
            }
        }
    }

    @Override
    @Nullable
    public PsiPolyVariantReference getReference() {
        if (this.isCommandDefinitionName() || this.isEndCommandDefinitionName()) {
            return new CMakeCommandReference(this, new TextRange(0, this.getTextRange().getLength()));
        }
        return null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        if (this.isFunctionName() || this.isEndFunctionName()) {
            return CMakeCompletionUtils.getRoutineIcon(true);
        }
        if (this.isMacroName() || this.isEndMacroName()) {
            return CMakeCompletionUtils.getRoutineIcon(false);
        }
        return super.getIcon(flags);
    }

    @NotNull
    public String getName() {
        return this.getValue();
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        CMakeRenameUtils.renameArgument(this.getProject(), name2, this.getNode());
        return this;
    }

    @Override
    @NotNull
    public String getValue() {
        CMakeLiteral literal = this.getCMakeLiteral();
        if (literal == null) {
            return "";
        }
        return CMakeArgumentManipulator.getValueFromCMakeLiteralNoEval(literal.getText());
    }

    @Override
    @NotNull
    public TextRange getContentsRange() {
        String text;
        PsiElement literal = this.getLiteralNotNull();
        int startOffset = literal.getStartOffsetInParent();
        TextRange range = new TextRange(startOffset, startOffset + literal.getTextLength());
        if (this.isBracketArgument() && (text = literal.getText()).startsWith("\"") && text.endsWith("\"")) {
            return range.shiftRight(1).grown(-2);
        }
        return range;
    }

    @Override
    public boolean isFunctionName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isFunctionDeclarationParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isEndFunctionName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isEndFunctionParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isMacroName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isMacroDeclarationParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isEndMacroName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isEndMacroParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isCommandDefinitionName() {
        return this.isFunctionName() || this.isMacroName();
    }

    @Override
    public boolean isEndCommandDefinitionName() {
        return this.isEndCommandDefinitionName(null);
    }

    @Override
    public boolean isEndCommandDefinitionName(@Nullable String definitionNameCandidate) {
        if (this.isEndFunctionName() || this.isEndMacroName()) {
            CMakeRoutine routine = (CMakeRoutine)this.getParentCommandArguments().getParent().getParent();
            CMakeArgument firstArgument = routine.getFirstArgument();
            if (definitionNameCandidate != null) {
                return CMakeCommandReferenceHelper.commandNamesEqualByText((PsiElement)this, firstArgument) || CMakeCommandReferenceHelper.commandNamesEqualByText((PsiElement)firstArgument, definitionNameCandidate);
            }
            return CMakeCommandReferenceHelper.commandNamesEqualByText((PsiElement)this, firstArgument) || this.isCommandPartWithInvokedCompletion(firstArgument);
        }
        return false;
    }

    private boolean isCommandPartWithInvokedCompletion(@Nullable CMakeArgument firstArgument) {
        return firstArgument != null && this.getText().contains("IntellijIdeaRulezzz") && firstArgument.getText().toLowerCase(Locale.US).startsWith(this.getText().replace("IntellijIdeaRulezzz", "").toLowerCase(Locale.US));
    }

    @Override
    @Nullable
    public CMakeArgument getCommandDefinitionName() {
        CMakeRoutine cMakeCommand;
        CMakeArgument routineNameArgument;
        if (this.isCommandDefinitionName()) {
            return this;
        }
        if (this.isEndCommandDefinitionName() && this.getParentCommandArguments().isEndRoutineParameters() && (routineNameArgument = (cMakeCommand = (CMakeRoutine)this.getParentCommandArguments().getParent().getParent()).getFirstArgument()) != null) {
            return routineNameArgument;
        }
        return null;
    }

    @Override
    @Nullable
    public CMakeArgument getNextArgument() {
        return (CMakeArgument)PsiTreeUtil.getNextSiblingOfType((PsiElement)this, CMakeArgument.class);
    }

    @Override
    @Nullable
    public CMakeArgument getPreviousArgument() {
        return (CMakeArgument)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this, CMakeArgument.class);
    }

    @Override
    @NotNull
    public CMakeCommandArguments getParentCommandArguments() {
        CMakeCommandArguments cMakeCommandArguments = (CMakeCommandArguments)PsiTreeUtil.getParentOfType((PsiElement)this, CMakeCommandArguments.class, (boolean)true);
        assert (cMakeCommandArguments != null);
        return cMakeCommandArguments;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new CMakeArgumentPresentation(this);
    }
}

