/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeElementBase;
import com.jetbrains.cmake.resolve.CMakeCommandReference;
import com.jetbrains.cmake.resolve.CMakeRenameUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeCommandImplMixin
extends CMakeElementBase
implements CMakeCommand {
    public CMakeCommandImplMixin(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getName() {
        return this.getNameElement().getText();
    }

    @Override
    @NotNull
    public PsiElement getNameElement() {
        return this.getFirstChild();
    }

    @Override
    public PsiPolyVariantReference getReference() {
        return new CMakeCommandReference(this.getFirstChild(), new TextRange(0, this.getFirstChild().getTextRange().getLength()));
    }

    public PsiElement setName(@NotNull String name2) {
        CMakeRenameUtils.renameCommandCall(this.getProject(), name2, this.getNode());
        return this;
    }

    @Override
    public boolean namesEqual(@Nullable String name2) {
        return StringUtil.equalsIgnoreCase((CharSequence)name2, (CharSequence)this.getName());
    }

    @Override
    @Nullable
    public CMakeArgument getFirstArgument() {
        return (CMakeArgument)ContainerUtil.getFirstItem(this.getCMakeArgumentList());
    }

    @Override
    @Nullable
    public String getFirstArgumentValue() {
        return CMakeCommandImplMixin.getArgValue(this.getFirstArgument());
    }

    @Override
    @NotNull
    public List<CMakeArgument> getTailArguments() {
        List<CMakeArgument> list = this.getCMakeArgumentList();
        return list != null && list.size() > 1 ? ContainerUtil.subList(list, (int)1) : Collections.emptyList();
    }

    @Override
    @Nullable
    public List<CMakeArgument> getCMakeArgumentList() {
        CMakeCommandArguments args = this.getCMakeCommandArguments();
        return args == null ? null : args.getCMakeArgumentList();
    }

    @Override
    @NotNull
    public List<String> getTailArgumentsValues() {
        return ContainerUtil.map(this.getTailArguments(), (Function)((NotNullFunction)each -> CMakeCommandImplMixin.getArgValue(each)));
    }

    @Contract(value="null -> null")
    private static String getArgValue(@Nullable CMakeArgument arg) {
        return arg == null ? null : arg.getValue();
    }

    @Override
    public boolean canAppendArguments() {
        CMakeCommandArguments arguments = this.getCMakeCommandArguments();
        return arguments != null && arguments.canAppendArguments();
    }

    @Override
    public void appendArgument(@NotNull String argumentText) {
        CMakeCommandArguments arguments = this.getCMakeCommandArguments();
        Objects.requireNonNull(arguments).appendArgument(argumentText);
    }
}

