/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.refactoring.rename.FragmentaryPsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeFileReferenceSet;
import com.jetbrains.cmake.psi.CMakeLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMakeFileReference
extends FileReference
implements FragmentaryPsiReference {
    @NotNull
    protected final CMakeFileReferenceSet cmakeFileReferenceSet;
    protected final boolean isExpressionRef;

    CMakeFileReference(@NotNull CMakeFileReferenceSet fileReferenceSet, @NotNull TextRange range, int index, @NotNull String text) {
        super((FileReferenceSet)fileReferenceSet, range, index, text);
        this.cmakeFileReferenceSet = fileReferenceSet;
        this.isExpressionRef = CMakeFileReference.isVariableRef(text);
        if (this.isExpressionRef) {
            this.cmakeFileReferenceSet.setFragmentOnlyRename(true);
        }
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (CMakeFileReference.isVariableRef(this.getText())) {
            return this.resolveVariable(containingFile);
        }
        return super.innerResolve(caseSensitive, containingFile);
    }

    private static boolean isVariableRef(@NotNull String text) {
        return text.startsWith("${") && text.endsWith("}");
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        return this.isReadOnlyFragment() ? this.getElement() : super.handleElementRename(newElementName);
    }

    @NotNull
    private ResolveResult[] resolveVariable(@NotNull PsiFile containingFile) {
        String varName = this.getText().substring(1);
        if (varName.startsWith("{")) {
            int pos = varName.indexOf(125, 1);
            String string = varName = pos < 1 ? "" : varName.substring(1, pos);
        }
        if (!varName.isEmpty()) {
            PsiFile element = null;
            if (varName.equals("CMAKE_CURRENT_LIST_FILE")) {
                element = containingFile;
            } else if (varName.equals("CMAKE_CURRENT_LIST_DIR") || varName.equals("CMAKE_CURRENT_SOURCE_DIR")) {
                element = containingFile.getParent();
            } else if (varName.equals("PROJECT_SOURCE_DIR")) {
                Project project2 = containingFile.getProject();
                element = PsiManager.getInstance((Project)project2).findDirectory(project2.getBaseDir());
            }
            if (element != null) {
                return new ResolveResult[]{new PsiElementResolveResult((PsiElement)element, false)};
            }
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @NotNull
    public Object[] getVariants() {
        CMakeArgument thisArgument;
        if (this.getElement() instanceof CMakeLiteral && ((thisArgument = ((CMakeLiteral)this.getElement()).getArgument()).isCommandDefinitionName() || thisArgument.isEndCommandDefinitionName())) {
            return LookupElement.EMPTY_ARRAY;
        }
        return super.getVariants();
    }

    public boolean isReadOnlyFragment() {
        return this.isExpressionRef;
    }

    public boolean isFragmentOnlyRename() {
        return this.cmakeFileReferenceSet.isFragmentOnlyRename();
    }

    @Nullable
    protected String encode(@NotNull String name2, @NotNull PsiElement psiElement) {
        return super.encode(name2, psiElement);
    }

    @NotNull
    public String decode(@NotNull String name2) {
        return super.decode(StringUtil.unescapeStringCharacters((String)name2));
    }
}

